/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.stack;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;
import org.elasticsearch.xpack.core.template.IndexTemplateRegistry;
import org.elasticsearch.xpack.core.template.LifecyclePolicyConfig;
import org.elasticsearch.xpack.stack.StackPlugin;

public class StackTemplateRegistry
extends IndexTemplateRegistry {
    public static final int REGISTRY_VERSION = 0;
    public static final String TEMPLATE_VERSION_VARIABLE = "xpack.stack.template.version";
    private final boolean stackTemplateEnabled;
    public static final String LOGS_MAPPINGS_COMPONENT_TEMPLATE_NAME = "logs-mappings";
    public static final String LOGS_SETTINGS_COMPONENT_TEMPLATE_NAME = "logs-settings";
    public static final String LOGS_ILM_POLICY_NAME = "logs";
    public static final String LOGS_INDEX_TEMPLATE_NAME = "logs";
    public static final IndexTemplateConfig LOGS_MAPPINGS_COMPONENT_TEMPLATE = new IndexTemplateConfig("logs-mappings", "/logs-mappings.json", 0, "xpack.stack.template.version");
    public static final IndexTemplateConfig LOGS_SETTINGS_COMPONENT_TEMPLATE = new IndexTemplateConfig("logs-settings", "/logs-settings.json", 0, "xpack.stack.template.version");
    public static final LifecyclePolicyConfig LOGS_ILM_POLICY = new LifecyclePolicyConfig("logs", "/logs-policy.json");
    public static final IndexTemplateConfig LOGS_INDEX_TEMPLATE = new IndexTemplateConfig("logs", "/logs-template.json", 0, "xpack.stack.template.version");
    public static final String METRICS_MAPPINGS_COMPONENT_TEMPLATE_NAME = "metrics-mappings";
    public static final String METRICS_SETTINGS_COMPONENT_TEMPLATE_NAME = "metrics-settings";
    public static final String METRICS_ILM_POLICY_NAME = "metrics";
    public static final String METRICS_INDEX_TEMPLATE_NAME = "metrics";
    public static final IndexTemplateConfig METRICS_MAPPINGS_COMPONENT_TEMPLATE = new IndexTemplateConfig("metrics-mappings", "/metrics-mappings.json", 0, "xpack.stack.template.version");
    public static final IndexTemplateConfig METRICS_SETTINGS_COMPONENT_TEMPLATE = new IndexTemplateConfig("metrics-settings", "/metrics-settings.json", 0, "xpack.stack.template.version");
    public static final LifecyclePolicyConfig METRICS_ILM_POLICY = new LifecyclePolicyConfig("metrics", "/metrics-policy.json");
    public static final IndexTemplateConfig METRICS_INDEX_TEMPLATE = new IndexTemplateConfig("metrics", "/metrics-template.json", 0, "xpack.stack.template.version");
    public static final String SYNTHETICS_MAPPINGS_COMPONENT_TEMPLATE_NAME = "synthetics-mappings";
    public static final String SYNTHETICS_SETTINGS_COMPONENT_TEMPLATE_NAME = "synthetics-settings";
    public static final String SYNTHETICS_ILM_POLICY_NAME = "synthetics";
    public static final String SYNTHETICS_INDEX_TEMPLATE_NAME = "synthetics";
    public static final IndexTemplateConfig SYNTHETICS_MAPPINGS_COMPONENT_TEMPLATE = new IndexTemplateConfig("synthetics-mappings", "/synthetics-mappings.json", 0, "xpack.stack.template.version");
    public static final IndexTemplateConfig SYNTHETICS_SETTINGS_COMPONENT_TEMPLATE = new IndexTemplateConfig("synthetics-settings", "/synthetics-settings.json", 0, "xpack.stack.template.version");
    public static final LifecyclePolicyConfig SYNTHETICS_ILM_POLICY = new LifecyclePolicyConfig("synthetics", "/synthetics-policy.json");
    public static final IndexTemplateConfig SYNTHETICS_INDEX_TEMPLATE = new IndexTemplateConfig("synthetics", "/synthetics-template.json", 0, "xpack.stack.template.version");

    public StackTemplateRegistry(Settings nodeSettings, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry) {
        super(nodeSettings, clusterService, threadPool, client, xContentRegistry);
        this.stackTemplateEnabled = (Boolean)StackPlugin.STACK_TEMPLATES_ENABLED.get(nodeSettings);
    }

    protected List<LifecyclePolicyConfig> getPolicyConfigs() {
        if (this.stackTemplateEnabled) {
            return Arrays.asList(LOGS_ILM_POLICY, METRICS_ILM_POLICY, SYNTHETICS_ILM_POLICY);
        }
        return Collections.emptyList();
    }

    protected List<IndexTemplateConfig> getComponentTemplateConfigs() {
        if (this.stackTemplateEnabled) {
            return Arrays.asList(LOGS_MAPPINGS_COMPONENT_TEMPLATE, LOGS_SETTINGS_COMPONENT_TEMPLATE, METRICS_MAPPINGS_COMPONENT_TEMPLATE, METRICS_SETTINGS_COMPONENT_TEMPLATE, SYNTHETICS_MAPPINGS_COMPONENT_TEMPLATE, SYNTHETICS_SETTINGS_COMPONENT_TEMPLATE);
        }
        return Collections.emptyList();
    }

    protected List<IndexTemplateConfig> getComposableTemplateConfigs() {
        if (this.stackTemplateEnabled) {
            return Arrays.asList(LOGS_INDEX_TEMPLATE, METRICS_INDEX_TEMPLATE, SYNTHETICS_INDEX_TEMPLATE);
        }
        return Collections.emptyList();
    }

    protected String getOrigin() {
        return "stack";
    }

    protected boolean requiresMasterNode() {
        return true;
    }
}

