note
	description:	"[
						Example application that illustrates how one can use multiple classes to
						write to the same log writers at the same time
					]"
	legal:			"See note at the end of this class"
	status:			"See notice at the end of this class"
	date:			"$Date: 2011-02-03 09:57:24 -0800 (Thu, 03 Feb 2011) $"
	revision:		"$Revision: 85520 $"

class
	APPLICATION

create
	make

feature {NONE} -- Initialization

	make
			-- Make an instance of APPLICATION, and run the application
		local
			something: SOME_CLASS
		do
				--| Initialize the logging facility
			create log.make

				--| Enable stderr log output
			log.enable_default_stderr_log

				--| Write an informational message
			log.write_information ("The application is starting up...")

				--| Do something sensible (from an application perspective, that is)
			create something
			something.do_something

				--| Wait here, so the user can see the generated output
			io.readline
		end

feature {NONE} -- Attributes

	log: attached LOG_LOGGING_FACILITY;
			-- General Eiffel log facility

note
	copyright:	"Copyright (C) 2010 by ITPassion Ltd, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (See http://www.eiffel.com/licensing/forum.txt)"
	source:		"[
					ITPassion Ltd.
					5 Anstice Close, Chiswick, Middlesex, W4 2RJ, United Kingdom
					Telephone 0044-208-742-3422 Fax 0044-208-742-3468
					Website http://www.itpassion.com
					Customer Support http://powerdesk.itpassion.com
				]"

end
