note
	description: "Eiffel Vision dialog. GTK+ implementation."
	legal: "See notice at end of class."
	status: "See notice at end of class."
	date: "$Date: 2008-12-29 12:27:11 -0800 (Mon, 29 Dec 2008) $"
	revision: "$Revision: 76420 $"

class
	EV_DIALOG_IMP

inherit
	EV_DIALOG_I
		undefine
			propagate_foreground_color,
			propagate_background_color,
			lock_update,
			unlock_update
		redefine
			interface
		end

	EV_TITLED_WINDOW_IMP
		redefine
			make,
			interface,
			call_close_request_actions,
			initialize,
			client_area
		end

	EV_GTK_DEPENDENT_ROUTINES

create
	make

feature {NONE} -- Initialization

	make (an_interface: like interface)
			-- Create empty dialog box.
		do
			base_make (an_interface)
			set_c_object (create_gtk_dialog)
		end

	initialize
			-- Initialize 'Current'
		do
			Precursor {EV_TITLED_WINDOW_IMP}
			enable_closeable
		end

feature -- Status Report

	is_closeable: BOOLEAN
			-- Is the window closeable by the user?
		do
			Result := is_dialog_closeable
		end

	is_relative: BOOLEAN
			-- Is `Current' shown relative to another window?
		do
			Result := {EV_GTK_EXTERNALS}.gtk_window_struct_transient_parent (c_object) /= default_pointer
				and then is_show_requested
		end

feature -- Status Setting

	enable_closeable
			-- Set the window to be closeable by the user
		do
			set_closeable (True)
		end

	disable_closeable
			-- Set the window not to be closeable by the user
		do
			set_closeable (False)
		end

feature {NONE} -- Implementation

	client_area: POINTER
			-- Pointer to the widget that is treated as the main holder of the client area within the window.
		do
			Result := client_area_from_c_object (c_object)
		end

	set_closeable (new_status: BOOLEAN)
			-- Set `is_closeable' to `new_status'
		local
			close_fct: INTEGER
		do
			if new_status then
				close_fct := {EV_GTK_EXTERNALS}.Gdk_func_close_enum
			end
			close_fct := close_fct.bit_or ({EV_GTK_EXTERNALS}.Gdk_func_move_enum)
		    close_fct := close_fct.bit_or ({EV_GTK_EXTERNALS}.Gdk_func_resize_enum)
			{EV_GTK_EXTERNALS}.gdk_window_set_functions (
				{EV_GTK_EXTERNALS}.gtk_widget_struct_window (c_object),
				close_fct
			)
			is_dialog_closeable := new_status
		end

	call_close_request_actions
			-- Call the cancel actions if dialog is closeable.
		do
			if not has_modal_window and then is_dialog_closeable and then not App_implementation.is_in_transport and then not is_destroyed then
				dialog_key_press_action (create {EV_KEY}.make_with_code ({EV_KEY_CONSTANTS}.key_escape))
				Precursor {EV_TITLED_WINDOW_IMP}
			end
		end

	interface: EV_DIALOG
			-- Provides a common user interface to platform dependent
			-- functionality implemented by `Current'

	is_dialog_closeable: BOOLEAN;
			-- Temporary flag whose only use is to enable functions
			-- `is_closeable', `enable_closeable' and `disable_closeable'
			-- to be executed without raising zillions of assertion violations.
			--| FIXME implement cited function, then remove me.

note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"




end -- class EV_DIALOG_IMP

