%{
indexing
	description:"Basic texts scanners for TEXT_PANEL"
	author:     "Etienne Amodeo"
	date:       "$Date: 2008-07-01 00:44:03 -0700 (Tue, 01 Jul 2008) $"
	revision:   "$Revision: 73981 $"

class EDITOR_BASIC_SCANNER

inherit

	EDITOR_SCANNER

create
	make
%}

%option outfile="editor_basic_scanner.e"

%%

----------/** Separators **/----------------------------------------------------

[\r]+				-- Ignore carriage return
[ ]+				{
					create {EDITOR_TOKEN_SPACE} curr_token.make(text_count)
					update_token_list
					}
[\t]+				{
					create {EDITOR_TOKEN_TABULATION} curr_token.make(text_count)
					update_token_list
					}
\n+				{
					from i_ := 1 until i_ > text_count loop
						create {EDITOR_TOKEN_EOL} curr_token.make
						update_token_list
						i_ := i_ + 1
					end
					}
[^\n\t\r ]+			{
					curr_token := new_text_token (text)
					update_token_list
					}



--------------------------------------------------------------------------------

<<EOF>>			terminate

--------------------------------------------------------------------------------
%%

end -- class EDITOR_BASIC_SCANNER
