/*
	description: "Declarations for transfer routines of ewb."
	date:		"$Date: 2008-07-28 21:56:17 -0700 (Mon, 28 Jul 2008) $"
	revision:	"$Revision: 74247 $"
	copyright:	"Copyright (c) 1985-2006, Eiffel Software."
	license:	"GPL version 2 see http://www.eiffel.com/licensing/gpl.txt)"
	licensing_options:	"Commercial license is available at http://www.eiffel.com/licensing"
	copying: "[
			This file is part of Eiffel Software's Runtime.
			
			Eiffel Software's Runtime is free software; you can
			redistribute it and/or modify it under the terms of the
			GNU General Public License as published by the Free
			Software Foundation, version 2 of the License
			(available at the URL listed under "license" above).
			
			Eiffel Software's Runtime is distributed in the hope
			that it will be useful,	but WITHOUT ANY WARRANTY;
			without even the implied warranty of MERCHANTABILITY
			or FITNESS FOR A PARTICULAR PURPOSE.
			See the	GNU General Public License for more details.
			
			You should have received a copy of the GNU General Public
			License along with Eiffel Software's Runtime; if not,
			write to the Free Software Foundation, Inc.,
			51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA
		]"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"
*/

#ifndef _ewb_transfer_h_
#define _ewb_transfer_h_

#include "stream.h" 	
#include "transfer.h" 

extern STREAM *ewb_sp;				/* Stream used for communications */

extern void ewb_tpipe(STREAM *stream);		/* Open transfer "pipe" */
extern char *ewb_tread(int *size);		/* Read from the transfer "pipe" */
extern int ewb_twrite(void *buffer, size_t size);		/* Write to the transfer "pipe" */

#endif
