/*
 * Code for class I18N_UNIX_C_FUNCTIONS
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "i1394.h"
#include <locale.h>
#include <eif_langinfo.h>
#include <iconv.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F458_8943
static EIF_INTEGER_32 inline_F458_8943 (void)
{
	return LC_ALL;
	;
}
#define INLINE_F458_8943
#endif
#ifndef INLINE_F458_8942
static EIF_POINTER inline_F458_8942 (EIF_INTEGER_32 arg1, EIF_POINTER arg2)
{
	return setlocale((int) arg1, (const char *) arg2);
	;
}
#define INLINE_F458_8942
#endif
#ifndef INLINE_F458_8937
static EIF_POINTER inline_F458_8937 (EIF_INTEGER_32 arg1)
{
	char *dname;
				wchar_t *out = NULL;
				size_t insize, outsize = 0;

				dname = nl_langinfo(arg1);
				insize = strlen(dname) + 1;
				
				{
					iconv_t cd;
					size_t nconv, avail, alloc;
					char *res, *tres, *wrptr, *inptr;

					alloc = avail = insize + insize/4;
					if (!(res = malloc(alloc))) {
					  perror("malloc");
					  return NULL;
					}

					wrptr = res;   /* duplicate pointers because they */
					inptr = dname; /* get modified by iconv */
					
					/*get charset used by current locale */
					#if EIF_OS == EIF_OS_OPENBSD
						char *charset = locale_charset ();
					#else
						char *charset = nl_langinfo (CODESET);
					#endif
					
					cd = iconv_open ("UTF-8", charset);
					if (cd == (iconv_t)(-1)) {
							perror("iconv_open");
							free(res);
							return NULL;
					}

					do {
							nconv = iconv (cd, (const char **) &inptr, &insize, &wrptr, &avail); /*convertions */
							if (nconv == (size_t)(-1)) {
									if (errno == E2BIG) { /* need more room for result */
											tres = realloc(res, alloc += 20);
											avail += 20;
											if (!tres) {
													perror("realloc");
													break;
											}
											wrptr = tres + (wrptr - res);
											res = tres;
									}
									else /* something wrong with input */
											break;
							}
					} while (insize);

					if (iconv_close(cd))
							perror("iconv_close");
				   
					out = (wchar_t*) res;
					outsize = wrptr - res; /* should be == to (alloc - avail + 1) */
					/* TODO: should possibly null-terminate the result */
				}
				return out;
	;
}
#define INLINE_F458_8937
#endif
#ifndef INLINE_F458_8939
static EIF_POINTER inline_F458_8939 (void)
{
	#if EIF_OS == EIF_OS_OPENBSD
	return locale_charset ();
#else
	return nl_langinfo (CODESET);
#endif
	;
}
#define INLINE_F458_8939
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {I18N_UNIX_C_FUNCTIONS}.unix_set_locale */
void F458_8935 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_POINTER loc2 = (EIF_POINTER) 0;
	EIF_POINTER loc3 = (EIF_POINTER) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(5);
	RTLR(0,loc1);
	RTLR(1,tr1);
	RTLR(2,arg1);
	RTLR(3,Current);
	RTLR(4,tr2);
	
	RTEAA("unix_set_locale", 457, Current, 3, 1, 7639);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNS(2395, 2395, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F2396_26705(RTCV(tr1), arg1);
	loc1 = (EIF_REFERENCE) tr1;
	RTHOOK(2);
	ti4_1 = inline_F458_8943();
	tp1 = F2396_26724(RTCV(loc1));
	loc2 = inline_F458_8942(ti4_1, tp1);
	RTHOOK(3);
	if ((EIF_BOOLEAN)(loc2 != loc3)) {
		RTHOOK(4);
		tr1 = RTLNS(2395, 2395, _OBJSIZ_1_0_0_1_0_0_0_0_);
		F2396_26709(RTCV(tr1), loc2);
		loc1 = (EIF_REFERENCE) tr1;
		RTHOOK(5);
		tr1 = RTOUCR(5665,F458_8941,(Current));
		tr2 = F2396_26718(RTCV(loc1));
		F1702_20238(RTCV(tr1), tr2);
	} else {
		RTHOOK(6);
		tr1 = RTOUCR(5665,F458_8941,(Current));
		tr2 = RTMS_EX_H("POSIX",5,1331472728);
		F1702_20238(RTCV(tr1), tr2);
	}
	RTHOOK(7);
	RTLE;
	RTEE;
}

/* {I18N_UNIX_C_FUNCTIONS}.unix_get_locale_info_managed */
EIF_REFERENCE F458_8936 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(3);
	RTLR(0,tr1);
	RTLR(1,Result);
	RTLR(2,Current);
	
	RTEAA("unix_get_locale_info_managed", 457, Current, 0, 1, 7640);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNS(2588, 2588, _OBJSIZ_0_1_0_1_0_1_1_0_);
	tp1 = inline_F458_8937(arg1);
	F2589_29447(RTCV(tr1), tp1, ((EIF_INTEGER_32) 0L));
	Result = (EIF_REFERENCE) tr1;
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
}

/* {I18N_UNIX_C_FUNCTIONS}.unix_get_locale_info */
EIF_POINTER F458_8937 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("unix_get_locale_info", 457, Current, 0, 1, 7641);
	Result = inline_F458_8937 ((EIF_INTEGER_32) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {I18N_UNIX_C_FUNCTIONS}.unix_is_available */
EIF_BOOLEAN F458_8938 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_POINTER loc2 = (EIF_POINTER) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,tr1);
	RTLR(2,arg1);
	RTLR(3,Current);
	
	RTEAA("unix_is_available", 457, Current, 2, 1, 7642);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNS(2395, 2395, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F2396_26705(RTCV(tr1), arg1);
	loc1 = (EIF_REFERENCE) tr1;
	RTHOOK(2);
	ti4_1 = inline_F458_8943();
	tp1 = F2396_26724(RTCV(loc1));
	tp1 = inline_F458_8942(ti4_1, tp1);
	Result = (EIF_BOOLEAN) (EIF_BOOLEAN)(tp1 != loc2);
	RTHOOK(3);
	tr1 = F458_8940(Current);
	F458_8935(Current, tr1);
	RTHOOK(4);
	RTLE;
	RTEE;
	return Result;
}

/* {I18N_UNIX_C_FUNCTIONS}.c_current_codeset */
EIF_POINTER F458_8939 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("c_current_codeset", 457, Current, 0, 0, 7643);
	Result = inline_F458_8939 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {I18N_UNIX_C_FUNCTIONS}.unix_locale_name */
EIF_REFERENCE F458_8940 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	
	RTEAA("unix_locale_name", 457, Current, 0, 0, 7644);
	RTGC;
	RTHOOK(1);
	tr1 = RTOUCR(5665,F458_8941,(Current));
	Result = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE)) R17869[Dtype(tr1)-1701])(RTCV(tr1));
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
}

/* {I18N_UNIX_C_FUNCTIONS}.unix_locale_name_cell */
static EIF_REFERENCE F458_8941_body (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	RTLD;
	
#define Result RTOTRR
	RTOUDR(5665)

	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	
	RTEAA("unix_locale_name_cell", 457, Current, 0, 0, 7645);
	RTGC;
	RTOTP;
	RTHOOK(1);
	{
		static EIF_TYPE_INDEX typarr0[] = {457,1701,3669,0xFFFF};
		EIF_TYPE_INDEX typres0;
		static EIF_TYPE_INDEX typcache0 = INVALID_DTYPE;
		
		typres0 = (typcache0 != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), 1701, typarr0)));
		tr1 = RTLNS(typres0, 1701, _OBJSIZ_1_0_0_0_0_0_0_0_);
	}
	tr2 = RTMS_EX_H("POSIX",5,1331472728);
	F1702_20238(RTCV(tr1), tr2);
	Result = (EIF_REFERENCE) tr1;
	RTOTE;
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
#undef Result
}

EIF_REFERENCE F458_8941 (EIF_REFERENCE Current)
{
	GTCX
	return RTOUCR(5665,F458_8941_body,(Current));
}

/* {I18N_UNIX_C_FUNCTIONS}.c_setlocale */
EIF_POINTER F458_8942 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_POINTER arg2)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("c_setlocale", 457, Current, 0, 2, 7646);
	Result = inline_F458_8942 ((EIF_INTEGER_32) arg1, (EIF_POINTER) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {I18N_UNIX_C_FUNCTIONS}.c_lc_all */
EIF_INTEGER_32 F458_8943 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("c_lc_all", 457, Current, 0, 0, 7647);
	Result = inline_F458_8943 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

void EIF_Minit394 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
