/*
 * Code for class PATH
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "pa2568.h"
#include "eif_built_in.h"
#include <ctype.h>
#include "eif_path_name.h"
#include "eif_eiffel.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F3463_43722
static int inline_F3463_43722 (EIF_POINTER arg1, EIF_POINTER arg2)
{
	EIF_BOOLEAN Result = EIF_FALSE;
#ifdef EIF_WINDOWS
		/* To check this, we use `CreateFileW' to open both file, and then using the information
		 * returned by `GetFileInformationByHandle' we can check whether or not they are indeed
		 * the same.
		 * Note: it is important to use the W version of CreateFileW because arguments
		 * are Unicode, not ASCII. */
	BY_HANDLE_FILE_INFORMATION l_path1_info, l_path2_info;
	HANDLE l_path2_file = CreateFileW ((LPCWSTR) arg2, GENERIC_READ, FILE_SHARE_READ, NULL,
		OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	HANDLE l_path1_file = CreateFileW ((LPCWSTR) arg1, GENERIC_READ, FILE_SHARE_READ, NULL,
			OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);

	if ((l_path2_file == INVALID_HANDLE_VALUE) || (l_path1_file == INVALID_HANDLE_VALUE)) {
			/* We do not need the handles anymore, simply close them. Since Microsoft
			 * API accepts INVALID_HANDLE_VALUE we don't check the validity of arguments. */
		CloseHandle(l_path2_file);
		CloseHandle(l_path1_file);
	} else {
		BOOL success = GetFileInformationByHandle (l_path2_file, &l_path2_info);
		success = success && GetFileInformationByHandle (l_path1_file, &l_path1_info);
			/* We do not need the handles anymore, simply close them. */
		CloseHandle(l_path2_file);
		CloseHandle(l_path1_file);
		if (success) {
				/* Check that `path2' and `path1' do not represent the same file. */
			if
				((l_path2_info.dwVolumeSerialNumber == l_path1_info.dwVolumeSerialNumber) &&
				(l_path2_info.nFileIndexLow == l_path1_info.nFileIndexLow) &&
				(l_path2_info.nFileIndexHigh == l_path1_info.nFileIndexHigh))
			{
				Result = EIF_TRUE;
			}
		}
	}
#else
	struct stat buf1, buf2;
	int status;
	#ifdef HAS_LSTAT
		status = lstat(arg1, &buf1);
		if (status == 0) {
				/* We found a file, now let's check if it is not a symbolic link. If it is, we use `stat'
			 	 * to ensure the validity of the link. */
			if ((buf1.st_mode & S_IFLNK) == S_IFLNK) {
				status = stat (arg1, &buf1);
			}
		}
		
		if (status == 0) {
			status = lstat(arg2, &buf2);
			if (status == 0) {
					/* We found a file, now let's check if it is not a symbolic link. If it is, we use `stat'
				 	 * to ensure the validity of the link. */
				if ((buf2.st_mode & S_IFLNK) == S_IFLNK) {
					status = stat (arg2, &buf2);
				}
			}
		}
	#else
		status = stat (arg1, &buf1);
		if (status == 0) {
			status = stat (arg2, &buf2);
		}
	#endif
	if (status == 0) {
			/* Both files are present, check they represent the same one. */
		if ((buf1.st_dev == buf2.st_dev) && (buf1.st_ino == buf2.st_ino)) {
			Result = EIF_TRUE;
		}
	}
#endif
return Result;
	;
}
#define INLINE_F3463_43722
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {PATH}.make_empty */
void F3463_43662 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	
	RTEAA("make_empty", 3462, Current, 0, 0, 44261);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNSMART(eif_non_attached_type(3669));
	F3661_46346(RTCV(tr1));
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	RTHOOK(2);
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	RTHOOK(3);
	F3463_43708(Current);
	RTHOOK(4);
	RTLE;
	RTEE;
}

/* {PATH}.make_current */
void F3463_43663 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	
	RTEAA("make_current", 3462, Current, 0, 0, 44262);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNSMART(eif_non_attached_type(3669));
	ti4_1 = F3463_43707(Current);
	F3665_46507(RTCV(tr1), ti4_1);
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	RTHOOK(2);
	tr1 = *(EIF_REFERENCE *)(Current);
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R37869[Dtype(tr1)-3669])(RTCV(tr1), (EIF_CHARACTER_8) '.');
	RTHOOK(3);
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
		RTHOOK(4);
		tr1 = *(EIF_REFERENCE *)(Current);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R37869[Dtype(tr1)-3669])(RTCV(tr1), (EIF_CHARACTER_8) '\000');
	}
	RTHOOK(5);
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	RTHOOK(6);
	F3463_43708(Current);
	RTHOOK(7);
	RTLE;
	RTEE;
}

/* {PATH}.make_from_string */
void F3463_43664 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,arg1);
	
	RTEAA("make_from_string", 3462, Current, 0, 1, 44263);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNSMART(eif_non_attached_type(3669));
	ti4_1 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R37614[Dtype(arg1)-3662])(RTCV(arg1));
	ti4_2 = F3463_43707(Current);
	F3665_46507(RTCV(tr1), (EIF_INTEGER_32) (ti4_1 * ti4_2));
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	RTHOOK(2);
	tb1 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R37594[Dtype(arg1)-3663])(RTCV(arg1));
	if ((EIF_BOOLEAN) !tb1) {
		RTHOOK(3);
		tr1 = *(EIF_REFERENCE *)(Current);
		F3463_43716(Current, tr1, arg1, (EIF_CHARACTER_8) '\000');
		RTHOOK(4);
		F3463_43709(Current);
	} else {
		RTHOOK(5);
		*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	}
	RTHOOK(6);
	F3463_43708(Current);
	RTHOOK(7);
	RTLE;
	RTEE;
}

/* {PATH}.make_from_storage */
void F3463_43665 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,arg1);
	
	RTEAA("make_from_storage", 3462, Current, 0, 1, 44264);
	RTGC;
	RTHOOK(1);
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) arg1;
	RTHOOK(2);
	F3463_43709(Current);
	RTHOOK(3);
	F3463_43708(Current);
	RTHOOK(4);
	RTLE;
	RTEE;
}

/* {PATH}.make_from_normalized_storage */
void F3463_43666 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,arg1);
	
	RTEAA("make_from_normalized_storage", 3462, Current, 0, 1, 44265);
	RTGC;
	RTHOOK(1);
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) arg1;
	RTHOOK(2);
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	RTHOOK(3);
	F3463_43708(Current);
	RTHOOK(4);
	RTLE;
	RTEE;
}

/* {PATH}.make_from_pointer */
void F3463_43667 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,loc1);
	RTLR(2,tr1);
	
	RTEAA("make_from_pointer", 3462, Current, 2, 1, 44266);
	RTGC;
	RTHOOK(1);
	loc2 = F2249_25187(Current, arg1);
	RTHOOK(2);
	loc2 -= (EIF_INTEGER_32) (loc2 % F3463_43707(Current));
	RTHOOK(3);
	tr1 = RTLNS(2395, 2395, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F2396_26710(RTCV(tr1), arg1, loc2);
	loc1 = (EIF_REFERENCE) tr1;
	RTHOOK(4);
	tr1 = F2396_26717(RTCV(loc1), ((EIF_INTEGER_32) 1L), loc2);
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	RTHOOK(5);
	tr1 = *(EIF_REFERENCE *)(Current);
	tb1 = F1336_17903(RTCV(tr1));
	if ((EIF_BOOLEAN) !tb1) {
		RTHOOK(6);
		F3463_43709(Current);
	}
	RTHOOK(7);
	F3463_43708(Current);
	RTHOOK(8);
	RTLE;
	RTEE;
}

/* {PATH}.is_current_symbol */
EIF_BOOLEAN F3463_43668 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	
	RTEAA("is_current_symbol", 3462, Current, 0, 0, 44267);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr1) + O37728[Dtype(tr1)-3664]);
	if ((EIF_BOOLEAN)(ti4_1 == F3463_43707(Current))) {
		RTHOOK(2);
		tr1 = *(EIF_REFERENCE *)(Current);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_BOOLEAN) F3463_43719(Current, tr1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '.');
	}
	RTHOOK(4);
	RTLE;
	RTEE;
	return (EIF_BOOLEAN) 0;
}

/* {PATH}.is_parent_symbol */
EIF_BOOLEAN F3463_43669 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	
	RTEAA("is_parent_symbol", 3462, Current, 0, 0, 44268);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr1) + O37728[Dtype(tr1)-3664]);
	if ((EIF_BOOLEAN)(ti4_1 == (EIF_INTEGER_32) (((EIF_INTEGER_32) 2L) * F3463_43707(Current)))) {
		RTHOOK(2);
		tr1 = *(EIF_REFERENCE *)(Current);
		Result = F3463_43719(Current, tr1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '.');
		RTHOOK(3);
		tr1 = *(EIF_REFERENCE *)(Current);
		ti4_1 = F3463_43707(Current);
		Result = F3463_43719(Current, tr1, (EIF_INTEGER_32) (((EIF_INTEGER_32) 1L) + ti4_1), (EIF_CHARACTER_8) '.');
	}
	RTHOOK(4);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.is_empty */
EIF_BOOLEAN F3463_43671 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	
	RTEAA("is_empty", 3462, Current, 0, 0, 44270);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current);
	Result = F1336_17903(RTCV(tr1));
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.is_relative */
EIF_BOOLEAN F3463_43672 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("is_relative", 3462, Current, 0, 0, 44271);
	RTGC;
	RTHOOK(1);
	Result = F3463_43673(Current);
	Result = (EIF_BOOLEAN) (EIF_BOOLEAN) !Result;
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.is_absolute */
EIF_BOOLEAN F3463_43673 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_CHARACTER_8 tc1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	
	RTEAA("is_absolute", 3462, Current, 1, 0, 44272);
	RTGC;
	RTHOOK(1);
	loc1 = F3463_43713(Current);
	RTHOOK(2);
	if ((EIF_BOOLEAN) (loc1 > ((EIF_INTEGER_32) 0L))) {
		RTHOOK(3);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
			RTHOOK(4);
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = F3463_43707(Current);
			tc1 = F3463_43689(Current);
			Result = F3463_43719(Current, tr1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (loc1 - ti4_1) + ((EIF_INTEGER_32) 1L)), tc1);
		} else {
			RTHOOK(5);
			RTHOOK(6);
			RTLE;
			RTEE;
			return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		}
	}
	RTHOOK(7);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.is_same_file_as */
EIF_BOOLEAN F3463_43675 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_POINTER tp2;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,loc2);
	RTLR(3,arg1);
	
	RTEAA("is_same_file_as", 3462, Current, 2, 1, 44274);
	RTGC;
	RTHOOK(1);
	loc1 = F3463_43704(Current);
	RTHOOK(2);
	loc2 = F3463_43704(RTCV(arg1));
	RTHOOK(3);
	tp1 = *(EIF_POINTER *)(RTCV(loc1)+ _PTROFF_0_1_0_1_0_0_);
	tp2 = *(EIF_POINTER *)(RTCV(loc2)+ _PTROFF_0_1_0_1_0_0_);
	Result = EIF_TEST (inline_F3463_43722(tp1, tp2));
	RTHOOK(4);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.has_extension */
EIF_BOOLEAN F3463_43676 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	
	RTEAA("has_extension", 3462, Current, 1, 1, 44275);
	RTGC;
	RTHOOK(1);
	Result = '\0';
	tr1 = F3463_43680(Current);
	loc1 = tr1;
	if (EIF_TEST(loc1)) {
		tb1 = F3661_46386(RTCV(loc1), arg1);
		Result = tb1;
	}
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.root */
EIF_REFERENCE F3463_43677 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,Result);
	
	RTEAA("root", 3462, Current, 1, 0, 44276);
	RTGC;
	RTHOOK(1);
	loc1 = F3463_43713(Current);
	RTHOOK(2);
	if ((EIF_BOOLEAN)(loc1 != ((EIF_INTEGER_32) 0L))) {
		RTHOOK(3);
		tr1 = *(EIF_REFERENCE *)(Current);
		ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr1) + O37728[Dtype(tr1)-3664]);
		if ((EIF_BOOLEAN)(loc1 == ti4_1)) {
			RTHOOK(4);
			tr1 = RTLNS(3462, 3462, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F3463_43666(RTCV(tr1), *(EIF_REFERENCE *)(Current));
			RTHOOK(5);
			RTLE;
			RTEE;
			return (EIF_REFERENCE) tr1;
		} else {
			RTHOOK(6);
			tr1 = RTLNS(3462, 3462, _OBJSIZ_2_1_0_0_0_0_0_0_);
			tr2 = *(EIF_REFERENCE *)(Current);
			tr2 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R37653[Dtype(tr2)-3663])(RTCV(tr2), ((EIF_INTEGER_32) 1L), loc1);
			F3463_43666(RTCV(tr1), tr2);
			Result = (EIF_REFERENCE) tr1;
		}
	}
	RTHOOK(7);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.parent */
EIF_REFERENCE F3463_43678 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(5);
	RTLR(0,Current);
	RTLR(1,loc3);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLR(4,Result);
	
	RTEAA("parent", 3462, Current, 3, 0, 44277);
	RTGC;
	RTHOOK(1);
	loc1 = F3463_43714(Current);
	RTHOOK(2);
	if ((EIF_BOOLEAN)(loc1 == ((EIF_INTEGER_32) 0L))) {
		RTHOOK(3);
		tr1 = F3463_43677(Current);
		loc3 = tr1;
		if (EIF_TEST(loc3)) {
			RTHOOK(4);
			RTHOOK(5);
			RTLE;
			RTEE;
			return (EIF_REFERENCE) loc3;
		} else {
			RTHOOK(6);
			tr1 = RTLNS(3462, 3462, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F3463_43663(RTCV(tr1));
			RTHOOK(7);
			RTLE;
			RTEE;
			return (EIF_REFERENCE) tr1;
		}
	} else {
		RTHOOK(8);
		if ((EIF_BOOLEAN)(loc1 == F3463_43707(Current))) {
			RTHOOK(9);
			tr1 = RTLNS(3462, 3462, _OBJSIZ_2_1_0_0_0_0_0_0_);
			tr2 = *(EIF_REFERENCE *)(Current);
			ti4_1 = F3463_43707(Current);
			tr2 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R37653[Dtype(tr2)-3663])(RTCV(tr2), ((EIF_INTEGER_32) 1L), ti4_1);
			F3463_43666(RTCV(tr1), tr2);
			Result = (EIF_REFERENCE) tr1;
		} else {
			RTHOOK(10);
			loc2 = F3463_43713(Current);
			RTHOOK(11);
			if ((EIF_BOOLEAN) (loc1 <= loc2)) {
				RTHOOK(12);
				tr1 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr1) + O37728[Dtype(tr1)-3664]);
				if ((EIF_BOOLEAN)(loc2 == ti4_1)) {
					RTHOOK(13);
					RTHOOK(14);
					RTLE;
					RTEE;
					return (EIF_REFERENCE) Current;
				} else {
					RTHOOK(15);
					tr1 = RTLNS(3462, 3462, _OBJSIZ_2_1_0_0_0_0_0_0_);
					tr2 = *(EIF_REFERENCE *)(Current);
					tr2 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R37653[Dtype(tr2)-3663])(RTCV(tr2), ((EIF_INTEGER_32) 1L), loc2);
					F3463_43666(RTCV(tr1), tr2);
					Result = (EIF_REFERENCE) tr1;
				}
			} else {
				RTHOOK(16);
				tr1 = RTLNS(3462, 3462, _OBJSIZ_2_1_0_0_0_0_0_0_);
				tr2 = *(EIF_REFERENCE *)(Current);
				ti4_1 = F3463_43707(Current);
				tr2 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R37653[Dtype(tr2)-3663])(RTCV(tr2), ((EIF_INTEGER_32) 1L), (EIF_INTEGER_32) (loc1 - ti4_1));
				F3463_43666(RTCV(tr1), tr2);
				Result = (EIF_REFERENCE) tr1;
			}
		}
	}
	RTHOOK(17);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.entry */
EIF_REFERENCE F3463_43679 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE tr3 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(5);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,tr3);
	RTLR(4,Result);
	
	RTEAA("entry", 3462, Current, 2, 0, 44278);
	RTGC;
	RTHOOK(1);
	loc1 = F3463_43714(Current);
	RTHOOK(2);
	if ((EIF_BOOLEAN)(loc1 == ((EIF_INTEGER_32) 0L))) {
		RTHOOK(3);
		loc2 = F3463_43713(Current);
		RTHOOK(4);
		if ((EIF_BOOLEAN) (loc2 > ((EIF_INTEGER_32) 0L))) {
			RTHOOK(5);
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr1) + O37728[Dtype(tr1)-3664]);
			if ((EIF_BOOLEAN) (loc2 < ti4_1)) {
				RTHOOK(6);
				tr1 = RTLNS(3462, 3462, _OBJSIZ_2_1_0_0_0_0_0_0_);
				tr2 = *(EIF_REFERENCE *)(Current);
				tr3 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr3) + O37728[Dtype(tr3)-3664]);
				tr2 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R37653[Dtype(tr2)-3663])(RTCV(tr2), (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)), ti4_1);
				F3463_43666(RTCV(tr1), tr2);
				Result = (EIF_REFERENCE) tr1;
			}
		} else {
			RTHOOK(7);
			Result = (EIF_REFERENCE) Current;
		}
	} else {
		RTHOOK(8);
		loc2 = F3463_43713(Current);
		RTHOOK(9);
		if ((EIF_BOOLEAN) (loc1 <= loc2)) {
			RTHOOK(10);
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr1) + O37728[Dtype(tr1)-3664]);
			if ((EIF_BOOLEAN) (loc2 < ti4_1)) {
				RTHOOK(11);
				tr1 = RTLNS(3462, 3462, _OBJSIZ_2_1_0_0_0_0_0_0_);
				tr2 = *(EIF_REFERENCE *)(Current);
				tr3 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr3) + O37728[Dtype(tr3)-3664]);
				tr2 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R37653[Dtype(tr2)-3663])(RTCV(tr2), (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)), ti4_1);
				F3463_43666(RTCV(tr1), tr2);
				Result = (EIF_REFERENCE) tr1;
			}
		} else {
			RTHOOK(12);
			tr1 = RTLNS(3462, 3462, _OBJSIZ_2_1_0_0_0_0_0_0_);
			tr2 = *(EIF_REFERENCE *)(Current);
			tr3 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr3) + O37728[Dtype(tr3)-3664]);
			tr2 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R37653[Dtype(tr2)-3663])(RTCV(tr2), (EIF_INTEGER_32) (loc1 + ((EIF_INTEGER_32) 1L)), ti4_1);
			F3463_43666(RTCV(tr1), tr2);
			Result = (EIF_REFERENCE) tr1;
		}
	}
	RTHOOK(13);
	tb1 = '\0';
	if ((EIF_BOOLEAN)(Result != NULL)) {
		tb2 = '\01';
		tb3 = '\01';
		tb4 = F3463_43671(RTCV(Result));
		if (!tb4) {
			tb4 = F3463_43668(RTCV(Result));
			tb3 = tb4;
		}
		if (!tb3) {
			tb3 = F3463_43669(RTCV(Result));
			tb2 = tb3;
		}
		tb1 = tb2;
	}
	if (tb1) {
		RTHOOK(14);
		RTHOOK(15);
		RTLE;
		RTEE;
		return (EIF_REFERENCE) NULL;
	}
	RTHOOK(16);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.extension */
EIF_REFERENCE F3463_43680 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_CHARACTER_32 tw1;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc4);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc1);
	
	RTEAA("extension", 3462, Current, 4, 0, 44279);
	RTGC;
	RTHOOK(1);
	tr1 = F3463_43679(Current);
	loc4 = tr1;
	if (EIF_TEST(loc4)) {
		RTHOOK(2);
		loc1 = F3463_43702(RTCV(loc4));
		RTHOOK(3);
		loc3 = *(EIF_INTEGER_32 *)(RTCV(loc1)+ _LNGOFF_1_0_0_2_);
		RTHOOK(4);
		tw1 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '.';
		loc2 = F3663_46450(RTCV(loc1), tw1, loc3);
		RTHOOK(5);
		if ((EIF_BOOLEAN) ((EIF_BOOLEAN)(loc2 != ((EIF_INTEGER_32) 0L)) && (EIF_BOOLEAN)(loc2 != loc3))) {
			RTHOOK(6);
			tr1 = F3664_46500(RTCV(loc1), (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)), loc3);
			RTHOOK(7);
			RTLE;
			RTEE;
			return (EIF_REFERENCE) tr1;
		}
	}
	RTHOOK(8);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) 0;
}

/* {PATH}.components */
EIF_REFERENCE F3463_43681 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(5);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLR(3,loc1);
	RTLR(4,tr2);
	
	RTEAA("components", 3462, Current, 3, 0, 44280);
	RTGC;
	RTHOOK(1);
	{
		static EIF_TYPE_INDEX typarr0[] = {3462,2312,3462,0xFFFF};
		EIF_TYPE_INDEX typres0;
		static EIF_TYPE_INDEX typcache0 = INVALID_DTYPE;
		
		typres0 = (typcache0 != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), 2312, typarr0)));
		tr1 = RTLNS(typres0, 2312, _OBJSIZ_1_1_0_1_0_0_0_0_);
	}
	F2313_25864(RTCV(tr1), ((EIF_INTEGER_32) 10L));
	Result = (EIF_REFERENCE) tr1;
	RTHOOK(2);
	loc3 = F3463_43713(Current);
	RTHOOK(3);
	if ((EIF_BOOLEAN) (loc3 > ((EIF_INTEGER_32) 0L))) {
		RTHOOK(4);
		tr1 = RTLNS(3669, 3669, _OBJSIZ_1_1_0_3_0_0_0_0_);
		F3665_46507(RTCV(tr1), loc3);
		loc1 = (EIF_REFERENCE) tr1;
		RTHOOK(5);
		tr1 = *(EIF_REFERENCE *)(Current);
		F3670_46752(RTCV(loc1), tr1, ((EIF_INTEGER_32) 1L), loc3);
		RTHOOK(6);
		tr1 = RTLNS(3462, 3462, _OBJSIZ_2_1_0_0_0_0_0_0_);
		F3463_43666(RTCV(tr1), loc1);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R16628[Dtype(Result)-1493])(RTCV(Result), tr1);
		RTHOOK(7);
		loc3++;
	} else {
		RTHOOK(8);
		loc3 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	}
	RTHOOK(9);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr1) + O37728[Dtype(tr1)-3664]);
	if ((EIF_BOOLEAN) (loc3 <= ti4_1)) {
		RTHOOK(10);
		loc2 = (EIF_INTEGER_32) loc3;
		RTHOOK(11);
		loc3 = F3463_43715(Current, loc2);
		for (;;) {
			RTHOOK(12);
			if ((EIF_BOOLEAN)(loc3 == ((EIF_INTEGER_32) 0L))) break;
			RTHOOK(13);
			tr1 = RTLNS(3669, 3669, _OBJSIZ_1_1_0_3_0_0_0_0_);
			F3665_46507(RTCV(tr1), (EIF_INTEGER_32) (loc3 - loc2));
			loc1 = (EIF_REFERENCE) tr1;
			RTHOOK(14);
			tr1 = *(EIF_REFERENCE *)(Current);
			F3670_46752(RTCV(loc1), tr1, loc2, (EIF_INTEGER_32) (loc3 - ((EIF_INTEGER_32) 1L)));
			RTHOOK(15);
			tr1 = RTLNS(3462, 3462, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F3463_43666(RTCV(tr1), loc1);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R16628[Dtype(Result)-1493])(RTCV(Result), tr1);
			RTHOOK(16);
			loc2 = F3463_43707(Current);
			loc2 = (EIF_INTEGER_32) (EIF_INTEGER_32) (loc3 + loc2);
			RTHOOK(17);
			loc3 = F3463_43715(Current, loc2);
		}
		RTHOOK(18);
		tr1 = *(EIF_REFERENCE *)(Current);
		ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr1) + O37728[Dtype(tr1)-3664]);
		if ((EIF_BOOLEAN) (loc2 <= ti4_1)) {
			RTHOOK(19);
			tr1 = RTLNS(3669, 3669, _OBJSIZ_1_1_0_3_0_0_0_0_);
			tr2 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr2) + O37728[Dtype(tr2)-3664]);
			F3665_46507(RTCV(tr1), (EIF_INTEGER_32) (ti4_1 - loc2));
			loc1 = (EIF_REFERENCE) tr1;
			RTHOOK(20);
			tr1 = *(EIF_REFERENCE *)(Current);
			tr2 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr2) + O37728[Dtype(tr2)-3664]);
			F3670_46752(RTCV(loc1), tr1, loc2, ti4_1);
			RTHOOK(21);
			tr1 = RTLNS(3462, 3462, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F3463_43666(RTCV(tr1), loc1);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R16628[Dtype(Result)-1493])(RTCV(Result), tr1);
		}
	}
	RTHOOK(22);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.absolute_path */
EIF_REFERENCE F3463_43682 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	
	RTEAA("absolute_path", 3462, Current, 0, 0, 44281);
	RTGC;
	RTHOOK(1);
	tr1 = F2254_25272(RTCV(RTOUCR(31,F3463_43712,(Current))));
	Result = F3463_43683(Current, tr1);
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.absolute_path_in */
EIF_REFERENCE F3463_43683 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE tr3 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(8);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,arg1);
	RTLR(3,loc1);
	RTLR(4,Result);
	RTLR(5,tr2);
	RTLR(6,tr3);
	RTLR(7,loc2);
	
	RTEAA("absolute_path_in", 3462, Current, 2, 1, 44282);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current);
	tb1 = F1336_17903(RTCV(tr1));
	if (tb1) {
		RTHOOK(2);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_REFERENCE) arg1;
	} else {
		RTHOOK(4);
		if (F3463_43673(Current)) {
			RTHOOK(5);
			RTHOOK(6);
			RTLE;
			RTEE;
			return (EIF_REFERENCE) Current;
		} else {
			RTHOOK(7);
			if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
				RTHOOK(8);
				tr1 = F3463_43677(Current);
				loc1 = tr1;
				if (EIF_TEST(loc1)) {
					RTHOOK(9);
					tb1 = '\0';
					tb2 = '\0';
					tr1 = *(EIF_REFERENCE *)(RTCV(loc1));
					ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr1) + O37728[Dtype(tr1)-3664]);
					if ((EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 4L))) {
						tr1 = *(EIF_REFERENCE *)(RTCV(arg1));
						ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr1) + O37728[Dtype(tr1)-3664]);
						tb2 = (EIF_BOOLEAN) (ti4_1 >= ((EIF_INTEGER_32) 4L));
					}
					if (tb2) {
						tb2 = '\0';
						tr1 = *(EIF_REFERENCE *)(RTCV(loc1));
						tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20093[Dtype(tr1)-2034])(RTCV(tr1), ((EIF_INTEGER_32) 1L)));
						tr1 = *(EIF_REFERENCE *)(RTCV(arg1));
						tc2 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20093[Dtype(tr1)-2034])(RTCV(tr1), ((EIF_INTEGER_32) 1L)));
						if ((EIF_BOOLEAN)(tc1 == tc2)) {
							tr1 = *(EIF_REFERENCE *)(RTCV(loc1));
							tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20093[Dtype(tr1)-2034])(RTCV(tr1), ((EIF_INTEGER_32) 3L)));
							tr1 = *(EIF_REFERENCE *)(RTCV(arg1));
							tc2 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20093[Dtype(tr1)-2034])(RTCV(tr1), ((EIF_INTEGER_32) 3L)));
							tb2 = (EIF_BOOLEAN)(tc1 == tc2);
						}
						tb1 = tb2;
					}
					if (tb1) {
						RTHOOK(10);
						Result = (EIF_REFERENCE) eif_builtin_ANY_twin (arg1);
					} else {
						RTHOOK(11);
						Result = (EIF_REFERENCE) loc1;
					}
					RTHOOK(12);
					tr1 = *(EIF_REFERENCE *)(RTCV(Result));
					tr2 = *(EIF_REFERENCE *)(Current);
					tr3 = *(EIF_REFERENCE *)(RTCV(loc1));
					ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr3) + O37728[Dtype(tr3)-3664]);
					tr3 = *(EIF_REFERENCE *)(Current);
					ti4_2 = *(EIF_INTEGER_32 *)(RTCV(tr3) + O37728[Dtype(tr3)-3664]);
					tc1 = F3463_43689(Current);
					F3463_43718(Current, tr1, tr2, (EIF_INTEGER_32) (ti4_1 + ((EIF_INTEGER_32) 1L)), ti4_2, tc1);
				} else {
					RTHOOK(13);
					tr1 = *(EIF_REFERENCE *)(Current);
					if (F3463_43719(Current, tr1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '\\')) {
						RTHOOK(14);
						Result = (EIF_REFERENCE) eif_builtin_ANY_twin (arg1);
						RTHOOK(15);
						tr1 = F3463_43677(RTCV(Result));
						loc2 = tr1;
						if (EIF_TEST(loc2)) {
							RTHOOK(16);
							Result = (EIF_REFERENCE) loc2;
						}
					} else {
						RTHOOK(17);
						Result = (EIF_REFERENCE) eif_builtin_ANY_twin (arg1);
					}
					RTHOOK(18);
					tr1 = *(EIF_REFERENCE *)(RTCV(Result));
					tr2 = *(EIF_REFERENCE *)(Current);
					tc1 = F3463_43689(Current);
					F3463_43717(Current, tr1, tr2, tc1);
				}
			} else {
				RTHOOK(19);
				Result = (EIF_REFERENCE) eif_builtin_ANY_twin (arg1);
				RTHOOK(20);
				tr1 = *(EIF_REFERENCE *)(RTCV(Result));
				tr2 = *(EIF_REFERENCE *)(Current);
				tc1 = F3463_43689(Current);
				F3463_43717(Current, tr1, tr2, tc1);
			}
			RTHOOK(21);
			F3463_43708(RTCV(Result));
		}
	}
	RTHOOK(22);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.canonical_path */
EIF_REFERENCE F3463_43684 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc5 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_CHARACTER_8 tc1;
	RTLD;
	
	RTLI(8);
	RTLR(0,loc2);
	RTLR(1,Current);
	RTLR(2,loc4);
	RTLR(3,tr1);
	RTLR(4,loc3);
	RTLR(5,tr2);
	RTLR(6,loc1);
	RTLR(7,loc5);
	
	RTEAA("canonical_path", 3462, Current, 5, 0, 44221);
	RTGC;
	RTHOOK(1);
	loc2 = F3463_43682(Current);
	RTHOOK(2);
	tr1 = F3463_43677(RTCV(loc2));
	loc4 = tr1;
	if (EIF_TEST(loc4)) {
		RTHOOK(3);
		tr1 = RTLNSMART(eif_non_attached_type(3669));
		tr2 = *(EIF_REFERENCE *)(RTCV(loc2));
		ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr2) + O37728[Dtype(tr2)-3664]);
		F3665_46507(RTCV(tr1), ti4_1);
		loc3 = (EIF_REFERENCE) tr1;
		RTHOOK(4);
		loc1 = F3463_43681(RTCV(loc2));
		RTHOOK(5);
		F2313_25894(RTCV(loc1));
		RTHOOK(6);
		tr1 = F2313_25868(RTCV(loc1));
		tr1 = *(EIF_REFERENCE *)(RTCV(tr1));
		tc1 = F3463_43689(Current);
		F3463_43717(Current, loc3, tr1, tc1);
		RTHOOK(7);
		(FUNCTION_CAST(void, (EIF_REFERENCE)) R16645[Dtype(loc1)-1493])(RTCV(loc1));
		for (;;) {
			RTHOOK(8);
			tb1 = F2069_23212(RTCV(loc1));
			if (tb1) break;
			RTHOOK(9);
			tr1 = F2313_25868(RTCV(loc1));
			tb2 = F3463_43668(RTCV(tr1));
			if (tb2) {
				RTHOOK(10);
				(FUNCTION_CAST(void, (EIF_REFERENCE)) R16645[Dtype(loc1)-1493])(RTCV(loc1));
			} else {
				RTHOOK(11);
				tr1 = F2313_25868(RTCV(loc1));
				tb2 = F3463_43669(RTCV(tr1));
				if (tb2) {
					RTHOOK(12);
					tb2 = F2037_23148(RTCV(loc1));
					if ((EIF_BOOLEAN) !tb2) {
						RTHOOK(13);
						F2313_25897(RTCV(loc1));
						RTHOOK(14);
						(FUNCTION_CAST(void, (EIF_REFERENCE)) R16645[Dtype(loc1)-1493])(RTCV(loc1));
					}
					RTHOOK(15);
					(FUNCTION_CAST(void, (EIF_REFERENCE)) R16645[Dtype(loc1)-1493])(RTCV(loc1));
				} else {
					RTHOOK(16);
					F2313_25896(RTCV(loc1));
				}
			}
		}
		RTHOOK(17);
		loc5 = F2005_23076(RTCV(loc1));
		for (;;) {
			tb2 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R17853[Dtype(loc5)-1677])(RTCV(loc5));
			if (tb2) break;
			RTHOOK(18);
			tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE)) R17852[Dtype(loc5)-1677])(RTCV(loc5));
			tr1 = *(EIF_REFERENCE *)(RTCV(tr1));
			tc1 = F3463_43689(Current);
			F3463_43717(Current, loc3, tr1, tc1);
			RTHOOK(19);
			(FUNCTION_CAST(void, (EIF_REFERENCE)) R17854[Dtype(loc5)-1677])(RTCV(loc5));
		}
		RTHOOK(20);
		tr1 = RTLNS(3462, 3462, _OBJSIZ_2_1_0_0_0_0_0_0_);
		F3463_43666(RTCV(tr1), loc3);
		RTHOOK(21);
		RTLE;
		RTEE;
		return (EIF_REFERENCE) tr1;
	} else {
		RTHOOK(22);
		RTHOOK(23);
		RTLE;
		RTEE;
		return (EIF_REFERENCE) loc2;
	}/* NOTREACHED */
	
}

/* {PATH}.hash_code */
EIF_INTEGER_32 F3463_43685 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	
	RTEAA("hash_code", 3462, Current, 0, 0, 44222);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN) EIF_TEST(eif_case_sensitive_path_names())) {
		RTHOOK(2);
		tr1 = *(EIF_REFERENCE *)(Current);
		Result = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R35390[Dtype(tr1)-3438])(RTCV(tr1));
	} else {
		RTHOOK(3);
		Result = F3661_46356(RTCV(F3463_43702(Current)));
	}
	RTHOOK(4);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.native_string */
EIF_REFERENCE F3463_43686 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(2);
	RTLR(0,tr1);
	RTLR(1,Current);
	
	RTEAA("native_string", 3462, Current, 0, 0, 44223);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNS(2250, 2250, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F2251_25193(RTCV(tr1), *(EIF_REFERENCE *)(Current));
	RTHOOK(2);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.directory_separator */
EIF_CHARACTER_8 F3463_43689 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("directory_separator", 3462, Current, 0, 0, 44226);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
		RTHOOK(2);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
	} else {
		RTHOOK(4);
		RTHOOK(5);
		RTLE;
		RTEE;
		return (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
	}/* NOTREACHED */
	
}

/* {PATH}.extended */
EIF_REFERENCE F3463_43690 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_INTEGER_32 ti4_4;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	RTLD;
	
	RTLI(5);
	RTLR(0,loc1);
	RTLR(1,tr1);
	RTLR(2,Current);
	RTLR(3,tr2);
	RTLR(4,arg1);
	
	RTEAA("extended", 3462, Current, 2, 1, 44227);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNSMART(eif_non_attached_type(3669));
	tr2 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr2) + O37728[Dtype(tr2)-3664]);
	ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R37614[Dtype(arg1)-3662])(RTCV(arg1));
	ti4_3 = F3463_43707(Current);
	ti4_4 = F3463_43707(Current);
	F3665_46507(RTCV(tr1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + (EIF_INTEGER_32) (ti4_2 * ti4_3)) + ti4_4));
	loc1 = (EIF_REFERENCE) tr1;
	RTHOOK(2);
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R37856[Dtype(loc1)-3669])(RTCV(loc1), *(EIF_REFERENCE *)(Current));
	RTHOOK(3);
	tb1 = '\0';
	ti4_1 = *(EIF_INTEGER_32 *)(RTCV(loc1) + O37728[Dtype(loc1)-3664]);
	if ((EIF_BOOLEAN) (ti4_1 > ((EIF_INTEGER_32) 0L))) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCV(loc1) + O37728[Dtype(loc1)-3664]);
		tb1 = (EIF_BOOLEAN)(F3463_43713(Current) == ti4_1);
	}
	if (tb1) {
		RTHOOK(4);
		F3463_43716(Current, loc1, arg1, (EIF_CHARACTER_8) '\000');
	} else {
		RTHOOK(5);
		tc1 = F3463_43689(Current);
		F3463_43716(Current, loc1, arg1, tc1);
	}
	RTHOOK(6);
	tr1 = RTLNS(3462, 3462, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F3463_43665(RTCV(tr1), loc1);
	RTHOOK(7);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.extended_path */
EIF_REFERENCE F3463_43691 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	RTLD;
	
	RTLI(5);
	RTLR(0,loc1);
	RTLR(1,tr1);
	RTLR(2,Current);
	RTLR(3,tr2);
	RTLR(4,arg1);
	
	RTEAA("extended_path", 3462, Current, 1, 1, 44228);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNSMART(eif_non_attached_type(3669));
	tr2 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr2) + O37728[Dtype(tr2)-3664]);
	tr2 = *(EIF_REFERENCE *)(RTCV(arg1));
	ti4_2 = *(EIF_INTEGER_32 *)(RTCV(tr2) + O37728[Dtype(tr2)-3664]);
	ti4_3 = F3463_43707(Current);
	F3665_46507(RTCV(tr1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + ti4_2) + ti4_3));
	loc1 = (EIF_REFERENCE) tr1;
	RTHOOK(2);
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R37856[Dtype(loc1)-3669])(RTCV(loc1), *(EIF_REFERENCE *)(Current));
	RTHOOK(3);
	tb1 = '\0';
	ti4_1 = *(EIF_INTEGER_32 *)(RTCV(loc1) + O37728[Dtype(loc1)-3664]);
	if ((EIF_BOOLEAN) (ti4_1 > ((EIF_INTEGER_32) 0L))) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCV(loc1) + O37728[Dtype(loc1)-3664]);
		tb1 = (EIF_BOOLEAN)(F3463_43713(Current) == ti4_1);
	}
	if (tb1) {
		RTHOOK(4);
		tr1 = *(EIF_REFERENCE *)(RTCV(arg1));
		F3463_43717(Current, loc1, tr1, (EIF_CHARACTER_8) '\000');
	} else {
		RTHOOK(5);
		tr1 = *(EIF_REFERENCE *)(RTCV(arg1));
		tc1 = F3463_43689(Current);
		F3463_43717(Current, loc1, tr1, tc1);
	}
	RTHOOK(6);
	tr1 = RTLNS(3462, 3462, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F3463_43666(RTCV(tr1), loc1);
	RTHOOK(7);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.appended */
EIF_REFERENCE F3463_43692 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	RTLD;
	
	RTLI(5);
	RTLR(0,loc1);
	RTLR(1,tr1);
	RTLR(2,Current);
	RTLR(3,tr2);
	RTLR(4,arg1);
	
	RTEAA("appended", 3462, Current, 1, 1, 44229);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNSMART(eif_non_attached_type(3669));
	tr2 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr2) + O37728[Dtype(tr2)-3664]);
	ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R37614[Dtype(arg1)-3662])(RTCV(arg1));
	ti4_3 = F3463_43707(Current);
	F3665_46507(RTCV(tr1), (EIF_INTEGER_32) (ti4_1 + (EIF_INTEGER_32) (ti4_2 * ti4_3)));
	loc1 = (EIF_REFERENCE) tr1;
	RTHOOK(2);
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R37856[Dtype(loc1)-3669])(RTCV(loc1), *(EIF_REFERENCE *)(Current));
	RTHOOK(3);
	F3463_43716(Current, loc1, arg1, (EIF_CHARACTER_8) '\000');
	RTHOOK(4);
	tr1 = RTLNS(3462, 3462, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F3463_43665(RTCV(tr1), loc1);
	RTHOOK(5);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.appended_with_extension */
EIF_REFERENCE F3463_43693 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_INTEGER_32 ti4_4;
	RTLD;
	
	RTLI(5);
	RTLR(0,loc1);
	RTLR(1,tr1);
	RTLR(2,Current);
	RTLR(3,tr2);
	RTLR(4,arg1);
	
	RTEAA("appended_with_extension", 3462, Current, 2, 1, 44230);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNSMART(eif_non_attached_type(3669));
	tr2 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr2) + O37728[Dtype(tr2)-3664]);
	ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R37614[Dtype(arg1)-3662])(RTCV(arg1));
	ti4_3 = F3463_43707(Current);
	ti4_4 = F3463_43707(Current);
	F3665_46507(RTCV(tr1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + (EIF_INTEGER_32) (ti4_2 * ti4_3)) + ti4_4));
	loc1 = (EIF_REFERENCE) tr1;
	RTHOOK(2);
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R37856[Dtype(loc1)-3669])(RTCV(loc1), *(EIF_REFERENCE *)(Current));
	RTHOOK(3);
	F3463_43716(Current, loc1, arg1, (EIF_CHARACTER_8) '.');
	RTHOOK(4);
	tr1 = RTLNS(3462, 3462, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F3463_43666(RTCV(tr1), loc1);
	RTHOOK(5);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.same_as */
EIF_BOOLEAN F3463_43694 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(2);
	RTLR(0,arg1);
	RTLR(1,Current);
	
	RTEAA("same_as", 3462, Current, 0, 1, 44231);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN)(arg1 == NULL)) {
	} else {
		RTHOOK(2);
		if ((EIF_BOOLEAN)(arg1 == Current)) {
			RTHOOK(3);
			RTHOOK(4);
			RTLE;
			RTEE;
			return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		} else {
			RTHOOK(5);
			if ((EIF_BOOLEAN) EIF_TEST(eif_case_sensitive_path_names())) {
				RTHOOK(6);
				RTHOOK(7);
				RTLE;
				RTEE;
				return (EIF_BOOLEAN) F3463_43697(Current, arg1);
			} else {
				RTHOOK(8);
				RTHOOK(9);
				RTLE;
				RTEE;
				return (EIF_BOOLEAN) F3463_43698(Current, arg1);
			}
		}
	}
	RTHOOK(10);
	RTLE;
	RTEE;
	return (EIF_BOOLEAN) 0;
}

/* {PATH}.is_less */
EIF_BOOLEAN F3463_43695 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,arg1);
	RTLR(3,tr2);
	
	RTEAA("is_less", 3462, Current, 0, 1, 44232);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN) EIF_TEST(eif_case_sensitive_path_names())) {
		RTHOOK(2);
		tr1 = *(EIF_REFERENCE *)(Current);
		tr2 = *(EIF_REFERENCE *)(RTCV(arg1));
		Result = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE, EIF_REFERENCE)) R19689[Dtype(tr1)-1889])(RTCV(tr1), tr2);
	} else {
		RTHOOK(3);
		tr1 = F3664_46497(RTCV(F3463_43702(Current)));
		tr2 = F3463_43702(RTCV(arg1));
		tr2 = F3664_46497(RTCV(tr2));
		Result = F3663_46463(RTCV(tr1), tr2);
	}
	RTHOOK(4);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.is_equal */
EIF_BOOLEAN F3463_43696 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	
	
	RTEAA("is_equal", 3462, Current, 0, 1, 44233);
	RTHOOK(1);
	RTHOOK(2);
	RTEE;
	return (EIF_BOOLEAN) F3463_43694(Current, arg1);
}

/* {PATH}.is_case_sensitive_equal */
EIF_BOOLEAN F3463_43697 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	
	RTEAA("is_case_sensitive_equal", 3462, Current, 0, 1, 44234);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN)(arg1 == Current)) {
		RTHOOK(2);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	} else {
		RTHOOK(4);
		tr1 = *(EIF_REFERENCE *)(Current);
		tr2 = *(EIF_REFERENCE *)(RTCV(arg1));
		Result = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE, EIF_REFERENCE)) R11[Dtype(tr1)-0])(RTCV(tr1), tr2);
	}
	RTHOOK(5);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.is_case_insensitive_equal */
EIF_BOOLEAN F3463_43698 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	
	RTEAA("is_case_insensitive_equal", 3462, Current, 0, 1, 44235);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN)(arg1 == Current)) {
		RTHOOK(2);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	} else {
		RTHOOK(4);
		tr1 = F3463_43702(Current);
		tr2 = F3463_43702(RTCV(arg1));
		Result = F3663_46461(RTCV(tr1), tr2);
	}
	RTHOOK(5);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.copy */
void F3463_43699 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	
	RTEAA("copy", 3462, Current, 0, 1, 44236);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN)(arg1 != Current)) {
		RTHOOK(2);
		F1_16(Current, arg1);
		RTHOOK(3);
		tr1 = *(EIF_REFERENCE *)(RTCV(arg1));
		tr1 = (EIF_REFERENCE) eif_builtin_ANY_twin (tr1);
		RTAR(Current, tr1);
		*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	}
	RTHOOK(4);
	RTLE;
	RTEE;
}

/* {PATH}.out */
EIF_REFERENCE F3463_43700 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	
	
	RTEAA("out", 3462, Current, 0, 0, 44237);
	RTHOOK(1);
	RTHOOK(2);
	RTEE;
	return (EIF_REFERENCE) F3463_43701(Current);
}

/* {PATH}.utf_8_name */
EIF_REFERENCE F3463_43701 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	struct eif_ex_280 sloc1;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) sloc1.data;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	memset (&sloc1.overhead, 0, OVERHEAD + _OBJSIZ_0_0_0_0_0_0_0_0_);
	sloc1.overhead.ov_flags = EO_EXP | EO_STACK;
	RT_DFS(&sloc1.overhead, 308);
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,Result);
	
	RTEAA("utf_8_name", 3462, Current, 1, 0, 44238);
	RTGC;
	RTHOOK(1);
	tr1 = F3463_43702(Current);
	Result = F309_6680(RTCV(loc1), tr1);
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.name */
EIF_REFERENCE F3463_43702 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	struct eif_ex_280 sloc1;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) sloc1.data;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	memset (&sloc1.overhead, 0, OVERHEAD + _OBJSIZ_0_0_0_0_0_0_0_0_);
	sloc1.overhead.ov_flags = EO_EXP | EO_STACK;
	RT_DFS(&sloc1.overhead, 308);
	RTLI(6);
	RTLR(0,loc2);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc1);
	RTLR(4,tr2);
	RTLR(5,Result);
	
	RTEAA("name", 3462, Current, 2, 0, 44239);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_1_);
	loc2 = tr1;
	if (EIF_TEST(loc2)) {
		RTHOOK(2);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_REFERENCE) loc2;
	} else {
		RTHOOK(4);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
			RTHOOK(5);
			tr1 = RTLNS(3663, 3663, _OBJSIZ_1_0_0_4_0_0_0_0_);
			tr2 = F309_6722(RTCV(loc1), *(EIF_REFERENCE *)(Current));
			F3663_46439(RTCV(tr1), tr2);
			Result = (EIF_REFERENCE) tr1;
		} else {
			RTHOOK(6);
			tr1 = RTLNS(3663, 3663, _OBJSIZ_1_0_0_4_0_0_0_0_);
			tr2 = F309_6695(RTCV(loc1), *(EIF_REFERENCE *)(Current));
			F3663_46439(RTCV(tr1), tr2);
			Result = (EIF_REFERENCE) tr1;
		}
		RTHOOK(7);
		RTAR(Current, Result);
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) Result;
	}
	RTHOOK(8);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.to_pointer */
EIF_REFERENCE F3463_43704 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,tr1);
	RTLR(2,Current);
	RTLR(3,tr2);
	
	RTEAA("to_pointer", 3462, Current, 1, 0, 44241);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNS(2395, 2395, _OBJSIZ_1_0_0_1_0_0_0_0_);
	tr2 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr2) + O37728[Dtype(tr2)-3664]);
	ti4_2 = F3463_43707(Current);
	F2396_26706(RTCV(tr1), (EIF_INTEGER_32) (ti4_1 + ti4_2));
	loc1 = (EIF_REFERENCE) tr1;
	RTHOOK(2);
	F2396_26730(RTCV(loc1), *(EIF_REFERENCE *)(Current));
	RTHOOK(3);
	tr1 = *(EIF_REFERENCE *)(RTCV(loc1));
	RTHOOK(4);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.storage */
EIF_REFERENCE F3463_43706 (EIF_REFERENCE Current)
{
	return *(EIF_REFERENCE *)(Current);
}


/* {PATH}.unit_size */
EIF_INTEGER_32 F3463_43707 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("unit_size", 3462, Current, 0, 0, 44244);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
		RTHOOK(2);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
	} else {
		RTHOOK(4);
		RTHOOK(5);
		RTLE;
		RTEE;
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	}/* NOTREACHED */
	
}

/* {PATH}.reset_internal_data */
void F3463_43708 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	
	
	RTEAA("reset_internal_data", 3462, Current, 0, 0, 44245);
	RTHOOK(1);
	*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
	RTHOOK(2);
	RTEE;
}

/* {PATH}.normalize */
void F3463_43709 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc4 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc5 = (EIF_INTEGER_32) 0;
	EIF_BOOLEAN loc6 = (EIF_BOOLEAN) 0;
	EIF_BOOLEAN loc7 = (EIF_BOOLEAN) 0;
	EIF_BOOLEAN loc8 = (EIF_BOOLEAN) 0;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_CHARACTER_8 tc1;
	RTLD;
	
	RTLI(2);
	RTLR(0,loc1);
	RTLR(1,Current);
	
	RTEAA("normalize", 3462, Current, 8, 0, 44246);
	RTGC;
	RTHOOK(1);
	loc1 = *(EIF_REFERENCE *)(Current);
	RTHOOK(2);
	loc4 = *(EIF_INTEGER_32 *)(RTCV(loc1) + O37728[Dtype(loc1)-3664]);
	RTHOOK(3);
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
		RTHOOK(4);
		loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		RTHOOK(5);
		if ((EIF_BOOLEAN) (loc4 >= ((EIF_INTEGER_32) 10L))) {
			RTHOOK(6);
			tb1 = '\01';
			tb2 = '\0';
			if (F3463_43719(Current, loc1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '/')) {
				tb3 = '\01';
				if (!F3463_43719(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '/')) {
					tb3 = F3463_43719(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '\\');
				}
				tb2 = tb3;
			}
			if (!(tb2)) {
				tb2 = '\0';
				if (F3463_43719(Current, loc1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '\\')) {
					tb3 = '\01';
					if (!F3463_43719(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '\\')) {
						tb3 = F3463_43719(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '/');
					}
					tb2 = tb3;
				}
				tb1 = tb2;
			}
			if (tb1) {
				RTHOOK(7);
				tb1 = '\0';
				if ((EIF_BOOLEAN) !F3463_43719(Current, loc1, ((EIF_INTEGER_32) 5L), (EIF_CHARACTER_8) '/')) {
					tb1 = (EIF_BOOLEAN) !F3463_43719(Current, loc1, ((EIF_INTEGER_32) 5L), (EIF_CHARACTER_8) '\\');
				}
				if (tb1) {
					RTHOOK(8);
					loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 5L);
					RTHOOK(9);
					loc8 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
				}
			}
		}
		RTHOOK(10);
		loc3 = (EIF_INTEGER_32) loc2;
		RTHOOK(11);
		loc7 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		for (;;) {
			RTHOOK(12);
			if ((EIF_BOOLEAN) (loc2 > loc4)) break;
			RTHOOK(13);
			if (loc6) {
				RTHOOK(14);
				loc7 = '\0';
				if ((EIF_BOOLEAN) !F3463_43719(Current, loc1, loc2, (EIF_CHARACTER_8) '\\')) {
					loc7 = (EIF_BOOLEAN) !F3463_43719(Current, loc1, loc2, (EIF_CHARACTER_8) '/');
				}
				RTHOOK(15);
				loc6 = (EIF_BOOLEAN) (EIF_BOOLEAN) !loc7;
			} else {
				RTHOOK(16);
				if (F3463_43719(Current, loc1, loc2, (EIF_CHARACTER_8) '/')) {
					RTHOOK(17);
					tc1 = (EIF_CHARACTER_8) '\\';
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R16637[Dtype(loc1)-2034])(RTCV(loc1), (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &loc2);
					RTHOOK(18);
					loc6 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
				} else {
					RTHOOK(19);
					loc6 = F3463_43719(Current, loc1, loc2, (EIF_CHARACTER_8) '\\');
				}
			}
			RTHOOK(20);
			if (loc7) {
				RTHOOK(21);
				if ((EIF_BOOLEAN)(loc2 != loc3)) {
					RTHOOK(22);
					tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20093[Dtype(loc1)-2034])(RTCV(loc1), loc2));
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R16637[Dtype(loc1)-2034])(RTCV(loc1), (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &loc3);
					RTHOOK(23);
					tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20093[Dtype(loc1)-2034])(RTCV(loc1), (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L))));
					ti4_1 = (EIF_INTEGER_32) (loc3 + ((EIF_INTEGER_32) 1L));
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R16637[Dtype(loc1)-2034])(RTCV(loc1), (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &ti4_1);
				}
				RTHOOK(24);
				loc3 += ((EIF_INTEGER_32) 2L);
			}
			RTHOOK(25);
			loc2 += ((EIF_INTEGER_32) 2L);
		}
	} else {
		RTHOOK(26);
		loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		RTHOOK(27);
		loc3 = (EIF_INTEGER_32) loc2;
		RTHOOK(28);
		loc7 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		for (;;) {
			RTHOOK(29);
			if ((EIF_BOOLEAN) (loc2 > loc4)) break;
			RTHOOK(30);
			if (loc6) {
				RTHOOK(31);
				loc7 = F3463_43719(Current, loc1, loc2, (EIF_CHARACTER_8) '/');
				loc7 = (EIF_BOOLEAN) (EIF_BOOLEAN) !loc7;
				RTHOOK(32);
				loc6 = (EIF_BOOLEAN) (EIF_BOOLEAN) !loc7;
			} else {
				RTHOOK(33);
				loc6 = F3463_43719(Current, loc1, loc2, (EIF_CHARACTER_8) '/');
			}
			RTHOOK(34);
			if (loc7) {
				RTHOOK(35);
				if ((EIF_BOOLEAN)(loc2 != loc3)) {
					RTHOOK(36);
					tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20093[Dtype(loc1)-2034])(RTCV(loc1), loc2));
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R16637[Dtype(loc1)-2034])(RTCV(loc1), (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &loc3);
				}
				RTHOOK(37);
				loc3++;
			}
			RTHOOK(38);
			loc2++;
		}
	}
	RTHOOK(39);
	if ((EIF_BOOLEAN)(loc2 != loc3)) {
		RTHOOK(40);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_INTEGER_32)) R37742[Dtype(loc1)-3667])(RTCV(loc1), (EIF_INTEGER_32) (loc3 - ((EIF_INTEGER_32) 1L)));
	}
	RTHOOK(41);
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	RTHOOK(42);
	if (loc8) {
		RTHOOK(43);
		loc5 = F3463_43713(Current);
		RTHOOK(44);
		if ((EIF_BOOLEAN)(loc5 == ((EIF_INTEGER_32) 0L))) {
			RTHOOK(45);
			ti4_1 = F3463_43707(Current);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_INTEGER_32)) R37874[Dtype(loc1)-3669])(RTCV(loc1), ti4_1);
		}
	}
	RTHOOK(46);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCV(loc1) + O37728[Dtype(loc1)-3664]);
	ti4_2 = F3463_43707(Current);
	tc1 = F3463_43689(Current);
	if (F3463_43719(Current, loc1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_2) + ((EIF_INTEGER_32) 1L)), tc1)) {
		RTHOOK(47);
		ti4_1 = *(EIF_INTEGER_32 *)(RTCV(loc1) + O37728[Dtype(loc1)-3664]);
		if ((EIF_BOOLEAN) (F3463_43713(Current) < ti4_1)) {
			RTHOOK(48);
			ti4_1 = F3463_43707(Current);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_INTEGER_32)) R37876[Dtype(loc1)-3669])(RTCV(loc1), ti4_1);
		}
	}
	RTHOOK(49);
	RTLE;
	RTEE;
}

/* {PATH}.internal_name */
EIF_REFERENCE F3463_43710 (EIF_REFERENCE Current)
{
	return *(EIF_REFERENCE *)(Current + _REFACS_1_);
}


/* {PATH}.env */
static EIF_REFERENCE F3463_43712_body (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
#define Result RTOTRR
	RTOUDR(31)

	RTLI(2);
	RTLR(0,tr1);
	RTLR(1,Current);
	
	RTEAA("env", 3462, Current, 0, 0, 44249);
	RTGC;
	RTOTP;
	RTHOOK(1);
	tr1 = RTLNS(2253, 2253, _OBJSIZ_0_0_0_1_0_0_0_0_);
	Result = (EIF_REFERENCE) tr1;
	RTOTE;
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
#undef Result
}

EIF_REFERENCE F3463_43712 (EIF_REFERENCE Current)
{
	GTCX
	return RTOUCR(31,F3463_43712_body,(Current));
}

/* {PATH}.root_end_position */
EIF_INTEGER_32 F3463_43713 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_CHARACTER_8 loc1 = (EIF_CHARACTER_8) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_CHARACTER_8 tc1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	
	RTEAA("root_end_position", 3462, Current, 2, 0, 44250);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current);
	tb1 = F1336_17903(RTCV(tr1));
	if ((EIF_BOOLEAN) !tb1) {
		RTHOOK(2);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
			RTHOOK(3);
			tb1 = '\0';
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr1) + O37728[Dtype(tr1)-3664]);
			if ((EIF_BOOLEAN)(ti4_1 == F3463_43707(Current))) {
				tr1 = *(EIF_REFERENCE *)(Current);
				tb1 = F3463_43719(Current, tr1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '\\');
			}
			if (tb1) {
				RTHOOK(4);
				RTHOOK(5);
				RTLE;
				RTEE;
				return (EIF_INTEGER_32) F3463_43707(Current);
			} else {
				RTHOOK(6);
				tb1 = '\0';
				tr1 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr1) + O37728[Dtype(tr1)-3664]);
				if ((EIF_BOOLEAN) (ti4_1 >= ((EIF_INTEGER_32) 4L))) {
					tb2 = '\0';
					tr1 = *(EIF_REFERENCE *)(Current);
					tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20093[Dtype(tr1)-2034])(RTCV(tr1), ((EIF_INTEGER_32) 2L)));
					if ((EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\000')) {
						tr1 = *(EIF_REFERENCE *)(Current);
						tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20093[Dtype(tr1)-2034])(RTCV(tr1), ((EIF_INTEGER_32) 4L)));
						tb2 = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\000');
					}
					tb1 = tb2;
				}
				if (tb1) {
					RTHOOK(7);
					tr1 = *(EIF_REFERENCE *)(Current);
					loc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20093[Dtype(tr1)-2034])(RTCV(tr1), ((EIF_INTEGER_32) 1L)));
					loc1 = (EIF_CHARACTER_8) tolower(loc1);
					RTHOOK(8);
					tb1 = '\0';
					if ((EIF_BOOLEAN) ((EIF_BOOLEAN) (loc1 >= (EIF_CHARACTER_8) 'a') && (EIF_BOOLEAN) (loc1 <= (EIF_CHARACTER_8) 'z'))) {
						tr1 = *(EIF_REFERENCE *)(Current);
						tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20093[Dtype(tr1)-2034])(RTCV(tr1), ((EIF_INTEGER_32) 3L)));
						tb1 = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) ':');
					}
					if (tb1) {
						RTHOOK(9);
						tb1 = '\0';
						tr1 = *(EIF_REFERENCE *)(Current);
						ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr1) + O37728[Dtype(tr1)-3664]);
						if ((EIF_BOOLEAN) (ti4_1 >= (EIF_INTEGER_32) (((EIF_INTEGER_32) 3L) * F3463_43707(Current)))) {
							tr1 = *(EIF_REFERENCE *)(Current);
							tb1 = F3463_43719(Current, tr1, ((EIF_INTEGER_32) 5L), (EIF_CHARACTER_8) '\\');
						}
						if (tb1) {
							RTHOOK(10);
							RTHOOK(11);
							RTLE;
							RTEE;
							return (EIF_INTEGER_32) ((EIF_INTEGER_32) 6L);
						} else {
							RTHOOK(12);
							RTHOOK(13);
							RTLE;
							RTEE;
							return (EIF_INTEGER_32) ((EIF_INTEGER_32) 4L);
						}
					} else {
						RTHOOK(14);
						tb1 = '\0';
						if ((EIF_BOOLEAN)(loc1 == (EIF_CHARACTER_8) '\\')) {
							tr1 = *(EIF_REFERENCE *)(Current);
							tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20093[Dtype(tr1)-2034])(RTCV(tr1), ((EIF_INTEGER_32) 3L)));
							tb1 = (EIF_BOOLEAN)(tc1 != (EIF_CHARACTER_8) '\\');
						}
						if (tb1) {
							RTHOOK(15);
							Result = F3463_43707(Current);
						} else {
							RTHOOK(16);
							tb1 = '\0';
							tb2 = '\0';
							tb3 = '\0';
							tr1 = *(EIF_REFERENCE *)(Current);
							ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr1) + O37728[Dtype(tr1)-3664]);
							if ((EIF_BOOLEAN) (ti4_1 >= ((EIF_INTEGER_32) 10L))) {
								tb3 = (EIF_BOOLEAN)(loc1 == (EIF_CHARACTER_8) '\\');
							}
							if (tb3) {
								tr1 = *(EIF_REFERENCE *)(Current);
								tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20093[Dtype(tr1)-2034])(RTCV(tr1), ((EIF_INTEGER_32) 3L)));
								tb2 = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\\');
							}
							if (tb2) {
								tr1 = *(EIF_REFERENCE *)(Current);
								tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20093[Dtype(tr1)-2034])(RTCV(tr1), ((EIF_INTEGER_32) 5L)));
								tb1 = (EIF_BOOLEAN)(tc1 != (EIF_CHARACTER_8) '\\');
							}
							if (tb1) {
								RTHOOK(17);
								loc2 = F3463_43715(Current, ((EIF_INTEGER_32) 7L));
								RTHOOK(18);
								tb1 = '\0';
								if ((EIF_BOOLEAN) (loc2 > ((EIF_INTEGER_32) 0L))) {
									tr1 = *(EIF_REFERENCE *)(Current);
									ti4_1 = *(EIF_INTEGER_32 *)(RTCV(tr1) + O37728[Dtype(tr1)-3664]);
									tb1 = (EIF_BOOLEAN) ((EIF_INTEGER_32) (loc2 + F3463_43707(Current)) <= ti4_1);
								}
								if (tb1) {
									RTHOOK(19);
									ti4_1 = F3463_43707(Current);
									loc2 = F3463_43715(Current, (EIF_INTEGER_32) (loc2 + ti4_1));
									RTHOOK(20);
									if ((EIF_BOOLEAN) (loc2 > ((EIF_INTEGER_32) 0L))) {
										RTHOOK(21);
										RTHOOK(22);
										RTLE;
										RTEE;
										return (EIF_INTEGER_32) (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L));
									} else {
										RTHOOK(23);
										tr1 = *(EIF_REFERENCE *)(Current);
										Result = *(EIF_INTEGER_32 *)(RTCV(tr1) + O37728[Dtype(tr1)-3664]);
									}
								}
							}
						}
					}
				}
			}
		} else {
			RTHOOK(24);
			tr1 = *(EIF_REFERENCE *)(Current);
			tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20093[Dtype(tr1)-2034])(RTCV(tr1), ((EIF_INTEGER_32) 1L)));
			if ((EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '/')) {
				RTHOOK(25);
				RTHOOK(26);
				RTLE;
				RTEE;
				return (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
		}
	}
	RTHOOK(27);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.end_position_of_last_directory_separator */
EIF_INTEGER_32 F3463_43714 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	
	RTEAA("end_position_of_last_directory_separator", 3462, Current, 0, 0, 44251);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current);
	tb1 = F1336_17903(RTCV(tr1));
	if ((EIF_BOOLEAN) !tb1) {
		RTHOOK(2);
		tr1 = *(EIF_REFERENCE *)(Current);
		Result = *(EIF_INTEGER_32 *)(RTCV(tr1) + O37728[Dtype(tr1)-3664]);
		ti4_1 = F3463_43707(Current);
		Result = (EIF_INTEGER_32) (EIF_INTEGER_32) ((EIF_INTEGER_32) (Result - ti4_1) + ((EIF_INTEGER_32) 1L));
		RTHOOK(3);
		if ((EIF_BOOLEAN) (Result >= ((EIF_INTEGER_32) 1L))) {
			for (;;) {
				RTHOOK(4);
				tb1 = '\01';
				if (!(EIF_BOOLEAN) (Result < ((EIF_INTEGER_32) 1L))) {
					tr1 = *(EIF_REFERENCE *)(Current);
					tc1 = F3463_43689(Current);
					tb1 = F3463_43719(Current, tr1, Result, tc1);
				}
				if (tb1) break;
				RTHOOK(5);
				Result -= F3463_43707(Current);
			}
		}
		RTHOOK(6);
		if ((EIF_BOOLEAN) (Result < ((EIF_INTEGER_32) 0L))) {
			RTHOOK(7);
			RTHOOK(8);
			RTLE;
			RTEE;
			return (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
		} else {
			RTHOOK(9);
			ti4_1 = F3463_43707(Current);
			Result = (EIF_INTEGER_32) (EIF_INTEGER_32) ((EIF_INTEGER_32) (Result + ti4_1) - ((EIF_INTEGER_32) 1L));
		}
	}
	RTHOOK(10);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.next_directory_separator */
EIF_INTEGER_32 F3463_43715 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_CHARACTER_8 loc3 = (EIF_CHARACTER_8) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_BOOLEAN tb1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,loc4);
	
	RTEAA("next_directory_separator", 3462, Current, 4, 1, 44252);
	RTGC;
	RTHOOK(1);
	loc2 = F3463_43707(Current);
	RTHOOK(2);
	loc3 = F3463_43689(Current);
	RTHOOK(3);
	Result = (EIF_INTEGER_32) arg1;
	RTHOOK(4);
	loc4 = *(EIF_REFERENCE *)(Current);
	RTHOOK(5);
	loc1 = *(EIF_INTEGER_32 *)(RTCV(loc4) + O37728[Dtype(loc4)-3664]);
	for (;;) {
		RTHOOK(6);
		tb1 = '\01';
		if (!(EIF_BOOLEAN) ((EIF_BOOLEAN) (Result < ((EIF_INTEGER_32) 1L)) || (EIF_BOOLEAN) (Result > loc1))) {
			tb1 = F3463_43719(Current, loc4, Result, loc3);
		}
		if (tb1) break;
		RTHOOK(7);
		Result += loc2;
	}
	RTHOOK(8);
	if ((EIF_BOOLEAN) (Result > loc1)) {
		RTHOOK(9);
		RTHOOK(10);
		RTLE;
		RTEE;
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
	}
	RTHOOK(11);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.internal_append_into */
void F3463_43716 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_CHARACTER_8 arg3)
{
	GTCX
	RTEX;
	struct eif_ex_280 sloc1;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) sloc1.data;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_CHARACTER_32 tw1;
	EIF_CHARACTER_32 tw2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	RTLD;
	
	memset (&sloc1.overhead, 0, OVERHEAD + _OBJSIZ_0_0_0_0_0_0_0_0_);
	sloc1.overhead.ov_flags = EO_EXP | EO_STACK;
	RT_DFS(&sloc1.overhead, 308);
	RTLI(4);
	RTLR(0,arg2);
	RTLR(1,arg1);
	RTLR(2,Current);
	RTLR(3,loc1);
	
	RTEAA("internal_append_into", 3462, Current, 1, 3, 44253);
	RTGC;
	RTHOOK(1);
	tb1 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R37594[Dtype(arg2)-3663])(RTCV(arg2));
	if ((EIF_BOOLEAN) !tb1) {
		RTHOOK(2);
		tb1 = '\0';
		if ((EIF_BOOLEAN)(arg3 != (EIF_CHARACTER_8) '\000')) {
			tb2 = F1336_17903(RTCV(arg1));
			tb1 = (EIF_BOOLEAN) !tb2;
		}
		if (tb1) {
			RTHOOK(3);
			tb1 = '\0';
			ti4_1 = *(EIF_INTEGER_32 *)(RTCV(arg1) + O37728[Dtype(arg1)-3664]);
			ti4_2 = F3463_43707(Current);
			if ((EIF_BOOLEAN) !F3463_43719(Current, arg1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_2) + ((EIF_INTEGER_32) 1L)), arg3)) {
				tw1 = (FUNCTION_CAST(EIF_CHARACTER_32, (EIF_REFERENCE, EIF_INTEGER_32)) R37580[Dtype(arg2)-3663])(RTCV(arg2), ((EIF_INTEGER_32) 1L));
				tw2 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '/';
				tb1 = (EIF_BOOLEAN)(tw1 != tw2);
			}
			if (tb1) {
				RTHOOK(4);
				if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
					RTHOOK(5);
					tw1 = (FUNCTION_CAST(EIF_CHARACTER_32, (EIF_REFERENCE, EIF_INTEGER_32)) R37580[Dtype(arg2)-3663])(RTCV(arg2), ((EIF_INTEGER_32) 1L));
					tw2 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '\\';
					if ((EIF_BOOLEAN)(tw1 != tw2)) {
						RTHOOK(6);
						(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R37869[Dtype(arg1)-3669])(RTCV(arg1), arg3);
						RTHOOK(7);
						(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R37869[Dtype(arg1)-3669])(RTCV(arg1), (EIF_CHARACTER_8) '\000');
					}
				} else {
					RTHOOK(8);
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R37869[Dtype(arg1)-3669])(RTCV(arg1), arg3);
				}
			}
		}
		RTHOOK(9);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
			RTHOOK(10);
			F309_6709(RTCV(loc1), arg2, arg1);
		} else {
			RTHOOK(11);
			F309_6684(RTCV(loc1), arg2, arg1);
		}
	}
	RTHOOK(12);
	RTLE;
	RTEE;
}

/* {PATH}.internal_path_append_into */
void F3463_43717 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_CHARACTER_8 arg3)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,arg2);
	
	RTEAA("internal_path_append_into", 3462, Current, 0, 3, 44254);
	RTGC;
	RTHOOK(1);
	tb1 = '\0';
	if ((EIF_BOOLEAN)(arg3 != (EIF_CHARACTER_8) '\000')) {
		tb2 = F1336_17903(RTCV(arg1));
		tb1 = (EIF_BOOLEAN) !tb2;
	}
	if (tb1) {
		RTHOOK(2);
		tb1 = '\0';
		ti4_1 = *(EIF_INTEGER_32 *)(RTCV(arg1) + O37728[Dtype(arg1)-3664]);
		ti4_2 = F3463_43707(Current);
		if ((EIF_BOOLEAN) !F3463_43719(Current, arg1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_2) + ((EIF_INTEGER_32) 1L)), arg3)) {
			tb1 = (EIF_BOOLEAN) !F3463_43719(Current, arg2, ((EIF_INTEGER_32) 1L), arg3);
		}
		if (tb1) {
			RTHOOK(3);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R37869[Dtype(arg1)-3669])(RTCV(arg1), arg3);
			RTHOOK(4);
			if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
				RTHOOK(5);
				(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R37869[Dtype(arg1)-3669])(RTCV(arg1), (EIF_CHARACTER_8) '\000');
			}
		}
	}
	RTHOOK(6);
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R37856[Dtype(arg1)-3669])(RTCV(arg1), arg2);
	RTHOOK(7);
	RTLE;
	RTEE;
}

/* {PATH}.internal_path_append_substring_into */
void F3463_43718 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_CHARACTER_8 arg5)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,arg2);
	
	RTEAA("internal_path_append_substring_into", 3462, Current, 0, 5, 44255);
	RTGC;
	RTHOOK(1);
	tb1 = '\0';
	if ((EIF_BOOLEAN)(arg5 != (EIF_CHARACTER_8) '\000')) {
		tb2 = F1336_17903(RTCV(arg1));
		tb1 = (EIF_BOOLEAN) !tb2;
	}
	if (tb1) {
		RTHOOK(2);
		tb1 = '\0';
		ti4_1 = *(EIF_INTEGER_32 *)(RTCV(arg1) + O37728[Dtype(arg1)-3664]);
		ti4_2 = F3463_43707(Current);
		if ((EIF_BOOLEAN) !F3463_43719(Current, arg1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_2) + ((EIF_INTEGER_32) 1L)), arg5)) {
			tb1 = (EIF_BOOLEAN) !F3463_43719(Current, arg2, arg3, arg5);
		}
		if (tb1) {
			RTHOOK(3);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R37869[Dtype(arg1)-3669])(RTCV(arg1), arg5);
			RTHOOK(4);
			if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
				RTHOOK(5);
				(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R37869[Dtype(arg1)-3669])(RTCV(arg1), (EIF_CHARACTER_8) '\000');
			}
		}
	}
	RTHOOK(6);
	F3670_46752(RTCV(arg1), arg2, arg3, arg4);
	RTHOOK(7);
	RTLE;
	RTEE;
}

/* {PATH}.is_character */
EIF_BOOLEAN F3463_43719 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_INTEGER_32 arg2, EIF_CHARACTER_8 arg3)
{
	GTCX
	RTEX;
	EIF_CHARACTER_8 tc1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,arg1);
	RTLR(1,Current);
	
	RTEAA("is_character", 3462, Current, 0, 3, 44256);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
		RTHOOK(2);
		Result = '\0';
		tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20093[Dtype(arg1)-2034])(RTCV(arg1), arg2));
		if ((EIF_BOOLEAN)(tc1 == arg3)) {
			tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20093[Dtype(arg1)-2034])(RTCV(arg1), (EIF_INTEGER_32) (arg2 + ((EIF_INTEGER_32) 1L))));
			Result = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\000');
		}
	} else {
		RTHOOK(3);
		tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R20093[Dtype(arg1)-2034])(RTCV(arg1), arg2));
		Result = (EIF_BOOLEAN) (EIF_BOOLEAN)(tc1 == arg3);
	}
	RTHOOK(4);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.c_same_files */
EIF_BOOLEAN F3463_43722 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2)
{
	GTCX
	RTEX;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("c_same_files", 3462, Current, 0, 2, 44259);
	Result = EIF_TEST(inline_F3463_43722 ((EIF_POINTER) arg1, (EIF_POINTER) arg2));
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

void EIF_Minit2568 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
