note

	status: "See notice at end of class.";
	date: "$Date: 2008-12-29 12:27:11 -0800 (Mon, 29 Dec 2008) $";
	revision: "$Revision: 76420 $"

class

	FILE_SELEC

inherit

	TERMINAL_OUI
		redefine
			make, make_unmanaged, create_ev_widget,
			implementation
		end

create

	make, make_unmanaged

feature {NONE} -- Initialization

	make (a_name: STRING; a_parent: COMPOSITE)
			-- Create a selection list with `a_name' as identifier,
			-- `a_parent' as parent and call `set_default'.
		do
			create_ev_widget (a_name, a_parent, True)
		end;

	make_unmanaged (a_name: STRING; a_parent: COMPOSITE)
			-- Create an unmanaged selection list with `a_name' as identifier,
			-- `a_parent' as parent and call `set_default'.
		do
			create_ev_widget (a_name, a_parent, False)
		end;

	create_ev_widget (a_name: STRING; a_parent: COMPOSITE; man: BOOLEAN)
			-- Create a selection list with `a_name' as identifier,
			-- `a_parent' as parent and call `set_default'.
		do
			depth := a_parent.depth+1;
			widget_manager.new (Current, a_parent);
			if a_name /= Void then
				identifier := a_name.twin
			else
				identifier := Void
			end
			create {FILE_SELEC_IMP} implementation.make (Current, man, a_parent);
			set_default
		end;

feature -- Element change

	add_cancel_action (a_command: COMMAND; argument: ANY)
			-- Add `a_command' to the list of action to execute when
			-- cancel button is activated.
		require
			exists: not destroyed;
			valid_command: a_command /= Void
		do
			implementation.add_cancel_action (a_command, argument)
		end;

	add_filter_action (a_command: COMMAND; argument: ANY)
			-- Add `a_command' to the list of action to execute when
			-- filter button is activated.
		require
			exists: not destroyed;
			valid_command: a_command /= Void
		do
			implementation.add_filter_action (a_command, argument)
		end;

	add_help_action (a_command: COMMAND; argument: ANY)
			-- Add `a_command' to the list of action to execute when
			-- help button is activated.
		require
			exists: not destroyed;
			valid_command: a_command /= Void
		do
			implementation.add_help_action (a_command, argument)
		end;

	add_ok_action (a_command: COMMAND; argument: ANY)
			-- Add `a_command' to the list of action to execute when
			-- ok button is activated.
		require
			exists: not destroyed;
			valid_command: a_command /= Void
		do
			implementation.add_ok_action (a_command, argument)
		end;

	dir_count: INTEGER
			-- Number of items in directory list
		require
			exists: not destroyed
		do
			Result := implementation.dir_count
		end;

	dir_list: LINKED_LIST [STRING]
			-- Items of current directory list
		require
			exists: not destroyed
		do
			Result := implementation.dir_list
		end;

	directory: STRING
			-- Base directory used in determining files and directories
			-- to be displayed
		require
			exists: not destroyed
		do
			Result := implementation.directory
		end;

	file_count: INTEGER
			-- Number of items in file list
		require
			exists: not destroyed
		do
			Result := implementation.file_count
		end;

	file_list: LINKED_LIST [STRING_GENERAL]
			-- Items of current file list
		require
			exists: not destroyed
		do
			Result := implementation.file_list
		end;

	filter: STRING
			-- Current filter value
		require
			exists: not destroyed
		do
			Result := implementation.filter
		end;

	hide_cancel_button
			-- Make cancel button invisible.
		require
			exists: not destroyed
		do
			implementation.hide_cancel_button
		end;

	hide_filter_button
			-- Make filter button invisible.
		require
			exists: not destroyed
		do
			implementation.hide_filter_button
		end;

	hide_help_button
			-- Make help button invisible.
		require
			exists: not destroyed
		do
			implementation.hide_help_button
		end;

	hide_ok_button
			-- Make ok button invisible.
		require
			exists: not destroyed
		do
			implementation.hide_ok_button
		end;

	set_directory_selection
			-- Sets selection to directories only.
		require
			exists: not destroyed
		do
			implementation.set_directory_selection
		end;

   	set_file_selection
	   		-- Sets selection to files (default value).
		require
			exists: not destroyed
	   	do
   			implementation.set_file_selection
	   	end;

   	set_all_selection
	   		-- Sets selection to files and directories.
		require
			exists: not destroyed
	   	do
	 		implementation.set_all_selection
	   	end;

feature {G_ANY, G_ANY_I, WIDGET_I, TOOLKIT}

	implementation: FILE_SELEC_I;
			-- Implementation of current file selection

feature

	is_dir_valid: BOOLEAN
			-- Is current search directory valid?
		require
			exists: not destroyed
		do
			Result := implementation.is_dir_valid
		end;

	is_list_updated: BOOLEAN
			-- Is file od directory list updated during last search?
		require
			exists: not destroyed
		do
			Result := implementation.is_list_updated
		end;

	pattern: STRING
			-- Search pattern used in combination with `directory'
			-- files and directories to be displayed
		require
			exists: not destroyed
		do
			Result := implementation.pattern
		end;

	pattern_name: STRING
			-- Name of the search pattern
		require
			exists: not destroyed
		do
			Result := implementation.pattern_name
		end;

	remove_cancel_action (a_command: COMMAND; argument: ANY)
			-- Remove `a_command' from the list of action to execute when
			-- cancel button is activated.
		require
			exists: not destroyed;
			valid_command: a_command /= Void
		do
			implementation.remove_cancel_action (a_command, argument)
		end;

	remove_filter_action (a_command: COMMAND; argument: ANY)
			-- Remove `a_command' from the list of action to execute when
			-- filter button is activated.
		require
			exists: not destroyed;
			valid_command: a_command /= Void
		do
			implementation.remove_filter_action (a_command, argument)
		end;

	remove_help_action (a_command: COMMAND; argument: ANY)
			-- Remove `a_command' from the list of action to execute when
			-- help button is activated.
		require
			exists: not destroyed;
			valid_command: a_command /= Void
		do
			implementation.remove_help_action (a_command, argument)
		end;

	remove_ok_action (a_command: COMMAND; argument: ANY)
			-- Remove `a_command' from the list of action to execute when
			-- ok button is activated.
		require
			exists: not destroyed;
			valid_command: a_command /= Void
		do
			implementation.remove_ok_action (a_command, argument)
		end;

	selected_file: STRING
			-- Current selected file
		require
			exists: not destroyed;
		do
			Result := implementation.selected_file
		end;

	set_dir_list_label (a_label: STRING)
			-- Set `a_label' as dir list label,
			-- by default this label is `Directories'.
		require
			exists: not destroyed;
		do
			implementation.set_dir_list_label (a_label)
		end;

	set_directory (a_directory_name: STRING)
			-- Set base directory used in determining files and directories
			-- to be displayed to `a_directory_name'.
		require
			exists: not destroyed;
			not_a_directory_name_void: a_directory_name /= Void
		do
			implementation.set_directory (a_directory_name)
		end;

	set_file_list_label (a_label: STRING)
			-- Set `a_label' as file list label,
			-- by default this label is `Files'.
		require
			exists: not destroyed;
			valid_a_label: a_label /= Void
		do
			implementation.set_file_list_label (a_label)
		end;

	set_filter (a_filter: STRING)
			-- Set current filter to `a_filter'.
		require
			exists: not destroyed;
			not_a_filter_void: a_filter /= Void
		do
			implementation.set_filter (a_filter)
		end;

	set_filter_label (a_label: STRING)
			-- Set `a_label' as filter label,
			-- by default this label is `Filter'.
		require
			exists: not destroyed;
			valid_a_label: a_label /= Void
		do
			implementation.set_filter_label (a_label)
		end;

	set_pattern (a_pattern: STRING)
			-- Set pattern to `a_pattern'.
		require
			exists: not destroyed;
			not_a_pattern_void: a_pattern /= Void
		do
			implementation.set_pattern (a_pattern)
		end;

	set_pattern_name (a_name: STRING)
			-- Give `a_name' to a pattern.
		require
			exists: not destroyed
			not_a_name_void: a_name /= Void
		do
			implementation.set_pattern_name (a_name)
		end

	show_cancel_button
			-- Make cancel button visible.
		require
			exists: not destroyed
		do
			implementation.show_cancel_button
		end;

	show_filter_button
			-- Make filter button visible.
		require
			exists: not destroyed
		do
			implementation.show_filter_button
		end;

	show_help_button
			-- Make help button visible.
		require
			exists: not destroyed
		do
			implementation.show_help_button
		end;

	show_ok_button
			-- Make ok button visible.
		require
			exists: not destroyed
		do
			implementation.show_ok_button
		end;

	hide_file_selection_list
		require
			exists: not destroyed
		do
			implementation.hide_file_selection_list;
		end;

	show_file_selection_list
		require
			exists: not destroyed
		do
			implementation.show_file_selection_list;
		end;

	hide_file_selection_label
		require
			exists: not destroyed
		do
			implementation.hide_file_selection_label;
		end;

	show_file_selection_label
		require
			exists: not destroyed
		do
			implementation.show_file_selection_label;
		end;

	set_file_list_width (new_width: INTEGER)
		require
			exists: not destroyed;
			width_large_enough: new_width >= 1;
		do
			implementation.set_file_list_width (new_width);
		end;

note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"




end

