note

	description: "General label implementation"
	legal: "See notice at end of class.";
	status: "See notice at end of class.";
	date: "$Date: 2008-12-29 12:27:11 -0800 (Mon, 29 Dec 2008) $";
	revision: "$Revision: 76420 $"

deferred class

	LABEL_I 

inherit

	PRIMITIVE_I;

	FONTABLE_I
	
feature -- Access

	text: STRING
			-- Text of current label
		deferred
		end

feature -- Status setting

	allow_recompute_size
			-- Allow current label to recompute its  size according to
			-- some changes on its value.
		deferred
		end;

	forbid_recompute_size
			-- Forbid current label to recompute its size according to
			-- some changes on its value.
		deferred
		end;

	set_right_alignment
		-- Set text alignment of current label to right.
		deferred
		end;

	set_center_alignment
			-- Set text alignment of current label to center.
		deferred
		end;

	set_left_alignment
			-- Set text alignment of current label to left.
		deferred
		end;

feature -- Element change

	set_text (a_text: STRING)
			-- Set text of current label to `a_text'.
		require
			not_a_text_void: a_text /= Void
		deferred
		ensure
			set: text.is_equal (a_text)
		end;

note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"




end --class LABEL_I

