note
	description	: "Main window for this application"
	legal: "See notice at end of class."
	status: "See notice at end of class."
	author		: "Generated by the New Vision2 Application Wizard."
	date		: "$Date: 2010-05-03 06:31:37 -0700 (Mon, 03 May 2010) $"
	revision	: "1.0.0"

class
	MAIN_WINDOW

inherit
	EV_TITLED_WINDOW

	INTERFACE_NAMES
		export
			{NONE} all
		undefine
			default_create, copy
		end

create
	make

feature {NONE} -- Initialization

	make
			-- Creation method
		do
			setup_widgets

			default_create

			setup_docking_attributes
			setup_content_control_panel

			extend (main_container)
				-- Set the title of the window
			set_title (Window_title)
				-- Set the initial size of the window
			set_size (Window_width, Window_height)



				-- Execute `request_close_window' when the user clicks
				-- on the cross in the title bar.
			close_request_actions.extend (agent request_close_window)

			show_content_control_panel
		end

	setup_widgets
			-- Build the interface for this window.
		do
			build_containers

			main_container.extend (docking_container)
		end

	setup_content_control_panel
			-- Setup `content_contrl_panel'
		do
			create internal_content_control_panel.make (docking_manager, Current)
			build_docking_editor_contents
			build_docking_tool_contents
			build_docking_tool_contents
		end

	setup_docking_attributes
			-- Setup docking attributes.
		do
				-- Build the Docking Manager.
			create internal_docking_manager.make (docking_container, Current)
		end

feature -- Query

	content_control_panel: CONTENT_CONTROL_PANEL
			-- Content contol panel
		require
			set: is_content_control_panel_set
		local
			l_result: like internal_content_control_panel
		do
			l_result := internal_content_control_panel
			check l_result /= Void end -- Implied by precondition `set'
			Result := l_result
		ensure
			not_void: Result /= Void
		end

	docking_manager: SD_DOCKING_MANAGER
			-- <Precursor>
		require
			set: is_docking_manager_set
		local
			l_result: detachable like docking_manager
		do
			l_result := internal_docking_manager
			check l_result /= Void end -- FIXME: Implied by...
			Result := l_result
		end

	is_main_container_set: BOOLEAN
			-- If main container has been set?

	is_docking_manager_set: BOOLEAN
			-- If `internal_docking_manager' has been set?
		do
			Result := internal_docking_manager /= Void
		end

	is_content_control_panel_set: BOOLEAN
			-- If `internal_content_control_panel' has been set?
		do
			Result := attached internal_content_control_panel
		end

feature {NONE} -- Implemetation, Docking management

	build_docking_editor_contents
			-- Build editor contents.
		do
			content_control_panel.build_docking_editor_content
		end

	build_docking_tool_contents
			-- Build tool contents.
		do
			content_control_panel.build_docking_tool_content
		end

	show_content_control_panel
			-- Show center control panel
		local
			l_dialog: EV_DIALOG
			l_title: STRING_GENERAL
		do
			l_title := "Control Panel"
			create l_dialog.make_with_title (l_title)
			l_dialog.extend (content_control_panel)
			l_dialog.set_width (400)
			l_dialog.set_height (400)
			l_dialog.show_relative_to_window (Current)
		end

feature {NONE} -- Implementation, Close event

	request_close_window
			-- The user wants to close the window
		local
			question_dialog: EV_CONFIRMATION_DIALOG
		do
			create question_dialog.make_with_text (Label_confirm_close_window)
			question_dialog.show_modal_to_window (Current)

			if question_dialog.selected_button ~ ((create {EV_DIALOG_CONSTANTS}).ev_ok) then
					-- Destroy the window
				destroy;

					-- End the application
					--| TODO: Remove this line if you don't want the application
					--|       to end when the first window is closed..
				if attached (create {EV_ENVIRONMENT}).application as l_app then
					l_app.destroy
				else
					check False end -- Implied by application is running
				end
			end
		end

feature {NONE} -- Implementation

	main_container: EV_VERTICAL_BOX
			-- Main container (contains all widgets displayed in this window)

	docking_container: EV_VERTICAL_BOX
			-- Container managed by docking manager.

	build_containers
			-- Create `main_container' and `docking_container'.
		require
			main_container_not_yet_created: not is_main_container_set
		do
			create main_container
			is_main_container_set := True
			create docking_container
		ensure
			main_container_created: is_main_container_set
		end

feature {NONE} -- Implementation / Constants

	sd_shared: SD_SHARED
			-- Docking icons, etc.
		once
			create Result
		end

	Window_title: STRING = "Docking Control"
			-- Title of the window.

	Window_width: INTEGER = 800
			-- Initial width for this window.

	Window_height: INTEGER = 600
			-- Initial height for this window.

	internal_docking_manager: detachable SD_DOCKING_MANAGER
			-- Instance holder of `docking_manager'

	internal_content_control_panel: detachable like content_control_panel
			-- Instance of `content_control_panel'

;note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"


end -- class MAIN_WINDOW
