note

	description:

		"Semantic action factories"

	library: "Gobo Eiffel Lexical Library"
	copyright: "Copyright (c) 1999, Eric Bezault and others"
	license: "MIT License"
	date: "$Date: 2012-08-22 12:54:13 -0700 (Wed, 22 Aug 2012) $"
	revision: "$Revision: 89387 $"

class LX_ACTION_FACTORY

create

	make

feature {NONE} -- Initialization

	make
			-- Create a new semantic action factory.
		do
		end

feature -- Access

	new_action (a_text: STRING): LX_ACTION
			-- New semantic action with `a_text'
			-- as textual representation
		require
			a_text_not_void: a_text /= Void
		do
			create Result.make (a_text)
		ensure
			action_not_void: Result /= Void
			text_set: Result.text = a_text
		end

end
