note
	description: "[
		Exception representing an invariant violation
		]"
	library: "Free implementation of ELKS library"
	copyright: "Copyright (c) 1986-2006, Eiffel Software and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2008-12-29 11:36:38 -0800 (Mon, 29 Dec 2008) $"
	revision: "$Revision: 254 $"

class
	INVARIANT_VIOLATION

inherit
	ASSERTION_VIOLATION

feature -- Access

	frozen code: INTEGER
			-- Exception code
		do
			Result := {EXCEP_CONST}.class_invariant
		end

feature {EXCEPTION_MANAGER} -- Element change

	frozen set_is_entry (a_is_entry: BOOLEAN)
			-- Set `is_entry' with `a_is_entry'.
		do
			is_entry := a_is_entry
		ensure
			is_entry_set: is_entry = a_is_entry
		end

feature {NONE} -- Accesss

	frozen internal_meaning: STRING = "Class invariant violated."

feature -- Status report

	frozen is_entry: BOOLEAN
			-- Is current invariant entry violation? Otherwise, invariant exit violation.

end
