note
	description: "Shared objects."
	legal: "See notice at end of class."
	status: "See notice at end of class."
	date: "$Date: 2010-08-03 13:55:50 -0700 (Tue, 03 Aug 2010) $"
	revision: "$Revision: 84107 $"

class
	EW_SHARED_OBJECTS

feature -- Access

	output: EW_EWEASEL_OUTPUT_CONTROL
			-- Output interface
		do
			Result := output_cell.item
		end

feature -- Status Setting

	set_output (a_output: like output)
			-- Set the output dispatcher
		require
			output_not_void: a_output /= Void
		once
			output_cell.put (a_output)
		ensure
			output_set: output = a_output
		end

feature {NONE} -- Implementation

	output_cell: CELL [EW_EWEASEL_OUTPUT_CONTROL]
			-- Output cell
		once ("PROCESS")
			create Result.put (Void)
		end

note
	copyright: "[
			Copyright (c) 1984-2007, University of Southern California and contributors.
			All rights reserved.
			]"
	license:   "Your use of this work is governed under the terms of the GNU General Public License version 2"
	copying: "[
			This file is part of the EiffelWeasel Eiffel Regression Tester.

			The EiffelWeasel Eiffel Regression Tester is free
			software; you can redistribute it and/or modify it under
			the terms of the GNU General Public License version 2 as published
			by the Free Software Foundation.

			The EiffelWeasel Eiffel Regression Tester is
			distributed in the hope that it will be useful, but
			WITHOUT ANY WARRANTY; without even the implied warranty
			of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
			See the GNU General Public License version 2 for more details.

			You should have received a copy of the GNU General Public
			License version 2 along with the EiffelWeasel Eiffel Regression Tester
			if not, write to the Free Software Foundation,
			Inc., 51 Franklin St, Fifth Floor, Boston, MA
		]"


end -- class SHARED_OBJECTS
