/*
 * Code for class EW_UNIX_OS
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "ew192.h"
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <string.h>
#include <signal.h>
#include <sys/wait.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F88_1131
static void inline_F88_1131 (EIF_POINTER arg1, EIF_POINTER arg2)
{
	int rc;
  				int fd[2];
  				EIF_INTEGER * read_ptr;
  				EIF_INTEGER * write_ptr;

  				rc = pipe(fd);
  				if (rc != 0) {
    					xraise(EN_SYS);
  				}
  				read_ptr = (EIF_INTEGER *) arg1;
  				write_ptr = (EIF_INTEGER *) arg2;
  				*read_ptr = fd[0];
  				*write_ptr = fd[1];
	;
}
#define INLINE_F88_1131
#endif
#ifndef INLINE_F88_1134
static EIF_INTEGER_32 inline_F88_1134 (void)
{
	pid_t pid;

  				pid = eif_thread_fork();
  				if (pid == (pid_t) -1) {
    					xraise(EN_SYS);
  				}
  				return (EIF_INTEGER) pid;
	;
}
#define INLINE_F88_1134
#endif
#ifndef INLINE_F88_1132
static EIF_POINTER inline_F88_1132 (EIF_INTEGER_32 arg1)
{
	char ** result;

  				result = (char **) malloc((size_t) (arg1 * sizeof(char *)));
  				if (result == NULL) {
    					enomem();
  				}
  				return (EIF_POINTER) result;
	;
}
#define INLINE_F88_1132
#endif
#ifndef INLINE_F88_1130
static EIF_POINTER inline_F88_1130 (EIF_POINTER arg1)
{
	void * result;

  				result = (char *) malloc((size_t) (strlen((char *) arg1) + 1));
  				if (result == NULL) {
    					enomem();
  				}
  				strcpy(result, arg1);
  				return (EIF_POINTER) result;
	;
}
#define INLINE_F88_1130
#endif
#ifndef INLINE_F88_1133
static void inline_F88_1133 (EIF_POINTER arg1, EIF_INTEGER_32 arg2, EIF_POINTER arg3)
{
	char ** arguments;

				arguments = (char **) arg1;
				arguments[arg2] = (char *) arg3;
	;
}
#define INLINE_F88_1133
#endif
#ifndef INLINE_F88_1135
static void inline_F88_1135 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4)
{
	int getdtablesize(void);
  				int max_descriptors;
  				int k, rc;
  
  				if (arg4 == EIF_TRUE) {
    					max_descriptors = getdtablesize();
  					for (k = 3; k < max_descriptors; k++) {
    						rc = fcntl(k, F_SETFD, 1);
    						if (rc == -1 && errno != EBADF) {
      							xraise(EN_SYS);
    						}
  					}
  				}
  				if (arg3 == NULL) {
    					(void) execv((char *) arg1, (char **) arg2);
  				} else {
    					(void) execve((char *) arg1, (char **) arg2, (char **) arg3);
  				}
  				xraise(EN_SYS);
	;
}
#define INLINE_F88_1135
#endif
#ifndef INLINE_F88_1137
static EIF_INTEGER_32 inline_F88_1137 (EIF_INTEGER_32 arg1, EIF_BOOLEAN arg2, EIF_POINTER arg3)
{
	pid_t rc;
  				int status, options;
  				EIF_BOOLEAN * ptr;

  				options = ((arg2 == EIF_TRUE) ? 0 : WNOHANG) | WUNTRACED;
  				ptr = (EIF_BOOLEAN *) arg3;
  				rc = waitpid((pid_t) arg1, &status, options);
  				if (rc == (pid_t) -1) {
    					xraise(EN_SYS);
  				} else if (rc == (pid_t) 0) {	/* No process has status to report yet */
    					*ptr = EIF_FALSE;
  				} else {		/* Process reported status */
    					*ptr = EIF_TRUE;
  				}
  				return (EIF_INTEGER) status;
	;
}
#define INLINE_F88_1137
#endif
#ifndef INLINE_F88_1136
static void inline_F88_1136 (EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	int rc;

  				rc = kill((pid_t) arg1, (int) arg2);
  				if (rc != 0 && errno != ESRCH) {
    					xraise(EN_SYS);
  				}
	;
}
#define INLINE_F88_1136
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {EW_UNIX_OS}.null_file_name */

EIF_REFERENCE F571_2976 (EIF_REFERENCE Current)
{
	GTCX
	RTOSC (2976,RTMS_EX_H("/dev/null",9,2028729708));
}

/* {EW_UNIX_OS}.full_file_name */
EIF_REFERENCE F571_2977 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(5);
	RTLR(0,tr1);
	RTLR(1,arg1);
	RTLR(2,arg2);
	RTLR(3,Result);
	RTLR(4,Current);
	
	RTEAA("full_file_name", 570, Current, 0, 2, 4960);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNS(782, 782, _OBJSIZ_1_1_0_3_0_0_0_0_);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCV(arg1)+ _LNGOFF_1_1_0_2_);
	ti4_2 = *(EIF_INTEGER_32 *)(RTCV(arg2)+ _LNGOFF_1_1_0_2_);
	F779_5973(RTCV(tr1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + ti4_2) + ((EIF_INTEGER_32) 1L)));
	Result = (EIF_REFERENCE) tr1;
	RTHOOK(2);
	tb1 = F258_1928(RTCV(arg1));
	if ((EIF_BOOLEAN) !tb1) {
		RTHOOK(3);
		F783_6184(RTCV(Result), arg1);
		RTHOOK(4);
		ti4_1 = *(EIF_INTEGER_32 *)(RTCV(arg1)+ _LNGOFF_1_1_0_2_);
		tc1 = F783_6149(RTCV(arg1), ti4_1);
		if ((EIF_BOOLEAN)(tc1 != RTOSCF(2288,F401_2288,(Current)))) {
			RTHOOK(5);
			tc1 = RTOSCF(2288,F401_2288,(Current));
			F783_6199(RTCV(Result), tc1);
		}
	}
	RTHOOK(6);
	F783_6184(RTCV(Result), arg2);
	RTHOOK(7);
	RTLE;
	RTEE;
	return Result;
}

/* {EW_UNIX_OS}.executable_full_file_name */
EIF_REFERENCE F571_2978 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2)
{
	GTCX
	RTEX;
	
	
	RTEAA("executable_full_file_name", 570, Current, 0, 2, 4961);
	RTHOOK(1);
	RTHOOK(2);
	RTEE;
	return (EIF_REFERENCE) F571_2977(Current, arg1, arg2);
}

/* {EW_UNIX_OS}.full_directory_name */
EIF_REFERENCE F571_2979 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2)
{
	GTCX
	RTEX;
	
	
	RTEAA("full_directory_name", 570, Current, 0, 2, 4962);
	RTHOOK(1);
	RTHOOK(2);
	RTEE;
	return (EIF_REFERENCE) F571_2977(Current, arg1, arg2);
}

/* {EW_UNIX_OS}.new_pipe */
EIF_REFERENCE F571_2980 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(2);
	RTLR(0,tr1);
	RTLR(1,Current);
	
	RTEAA("new_pipe", 570, Current, 2, 0, 4963);
	RTGC;
	RTHOOK(1);
	inline_F88_1131((EIF_INTEGER_32 *) &(loc1), (EIF_INTEGER_32 *) &(loc2));
	RTHOOK(2);
	tr1 = RTLNS(904, 904, _OBJSIZ_0_0_0_2_0_0_0_0_);
	F905_7100(RTCV(tr1), loc1, loc2);
	RTHOOK(3);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) tr1;
}

/* {EW_UNIX_OS}.fork_process */
EIF_INTEGER_32 F571_2981 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	
	
	RTEAA("fork_process", 570, Current, 0, 0, 4964);
	RTHOOK(1);
	RTHOOK(2);
	RTEE;
	return (EIF_INTEGER_32) inline_F88_1134();
}

/* {EW_UNIX_OS}.exec_process */
void F571_2982 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc5 = (EIF_REFERENCE) 0;
	EIF_POINTER loc6 = (EIF_POINTER) 0;
	EIF_POINTER loc7 = (EIF_POINTER) 0;
	EIF_POINTER loc8 = (EIF_POINTER) 0;
	RTLD;
	
	RTLI(5);
	RTLR(0,arg2);
	RTLR(1,loc4);
	RTLR(2,arg1);
	RTLR(3,loc5);
	RTLR(4,Current);
	
	RTEAA("exec_process", 570, Current, 8, 4, 4965);
	RTGC;
	RTHOOK(1);
	loc2 = F544_2741(RTCV(arg2));
	RTHOOK(2);
	loc3 = *(EIF_INTEGER_32 *)(RTCV(arg2)+ _LNGOFF_1_1_0_0_);
	RTHOOK(3);
	loc4 = F783_6227(RTCV(arg1));
	RTHOOK(4);
	loc6 = inline_F88_1132((EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)));
	RTHOOK(5);
	loc1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	for (;;) {
		RTHOOK(6);
		if ((EIF_BOOLEAN) (loc1 > loc2)) break;
		RTHOOK(7);
		loc5 = F544_2735(RTCV(arg2), (EIF_INTEGER_32) ((EIF_INTEGER_32) (loc3 + loc1) - ((EIF_INTEGER_32) 1L)));
		loc5 = F783_6227(RTCV(loc5));
		RTHOOK(8);
		loc7 = inline_F88_1130(loc5);
		RTHOOK(9);
		inline_F88_1133(loc6, (EIF_INTEGER_32) (loc1 - ((EIF_INTEGER_32) 1L)), loc7);
		RTHOOK(10);
		loc1++;
	}
	RTHOOK(11);
	inline_F88_1133(loc6, loc2, loc8);
	RTHOOK(12);
	inline_F88_1135(loc4, loc6, arg3, arg4);
	RTHOOK(13);
	RTLE;
	RTEE;
}

/* {EW_UNIX_OS}.wait_for_process_block */
EIF_INTEGER_32 F571_2983 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	EIF_BOOLEAN loc1 = (EIF_BOOLEAN) 0;
	
	
	RTEAA("wait_for_process_block", 570, Current, 1, 1, 4966);
	RTHOOK(1);
	RTHOOK(2);
	RTEE;
	return (EIF_INTEGER_32) inline_F88_1137(arg1, (EIF_BOOLEAN) 1, (EIF_BOOLEAN *) &(loc1));
}

/* {EW_UNIX_OS}.send_signal */
void F571_2985 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	GTCX
	RTEX;
	
	
	RTEAA("send_signal", 570, Current, 0, 2, 4968);
	RTHOOK(1);
	inline_F88_1136(arg2, arg1);
	RTHOOK(2);
	RTEE;
}

/* {EW_UNIX_OS}.terminate_hard */
void F571_2986 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	
	RTEAA("terminate_hard", 570, Current, 0, 1, 4969);
	RTGC;
	RTHOOK(1);
	ti4_1 = RTOSCF(2307,F402_2307,(Current));
	F571_2985(Current, ti4_1, arg1);
	RTHOOK(2);
	RTLE;
	RTEE;
}

void EIF_Minit192 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
