/*
 * Code for class PROCESS_UNIX_PROCESS_MANAGER
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "pr801.h"
#include "eif_memory.h"
#include <string.h>
#include "eif_built_in.h"
#include <sys/types.h>
#include "eif_process.h"
#include "eif_file.h"
#include "eif_dir.h"
#include <unistd.h>
#include "eif_except.h"
#include "eif_main.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F920_13147
static EIF_INTEGER_32 inline_F920_13147 (EIF_INTEGER_32 arg1)
{
	return (EIF_INTEGER_32) (WEXITSTATUS(arg1))
	;
}
#define INLINE_F920_13147
#endif
#ifndef INLINE_F603_8918
static void inline_F603_8918 (EIF_INTEGER_32 arg1, EIF_BOOLEAN arg2, EIF_BOOLEAN* arg3, EIF_INTEGER_32* arg4, EIF_BOOLEAN* arg5)
{
	{
  pid_t rc;
  int status;
  
  rc = waitpid((pid_t) arg1, &status, (arg2 ? 0 : WNOHANG) | WUNTRACED);
  *(EIF_BOOLEAN *) arg5 = (rc != -1);
  if (rc != -1) {				    
	  if (rc == 0) { /* No process has status to report yet */
	    *(EIF_BOOLEAN *) arg3 = EIF_FALSE;
	  } else { /* Process reported status */
	    *(EIF_BOOLEAN *) arg3 = EIF_TRUE;
	  }
	  *(EIF_INTEGER *) arg4 = (EIF_INTEGER) status;
  }
}
	;
}
#define INLINE_F603_8918
#endif
#ifndef INLINE_F920_13148
static int inline_F920_13148 (EIF_INTEGER_32 arg1)
{
	return (int) (WIFEXITED(arg1))
	;
}
#define INLINE_F920_13148
#endif
#ifndef INLINE_F920_13149
static int inline_F920_13149 (EIF_INTEGER_32 arg1)
{
	return (int) (WIFSIGNALED(arg1))
	;
}
#define INLINE_F920_13149
#endif
#ifndef INLINE_F329_5483
static int inline_F329_5483 (void)
{
	#ifdef WORKBENCH
	return EIF_TEST(is_debug_mode());
#else
	return EIF_FALSE;
#endif
	;
}
#define INLINE_F329_5483
#endif
#ifndef INLINE_F329_5482
static void inline_F329_5482 (EIF_BOOLEAN arg1)
{
	#ifdef WORKBENCH
	set_debug_mode (arg1 ? 1 : 0);
#endif
	;
}
#define INLINE_F329_5482
#endif
#ifndef INLINE_F603_8908
static void inline_F603_8908 (void)
{
	{
	setpgid (0, 0);
}
	;
}
#define INLINE_F603_8908
#endif
#ifndef INLINE_F603_8923
static void inline_F603_8923 (EIF_INTEGER_32 arg1)
{
	{
	pid_t pgid = getpgid (arg1);
	tcsetpgrp (1, pgid);
	tcsetpgrp (2, pgid);
}
	;
}
#define INLINE_F603_8923
#endif
#ifndef INLINE_F603_8916
static void inline_F603_8916 (EIF_POINTER arg1, EIF_POINTER arg2)
{
	{
  int rc;
  int fd[2];
  EIF_INTEGER * read_ptr;
  EIF_INTEGER * write_ptr;
  rc = pipe(fd);
  if (rc != 0) {
    eraise(Strerror(errno), EN_SYS);
  }
  read_ptr = (EIF_INTEGER *) arg1;
  write_ptr = (EIF_INTEGER *) arg2;
  *read_ptr = fd[0];
  *write_ptr = fd[1];
}
	;
}
#define INLINE_F603_8916
#endif
#ifndef INLINE_F603_8904
static void inline_F603_8904 (EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	{
  int rc;
  rc = dup2(arg1, arg2);
  if (rc < 0) {
	    eraise(Strerror(errno), EN_SYS);
  }
}
	;
}
#define INLINE_F603_8904
#endif
#ifndef INLINE_F603_8905
static void inline_F603_8905 (EIF_INTEGER_32 arg1)
{
	{
	 int rc;
	  rc = close(arg1);
	  if (rc != 0) {
	    eraise(Strerror(errno), EN_SYS);
	  }
}
	;
}
#define INLINE_F603_8905
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {PROCESS_UNIX_PROCESS_MANAGER}.make */
void F920_13090 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_REFERENCE arg3)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(5);
	RTLR(0,arg3);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLR(4,arg2);
	RTLIU(5);
	
	RTGC;
	if ((EIF_BOOLEAN)(arg3 != NULL)) {
		tr1 = RTLNSMART(eif_new_type(2101, 0).id);
		F2102_21725(RTCW(tr1), arg3);
		RTAR(Current, tr1);
		*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	} else {
		*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) NULL;
	}
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current + _REFACS_4_) = (EIF_REFERENCE) arg1;
	F920_13102(Current, arg2);
	*(EIF_INTEGER_32 *)(Current+ _LNGOFF_15_11_0_1_) = (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
	tr1 = RTMS_EX_H("",0,0);
	{
		/* INLINED CODE (PROCESS_UNIX_PROCESS_MANAGER.set_input_file_name) */
		RTAR(Current, tr1);
		*(EIF_REFERENCE *)(Current + _REFACS_6_) = (EIF_REFERENCE) tr1;
		*(EIF_BOOLEAN *)(Current+ _CHROFF_15_7_) = (EIF_BOOLEAN) (EIF_BOOLEAN)(tr1 == NULL);
		/* END INLINED CODE */
	}
	;
	tr1 = RTMS_EX_H("",0,0);
	{
		/* INLINED CODE (PROCESS_UNIX_PROCESS_MANAGER.set_output_file_name) */
		RTAR(Current, tr1);
		*(EIF_REFERENCE *)(Current + _REFACS_7_) = (EIF_REFERENCE) tr1;
		*(EIF_BOOLEAN *)(Current+ _CHROFF_15_8_) = (EIF_BOOLEAN) (EIF_BOOLEAN)(tr1 == NULL);
		/* END INLINED CODE */
	}
	;
	tr1 = RTMS_EX_H("",0,0);
	{
		/* INLINED CODE (PROCESS_UNIX_PROCESS_MANAGER.set_error_file_name) */
		RTAR(Current, tr1);
		*(EIF_REFERENCE *)(Current + _REFACS_8_) = (EIF_REFERENCE) tr1;
		*(EIF_BOOLEAN *)(Current+ _CHROFF_15_9_) = (EIF_BOOLEAN) (EIF_BOOLEAN)(tr1 == NULL);
		*(EIF_BOOLEAN *)(Current+ _CHROFF_15_10_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 0;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (PROCESS_UNIX_PROCESS_MANAGER.set_is_executing) */
		*(EIF_BOOLEAN *)(Current+ _CHROFF_15_1_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 0;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.exit_code */
EIF_INTEGER_32 F920_13093 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTGC;
	if ((EIF_BOOLEAN) ((EIF_BOOLEAN) ((EIF_BOOLEAN) !*(EIF_BOOLEAN *)(Current+ _CHROFF_15_1_) && *(EIF_BOOLEAN *)(Current+ _CHROFF_15_0_)) && *(EIF_BOOLEAN *)(Current+ _CHROFF_15_2_))) {
		ti4_1 = *(EIF_INTEGER_32 *)(Current+ _LNGOFF_15_11_0_2_);
		RTLE;
		return (EIF_INTEGER_32) inline_F920_13147(ti4_1);
	}
	RTLE;
	return (EIF_INTEGER_32) 0;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.set_arguments */
void F920_13102 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(5);
	RTLR(0,arg1);
	RTLR(1,loc1);
	RTLR(2,Current);
	RTLR(3,loc2);
	RTLR(4,tr1);
	RTLIU(5);
	
	RTGC;
	if ((EIF_BOOLEAN)(arg1 != NULL)) {
		{
			static EIF_TYPE_INDEX typarr0[] = {1712,2066,0xFFFF};
			EIF_TYPE typres0;
			static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
			
			typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), typarr0)));
			loc1 = RTLNSMART(typres0.id);
		}
		F1713_16935(RTCW(loc1), ((EIF_INTEGER_32) 0L));
		loc2 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE)) R13496[Dtype(RTCW(arg1))-1125])(arg1);
		for (;;) {
			tb1 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R13190[Dtype(loc2)-1069])(loc2);
			if (tb1) break;
			tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE)) R13189[Dtype(loc2)-1069])(loc2);
			tr1 = (EIF_REFERENCE) eif_builtin_ANY_twin__o (tr1);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R13744[Dtype(RTCW(loc1))-1451])(loc1, tr1);
			(FUNCTION_CAST(void, (EIF_REFERENCE)) R13191[Dtype(loc2)-1069])(loc2);
		}
	}
	RTAR(Current, loc1);
	*(EIF_REFERENCE *)(Current + _REFACS_5_) = (EIF_REFERENCE) loc1;
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.set_close_nonstandard_files */
void F920_13103 (EIF_REFERENCE Current, EIF_BOOLEAN arg1)
{
	GTCX
	
	
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_6_) = (EIF_BOOLEAN) arg1;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.set_input_file_name */
void F920_13104 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,arg1);
	RTLIU(2);
	
	RTGC;
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current + _REFACS_6_) = (EIF_REFERENCE) arg1;
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_7_) = (EIF_BOOLEAN) (EIF_BOOLEAN)(arg1 == NULL);
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.set_output_file_name */
void F920_13105 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,arg1);
	RTLIU(2);
	
	RTGC;
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current + _REFACS_7_) = (EIF_REFERENCE) arg1;
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_8_) = (EIF_BOOLEAN) (EIF_BOOLEAN)(arg1 == NULL);
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.set_error_file_name */
void F920_13106 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,arg1);
	RTLIU(2);
	
	RTGC;
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current + _REFACS_8_) = (EIF_REFERENCE) arg1;
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_9_) = (EIF_BOOLEAN) (EIF_BOOLEAN)(arg1 == NULL);
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_10_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 0;
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.set_error_same_as_output */
void F920_13107 (EIF_REFERENCE Current)
{
	GTCX
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTGC;
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_10_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_9_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 0;
	*(EIF_REFERENCE *)(Current + _REFACS_8_) = (EIF_REFERENCE) NULL;
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.wait_for_process */
void F920_13108 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_BOOLEAN arg2)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_BOOLEAN loc2 = (EIF_BOOLEAN) 0;
	EIF_BOOLEAN loc3 = (EIF_BOOLEAN) 0;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTGC;
	inline_F603_8918(arg1, arg2, (EIF_BOOLEAN *) &(loc2), (EIF_INTEGER_32 *) &(loc1), (EIF_BOOLEAN *) &(loc3));
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_0_) = (EIF_BOOLEAN) loc3;
	if (*(EIF_BOOLEAN *)(Current+ _CHROFF_15_0_)) {
		*(EIF_BOOLEAN *)(Current+ _CHROFF_15_2_) = (EIF_BOOLEAN) loc2;
		*(EIF_INTEGER_32 *)(Current+ _LNGOFF_15_11_0_2_) = (EIF_INTEGER_32) loc1;
		tb1 = '\0';
		if (*(EIF_BOOLEAN *)(Current+ _CHROFF_15_2_)) {
			tb2 = '\01';
			ti4_1 = *(EIF_INTEGER_32 *)(Current+ _LNGOFF_15_11_0_2_);
			if (!EIF_TEST (inline_F920_13148(ti4_1))) {
				ti4_1 = *(EIF_INTEGER_32 *)(Current+ _LNGOFF_15_11_0_2_);
				tb2 = EIF_TEST (inline_F920_13149(ti4_1));
			}
			tb1 = tb2;
		}
		if (tb1) {
			{
				/* INLINED CODE (PROCESS_UNIX_PROCESS_MANAGER.set_is_executing) */
				*(EIF_BOOLEAN *)(Current+ _CHROFF_15_1_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 0;
				/* END INLINED CODE */
			}
			;
		} else {
			{
				/* INLINED CODE (PROCESS_UNIX_PROCESS_MANAGER.set_is_executing) */
				*(EIF_BOOLEAN *)(Current+ _CHROFF_15_1_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
				/* END INLINED CODE */
			}
			;
		}
	} else {
		*(EIF_BOOLEAN *)(Current+ _CHROFF_15_2_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 0;
		{
			/* INLINED CODE (PROCESS_UNIX_PROCESS_MANAGER.set_is_executing) */
			*(EIF_BOOLEAN *)(Current+ _CHROFF_15_1_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 0;
			/* END INLINED CODE */
		}
		;
	}
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.close_pipes */
void F920_13109 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(5);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc2);
	RTLR(4,loc3);
	RTLIU(5);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_12_);
	loc1 = tr1;
	if (EIF_TEST(loc1)) {
		F1051_15075(loc1);
	}
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_13_);
	loc2 = tr1;
	if (EIF_TEST(loc2)) {
		F1051_15074(loc2);
	}
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_14_);
	loc3 = tr1;
	if (EIF_TEST(loc3)) {
		F1051_15074(loc3);
	}
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.spawn_nowait */
#undef EIF_VOLATILE
#define EIF_VOLATILE volatile
void F920_13110 (EIF_REFERENCE Current, EIF_BOOLEAN arg1, EIF_REFERENCE arg2, EIF_BOOLEAN arg3)
{
	GTCX
	RTEX;
	RTED;
	EIF_REFERENCE EIF_VOLATILE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE EIF_VOLATILE loc2 = (EIF_REFERENCE) 0;
	EIF_BOOLEAN EIF_VOLATILE loc3 = (EIF_BOOLEAN) 0;
	EIF_REFERENCE EIF_VOLATILE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE EIF_VOLATILE loc5 = (EIF_REFERENCE) 0;
	EIF_REFERENCE EIF_VOLATILE saved_except = (EIF_REFERENCE) 0;
	EIF_POINTER  EIF_VOLATILE tp1;
	EIF_REFERENCE  EIF_VOLATILE tr1 = NULL;
	EIF_INTEGER_32  EIF_VOLATILE ti4_1;
	EIF_INTEGER_32  EIF_VOLATILE ti4_2;
	EIF_BOOLEAN  EIF_VOLATILE tb1;
	RTLD;
	RTXD;
	
	RTLI(8);
	RTLR(0,loc5);
	RTLR(1,Current);
	RTLR(2,loc1);
	RTLR(3,loc4);
	RTLR(4,loc2);
	RTLR(5,tr1);
	RTLR(6,arg2);
	RTLR(7,saved_except);
	RTLIU(8);
	RTXSLS;
	
	RTEV;
	RTGC;
	RTE_T
	loc5 = F920_13132(Current);
	RTAR(Current, loc5);
	*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) loc5;
	F920_13133(Current);
	loc1 = RTLNS(eif_new_type(915, 0x00).id, 915, _OBJSIZ_0_0_0_1_0_0_0_0_);
	loc4 = *(EIF_REFERENCE *)(Current);
	if ((EIF_BOOLEAN)(loc4 != NULL)) {
		loc2 = F916_13048(RTCW(loc1));
		{
			/* INLINED CODE (EXECUTION_ENVIRONMENT.change_working_path) */
			tr1 = (EIF_REFERENCE)  0;
			(void) RTCW(loc1);
			tr1 = F2102_21766(RTCW(loc4));
			tp1 = *(EIF_POINTER *)(RTCW(tr1)+ _PTROFF_0_1_0_1_0_0_);
			ti4_1 = (EIF_INTEGER_32) eif_chdir((EIF_FILENAME) tp1);
			*(EIF_INTEGER_32 *)(loc1 + O11349[Dtype(loc1)-915]) = (EIF_INTEGER_32) ti4_1;
			/* END INLINED CODE */
		}
		;
	}
	loc3 = EIF_TEST (inline_F329_5483());
	{
		/* INLINED CODE (RT_DEBUGGER.disable_debug) */
		inline_F329_5482((EIF_BOOLEAN) 0);
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (PROCESS_UNIX_OS.fork_process) */
		ti4_1 = (EIF_INTEGER_32)  0;
		ti4_1 = F603_8912(Current);
		/* END INLINED CODE */
	}
	ti4_2 = ti4_1;
	*(EIF_INTEGER_32 *)(Current+ _LNGOFF_15_11_0_1_) = (EIF_INTEGER_32) ti4_2;
	switch (*(EIF_INTEGER_32 *)(Current+ _LNGOFF_15_11_0_1_)) {
		case -1L:
			inline_F329_5482(loc3);
			if ((EIF_BOOLEAN)(loc2 != NULL)) {
				{
					/* INLINED CODE (EXECUTION_ENVIRONMENT.change_working_path) */
					tr1 = (EIF_REFERENCE)  0;
					(void) RTCW(loc1);
					tr1 = F2102_21766(RTCW(loc2));
					tp1 = *(EIF_POINTER *)(RTCW(tr1)+ _PTROFF_0_1_0_1_0_0_);
					ti4_1 = (EIF_INTEGER_32) eif_chdir((EIF_FILENAME) tp1);
					*(EIF_INTEGER_32 *)(loc1 + O11349[Dtype(loc1)-915]) = (EIF_INTEGER_32) ti4_1;
					/* END INLINED CODE */
				}
				;
			}
			break;
		case 0L:
			eif_gc_stop();
			if (arg3) {
				inline_F603_8908();
				if (arg1) {
					ti4_1 = *(EIF_INTEGER_32 *)(Current+ _LNGOFF_15_11_0_1_);
					inline_F603_8923(ti4_1);
				}
			}
			F920_13135(Current);
			tr1 = *(EIF_REFERENCE *)(Current + _REFACS_4_);
			tb1 = *(EIF_BOOLEAN *)(Current+ _CHROFF_15_6_);
			tp1 = F920_13143(Current, arg2);
			F603_8909(Current, tr1, loc5, tb1, tp1);
			break;
		default:
			inline_F329_5482(loc3);
			F920_13134(Current);
			*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
			{
				/* INLINED CODE (PROCESS_UNIX_PROCESS_MANAGER.set_is_executing) */
				*(EIF_BOOLEAN *)(Current+ _CHROFF_15_1_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
				/* END INLINED CODE */
			}
			;
			if ((EIF_BOOLEAN)(loc2 != NULL)) {
				{
					/* INLINED CODE (EXECUTION_ENVIRONMENT.change_working_path) */
					tr1 = (EIF_REFERENCE)  0;
					(void) RTCW(loc1);
					tr1 = F2102_21766(RTCW(loc2));
					tp1 = *(EIF_POINTER *)(RTCW(tr1)+ _PTROFF_0_1_0_1_0_0_);
					ti4_1 = (EIF_INTEGER_32) eif_chdir((EIF_FILENAME) tp1);
					*(EIF_INTEGER_32 *)(loc1 + O11349[Dtype(loc1)-915]) = (EIF_INTEGER_32) ti4_1;
					/* END INLINED CODE */
				}
				;
			}
			break;
	}
	RTE_E
	RTXSC;
	if ((EIF_BOOLEAN)(*(EIF_INTEGER_32 *)(Current+ _LNGOFF_15_11_0_1_) == ((EIF_INTEGER_32) 0L))) {
		tr1 = RTLNS(eif_new_type(873, 0x00).id, 873, _OBJSIZ_0_0_0_0_0_0_0_0_);
		esdie(((EIF_INTEGER_32) 1L));
	}
	inline_F329_5482(loc3);
	/* NOTREACHED */
	RTE_EE
	RTEOK;
	RTLE;
}
#undef EIF_VOLATILE
#define EIF_VOLATILE

/* {PROCESS_UNIX_PROCESS_MANAGER}.read_output_to_special */
void F920_13113 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_13_);
	loc1 = tr1;
	if (EIF_TEST(loc1)) {
		F1051_15101(loc1, arg1);
		tb1 = *(EIF_BOOLEAN *)(loc1+ _CHROFF_2_1_);
		*(EIF_BOOLEAN *)(Current+ _CHROFF_15_4_) = (EIF_BOOLEAN) (EIF_BOOLEAN) !tb1;
	} else {
		*(EIF_BOOLEAN *)(Current+ _CHROFF_15_4_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		{
			/* INLINED CODE (SPECIAL.wipe_out) */
			(void) RTCW(arg1);
			eif_builtin_SPECIAL_set_count__i4_ (arg1, ((EIF_INTEGER_32) 0L));
			/* END INLINED CODE */
		}
		;
	}
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.built_argument_list */
EIF_REFERENCE F920_13132 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTCFDT;
	RTLD;
	
	RTLI(6);
	RTLR(0,loc2);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,Result);
	RTLR(4,loc3);
	RTLR(5,tr2);
	RTLIU(6);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_5_);
	loc2 = tr1;
	if (EIF_TEST(loc2)) {
		{
			static EIF_TYPE_INDEX typarr0[] = {1748,2066,0xFFFF};
			EIF_TYPE typres0;
			static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
			
			typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(dftype, typarr0)));
			Result = RTLNSMART(typres0.id);
		}
		tr1 = *(EIF_REFERENCE *)(Current + _REFACS_4_);
		ti4_1 = F1713_16956(loc2);
		F1749_17128(RTCW(Result), tr1, ((EIF_INTEGER_32) 1L), (EIF_INTEGER_32) (ti4_1 + ((EIF_INTEGER_32) 1L)));
		loc3 = F1713_16949(loc2);
		loc1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
		for (;;) {
			{
				/* INLINED CODE (GENERAL_SPECIAL_ITERATION_CURSOR.after) */
				tb1 = (EIF_BOOLEAN)  0;
				(void) loc3;
				ti4_1 = *(EIF_INTEGER_32 *)(loc3+ _LNGOFF_2_0_0_0_);
				ti4_2 = *(EIF_INTEGER_32 *)(loc3+ _LNGOFF_2_0_0_1_);
				tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN) (ti4_1 > ti4_2);
				/* END INLINED CODE */
			}
			tb1 = tb1;
			if (tb1) break;
			{
				/* INLINED CODE (GENERAL_SPECIAL_ITERATION_CURSOR.item) */
				tr1 = (EIF_REFERENCE)  0;
				(void) loc3;
				tr2 = *(EIF_REFERENCE *)(loc3);
				tr1 = 
					/* INLINED CODE (SPECIAL.item) */
					*((EIF_REFERENCE *)RTCW(tr2) + (*(EIF_INTEGER_32 *)(loc3+ _LNGOFF_2_0_0_0_)))
					/* END INLINED CODE */;
				/* END INLINED CODE */
			}
			tr1 = tr1;
			{
				/* INLINED CODE (ARRAY.put) */
				(void) RTCW(Result);
				tr2 = *(EIF_REFERENCE *)(Result);
				ti4_1 = *(EIF_INTEGER_32 *)(Result + O14404[Dtype(Result)-1748]);
				/* INLINED CODE (SPECIAL.put) */
				*((EIF_REFERENCE *)RTCW(tr2) + ((EIF_INTEGER_32) (loc1 - ti4_1))) = tr1;
				RTAR(tr2,tr1);
				/* END INLINED CODE */;
				/* END INLINED CODE */
			}
			;
			loc1++;
			{
				/* INLINED CODE (GENERAL_SPECIAL_ITERATION_CURSOR.forth) */
				(void) loc3;
				(*(EIF_INTEGER_32 *)(loc3+ _LNGOFF_2_0_0_0_))++;
				/* END INLINED CODE */
			}
			;
		}
	} else {
		{
			static EIF_TYPE_INDEX typarr0[] = {1748,2066,0xFFFF};
			EIF_TYPE typres0;
			static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
			
			typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(dftype, typarr0)));
			Result = RTLNSMART(typres0.id);
		}
		F1749_17128(RTCW(Result), *(EIF_REFERENCE *)(Current + _REFACS_4_), ((EIF_INTEGER_32) 1L), ((EIF_INTEGER_32) 1L));
		RTLE;
		return (EIF_REFERENCE) Result;
	}
	RTLE;
	return Result;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.open_files_and_pipes */
void F920_13133 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	RTLD;
	
	RTLI(6);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc2);
	RTLR(4,loc3);
	RTLR(5,loc4);
	RTLIU(6);
	
	RTGC;
	loc1 = RTLNS(eif_new_type(603, 0x00).id, 603, _OBJSIZ_0_0_0_0_0_0_0_0_);
	*(EIF_REFERENCE *)(Current + _REFACS_12_) = (EIF_REFERENCE) NULL;
	*(EIF_REFERENCE *)(Current + _REFACS_9_) = (EIF_REFERENCE) NULL;
	if (*(EIF_BOOLEAN *)(Current+ _CHROFF_15_7_)) {
		{
			/* INLINED CODE (UNIX_PIPE_FACTORY.new_unnamed_pipe) */
			ti4_1 = (EIF_INTEGER_32)  0;
			ti4_2 = (EIF_INTEGER_32)  0;
			tr1 = (EIF_REFERENCE)  0;
			(void) RTCW(loc1);
			inline_F603_8916((EIF_INTEGER_32 *) &(ti4_1), (EIF_INTEGER_32 *) &(ti4_2));
			tr1 = RTLNS(eif_new_type(1050, 0x00).id, 1050, _OBJSIZ_2_7_2_5_1_0_2_1_);
			F1051_15057(RTCW(tr1), ti4_1, ti4_2);
			/* END INLINED CODE */
		}
		tr1 = tr1;
		RTAR(Current, tr1);
		*(EIF_REFERENCE *)(Current + _REFACS_12_) = (EIF_REFERENCE) tr1;
	} else {
		loc2 = *(EIF_REFERENCE *)(Current + _REFACS_6_);
		tb1 = '\0';
		if ((EIF_BOOLEAN)(loc2 != NULL)) {
			tb2 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R17077[Dtype(RTCW(loc2))-2070])(loc2);
			tb1 = (EIF_BOOLEAN) !tb2;
		}
		if (tb1) {
			tr1 = RTLNSMART(eif_new_type(1566, 0).id);
			F1566_16163(RTCW(tr1), loc2);
			RTAR(Current, tr1);
			*(EIF_REFERENCE *)(Current + _REFACS_9_) = (EIF_REFERENCE) tr1;
		}
	}
	*(EIF_REFERENCE *)(Current + _REFACS_13_) = (EIF_REFERENCE) NULL;
	*(EIF_REFERENCE *)(Current + _REFACS_10_) = (EIF_REFERENCE) NULL;
	if (*(EIF_BOOLEAN *)(Current+ _CHROFF_15_8_)) {
		{
			/* INLINED CODE (UNIX_PIPE_FACTORY.new_unnamed_pipe) */
			ti4_1 = (EIF_INTEGER_32)  0;
			ti4_2 = (EIF_INTEGER_32)  0;
			tr1 = (EIF_REFERENCE)  0;
			(void) RTCW(loc1);
			inline_F603_8916((EIF_INTEGER_32 *) &(ti4_1), (EIF_INTEGER_32 *) &(ti4_2));
			tr1 = RTLNS(eif_new_type(1050, 0x00).id, 1050, _OBJSIZ_2_7_2_5_1_0_2_1_);
			F1051_15057(RTCW(tr1), ti4_1, ti4_2);
			/* END INLINED CODE */
		}
		tr1 = tr1;
		RTAR(Current, tr1);
		*(EIF_REFERENCE *)(Current + _REFACS_13_) = (EIF_REFERENCE) tr1;
	} else {
		loc3 = *(EIF_REFERENCE *)(Current + _REFACS_7_);
		tb1 = '\0';
		if ((EIF_BOOLEAN)(loc3 != NULL)) {
			tb2 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R17077[Dtype(RTCW(loc3))-2070])(loc3);
			tb1 = (EIF_BOOLEAN) !tb2;
		}
		if (tb1) {
			tr1 = RTLNSMART(eif_new_type(1566, 0).id);
			F1566_16165(RTCW(tr1), loc3);
			RTAR(Current, tr1);
			*(EIF_REFERENCE *)(Current + _REFACS_10_) = (EIF_REFERENCE) tr1;
		}
	}
	*(EIF_REFERENCE *)(Current + _REFACS_14_) = (EIF_REFERENCE) NULL;
	*(EIF_REFERENCE *)(Current + _REFACS_11_) = (EIF_REFERENCE) NULL;
	if ((EIF_BOOLEAN) !*(EIF_BOOLEAN *)(Current+ _CHROFF_15_10_)) {
		if (*(EIF_BOOLEAN *)(Current+ _CHROFF_15_9_)) {
			{
				/* INLINED CODE (UNIX_PIPE_FACTORY.new_unnamed_pipe) */
				ti4_1 = (EIF_INTEGER_32)  0;
				ti4_2 = (EIF_INTEGER_32)  0;
				tr1 = (EIF_REFERENCE)  0;
				(void) RTCW(loc1);
				inline_F603_8916((EIF_INTEGER_32 *) &(ti4_1), (EIF_INTEGER_32 *) &(ti4_2));
				tr1 = RTLNS(eif_new_type(1050, 0x00).id, 1050, _OBJSIZ_2_7_2_5_1_0_2_1_);
				F1051_15057(RTCW(tr1), ti4_1, ti4_2);
				/* END INLINED CODE */
			}
			tr1 = tr1;
			RTAR(Current, tr1);
			*(EIF_REFERENCE *)(Current + _REFACS_14_) = (EIF_REFERENCE) tr1;
		} else {
			loc4 = *(EIF_REFERENCE *)(Current + _REFACS_8_);
			tb1 = '\0';
			if ((EIF_BOOLEAN)(loc4 != NULL)) {
				tb2 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R17077[Dtype(RTCW(loc4))-2070])(loc4);
				tb1 = (EIF_BOOLEAN) !tb2;
			}
			if (tb1) {
				tr1 = RTLNSMART(eif_new_type(1566, 0).id);
				F1566_16165(RTCW(tr1), loc4);
				RTAR(Current, tr1);
				*(EIF_REFERENCE *)(Current + _REFACS_11_) = (EIF_REFERENCE) tr1;
			}
		}
	}
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.setup_parent_process_files */
void F920_13134 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc5 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc6 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(8);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc2);
	RTLR(4,loc3);
	RTLR(5,loc4);
	RTLR(6,loc5);
	RTLR(7,loc6);
	RTLIU(8);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_12_);
	loc1 = tr1;
	if (EIF_TEST(loc1)) {
		F1051_15074(loc1);
	} else {
		tr1 = *(EIF_REFERENCE *)(Current + _REFACS_9_);
		loc2 = tr1;
		if (EIF_TEST(loc2)) {
			{
				/* INLINED CODE (FILE.close) */
				(void) loc2;
				tp1 = *(EIF_POINTER *)(loc2 + O13877[Dtype(loc2)-1565]);
				eif_file_close((FILE*) tp1);
				*(EIF_INTEGER_32 *)(loc2 + O14016[Dtype(loc2)-1565]) = (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
				tp1 = F1_33(loc2);
				*(EIF_POINTER *)(loc2 + O13877[Dtype(loc2)-1565]) = (EIF_POINTER) tp1;
				*(EIF_BOOLEAN *)(loc2 + O14025[Dtype(loc2)-1565]) = (EIF_BOOLEAN) (EIF_BOOLEAN) 0;
				/* END INLINED CODE */
			}
			;
		}
	}
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_13_);
	loc3 = tr1;
	if (EIF_TEST(loc3)) {
		F1051_15075(loc3);
	} else {
		tr1 = *(EIF_REFERENCE *)(Current + _REFACS_10_);
		loc4 = tr1;
		if (EIF_TEST(loc4)) {
			{
				/* INLINED CODE (FILE.close) */
				(void) loc4;
				tp1 = *(EIF_POINTER *)(loc4 + O13877[Dtype(loc4)-1565]);
				eif_file_close((FILE*) tp1);
				*(EIF_INTEGER_32 *)(loc4 + O14016[Dtype(loc4)-1565]) = (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
				tp1 = F1_33(loc4);
				*(EIF_POINTER *)(loc4 + O13877[Dtype(loc4)-1565]) = (EIF_POINTER) tp1;
				*(EIF_BOOLEAN *)(loc4 + O14025[Dtype(loc4)-1565]) = (EIF_BOOLEAN) (EIF_BOOLEAN) 0;
				/* END INLINED CODE */
			}
			;
		}
	}
	if ((EIF_BOOLEAN) !*(EIF_BOOLEAN *)(Current+ _CHROFF_15_10_)) {
		tr1 = *(EIF_REFERENCE *)(Current + _REFACS_14_);
		loc5 = tr1;
		if (EIF_TEST(loc5)) {
			F1051_15075(loc5);
		} else {
			tr1 = *(EIF_REFERENCE *)(Current + _REFACS_11_);
			loc6 = tr1;
			if (EIF_TEST(loc6)) {
				{
					/* INLINED CODE (FILE.close) */
					(void) loc6;
					tp1 = *(EIF_POINTER *)(loc6 + O13877[Dtype(loc6)-1565]);
					eif_file_close((FILE*) tp1);
					*(EIF_INTEGER_32 *)(loc6 + O14016[Dtype(loc6)-1565]) = (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
					tp1 = F1_33(loc6);
					*(EIF_POINTER *)(loc6 + O13877[Dtype(loc6)-1565]) = (EIF_POINTER) tp1;
					*(EIF_BOOLEAN *)(loc6 + O14025[Dtype(loc6)-1565]) = (EIF_BOOLEAN) (EIF_BOOLEAN) 0;
					/* END INLINED CODE */
				}
				;
			}
		}
	}
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.setup_child_process_files */
void F920_13135 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc5 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc6 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	RTLD;
	
	RTLI(8);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc2);
	RTLR(4,loc3);
	RTLR(5,loc4);
	RTLR(6,loc5);
	RTLR(7,loc6);
	RTLIU(8);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_12_);
	loc1 = tr1;
	if (EIF_TEST(loc1)) {
		ti4_1 = *(EIF_INTEGER_32 *)(loc1+ _LNGOFF_2_7_2_1_);
		{
			/* INLINED CODE (PROCESS_UNIX_PROCESS_MANAGER.move_desc) */
			ti4_2 = ((EIF_INTEGER_32) 0L);
			if ((EIF_BOOLEAN)(ti4_1 != ti4_2)) {
				inline_F603_8904(ti4_1, ti4_2);
				inline_F603_8905(ti4_1);
			}
			/* END INLINED CODE */
		}
		;
		F1051_15075(loc1);
	} else {
		tr1 = *(EIF_REFERENCE *)(Current + _REFACS_9_);
		loc2 = tr1;
		if (EIF_TEST(loc2)) {
			{
				/* INLINED CODE (FILE.descriptor) */
				ti4_1 = (EIF_INTEGER_32)  0;
				(void) loc2;
				tp1 = *(EIF_POINTER *)(loc2 + O13877[Dtype(loc2)-1565]);
				ti4_1 = (EIF_INTEGER_32) eif_file_fd((FILE*) tp1);
				*(EIF_BOOLEAN *)(loc2 + O14025[Dtype(loc2)-1565]) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
				/* END INLINED CODE */
			}
			ti4_1 = ti4_1;
			{
				/* INLINED CODE (PROCESS_UNIX_PROCESS_MANAGER.move_desc) */
				ti4_2 = ((EIF_INTEGER_32) 0L);
				if ((EIF_BOOLEAN)(ti4_1 != ti4_2)) {
					inline_F603_8904(ti4_1, ti4_2);
					inline_F603_8905(ti4_1);
				}
				/* END INLINED CODE */
			}
			;
		}
	}
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_13_);
	loc3 = tr1;
	if (EIF_TEST(loc3)) {
		ti4_1 = *(EIF_INTEGER_32 *)(loc3+ _LNGOFF_2_7_2_2_);
		{
			/* INLINED CODE (PROCESS_UNIX_PROCESS_MANAGER.move_desc) */
			ti4_2 = ((EIF_INTEGER_32) 1L);
			if ((EIF_BOOLEAN)(ti4_1 != ti4_2)) {
				inline_F603_8904(ti4_1, ti4_2);
				inline_F603_8905(ti4_1);
			}
			/* END INLINED CODE */
		}
		;
		F1051_15074(loc3);
	} else {
		tr1 = *(EIF_REFERENCE *)(Current + _REFACS_10_);
		loc4 = tr1;
		if (EIF_TEST(loc4)) {
			{
				/* INLINED CODE (FILE.descriptor) */
				ti4_1 = (EIF_INTEGER_32)  0;
				(void) loc4;
				tp1 = *(EIF_POINTER *)(loc4 + O13877[Dtype(loc4)-1565]);
				ti4_1 = (EIF_INTEGER_32) eif_file_fd((FILE*) tp1);
				*(EIF_BOOLEAN *)(loc4 + O14025[Dtype(loc4)-1565]) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
				/* END INLINED CODE */
			}
			ti4_1 = ti4_1;
			{
				/* INLINED CODE (PROCESS_UNIX_PROCESS_MANAGER.move_desc) */
				ti4_2 = ((EIF_INTEGER_32) 1L);
				if ((EIF_BOOLEAN)(ti4_1 != ti4_2)) {
					inline_F603_8904(ti4_1, ti4_2);
					inline_F603_8905(ti4_1);
				}
				/* END INLINED CODE */
			}
			;
		}
	}
	if (*(EIF_BOOLEAN *)(Current+ _CHROFF_15_10_)) {
		inline_F603_8904(((EIF_INTEGER_32) 1L), ((EIF_INTEGER_32) 2L));
	} else {
		tr1 = *(EIF_REFERENCE *)(Current + _REFACS_14_);
		loc5 = tr1;
		if (EIF_TEST(loc5)) {
			ti4_1 = *(EIF_INTEGER_32 *)(loc5+ _LNGOFF_2_7_2_2_);
			{
				/* INLINED CODE (PROCESS_UNIX_PROCESS_MANAGER.move_desc) */
				ti4_2 = ((EIF_INTEGER_32) 2L);
				if ((EIF_BOOLEAN)(ti4_1 != ti4_2)) {
					inline_F603_8904(ti4_1, ti4_2);
					inline_F603_8905(ti4_1);
				}
				/* END INLINED CODE */
			}
			;
			F1051_15074(loc5);
		} else {
			tr1 = *(EIF_REFERENCE *)(Current + _REFACS_11_);
			loc6 = tr1;
			if (EIF_TEST(loc6)) {
				{
					/* INLINED CODE (FILE.descriptor) */
					ti4_1 = (EIF_INTEGER_32)  0;
					(void) loc6;
					tp1 = *(EIF_POINTER *)(loc6 + O13877[Dtype(loc6)-1565]);
					ti4_1 = (EIF_INTEGER_32) eif_file_fd((FILE*) tp1);
					*(EIF_BOOLEAN *)(loc6 + O14025[Dtype(loc6)-1565]) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
					/* END INLINED CODE */
				}
				ti4_1 = ti4_1;
				{
					/* INLINED CODE (PROCESS_UNIX_PROCESS_MANAGER.move_desc) */
					ti4_2 = ((EIF_INTEGER_32) 2L);
					if ((EIF_BOOLEAN)(ti4_1 != ti4_2)) {
						inline_F603_8904(ti4_1, ti4_2);
						inline_F603_8905(ti4_1);
					}
					/* END INLINED CODE */
				}
				;
			}
		}
	}
	RTLE;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.move_desc */
void F920_13136 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	GTCX
	
	
	RTGC;
	if ((EIF_BOOLEAN)(arg1 != arg2)) {
		inline_F603_8904(arg1, arg2);
		inline_F603_8905(arg1);
	}
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.environment_table_as_pointer */
EIF_POINTER F920_13143 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_POINTER loc3 = (EIF_POINTER) 0;
	EIF_INTEGER_32 loc4 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc5 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc6 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc7 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc8 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc9 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc10 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_POINTER tp2;
	EIF_POINTER tp3;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_CHARACTER_32 tw1;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	RTLD;
	
	RTLI(11);
	RTLR(0,arg1);
	RTLR(1,loc7);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLR(4,loc1);
	RTLR(5,loc8);
	RTLR(6,loc9);
	RTLR(7,loc10);
	RTLR(8,loc6);
	RTLR(9,loc2);
	RTLR(10,Current);
	RTLIU(11);
	
	RTGC;
	tb1 = '\0';
	if ((EIF_BOOLEAN)(arg1 != NULL)) {
		{
			/* INLINED CODE (FINITE.is_empty) */
			tb2 = (EIF_BOOLEAN)  0;
			(void) RTCW(arg1);
			ti4_1 = *(EIF_INTEGER_32 *)(arg1 + O14539[Dtype(arg1)-1773]);
			tb2 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
			/* END INLINED CODE */
		}
		tb2 = tb2;
		tb1 = (EIF_BOOLEAN) !tb2;
	}
	if (tb1) {
		loc7 = F1774_17248(RTCW(arg1));
		for (;;) {
			tb1 = F1176_15654(loc7);
			if (tb1) break;
			tb2 = '\0';
			{
				/* INLINED CODE (HASH_TABLE_ITERATION_CURSOR.key) */
				tr1 = (EIF_REFERENCE)  0;
				(void) loc7;
				tr2 = *(EIF_REFERENCE *)(loc7);
				tr2 = *(EIF_REFERENCE *)(RTCW(tr2) + _REFACS_2_);
				tr1 = 
					/* INLINED CODE (SPECIAL.item) */
					*((EIF_REFERENCE *)RTCW(tr2) + (*(EIF_INTEGER_32 *)(loc7+ _LNGOFF_1_1_0_4_)))
					/* END INLINED CODE */;
				/* END INLINED CODE */
			}
			tr1 = tr1;
			if ((EIF_BOOLEAN)(tr1 != NULL)) {
				{
					/* INLINED CODE (HASH_TABLE_ITERATION_CURSOR.item) */
					tr1 = (EIF_REFERENCE)  0;
					(void) loc7;
					tr2 = *(EIF_REFERENCE *)(loc7);
					tr2 = *(EIF_REFERENCE *)(RTCW(tr2) + _REFACS_1_);
					tr1 = 
						/* INLINED CODE (SPECIAL.item) */
						*((EIF_REFERENCE *)RTCW(tr2) + (*(EIF_INTEGER_32 *)(loc7+ _LNGOFF_1_1_0_4_)))
						/* END INLINED CODE */;
					/* END INLINED CODE */
				}
				tr1 = tr1;
				tb2 = (EIF_BOOLEAN)(tr1 != NULL);
			}
			if (tb2) {
				loc5++;
			}
			F1176_15655(loc7);
		}
		ti4_1 = (EIF_INTEGER_32) eif_builtin_PLATFORM_pointer_bytes__i4;
		tp1 = malloc((size_t)(EIF_INTEGER_32) ((EIF_INTEGER_32) (loc5 + ((EIF_INTEGER_32) 1L)) * ti4_1));
		Result = (EIF_POINTER) tp1;
		loc1 = RTLNS(eif_new_type(908, 0x00).id, 908, _OBJSIZ_0_1_0_1_0_1_1_0_);
		ti4_1 = (EIF_INTEGER_32) eif_builtin_PLATFORM_pointer_bytes__i4;
		F909_12820(RTCW(loc1), Result, (EIF_INTEGER_32) ((EIF_INTEGER_32) (loc5 + ((EIF_INTEGER_32) 1L)) * ti4_1));
		loc8 = F1774_17248(RTCW(arg1));
		for (;;) {
			tb2 = F1176_15654(loc8);
			if (tb2) break;
			tb3 = '\0';
			{
				/* INLINED CODE (HASH_TABLE_ITERATION_CURSOR.key) */
				tr1 = (EIF_REFERENCE)  0;
				(void) loc8;
				tr2 = *(EIF_REFERENCE *)(loc8);
				tr2 = *(EIF_REFERENCE *)(RTCW(tr2) + _REFACS_2_);
				tr1 = 
					/* INLINED CODE (SPECIAL.item) */
					*((EIF_REFERENCE *)RTCW(tr2) + (*(EIF_INTEGER_32 *)(loc8+ _LNGOFF_1_1_0_4_)))
					/* END INLINED CODE */;
				/* END INLINED CODE */
			}
			tr1 = tr1;
			loc9 = tr1;
			if (EIF_TEST(loc9)) {
				{
					/* INLINED CODE (HASH_TABLE_ITERATION_CURSOR.item) */
					tr1 = (EIF_REFERENCE)  0;
					(void) loc8;
					tr2 = *(EIF_REFERENCE *)(loc8);
					tr2 = *(EIF_REFERENCE *)(RTCW(tr2) + _REFACS_1_);
					tr1 = 
						/* INLINED CODE (SPECIAL.item) */
						*((EIF_REFERENCE *)RTCW(tr2) + (*(EIF_INTEGER_32 *)(loc8+ _LNGOFF_1_1_0_4_)))
						/* END INLINED CODE */;
					/* END INLINED CODE */
				}
				tr1 = tr1;
				loc10 = tr1;
				tb3 = EIF_TEST(loc10);
			}
			if (tb3) {
				loc6 = RTLNS(eif_new_type(2075, 0x00).id, 2075, _OBJSIZ_1_1_0_3_0_0_0_0_);
				ti4_1 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R17099[Dtype(loc9)-2070])(loc9);
				ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R17099[Dtype(loc10)-2070])(loc10);
				F2074_20978(RTCW(loc6), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + ti4_2) + ((EIF_INTEGER_32) 1L)));
				F2076_21092(RTCW(loc6), loc9);
				tw1 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '=';
				F2076_21106(RTCW(loc6), tw1);
				F2076_21092(RTCW(loc6), loc10);
				loc2 = RTLNS(eif_new_type(913, 0x00).id, 913, _OBJSIZ_1_0_0_1_0_0_0_0_);
				F914_12966(RTCW(loc2), loc6);
				{
					/* INLINED CODE (NATIVE_STRING.bytes_count) */
					ti4_1 = (EIF_INTEGER_32)  0;
					(void) RTCW(loc2);
					ti4_1 = *(EIF_INTEGER_32 *)(loc2+ _LNGOFF_1_0_0_0_);
					ti4_2 = F914_12979(loc2);
					ti4_1 = (EIF_INTEGER_32) (EIF_INTEGER_32) (ti4_1 * ti4_2);
					/* END INLINED CODE */
				}
				ti4_1 = ti4_1;
				tp1 = malloc((size_t)(EIF_INTEGER_32) (ti4_1 + ((EIF_INTEGER_32) 1L)));
				loc3 = (EIF_POINTER) tp1;
				{
					/* INLINED CODE (NATIVE_STRING.item) */
					tp1 = (EIF_POINTER)  0;
					(void) RTCW(loc2);
					tr1 = *(EIF_REFERENCE *)(loc2);
					tp1 = *(EIF_POINTER *)(RTCW(tr1)+ _PTROFF_0_1_0_1_0_0_);
					/* END INLINED CODE */
				}
				tp1 = tp1;
				{
					/* INLINED CODE (NATIVE_STRING.bytes_count) */
					ti4_1 = (EIF_INTEGER_32)  0;
					(void) RTCW(loc2);
					ti4_1 = *(EIF_INTEGER_32 *)(loc2+ _LNGOFF_1_0_0_0_);
					ti4_2 = F914_12979(loc2);
					ti4_1 = (EIF_INTEGER_32) (EIF_INTEGER_32) (ti4_1 * ti4_2);
					/* END INLINED CODE */
				}
				ti4_1 = ti4_1;
				memcpy((void *)loc3, (const void *) tp1, (size_t) (EIF_INTEGER_32) (ti4_1 + ((EIF_INTEGER_32) 1L)));
				ti4_1 = (EIF_INTEGER_32) eif_builtin_PLATFORM_pointer_bytes__i4;
				{
					/* INLINED CODE (MANAGED_POINTER.put_pointer) */
					tp1 = loc3;
					ti4_1 = (EIF_INTEGER_32) (loc4 * ti4_1);
					(void) RTCW(loc1);
					tp2 = *(EIF_POINTER *)(loc1+ _PTROFF_0_1_0_1_0_0_);
					tp2 = RTPOF(tp2,ti4_1);
					ti4_2 = (EIF_INTEGER_32) eif_builtin_PLATFORM_pointer_bytes__i4;
					memcpy((void *)tp2, (const void *) (EIF_POINTER *) &(tp1), (size_t) ti4_2);
					/* END INLINED CODE */
				}
				;
				loc4++;
			}
			F1176_15655(loc8);
		}
		{
			/* INLINED CODE (ANY.default_pointer) */
			tp1 = (EIF_POINTER)  0;
			/* END INLINED CODE */
		}
		tp2 = tp1;
		ti4_1 = (EIF_INTEGER_32) eif_builtin_PLATFORM_pointer_bytes__i4;
		{
			/* INLINED CODE (MANAGED_POINTER.put_pointer) */
			ti4_1 = (EIF_INTEGER_32) (loc4 * ti4_1);
			(void) RTCW(loc1);
			tp3 = *(EIF_POINTER *)(loc1+ _PTROFF_0_1_0_1_0_0_);
			tp3 = RTPOF(tp3,ti4_1);
			ti4_2 = (EIF_INTEGER_32) eif_builtin_PLATFORM_pointer_bytes__i4;
			memcpy((void *)tp3, (const void *) (EIF_POINTER *) &(tp2), (size_t) ti4_2);
			/* END INLINED CODE */
		}
		;
	}
	RTLE;
	return Result;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.exit_code_from_status */
EIF_INTEGER_32 F920_13147 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	
	
	Result = inline_F920_13147 ((EIF_INTEGER_32) arg1);
	return Result;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.terminate_flag_from_status */
EIF_BOOLEAN F920_13148 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	
	
	Result = EIF_TEST(inline_F920_13148 ((EIF_INTEGER_32) arg1));
	return Result;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.signaled_flag_from_status */
EIF_BOOLEAN F920_13149 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	
	
	Result = EIF_TEST(inline_F920_13149 ((EIF_INTEGER_32) arg1));
	return Result;
}

/* {PROCESS_UNIX_PROCESS_MANAGER}.set_is_executing */
void F920_13152 (EIF_REFERENCE Current, EIF_BOOLEAN arg1)
{
	GTCX
	
	
	*(EIF_BOOLEAN *)(Current+ _CHROFF_15_1_) = (EIF_BOOLEAN) arg1;
}

void EIF_Minit801 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
