note
	description: "Summary description for {PE_HEADER_CONSTANTS}."
	date: "$Date: 2022-11-10 21:34:07 +0000 (Thu, 10 Nov 2022) $"
	revision: "$Revision: 106393 $"

class
	PE_HEADER_CONSTANTS

feature -- Constants

	PESIG: INTEGER = 0x4550 -- PE

	PE_BASE_HEADER_SIZE: INTEGER = 0x18
	PE_OPTIONAL_HEADER_SIZE: INTEGER = 0xe0
	PE_OBJECTENTRY_SIZE: INTEGER = 0x28
	PE_HEADBUF_SIZE: INTEGER
		do
			Result := PE_BASE_HEADER_SIZE + PE_OPTIONAL_HEADER_SIZE
		ensure
			is_class: class
		end
	PE_IMPORTDIRENTRY_SIZE: INTEGER = 0x14
	PE_NUM_VAS: INTEGER = 0x10
	PE_EXPORTHEADER_SIZE: INTEGER = 0x28
	PE_RESENTRY_SIZE: INTEGER = 0x08
	PE_RESDIR_SIZE: INTEGER = 0x10
	PE_RESDATAENTRY_SIZE: INTEGER = 0x10
	PE_SYMBOL_SIZE: INTEGER = 0x12
	PE_RELOC_SIZE: INTEGER = 0x0a

	PE_ORDINAL_FLAG: INTEGER = 0x80000000
	PE_INTEL386: INTEGER = 0x014c
	PE_MAGICNUM: INTEGER = 0x010b
	PE_FILE_EXECUTABLE: INTEGER = 0x0002
	PE_FILE_32BIT: INTEGER = 0x0100
	PE_FILE_LIBRARY: INTEGER = 0x2000
	PE_FILE_REVERSE_BITS_HIGH: INTEGER = 0x8000
	PE_FILE_REVERSE_BITS_LOW: INTEGER = 0x80
	PE_FILE_LOCAL_SYMBOLS_STRIPPED: INTEGER = 8
	PE_FILE_LINE_NUMBERS_STRIPPED: INTEGER = 4

	PE_REL_LOW16: INTEGER = 0x2000
	PE_REL_OFS32: INTEGER = 0x3000

	PE_SUBSYS_NATIVE: INTEGER = 1
	PE_SUBSYS_WINDOWS: INTEGER = 2
	PE_SUBSYS_CONSOLE: INTEGER = 3
	PE_SUBSYS_POSIX: INTEGER = 7

	WINF_UNDEFINED: INTEGER = 0x00000000
	WINF_CODE: INTEGER = 0x00000020
	WINF_INITDATA: INTEGER = 0x00000040
	WINF_UNINITDATA: INTEGER = 0x00000080
	WINF_DISCARDABLE: INTEGER = 0x02000000
	WINF_NOPAGE: INTEGER = 0x08000000
	WINF_SHARED: INTEGER = 0x10000000
	WINF_EXECUTE: INTEGER = 0x20000000
	WINF_READABLE: INTEGER = 0x40000000
	WINF_WRITEABLE: INTEGER = 0x80000000
	WINF_ALIGN_NOPAD: INTEGER = 0x00000008
	WINF_ALIGN_BYTE: INTEGER = 0x00100000
	WINF_ALIGN_WORD: INTEGER = 0x00200000
	WINF_ALIGN_DWORD: INTEGER = 0x00300000
	WINF_ALIGN_8: INTEGER = 0x00400000
	WINF_ALIGN_PARA: INTEGER = 0x00500000
	WINF_ALIGN_32: INTEGER = 0x00600000
	WINF_ALIGN_64: INTEGER = 0x00700000
	WINF_ALIGN: INTEGER
		do
			Result := WINF_ALIGN_64
		ensure
			is_class: class
		end
	WINF_COMMENT: INTEGER = 0x00000200
	WINF_REMOVE: INTEGER = 0x00000800
	WINF_COMDAT: INTEGER = 0x00001000
	WINF_NEG_FLAGS: INTEGER
		do
			Result := (WINF_DISCARDABLE | WINF_NOPAGE)
		ensure
			is_class: class
		end
	WINF_IMAGE_FLAGS: INTEGER = 0xfa0008e0

	WIN32_DEFAULT_BASE: INTEGER = 0x00400000
	WIN32_DEFAULT_FILEALIGN: INTEGER = 0x00000200
	WIN32_DEFAULT_OBJECTALIGN: INTEGER = 0x00001000
	WIN32_DEFAULT_STACKSIZE: INTEGER = 0x00100000
	WIN32_DEFAULT_STACKCOMMITSIZE: INTEGER = 0x00001000
	WIN32_DEFAULT_HEAPSIZE: INTEGER = 0x00100000
	WIN32_DEFAULT_HEAPCOMMITSIZE: INTEGER = 0x00001000
	WIN32_DEFAULT_SUBSYS: INTEGER
		do
			Result := PE_SUBSYS_WINDOWS
		ensure
			is_class: class
		end
	WIN32_DEFAULT_SUBSYSMAJOR: INTEGER = 4
	WIN32_DEFAULT_SUBSYSMINOR: INTEGER = 0
	WIN32_DEFAULT_OSMAJOR: INTEGER = 1
	WIN32_DEFAULT_OSMINOR: INTEGER = 0

	PE_FIXUP_ABSOLUTE: INTEGER = 0
	PE_FIXUP_HIGH: INTEGER = 1
	PE_FIXUP_LOW: INTEGER = 2
	PE_FIXUP_HIGHLOW: INTEGER = 3
	PE_FIXUP_HIGHADJUST: INTEGER = 4 -- to double check

end
