note
	description: "A possible index type that occur in the tables we are interested in."
	date: "$Date: 2023-07-10 14:24:14 +0000 (Mon, 10 Jul 2023) $"
	revision: "$Revision: 107116 $"

class
	PE_CONSTANT

inherit
	PE_CODED_INDEX_BASE
		redefine
			get_index_shift,
			has_index_overflow,
			tag_for_table
		end

create
	make_with_tag_and_index

feature -- Enum: tags

	TagBits: INTEGER = 2
			-- HasConstant
			-- https://www.ecma-international.org/wp-content/uploads/ECMA-335_6th_edition_june_2012.pdf#page=299&zoom=100,116,96

	FieldDef: INTEGER = 0
	ParamDef: INTEGER = 1
			--TagProperty : INTEGER =2
			-- TODO double check why TagProperty is not used.

feature -- Access

	tag_for_table (tb_id: NATURAL_32): INTEGER_32
			-- <Precursor/>
		do
			inspect tb_id
			when {PE_TABLES}.tfield then Result := fielddef
			when {PE_TABLES}.tparam then Result := paramdef
			else
				Result := Precursor (tb_id)
			end
		end

feature -- Operations

	get_index_shift: INTEGER
		do
			Result := tagbits
		end

	has_index_overflow (a_sizes: ARRAY [NATURAL_32]): BOOLEAN
		do
			Result := large (a_sizes [{PE_TABLES}.tField.to_integer_32 + 1]) or else
				large (a_sizes [{PE_TABLES}.tParam.to_integer_32 + 1])
		end

end
