/*
 * Code for class PATH
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "pa3013.h"
#include "eif_path_name.h"
#include "eif_built_in.h"
#include "eif_eiffel.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F4124_50218
static int inline_F4124_50218 (EIF_POINTER arg1, EIF_POINTER arg2)
{
	EIF_BOOLEAN Result = EIF_FALSE;
#ifdef EIF_WINDOWS
		/* To check this, we use `CreateFileW' to open both file, and then using the information
		 * returned by `GetFileInformationByHandle' we can check whether or not they are indeed
		 * the same.
		 * Note: it is important to use the W version of CreateFileW because arguments
		 * are Unicode, not ASCII. */
	BY_HANDLE_FILE_INFORMATION l_path1_info, l_path2_info;
	HANDLE l_path2_file = CreateFileW ((LPCWSTR) arg2, GENERIC_READ, FILE_SHARE_READ, NULL,
		OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	HANDLE l_path1_file = CreateFileW ((LPCWSTR) arg1, GENERIC_READ, FILE_SHARE_READ, NULL,
			OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);

	if ((l_path2_file == INVALID_HANDLE_VALUE) || (l_path1_file == INVALID_HANDLE_VALUE)) {
			/* We do not need the handles anymore, simply close them. Since Microsoft
			 * API accepts INVALID_HANDLE_VALUE we don't check the validity of arguments. */
		CloseHandle(l_path2_file);
		CloseHandle(l_path1_file);
	} else {
		BOOL success = GetFileInformationByHandle (l_path2_file, &l_path2_info);
		success = success && GetFileInformationByHandle (l_path1_file, &l_path1_info);
			/* We do not need the handles anymore, simply close them. */
		CloseHandle(l_path2_file);
		CloseHandle(l_path1_file);
		if (success) {
				/* Check that `path2' and `path1' do not represent the same file. */
			if
				((l_path2_info.dwVolumeSerialNumber == l_path1_info.dwVolumeSerialNumber) &&
				(l_path2_info.nFileIndexLow == l_path1_info.nFileIndexLow) &&
				(l_path2_info.nFileIndexHigh == l_path1_info.nFileIndexHigh))
			{
				Result = EIF_TRUE;
			}
		}
	}
#else
	struct stat buf1, buf2;
	int status;
	#ifdef HAS_LSTAT
		status = lstat(arg1, &buf1);
		if (status == 0) {
				/* We found a file, now let's check if it is not a symbolic link. If it is, we use `stat'
			 	 * to ensure the validity of the link. */
			if ((buf1.st_mode & S_IFLNK) == S_IFLNK) {
				status = stat (arg1, &buf1);
			}
		}
		
		if (status == 0) {
			status = lstat(arg2, &buf2);
			if (status == 0) {
					/* We found a file, now let's check if it is not a symbolic link. If it is, we use `stat'
				 	 * to ensure the validity of the link. */
				if ((buf2.st_mode & S_IFLNK) == S_IFLNK) {
					status = stat (arg2, &buf2);
				}
			}
		}
	#else
		status = stat (arg1, &buf1);
		if (status == 0) {
			status = stat (arg2, &buf2);
		}
	#endif
	if (status == 0) {
			/* Both files are present, check they represent the same one. */
		if ((buf1.st_dev == buf2.st_dev) && (buf1.st_ino == buf2.st_ino)) {
			Result = EIF_TRUE;
		}
	}
#endif
return Result;
	;
}
#define INLINE_F4124_50218
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {PATH}.make_empty */
void F4124_50157 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTEAA("make_empty", 4123, Current, 0, 0, 52168);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNSMART(eif_new_type(4018, 0).id);
	F4009_47641(RTCW(tr1));
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	RTHOOK(2);
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	RTHOOK(3);
	F4124_50204(Current);
	RTHOOK(6);
	RTLE;
	RTEE;
}

/* {PATH}.make_current */
void F4124_50158 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTEAA("make_current", 4123, Current, 0, 0, 52169);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNSMART(eif_new_type(4018, 0).id);
	ti4_1 = F4124_50203(Current);
	F4011_47737(RTCW(tr1), ti4_1);
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	RTHOOK(2);
	tr1 = *(EIF_REFERENCE *)(Current);
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R39368[Dtype(RTCW(tr1))-4018])(tr1, (EIF_CHARACTER_8) '.');
	RTHOOK(3);
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
		RTHOOK(4);
		tr1 = *(EIF_REFERENCE *)(Current);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R39368[Dtype(RTCW(tr1))-4018])(tr1, (EIF_CHARACTER_8) '\000');
	}
	RTHOOK(5);
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	RTHOOK(6);
	F4124_50204(Current);
	RTHOOK(10);
	RTLE;
	RTEE;
}

/* {PATH}.make_from_string */
void F4124_50159 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,arg1);
	RTLIU(3);
	
	RTEAA("make_from_string", 4123, Current, 0, 1, 52170);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNSMART(eif_new_type(4018, 0).id);
	ti4_1 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R39111[Dtype(RTCW(arg1))-4011])(arg1);
	ti4_2 = F4124_50203(Current);
	F4011_47737(RTCW(tr1), (EIF_INTEGER_32) (ti4_1 * ti4_2));
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	RTHOOK(2);
	tb1 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R39089[Dtype(RTCW(arg1))-4011])(arg1);
	if ((EIF_BOOLEAN) !tb1) {
		RTHOOK(3);
		F4124_50212(Current, *(EIF_REFERENCE *)(Current), arg1, (EIF_CHARACTER_8) '\000');
		RTHOOK(4);
		F4124_50205(Current);
	} else {
		RTHOOK(5);
		*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	}
	RTHOOK(6);
	F4124_50204(Current);
	RTHOOK(11);
	RTLE;
	RTEE;
}

/* {PATH}.make_from_storage */
void F4124_50161 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,arg1);
	RTLIU(2);
	
	RTEAA("make_from_storage", 4123, Current, 0, 1, 52172);
	RTGC;
	RTHOOK(1);
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) arg1;
	RTHOOK(2);
	F4124_50205(Current);
	RTHOOK(3);
	F4124_50204(Current);
	RTHOOK(6);
	RTLE;
	RTEE;
}

/* {PATH}.make_from_normalized_storage */
void F4124_50162 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,arg1);
	RTLIU(2);
	
	RTEAA("make_from_normalized_storage", 4123, Current, 0, 1, 52173);
	RTGC;
	RTHOOK(1);
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) arg1;
	RTHOOK(2);
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	RTHOOK(3);
	F4124_50204(Current);
	RTHOOK(6);
	RTLE;
	RTEE;
}

/* {PATH}.make_from_pointer */
void F4124_50163 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,loc1);
	RTLR(2,tr1);
	RTLIU(3);
	
	RTEAA("make_from_pointer", 4123, Current, 2, 1, 52174);
	RTGC;
	RTHOOK(1);
	loc2 = F2026_28158(Current, arg1);
	RTHOOK(2);
	loc2 -= (EIF_INTEGER_32) (loc2 % F4124_50203(Current));
	RTHOOK(3);
	loc1 = RTLNS(eif_new_type(2104, 0x00).id, 2104, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F2105_29706(RTCW(loc1), arg1, loc2);
	RTHOOK(4);
	tr1 = F2105_29714(RTCW(loc1), ((EIF_INTEGER_32) 1L), loc2);
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	RTHOOK(5);
	tr1 = *(EIF_REFERENCE *)(Current);
	tb1 = F2697_32768(RTCW(tr1));
	if ((EIF_BOOLEAN) !tb1) {
		RTHOOK(6);
		F4124_50205(Current);
	}
	RTHOOK(7);
	F4124_50204(Current);
	RTHOOK(8);
	RTLE;
	RTEE;
}

/* {PATH}.is_current_symbol */
EIF_BOOLEAN F4124_50164 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTEAA("is_current_symbol", 4123, Current, 0, 0, 52175);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O39200[Dtype(tr1)-4010]);
	if ((EIF_BOOLEAN)(ti4_1 == F4124_50203(Current))) {
		RTHOOK(2);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_BOOLEAN) F4124_50215(Current, *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '.');
	}
	RTHOOK(4);
	RTLE;
	RTEE;
	return (EIF_BOOLEAN) 0;
}

/* {PATH}.is_parent_symbol */
EIF_BOOLEAN F4124_50165 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTEAA("is_parent_symbol", 4123, Current, 0, 0, 52176);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O39200[Dtype(tr1)-4010]);
	if ((EIF_BOOLEAN)(ti4_1 == (EIF_INTEGER_32) (((EIF_INTEGER_32) 2L) * F4124_50203(Current)))) {
		RTHOOK(2);
		Result = F4124_50215(Current, *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '.');
		RTHOOK(3);
		tr1 = *(EIF_REFERENCE *)(Current);
		ti4_1 = F4124_50203(Current);
		Result = F4124_50215(Current, tr1, (EIF_INTEGER_32) (((EIF_INTEGER_32) 1L) + ti4_1), (EIF_CHARACTER_8) '.');
	}
	RTHOOK(4);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.has_root */
EIF_BOOLEAN F4124_50166 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("has_root", 4123, Current, 0, 0, 52177);
	RTGC;
	RTHOOK(1);
	ti4_1 = F4124_50209(Current);
	Result = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 != ((EIF_INTEGER_32) 0L));
	RTHOOK(3);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.is_empty */
EIF_BOOLEAN F4124_50167 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTEAA("is_empty", 4123, Current, 0, 0, 52178);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current);
	Result = F2697_32768(RTCW(tr1));
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.is_relative */
EIF_BOOLEAN F4124_50168 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("is_relative", 4123, Current, 0, 0, 52179);
	RTGC;
	RTHOOK(1);
	Result = F4124_50169(Current);
	Result = (EIF_BOOLEAN) (EIF_BOOLEAN) !Result;
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.is_absolute */
EIF_BOOLEAN F4124_50169 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_CHARACTER_8 tc1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTEAA("is_absolute", 4123, Current, 1, 0, 52180);
	RTGC;
	RTHOOK(1);
	loc1 = F4124_50209(Current);
	RTHOOK(2);
	if ((EIF_BOOLEAN) (loc1 > ((EIF_INTEGER_32) 0L))) {
		RTHOOK(3);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
			RTHOOK(4);
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = F4124_50203(Current);
			tc1 = F4124_50185(Current);
			Result = F4124_50215(Current, tr1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (loc1 - ti4_1) + ((EIF_INTEGER_32) 1L)), tc1);
		} else {
			RTHOOK(5);
			RTHOOK(6);
			RTLE;
			RTEE;
			return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		}
	}
	RTHOOK(7);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.is_same_file_as */
EIF_BOOLEAN F4124_50171 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_POINTER tp2;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,loc2);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTEAA("is_same_file_as", 4123, Current, 2, 1, 52182);
	RTGC;
	RTHOOK(1);
	loc1 = F4124_50200(Current);
	RTHOOK(2);
	loc2 = F4124_50200(RTCW(arg1));
	RTHOOK(3);
	tp1 = *(EIF_POINTER *)(RTCW(loc1)+ _PTROFF_0_1_0_1_0_0_);
	tp2 = *(EIF_POINTER *)(RTCW(loc2)+ _PTROFF_0_1_0_1_0_0_);
	Result = EIF_TEST (inline_F4124_50218(tp1, tp2));
	RTHOOK(4);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.has_extension */
EIF_BOOLEAN F4124_50172 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTEAA("has_extension", 4123, Current, 1, 1, 52183);
	RTGC;
	RTHOOK(1);
	Result = '\0';
	tr1 = F4124_50176(Current);
	loc1 = tr1;
	if (EIF_TEST(loc1)) {
		tb1 = F4009_47683(loc1, arg1);
		Result = tb1;
	}
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.root */
EIF_REFERENCE F4124_50173 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLIU(3);
	
	RTEAA("root", 4123, Current, 1, 0, 52184);
	RTGC;
	RTHOOK(1);
	loc1 = F4124_50209(Current);
	RTHOOK(2);
	if ((EIF_BOOLEAN)(loc1 != ((EIF_INTEGER_32) 0L))) {
		RTHOOK(3);
		tr1 = *(EIF_REFERENCE *)(Current);
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O39200[Dtype(tr1)-4010]);
		if ((EIF_BOOLEAN)(loc1 == ti4_1)) {
			RTHOOK(4);
			tr1 = RTLNS(eif_new_type(4123, 0x00).id, 4123, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F4124_50162(RTCW(tr1), *(EIF_REFERENCE *)(Current));
			RTHOOK(5);
			RTLE;
			RTEE;
			return (EIF_REFERENCE) tr1;
		} else {
			RTHOOK(6);
			Result = RTLNS(eif_new_type(4123, 0x00).id, 4123, _OBJSIZ_2_1_0_0_0_0_0_0_);
			tr1 = *(EIF_REFERENCE *)(Current);
			tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R39152[Dtype(RTCW(tr1))-4011])(tr1, ((EIF_INTEGER_32) 1L), loc1);
			F4124_50162(RTCW(Result), tr1);
		}
	}
	RTHOOK(8);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.parent */
EIF_REFERENCE F4124_50174 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,loc3);
	RTLR(2,tr1);
	RTLR(3,Result);
	RTLIU(4);
	
	RTEAA("parent", 4123, Current, 3, 0, 52185);
	RTGC;
	RTHOOK(1);
	loc1 = F4124_50210(Current);
	RTHOOK(2);
	if ((EIF_BOOLEAN)(loc1 == ((EIF_INTEGER_32) 0L))) {
		RTHOOK(3);
		tr1 = F4124_50173(Current);
		loc3 = tr1;
		if (EIF_TEST(loc3)) {
			
			RTHOOK(5);
			RTHOOK(6);
			RTLE;
			RTEE;
			return (EIF_REFERENCE) loc3;
		} else {
			RTHOOK(7);
			tr1 = RTLNS(eif_new_type(4123, 0x00).id, 4123, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F4124_50158(RTCW(tr1));
			RTHOOK(8);
			RTLE;
			RTEE;
			return (EIF_REFERENCE) tr1;
		}
	} else {
		RTHOOK(9);
		if ((EIF_BOOLEAN)(loc1 == F4124_50203(Current))) {
			RTHOOK(10);
			Result = RTLNS(eif_new_type(4123, 0x00).id, 4123, _OBJSIZ_2_1_0_0_0_0_0_0_);
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = F4124_50203(Current);
			tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R39152[Dtype(RTCW(tr1))-4011])(tr1, ((EIF_INTEGER_32) 1L), ti4_1);
			F4124_50162(RTCW(Result), tr1);
		} else {
			RTHOOK(11);
			loc2 = F4124_50209(Current);
			RTHOOK(12);
			if ((EIF_BOOLEAN) (loc1 <= loc2)) {
				RTHOOK(13);
				tr1 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O39200[Dtype(tr1)-4010]);
				if ((EIF_BOOLEAN)(loc2 == ti4_1)) {
					RTHOOK(14);
					RTHOOK(15);
					RTLE;
					RTEE;
					return (EIF_REFERENCE) Current;
				} else {
					RTHOOK(16);
					Result = RTLNS(eif_new_type(4123, 0x00).id, 4123, _OBJSIZ_2_1_0_0_0_0_0_0_);
					tr1 = *(EIF_REFERENCE *)(Current);
					tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R39152[Dtype(RTCW(tr1))-4011])(tr1, ((EIF_INTEGER_32) 1L), loc2);
					F4124_50162(RTCW(Result), tr1);
				}
			} else {
				RTHOOK(17);
				Result = RTLNS(eif_new_type(4123, 0x00).id, 4123, _OBJSIZ_2_1_0_0_0_0_0_0_);
				tr1 = *(EIF_REFERENCE *)(Current);
				ti4_1 = F4124_50203(Current);
				tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R39152[Dtype(RTCW(tr1))-4011])(tr1, ((EIF_INTEGER_32) 1L), (EIF_INTEGER_32) (loc1 - ti4_1));
				F4124_50162(RTCW(Result), tr1);
			}
		}
	}
	RTHOOK(18);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.entry */
EIF_REFERENCE F4124_50175 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,Result);
	RTLIU(4);
	
	RTEAA("entry", 4123, Current, 2, 0, 52186);
	RTGC;
	RTHOOK(1);
	loc1 = F4124_50210(Current);
	RTHOOK(2);
	if ((EIF_BOOLEAN)(loc1 == ((EIF_INTEGER_32) 0L))) {
		RTHOOK(3);
		loc2 = F4124_50209(Current);
		RTHOOK(4);
		if ((EIF_BOOLEAN) (loc2 > ((EIF_INTEGER_32) 0L))) {
			RTHOOK(5);
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O39200[Dtype(tr1)-4010]);
			if ((EIF_BOOLEAN) (loc2 < ti4_1)) {
				RTHOOK(6);
				Result = RTLNS(eif_new_type(4123, 0x00).id, 4123, _OBJSIZ_2_1_0_0_0_0_0_0_);
				tr1 = *(EIF_REFERENCE *)(Current);
				tr2 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2) + O39200[Dtype(tr2)-4010]);
				tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R39152[Dtype(RTCW(tr1))-4011])(tr1, (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)), ti4_1);
				F4124_50162(RTCW(Result), tr1);
			}
		} else {
			RTHOOK(7);
			Result = (EIF_REFERENCE) Current;
		}
	} else {
		RTHOOK(8);
		loc2 = F4124_50209(Current);
		RTHOOK(9);
		if ((EIF_BOOLEAN) (loc1 <= loc2)) {
			RTHOOK(10);
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O39200[Dtype(tr1)-4010]);
			if ((EIF_BOOLEAN) (loc2 < ti4_1)) {
				RTHOOK(11);
				Result = RTLNS(eif_new_type(4123, 0x00).id, 4123, _OBJSIZ_2_1_0_0_0_0_0_0_);
				tr1 = *(EIF_REFERENCE *)(Current);
				tr2 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2) + O39200[Dtype(tr2)-4010]);
				tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R39152[Dtype(RTCW(tr1))-4011])(tr1, (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)), ti4_1);
				F4124_50162(RTCW(Result), tr1);
			}
		} else {
			RTHOOK(12);
			Result = RTLNS(eif_new_type(4123, 0x00).id, 4123, _OBJSIZ_2_1_0_0_0_0_0_0_);
			tr1 = *(EIF_REFERENCE *)(Current);
			tr2 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2) + O39200[Dtype(tr2)-4010]);
			tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R39152[Dtype(RTCW(tr1))-4011])(tr1, (EIF_INTEGER_32) (loc1 + ((EIF_INTEGER_32) 1L)), ti4_1);
			F4124_50162(RTCW(Result), tr1);
		}
	}
	RTHOOK(13);
	tb1 = '\0';
	if ((EIF_BOOLEAN)(Result != NULL)) {
		tb2 = '\01';
		tb3 = '\01';
		tb4 = F4124_50167(RTCW(Result));
		if (!tb4) {
			tb4 = F4124_50164(RTCW(Result));
			tb3 = tb4;
		}
		if (!tb3) {
			tb3 = F4124_50165(RTCW(Result));
			tb2 = tb3;
		}
		tb1 = tb2;
	}
	if (tb1) {
		RTHOOK(14);
		RTHOOK(15);
		RTLE;
		RTEE;
		return (EIF_REFERENCE) NULL;
	}
	RTHOOK(17);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.extension */
EIF_REFERENCE F4124_50176 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_CHARACTER_32 tw1;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc4);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc1);
	RTLIU(4);
	
	RTEAA("extension", 4123, Current, 4, 0, 52187);
	RTGC;
	RTHOOK(1);
	tr1 = F4124_50175(Current);
	loc4 = tr1;
	if (EIF_TEST(loc4)) {
		RTHOOK(2);
		loc1 = F4124_50198(loc4);
		RTHOOK(3);
		loc3 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_0_0_2_);
		RTHOOK(4);
		tw1 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '.';
		loc2 = F4013_47824(RTCW(loc1), tw1, loc3);
		RTHOOK(5);
		if ((EIF_BOOLEAN) ((EIF_BOOLEAN)(loc2 != ((EIF_INTEGER_32) 0L)) && (EIF_BOOLEAN)(loc2 != loc3))) {
			RTHOOK(6);
			tr1 = F4014_47880(RTCW(loc1), (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)), loc3);
			RTHOOK(7);
			RTLE;
			RTEE;
			return (EIF_REFERENCE) tr1;
		}
	}
	RTHOOK(10);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) 0;
}

/* {PATH}.components */
EIF_REFERENCE F4124_50177 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,Result);
	RTLR(2,loc1);
	RTLR(3,tr1);
	RTLIU(4);
	
	RTEAA("components", 4123, Current, 3, 0, 52188);
	RTGC;
	RTHOOK(1);
	{
		static EIF_TYPE_INDEX typarr0[] = {2951,4123,0xFFFF};
		EIF_TYPE typres0;
		static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
		
		typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), typarr0)));
		Result = RTLNS(typres0.id, 2951, _OBJSIZ_1_1_0_1_0_0_0_0_);
	}
	F2952_33508(RTCW(Result), ((EIF_INTEGER_32) 10L));
	RTHOOK(2);
	loc3 = F4124_50209(Current);
	RTHOOK(3);
	if ((EIF_BOOLEAN) (loc3 > ((EIF_INTEGER_32) 0L))) {
		RTHOOK(4);
		loc1 = RTLNS(eif_new_type(4018, 0x00).id, 4018, _OBJSIZ_1_1_0_3_0_0_0_0_);
		F4011_47737(RTCW(loc1), loc3);
		RTHOOK(5);
		F4019_48087(RTCW(loc1), *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 1L), loc3);
		RTHOOK(6);
		tr1 = RTLNS(eif_new_type(4123, 0x00).id, 4123, _OBJSIZ_2_1_0_0_0_0_0_0_);
		F4124_50162(RTCW(tr1), loc1);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R28644[Dtype(RTCW(Result))-2660])(Result, tr1);
		RTHOOK(7);
		loc3++;
	} else {
		RTHOOK(8);
		loc3 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	}
	RTHOOK(9);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O39200[Dtype(tr1)-4010]);
	if ((EIF_BOOLEAN) (loc3 <= ti4_1)) {
		RTHOOK(10);
		loc2 = (EIF_INTEGER_32) loc3;
		RTHOOK(11);
		loc3 = F4124_50211(Current, loc2);
		for (;;) {
			RTHOOK(12);
			if ((EIF_BOOLEAN)(loc3 == ((EIF_INTEGER_32) 0L))) break;
			RTHOOK(13);
			loc1 = RTLNS(eif_new_type(4018, 0x00).id, 4018, _OBJSIZ_1_1_0_3_0_0_0_0_);
			F4011_47737(RTCW(loc1), (EIF_INTEGER_32) (loc3 - loc2));
			RTHOOK(14);
			F4019_48087(RTCW(loc1), *(EIF_REFERENCE *)(Current), loc2, (EIF_INTEGER_32) (loc3 - ((EIF_INTEGER_32) 1L)));
			RTHOOK(15);
			tr1 = RTLNS(eif_new_type(4123, 0x00).id, 4123, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F4124_50162(RTCW(tr1), loc1);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R28644[Dtype(RTCW(Result))-2660])(Result, tr1);
			RTHOOK(16);
			loc2 = F4124_50203(Current);
			loc2 = (EIF_INTEGER_32) (EIF_INTEGER_32) (loc3 + loc2);
			RTHOOK(17);
			loc3 = F4124_50211(Current, loc2);
		}
		RTHOOK(18);
		tr1 = *(EIF_REFERENCE *)(Current);
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O39200[Dtype(tr1)-4010]);
		if ((EIF_BOOLEAN) (loc2 <= ti4_1)) {
			RTHOOK(19);
			loc1 = RTLNS(eif_new_type(4018, 0x00).id, 4018, _OBJSIZ_1_1_0_3_0_0_0_0_);
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O39200[Dtype(tr1)-4010]);
			F4011_47737(RTCW(loc1), (EIF_INTEGER_32) (ti4_1 - loc2));
			RTHOOK(20);
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O39200[Dtype(tr1)-4010]);
			F4019_48087(RTCW(loc1), *(EIF_REFERENCE *)(Current), loc2, ti4_1);
			RTHOOK(21);
			tr1 = RTLNS(eif_new_type(4123, 0x00).id, 4123, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F4124_50162(RTCW(tr1), loc1);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R28644[Dtype(RTCW(Result))-2660])(Result, tr1);
		}
	}
	RTHOOK(22);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.absolute_path */
EIF_REFERENCE F4124_50178 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLIU(3);
	
	RTEAA("absolute_path", 4123, Current, 0, 0, 52189);
	RTGC;
	RTHOOK(1);
	tr1 = F2030_28243(RTCV(RTOUCR(232,F4124_50208, (Current))));
	Result = F4124_50179(Current, tr1);
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.absolute_path_in */
EIF_REFERENCE F4124_50179 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE tr3 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(8);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,arg1);
	RTLR(3,loc1);
	RTLR(4,Result);
	RTLR(5,tr2);
	RTLR(6,tr3);
	RTLR(7,loc2);
	RTLIU(8);
	
	RTEAA("absolute_path_in", 4123, Current, 2, 1, 52190);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current);
	tb1 = F2697_32768(RTCW(tr1));
	if (tb1) {
		RTHOOK(2);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_REFERENCE) arg1;
	} else {
		RTHOOK(4);
		if (F4124_50169(Current)) {
			RTHOOK(5);
			RTHOOK(6);
			RTLE;
			RTEE;
			return (EIF_REFERENCE) Current;
		} else {
			RTHOOK(7);
			if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
				RTHOOK(8);
				tr1 = F4124_50173(Current);
				loc1 = tr1;
				if (EIF_TEST(loc1)) {
					RTHOOK(9);
					tb1 = '\0';
					tb2 = '\0';
					tr1 = *(EIF_REFERENCE *)(loc1);
					ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O39200[Dtype(tr1)-4010]);
					if ((EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 4L))) {
						tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
						ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O39200[Dtype(tr1)-4010]);
						tb2 = (EIF_BOOLEAN) (ti4_1 >= ((EIF_INTEGER_32) 4L));
					}
					if (tb2) {
						tb2 = '\0';
						tr1 = *(EIF_REFERENCE *)(loc1);
						tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R28871[Dtype(RTCW(tr1))-2846])(tr1, ((EIF_INTEGER_32) 1L)));
						tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
						tc2 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R28871[Dtype(RTCW(tr1))-2846])(tr1, ((EIF_INTEGER_32) 1L)));
						if ((EIF_BOOLEAN)(tc1 == tc2)) {
							tr1 = *(EIF_REFERENCE *)(loc1);
							tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R28871[Dtype(RTCW(tr1))-2846])(tr1, ((EIF_INTEGER_32) 3L)));
							tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
							tc2 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R28871[Dtype(RTCW(tr1))-2846])(tr1, ((EIF_INTEGER_32) 3L)));
							tb2 = (EIF_BOOLEAN)(tc1 == tc2);
						}
						tb1 = tb2;
					}
					if (tb1) {
						RTHOOK(10);
						Result = (EIF_REFERENCE) eif_builtin_ANY_twin__o (arg1);
					} else {
						RTHOOK(11);
						Result = (EIF_REFERENCE) loc1;
					}
					RTHOOK(12);
					tr1 = *(EIF_REFERENCE *)(RTCW(Result));
					tr2 = *(EIF_REFERENCE *)(Current);
					tr3 = *(EIF_REFERENCE *)(loc1);
					ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr3) + O39200[Dtype(tr3)-4010]);
					tr3 = *(EIF_REFERENCE *)(Current);
					ti4_2 = *(EIF_INTEGER_32 *)(RTCW(tr3) + O39200[Dtype(tr3)-4010]);
					tc1 = F4124_50185(Current);
					F4124_50214(Current, tr1, tr2, (EIF_INTEGER_32) (ti4_1 + ((EIF_INTEGER_32) 1L)), ti4_2, tc1);
				} else {
					RTHOOK(13);
					if (F4124_50215(Current, *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '\\')) {
						RTHOOK(14);
						Result = (EIF_REFERENCE) eif_builtin_ANY_twin__o (arg1);
						RTHOOK(15);
						tr1 = F4124_50173(RTCW(Result));
						loc2 = tr1;
						if (EIF_TEST(loc2)) {
							RTHOOK(16);
							Result = (EIF_REFERENCE) loc2;
						}
					} else {
						RTHOOK(17);
						Result = (EIF_REFERENCE) eif_builtin_ANY_twin__o (arg1);
					}
					RTHOOK(18);
					tr1 = *(EIF_REFERENCE *)(RTCW(Result));
					tr2 = *(EIF_REFERENCE *)(Current);
					tc1 = F4124_50185(Current);
					F4124_50213(Current, tr1, tr2, tc1);
				}
			} else {
				RTHOOK(19);
				Result = (EIF_REFERENCE) eif_builtin_ANY_twin__o (arg1);
				RTHOOK(20);
				tr1 = *(EIF_REFERENCE *)(RTCW(Result));
				tr2 = *(EIF_REFERENCE *)(Current);
				tc1 = F4124_50185(Current);
				F4124_50213(Current, tr1, tr2, tc1);
			}
			RTHOOK(21);
			F4124_50204(RTCW(Result));
		}
	}
	RTHOOK(23);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.canonical_path */
EIF_REFERENCE F4124_50180 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc5 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_CHARACTER_8 tc1;
	RTLD;
	
	RTLI(7);
	RTLR(0,loc2);
	RTLR(1,Current);
	RTLR(2,loc4);
	RTLR(3,tr1);
	RTLR(4,loc3);
	RTLR(5,loc1);
	RTLR(6,loc5);
	RTLIU(7);
	
	RTEAA("canonical_path", 4123, Current, 5, 0, 52191);
	RTGC;
	RTHOOK(1);
	loc2 = F4124_50178(Current);
	RTHOOK(2);
	tr1 = F4124_50173(RTCW(loc2));
	loc4 = tr1;
	if (EIF_TEST(loc4)) {
		RTHOOK(3);
		loc3 = RTLNSMART(eif_new_type(4018, 0).id);
		tr1 = *(EIF_REFERENCE *)(RTCW(loc2));
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O39200[Dtype(tr1)-4010]);
		F4011_47737(RTCW(loc3), ti4_1);
		RTHOOK(4);
		loc1 = F4124_50177(RTCW(loc2));
		
		RTHOOK(7);
		F2952_33539(RTCW(loc1));
		RTHOOK(8);
		tr1 = F2952_33513(RTCW(loc1));
		tr1 = *(EIF_REFERENCE *)(RTCW(tr1));
		tc1 = F4124_50185(Current);
		F4124_50213(Current, loc3, tr1, tc1);
		RTHOOK(9);
		(FUNCTION_CAST(void, (EIF_REFERENCE)) R28662[Dtype(RTCW(loc1))-2767])(loc1);
		for (;;) {
			RTHOOK(10);
			tb1 = F2881_33049(RTCW(loc1));
			if (tb1) break;
			RTHOOK(11);
			tr1 = F2952_33513(RTCW(loc1));
			tb2 = F4124_50164(RTCW(tr1));
			if (tb2) {
				RTHOOK(12);
				(FUNCTION_CAST(void, (EIF_REFERENCE)) R28662[Dtype(RTCW(loc1))-2767])(loc1);
			} else {
				RTHOOK(13);
				tr1 = F2952_33513(RTCW(loc1));
				tb2 = F4124_50165(RTCW(tr1));
				if (tb2) {
					RTHOOK(14);
					tb2 = F2849_32993(RTCW(loc1));
					if ((EIF_BOOLEAN) !tb2) {
						RTHOOK(15);
						F2952_33542(RTCW(loc1));
						RTHOOK(16);
						(FUNCTION_CAST(void, (EIF_REFERENCE)) R28662[Dtype(RTCW(loc1))-2767])(loc1);
					}
					RTHOOK(17);
					(FUNCTION_CAST(void, (EIF_REFERENCE)) R28662[Dtype(RTCW(loc1))-2767])(loc1);
				} else {
					RTHOOK(18);
					F2952_33541(RTCW(loc1));
				}
			}
		}
		RTHOOK(19);
		loc5 = F2952_33522(RTCW(loc1));
		for (;;) {
			tb2 = F2375_31971(loc5);
			if (tb2) break;
			RTHOOK(20);
			tr1 = F2375_31962(loc5);
			tr1 = *(EIF_REFERENCE *)(RTCW(tr1));
			tc1 = F4124_50185(Current);
			F4124_50213(Current, loc3, tr1, tc1);
			RTHOOK(21);
			F2375_31977(loc5);
		}
		RTHOOK(22);
		tr1 = RTLNS(eif_new_type(4123, 0x00).id, 4123, _OBJSIZ_2_1_0_0_0_0_0_0_);
		F4124_50162(RTCW(tr1), loc3);
		RTHOOK(23);
		RTLE;
		RTEE;
		return (EIF_REFERENCE) tr1;
	} else {
		
		RTHOOK(25);
		RTHOOK(26);
		RTLE;
		RTEE;
		return (EIF_REFERENCE) loc2;
	}/* NOTREACHED */
	
}

/* {PATH}.hash_code */
EIF_INTEGER_32 F4124_50181 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTEAA("hash_code", 4123, Current, 0, 0, 52192);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN) EIF_TEST(eif_case_sensitive_path_names())) {
		RTHOOK(2);
		tr1 = *(EIF_REFERENCE *)(Current);
		Result = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R37370[Dtype(RTCW(tr1))-3818])(tr1);
	} else {
		RTHOOK(3);
		Result = F4009_47651(RTCV(F4124_50198(Current)));
	}
	RTHOOK(4);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.native_string */
EIF_REFERENCE F4124_50182 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(2);
	RTLR(0,tr1);
	RTLR(1,Current);
	RTLIU(2);
	
	RTEAA("native_string", 4123, Current, 0, 0, 52193);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNS(eif_new_type(2026, 0x00).id, 2026, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F2027_28164(RTCW(tr1), *(EIF_REFERENCE *)(Current));
	RTHOOK(2);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.directory_separator */
EIF_CHARACTER_8 F4124_50185 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("directory_separator", 4123, Current, 0, 0, 52196);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
		RTHOOK(2);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
	} else {
		RTHOOK(4);
		RTHOOK(5);
		RTLE;
		RTEE;
		return (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
	}/* NOTREACHED */
	
}

/* {PATH}.extended */
EIF_REFERENCE F4124_50186 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_INTEGER_32 ti4_4;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTEAA("extended", 4123, Current, 2, 1, 52197);
	RTGC;
	RTHOOK(1);
	loc1 = RTLNSMART(eif_new_type(4018, 0).id);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O39200[Dtype(tr1)-4010]);
	ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R39111[Dtype(RTCW(arg1))-4011])(arg1);
	ti4_3 = F4124_50203(Current);
	ti4_4 = F4124_50203(Current);
	F4011_47737(RTCW(loc1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + (EIF_INTEGER_32) (ti4_2 * ti4_3)) + ti4_4));
	RTHOOK(2);
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R39364[Dtype(RTCW(loc1))-4018])(loc1, *(EIF_REFERENCE *)(Current));
	RTHOOK(3);
	tb1 = '\0';
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1) + O39200[Dtype(loc1)-4010]);
	if ((EIF_BOOLEAN) (ti4_1 > ((EIF_INTEGER_32) 0L))) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1) + O39200[Dtype(loc1)-4010]);
		tb1 = (EIF_BOOLEAN)(F4124_50209(Current) == ti4_1);
	}
	if (tb1) {
		RTHOOK(4);
		F4124_50212(Current, loc1, arg1, (EIF_CHARACTER_8) '\000');
	} else {
		RTHOOK(5);
		tc1 = F4124_50185(Current);
		F4124_50212(Current, loc1, arg1, tc1);
	}
	RTHOOK(6);
	tr1 = RTLNS(eif_new_type(4123, 0x00).id, 4123, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F4124_50161(RTCW(tr1), loc1);
	RTHOOK(7);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.extended_path */
EIF_REFERENCE F4124_50187 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTEAA("extended_path", 4123, Current, 1, 1, 52198);
	RTGC;
	RTHOOK(1);
	loc1 = RTLNSMART(eif_new_type(4018, 0).id);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O39200[Dtype(tr1)-4010]);
	tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
	ti4_2 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O39200[Dtype(tr1)-4010]);
	ti4_3 = F4124_50203(Current);
	F4011_47737(RTCW(loc1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + ti4_2) + ti4_3));
	RTHOOK(2);
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R39364[Dtype(RTCW(loc1))-4018])(loc1, *(EIF_REFERENCE *)(Current));
	RTHOOK(3);
	tb1 = '\0';
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1) + O39200[Dtype(loc1)-4010]);
	if ((EIF_BOOLEAN) (ti4_1 > ((EIF_INTEGER_32) 0L))) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1) + O39200[Dtype(loc1)-4010]);
		tb1 = (EIF_BOOLEAN)(F4124_50209(Current) == ti4_1);
	}
	if (tb1) {
		RTHOOK(4);
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
		F4124_50213(Current, loc1, tr1, (EIF_CHARACTER_8) '\000');
	} else {
		RTHOOK(5);
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
		tc1 = F4124_50185(Current);
		F4124_50213(Current, loc1, tr1, tc1);
	}
	RTHOOK(6);
	tr1 = RTLNS(eif_new_type(4123, 0x00).id, 4123, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F4124_50162(RTCW(tr1), loc1);
	RTHOOK(7);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.appended */
EIF_REFERENCE F4124_50188 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTEAA("appended", 4123, Current, 1, 1, 52199);
	RTGC;
	RTHOOK(1);
	loc1 = RTLNSMART(eif_new_type(4018, 0).id);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O39200[Dtype(tr1)-4010]);
	ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R39111[Dtype(RTCW(arg1))-4011])(arg1);
	ti4_3 = F4124_50203(Current);
	F4011_47737(RTCW(loc1), (EIF_INTEGER_32) (ti4_1 + (EIF_INTEGER_32) (ti4_2 * ti4_3)));
	RTHOOK(2);
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R39364[Dtype(RTCW(loc1))-4018])(loc1, *(EIF_REFERENCE *)(Current));
	RTHOOK(3);
	F4124_50212(Current, loc1, arg1, (EIF_CHARACTER_8) '\000');
	RTHOOK(4);
	tr1 = RTLNS(eif_new_type(4123, 0x00).id, 4123, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F4124_50161(RTCW(tr1), loc1);
	RTHOOK(5);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.appended_with_extension */
EIF_REFERENCE F4124_50189 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_INTEGER_32 ti4_4;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTEAA("appended_with_extension", 4123, Current, 2, 1, 52200);
	RTGC;
	RTHOOK(1);
	loc1 = RTLNSMART(eif_new_type(4018, 0).id);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O39200[Dtype(tr1)-4010]);
	ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R39111[Dtype(RTCW(arg1))-4011])(arg1);
	ti4_3 = F4124_50203(Current);
	ti4_4 = F4124_50203(Current);
	F4011_47737(RTCW(loc1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + (EIF_INTEGER_32) (ti4_2 * ti4_3)) + ti4_4));
	RTHOOK(2);
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R39364[Dtype(RTCW(loc1))-4018])(loc1, *(EIF_REFERENCE *)(Current));
	RTHOOK(3);
	F4124_50212(Current, loc1, arg1, (EIF_CHARACTER_8) '.');
	RTHOOK(4);
	tr1 = RTLNS(eif_new_type(4123, 0x00).id, 4123, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F4124_50162(RTCW(tr1), loc1);
	RTHOOK(5);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.same_as */
EIF_BOOLEAN F4124_50190 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(2);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLIU(2);
	
	RTEAA("same_as", 4123, Current, 0, 1, 52201);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN)(arg1 == NULL)) {
	} else {
		RTHOOK(2);
		if ((EIF_BOOLEAN)(arg1 == Current)) {
			RTHOOK(3);
			RTHOOK(4);
			RTLE;
			RTEE;
			return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		} else {
			RTHOOK(5);
			if ((EIF_BOOLEAN) EIF_TEST(eif_case_sensitive_path_names())) {
				RTHOOK(6);
				RTHOOK(7);
				RTLE;
				RTEE;
				return (EIF_BOOLEAN) F4124_50193(Current, arg1);
			} else {
				RTHOOK(8);
				RTHOOK(9);
				RTLE;
				RTEE;
				return (EIF_BOOLEAN) F4124_50194(Current, arg1);
			}
		}
	}
	RTHOOK(10);
	RTLE;
	RTEE;
	return (EIF_BOOLEAN) 0;
}

/* {PATH}.is_less */
EIF_BOOLEAN F4124_50191 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,arg1);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTEAA("is_less", 4123, Current, 0, 1, 52202);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN) EIF_TEST(eif_case_sensitive_path_names())) {
		RTHOOK(2);
		tr1 = *(EIF_REFERENCE *)(Current);
		tr2 = *(EIF_REFERENCE *)(RTCW(arg1));
		Result = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE, EIF_REFERENCE)) R23582[Dtype(RTCW(tr1))-1906])(tr1, tr2);
	} else {
		RTHOOK(3);
		tr1 = F4014_47877(RTCV(F4124_50198(Current)));
		tr2 = F4124_50198(RTCW(arg1));
		tr2 = F4014_47877(RTCW(tr2));
		Result = F4013_47840(RTCW(tr1), tr2);
	}
	RTHOOK(4);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.is_equal */
EIF_BOOLEAN F4124_50192 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	
	
	RTEAA("is_equal", 4123, Current, 0, 1, 52203);
	RTHOOK(1);
	RTHOOK(2);
	RTEE;
	return (EIF_BOOLEAN) F4124_50190(Current, arg1);
}

/* {PATH}.is_case_sensitive_equal */
EIF_BOOLEAN F4124_50193 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTEAA("is_case_sensitive_equal", 4123, Current, 0, 1, 52204);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN)(arg1 == Current)) {
		RTHOOK(2);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	} else {
		RTHOOK(4);
		tr1 = *(EIF_REFERENCE *)(Current);
		tr2 = *(EIF_REFERENCE *)(RTCW(arg1));
		Result = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE, EIF_REFERENCE)) R11[Dtype(RTCW(tr1))-34])(tr1, tr2);
	}
	RTHOOK(5);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.is_case_insensitive_equal */
EIF_BOOLEAN F4124_50194 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTEAA("is_case_insensitive_equal", 4123, Current, 0, 1, 52205);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN)(arg1 == Current)) {
		RTHOOK(2);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	} else {
		RTHOOK(4);
		tr1 = F4124_50198(Current);
		tr2 = F4124_50198(RTCW(arg1));
		Result = F4013_47836(RTCW(tr1), tr2);
	}
	RTHOOK(5);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.copy */
void F4124_50195 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLIU(3);
	
	RTEAA("copy", 4123, Current, 0, 1, 52206);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN)(arg1 != Current)) {
		RTHOOK(2);
		eif_builtin_ANY_standard_copy__o_ (Current, arg1);
		RTHOOK(3);
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
		tr1 = (EIF_REFERENCE) eif_builtin_ANY_twin__o (tr1);
		RTAR(Current, tr1);
		*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	}
	RTHOOK(4);
	RTLE;
	RTEE;
}

/* {PATH}.out */
EIF_REFERENCE F4124_50196 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(3);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLIU(3);
	
	RTEAA("out", 4123, Current, 1, 0, 52207);
	RTGC;
	RTHOOK(1);
	tr1 = F4124_50198(Current);
	loc1 = tr1;
	loc1 = RTRV(eif_new_type(4010, 0x00),loc1);
	if (EIF_TEST(loc1)) {
		RTHOOK(2);
		tr1 = RTLNS(eif_new_type(4018, 0x00).id, 4018, _OBJSIZ_1_1_0_3_0_0_0_0_);
		F4011_47739(RTCW(tr1), loc1);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_REFERENCE) tr1;
	} else {
		RTHOOK(4);
		RTHOOK(5);
		RTLE;
		RTEE;
		return (EIF_REFERENCE) F4124_50197(Current);
	}/* NOTREACHED */
	
}

/* {PATH}.utf_8_name */
EIF_REFERENCE F4124_50197 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	struct eif_ex_448 sloc1;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) sloc1.data;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	memset (&sloc1.overhead, 0, OVERHEAD + _OBJSIZ_0_0_0_0_0_0_0_0_);
	sloc1.overhead.ov_flags = EO_EXP | EO_STACK;
	RT_DFS(&sloc1.overhead, eif_new_type(494, 0x00).id);
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,Result);
	RTLIU(4);
	
	RTEAA("utf_8_name", 4123, Current, 1, 0, 52208);
	RTGC;
	RTHOOK(1);
	tr1 = F4124_50198(Current);
	Result = F495_8461(RTCW(loc1), tr1);
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.name */
EIF_REFERENCE F4124_50198 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	struct eif_ex_448 sloc1;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) sloc1.data;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	memset (&sloc1.overhead, 0, OVERHEAD + _OBJSIZ_0_0_0_0_0_0_0_0_);
	sloc1.overhead.ov_flags = EO_EXP | EO_STACK;
	RT_DFS(&sloc1.overhead, eif_new_type(494, 0x00).id);
	RTLI(5);
	RTLR(0,loc2);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc1);
	RTLR(4,Result);
	RTLIU(5);
	
	RTEAA("name", 4123, Current, 2, 0, 52209);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_1_);
	loc2 = tr1;
	if (EIF_TEST(loc2)) {
		RTHOOK(2);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_REFERENCE) loc2;
	} else {
		RTHOOK(4);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
			RTHOOK(5);
			Result = RTLNS(eif_new_type(4013, 0x00).id, 4013, _OBJSIZ_1_0_0_4_0_0_0_0_);
			tr1 = F495_8500(RTCW(loc1), *(EIF_REFERENCE *)(Current));
			F4013_47813(RTCW(Result), tr1);
		} else {
			RTHOOK(6);
			Result = RTLNS(eif_new_type(4013, 0x00).id, 4013, _OBJSIZ_1_0_0_4_0_0_0_0_);
			tr1 = F495_8473(RTCW(loc1), *(EIF_REFERENCE *)(Current));
			F4013_47813(RTCW(Result), tr1);
		}
		RTHOOK(7);
		RTAR(Current, Result);
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) Result;
	}
	RTHOOK(9);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.debug_output */
EIF_REFERENCE F4124_50199 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	
	
	RTEAA("debug_output", 4123, Current, 0, 0, 52210);
	RTHOOK(1);
	RTHOOK(2);
	RTEE;
	return (EIF_REFERENCE) F4124_50198(Current);
}

/* {PATH}.to_pointer */
EIF_REFERENCE F4124_50200 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	RTLD;
	
	RTLI(3);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLIU(3);
	
	RTEAA("to_pointer", 4123, Current, 1, 0, 52211);
	RTGC;
	RTHOOK(1);
	loc1 = RTLNS(eif_new_type(2104, 0x00).id, 2104, _OBJSIZ_1_0_0_1_0_0_0_0_);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O39200[Dtype(tr1)-4010]);
	ti4_2 = F4124_50203(Current);
	F2105_29702(RTCW(loc1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + ti4_2) - ((EIF_INTEGER_32) 1L)));
	RTHOOK(2);
	F2105_29729(RTCW(loc1), *(EIF_REFERENCE *)(Current));
	RTHOOK(3);
	tr1 = *(EIF_REFERENCE *)(RTCW(loc1));
	RTHOOK(4);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.unit_size */
EIF_INTEGER_32 F4124_50203 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unit_size", 4123, Current, 0, 0, 52214);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
		RTHOOK(2);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
	} else {
		RTHOOK(4);
		RTHOOK(5);
		RTLE;
		RTEE;
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	}/* NOTREACHED */
	
}

/* {PATH}.reset_internal_data */
void F4124_50204 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	
	
	RTEAA("reset_internal_data", 4123, Current, 0, 0, 52152);
	RTHOOK(1);
	*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
	RTHOOK(2);
	RTEE;
}

/* {PATH}.normalize */
void F4124_50205 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc4 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc5 = (EIF_INTEGER_32) 0;
	EIF_BOOLEAN loc6 = (EIF_BOOLEAN) 0;
	EIF_BOOLEAN loc7 = (EIF_BOOLEAN) 0;
	EIF_BOOLEAN loc8 = (EIF_BOOLEAN) 0;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_CHARACTER_8 tc1;
	RTLD;
	
	RTLI(2);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLIU(2);
	
	RTEAA("normalize", 4123, Current, 8, 0, 52153);
	RTGC;
	RTHOOK(1);
	loc1 = *(EIF_REFERENCE *)(Current);
	RTHOOK(2);
	loc4 = *(EIF_INTEGER_32 *)(RTCW(loc1) + O39200[Dtype(loc1)-4010]);
	RTHOOK(3);
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
		RTHOOK(4);
		loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		RTHOOK(5);
		if ((EIF_BOOLEAN) (loc4 >= ((EIF_INTEGER_32) 10L))) {
			RTHOOK(6);
			tb1 = '\01';
			tb2 = '\0';
			if (F4124_50215(Current, loc1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '/')) {
				tb3 = '\01';
				if (!F4124_50215(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '/')) {
					tb3 = F4124_50215(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '\\');
				}
				tb2 = tb3;
			}
			if (!tb2) {
				tb2 = '\0';
				if (F4124_50215(Current, loc1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '\\')) {
					tb3 = '\01';
					if (!F4124_50215(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '\\')) {
						tb3 = F4124_50215(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '/');
					}
					tb2 = tb3;
				}
				tb1 = tb2;
			}
			if (tb1) {
				RTHOOK(7);
				tb1 = '\0';
				if ((EIF_BOOLEAN) !F4124_50215(Current, loc1, ((EIF_INTEGER_32) 5L), (EIF_CHARACTER_8) '/')) {
					tb1 = (EIF_BOOLEAN) !F4124_50215(Current, loc1, ((EIF_INTEGER_32) 5L), (EIF_CHARACTER_8) '\\');
				}
				if (tb1) {
					RTHOOK(8);
					loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 5L);
					RTHOOK(9);
					loc8 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
				}
			}
		}
		RTHOOK(10);
		loc3 = (EIF_INTEGER_32) loc2;
		RTHOOK(11);
		loc7 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		for (;;) {
			RTHOOK(12);
			if ((EIF_BOOLEAN) (loc2 > loc4)) break;
			RTHOOK(13);
			if (loc6) {
				RTHOOK(14);
				loc7 = '\0';
				if ((EIF_BOOLEAN) !F4124_50215(Current, loc1, loc2, (EIF_CHARACTER_8) '\\')) {
					loc7 = (EIF_BOOLEAN) !F4124_50215(Current, loc1, loc2, (EIF_CHARACTER_8) '/');
				}
				RTHOOK(15);
				loc6 = (EIF_BOOLEAN) (EIF_BOOLEAN) !loc7;
			} else {
				RTHOOK(16);
				if (F4124_50215(Current, loc1, loc2, (EIF_CHARACTER_8) '/')) {
					RTHOOK(17);
					tc1 = (EIF_CHARACTER_8) '\\';
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R28653[Dtype(RTCW(loc1))-2846])(loc1, (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &loc2);
					RTHOOK(18);
					loc6 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
				} else {
					RTHOOK(19);
					loc6 = F4124_50215(Current, loc1, loc2, (EIF_CHARACTER_8) '\\');
				}
			}
			RTHOOK(20);
			if (loc7) {
				RTHOOK(21);
				if ((EIF_BOOLEAN)(loc2 != loc3)) {
					RTHOOK(22);
					tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R28871[Dtype(RTCW(loc1))-2846])(loc1, loc2));
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R28653[Dtype(RTCW(loc1))-2846])(loc1, (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &loc3);
					RTHOOK(23);
					tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R28871[Dtype(RTCW(loc1))-2846])(loc1, (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L))));
					ti4_1 = (EIF_INTEGER_32) (loc3 + ((EIF_INTEGER_32) 1L));
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R28653[Dtype(RTCW(loc1))-2846])(loc1, (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &ti4_1);
				}
				RTHOOK(24);
				loc3 += ((EIF_INTEGER_32) 2L);
			}
			RTHOOK(25);
			loc2 += ((EIF_INTEGER_32) 2L);
		}
	} else {
		RTHOOK(26);
		loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		RTHOOK(27);
		loc3 = (EIF_INTEGER_32) loc2;
		RTHOOK(28);
		loc7 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		for (;;) {
			RTHOOK(29);
			if ((EIF_BOOLEAN) (loc2 > loc4)) break;
			RTHOOK(30);
			if (loc6) {
				RTHOOK(31);
				loc7 = F4124_50215(Current, loc1, loc2, (EIF_CHARACTER_8) '/');
				loc7 = (EIF_BOOLEAN) (EIF_BOOLEAN) !loc7;
				RTHOOK(32);
				loc6 = (EIF_BOOLEAN) (EIF_BOOLEAN) !loc7;
			} else {
				RTHOOK(33);
				loc6 = F4124_50215(Current, loc1, loc2, (EIF_CHARACTER_8) '/');
			}
			RTHOOK(34);
			if (loc7) {
				RTHOOK(35);
				if ((EIF_BOOLEAN)(loc2 != loc3)) {
					RTHOOK(36);
					tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R28871[Dtype(RTCW(loc1))-2846])(loc1, loc2));
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R28653[Dtype(RTCW(loc1))-2846])(loc1, (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &loc3);
				}
				RTHOOK(37);
				loc3++;
			}
			RTHOOK(38);
			loc2++;
		}
	}
	RTHOOK(39);
	if ((EIF_BOOLEAN)(loc2 != loc3)) {
		RTHOOK(40);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_INTEGER_32)) R39266[Dtype(RTCW(loc1))-4015])(loc1, (EIF_INTEGER_32) (loc3 - ((EIF_INTEGER_32) 1L)));
	}
	RTHOOK(41);
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	RTHOOK(42);
	if (loc8) {
		RTHOOK(43);
		loc5 = F4124_50209(Current);
		RTHOOK(44);
		if ((EIF_BOOLEAN)(loc5 == ((EIF_INTEGER_32) 0L))) {
			RTHOOK(45);
			ti4_1 = F4124_50203(Current);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_INTEGER_32)) R39272[Dtype(RTCW(loc1))-4015])(loc1, ti4_1);
		}
	}
	RTHOOK(46);
	tb1 = '\0';
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1) + O39200[Dtype(loc1)-4010]);
	ti4_2 = F4124_50203(Current);
	tc1 = F4124_50185(Current);
	if (F4124_50215(Current, loc1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_2) + ((EIF_INTEGER_32) 1L)), tc1)) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1) + O39200[Dtype(loc1)-4010]);
		tb1 = (EIF_BOOLEAN) (F4124_50209(Current) < ti4_1);
	}
	if (tb1) {
		RTHOOK(47);
		ti4_1 = F4124_50203(Current);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_INTEGER_32)) R39274[Dtype(RTCW(loc1))-4015])(loc1, ti4_1);
	}
	RTHOOK(49);
	RTLE;
	RTEE;
}

/* {PATH}.env */
static EIF_REFERENCE F4124_50208_body (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
#define Result RTOTRR
	RTOUDR(232)

	RTLI(2);
	RTLR(0,tr1);
	RTLR(1,Current);
	RTLIU(2);
	
	RTEAA("env", 4123, Current, 0, 0, 52156);
	RTGC;
	RTOTP;
	RTHOOK(1);
	tr1 = RTLNS(eif_new_type(2029, 0x00).id, 2029, _OBJSIZ_0_0_0_1_0_0_0_0_);
	Result = (EIF_REFERENCE) tr1;
	RTOTE;
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
#undef Result
}

EIF_REFERENCE F4124_50208 (EIF_REFERENCE Current)
{
	GTCX
	return RTOUCR(232,F4124_50208_body,(Current));
}

/* {PATH}.root_end_position */
EIF_INTEGER_32 F4124_50209 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_CHARACTER_8 loc1 = (EIF_CHARACTER_8) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_CHARACTER_8 tc1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTEAA("root_end_position", 4123, Current, 2, 0, 52157);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current);
	tb1 = F2697_32768(RTCW(tr1));
	if ((EIF_BOOLEAN) !tb1) {
		RTHOOK(2);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
			RTHOOK(3);
			tb1 = '\0';
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O39200[Dtype(tr1)-4010]);
			if ((EIF_BOOLEAN)(ti4_1 == F4124_50203(Current))) {
				tb1 = F4124_50215(Current, *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '\\');
			}
			if (tb1) {
				RTHOOK(4);
				RTHOOK(5);
				RTLE;
				RTEE;
				return (EIF_INTEGER_32) F4124_50203(Current);
			} else {
				RTHOOK(6);
				tb1 = '\0';
				tr1 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O39200[Dtype(tr1)-4010]);
				if ((EIF_BOOLEAN) (ti4_1 >= ((EIF_INTEGER_32) 4L))) {
					tb2 = '\0';
					tr1 = *(EIF_REFERENCE *)(Current);
					tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R28871[Dtype(RTCW(tr1))-2846])(tr1, ((EIF_INTEGER_32) 2L)));
					if ((EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\000')) {
						tr1 = *(EIF_REFERENCE *)(Current);
						tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R28871[Dtype(RTCW(tr1))-2846])(tr1, ((EIF_INTEGER_32) 4L)));
						tb2 = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\000');
					}
					tb1 = tb2;
				}
				if (tb1) {
					RTHOOK(7);
					tr1 = *(EIF_REFERENCE *)(Current);
					tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R28871[Dtype(RTCW(tr1))-2846])(tr1, ((EIF_INTEGER_32) 1L)));
					loc1 = eif_builtin_CHARACTER_8_as_lower__c1_c1(tc1);
					RTHOOK(8);
					tb1 = '\0';
					if ((EIF_BOOLEAN) ((EIF_BOOLEAN) (loc1 >= (EIF_CHARACTER_8) 'a') && (EIF_BOOLEAN) (loc1 <= (EIF_CHARACTER_8) 'z'))) {
						tr1 = *(EIF_REFERENCE *)(Current);
						tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R28871[Dtype(RTCW(tr1))-2846])(tr1, ((EIF_INTEGER_32) 3L)));
						tb1 = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) ':');
					}
					if (tb1) {
						RTHOOK(9);
						tb1 = '\0';
						tr1 = *(EIF_REFERENCE *)(Current);
						ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O39200[Dtype(tr1)-4010]);
						if ((EIF_BOOLEAN) (ti4_1 >= (EIF_INTEGER_32) (((EIF_INTEGER_32) 3L) * F4124_50203(Current)))) {
							tb1 = F4124_50215(Current, *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 5L), (EIF_CHARACTER_8) '\\');
						}
						if (tb1) {
							RTHOOK(10);
							RTHOOK(11);
							RTLE;
							RTEE;
							return (EIF_INTEGER_32) ((EIF_INTEGER_32) 6L);
						} else {
							RTHOOK(12);
							RTHOOK(13);
							RTLE;
							RTEE;
							return (EIF_INTEGER_32) ((EIF_INTEGER_32) 4L);
						}
					} else {
						RTHOOK(14);
						tb1 = '\0';
						if ((EIF_BOOLEAN)(loc1 == (EIF_CHARACTER_8) '\\')) {
							tr1 = *(EIF_REFERENCE *)(Current);
							tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R28871[Dtype(RTCW(tr1))-2846])(tr1, ((EIF_INTEGER_32) 3L)));
							tb1 = (EIF_BOOLEAN)(tc1 != (EIF_CHARACTER_8) '\\');
						}
						if (tb1) {
							RTHOOK(15);
							Result = F4124_50203(Current);
						} else {
							RTHOOK(16);
							tb1 = '\0';
							tb2 = '\0';
							tb3 = '\0';
							tr1 = *(EIF_REFERENCE *)(Current);
							ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O39200[Dtype(tr1)-4010]);
							if ((EIF_BOOLEAN) (ti4_1 >= ((EIF_INTEGER_32) 10L))) {
								tb3 = (EIF_BOOLEAN)(loc1 == (EIF_CHARACTER_8) '\\');
							}
							if (tb3) {
								tr1 = *(EIF_REFERENCE *)(Current);
								tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R28871[Dtype(RTCW(tr1))-2846])(tr1, ((EIF_INTEGER_32) 3L)));
								tb2 = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\\');
							}
							if (tb2) {
								tr1 = *(EIF_REFERENCE *)(Current);
								tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R28871[Dtype(RTCW(tr1))-2846])(tr1, ((EIF_INTEGER_32) 5L)));
								tb1 = (EIF_BOOLEAN)(tc1 != (EIF_CHARACTER_8) '\\');
							}
							if (tb1) {
								RTHOOK(17);
								loc2 = F4124_50211(Current, ((EIF_INTEGER_32) 7L));
								RTHOOK(18);
								tb1 = '\0';
								if ((EIF_BOOLEAN) (loc2 > ((EIF_INTEGER_32) 0L))) {
									tr1 = *(EIF_REFERENCE *)(Current);
									ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O39200[Dtype(tr1)-4010]);
									tb1 = (EIF_BOOLEAN) ((EIF_INTEGER_32) (loc2 + F4124_50203(Current)) <= ti4_1);
								}
								if (tb1) {
									RTHOOK(19);
									ti4_1 = F4124_50203(Current);
									ti4_1 = F4124_50211(Current, (EIF_INTEGER_32) (loc2 + ti4_1));
									loc2 = (EIF_INTEGER_32) ti4_1;
									RTHOOK(20);
									if ((EIF_BOOLEAN) (loc2 > ((EIF_INTEGER_32) 0L))) {
										RTHOOK(21);
										RTHOOK(22);
										RTLE;
										RTEE;
										return (EIF_INTEGER_32) (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L));
									} else {
										RTHOOK(23);
										tr1 = *(EIF_REFERENCE *)(Current);
										Result = *(EIF_INTEGER_32 *)(RTCW(tr1) + O39200[Dtype(tr1)-4010]);
									}
								}
							}
						}
					}
				}
			}
		} else {
			RTHOOK(24);
			tr1 = *(EIF_REFERENCE *)(Current);
			tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R28871[Dtype(RTCW(tr1))-2846])(tr1, ((EIF_INTEGER_32) 1L)));
			if ((EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '/')) {
				RTHOOK(25);
				RTHOOK(26);
				RTLE;
				RTEE;
				return (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
		}
	}
	RTHOOK(30);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.end_position_of_last_directory_separator */
EIF_INTEGER_32 F4124_50210 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTEAA("end_position_of_last_directory_separator", 4123, Current, 0, 0, 52158);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current);
	tb1 = F2697_32768(RTCW(tr1));
	if ((EIF_BOOLEAN) !tb1) {
		RTHOOK(2);
		tr1 = *(EIF_REFERENCE *)(Current);
		Result = *(EIF_INTEGER_32 *)(RTCW(tr1) + O39200[Dtype(tr1)-4010]);
		ti4_1 = F4124_50203(Current);
		Result = (EIF_INTEGER_32) (EIF_INTEGER_32) ((EIF_INTEGER_32) (Result - ti4_1) + ((EIF_INTEGER_32) 1L));
		RTHOOK(3);
		if ((EIF_BOOLEAN) (Result >= ((EIF_INTEGER_32) 1L))) {
			for (;;) {
				RTHOOK(4);
				tb1 = '\01';
				if (!(EIF_BOOLEAN) (Result < ((EIF_INTEGER_32) 1L))) {
					tr1 = *(EIF_REFERENCE *)(Current);
					tc1 = F4124_50185(Current);
					tb1 = F4124_50215(Current, tr1, Result, tc1);
				}
				if (tb1) break;
				RTHOOK(5);
				Result -= F4124_50203(Current);
			}
		}
		RTHOOK(6);
		if ((EIF_BOOLEAN) (Result < ((EIF_INTEGER_32) 0L))) {
			RTHOOK(7);
			RTHOOK(8);
			RTLE;
			RTEE;
			return (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
		} else {
			RTHOOK(9);
			ti4_1 = F4124_50203(Current);
			Result = (EIF_INTEGER_32) (EIF_INTEGER_32) ((EIF_INTEGER_32) (Result + ti4_1) - ((EIF_INTEGER_32) 1L));
		}
	}
	RTHOOK(13);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.next_directory_separator */
EIF_INTEGER_32 F4124_50211 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_CHARACTER_8 loc3 = (EIF_CHARACTER_8) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_BOOLEAN tb1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,loc4);
	RTLIU(2);
	
	RTEAA("next_directory_separator", 4123, Current, 4, 1, 52159);
	RTGC;
	RTHOOK(1);
	loc2 = F4124_50203(Current);
	RTHOOK(2);
	loc3 = F4124_50185(Current);
	RTHOOK(3);
	Result = (EIF_INTEGER_32) arg1;
	RTHOOK(4);
	loc4 = *(EIF_REFERENCE *)(Current);
	RTHOOK(5);
	loc1 = *(EIF_INTEGER_32 *)(RTCW(loc4) + O39200[Dtype(loc4)-4010]);
	for (;;) {
		RTHOOK(6);
		tb1 = '\01';
		if (!(EIF_BOOLEAN) ((EIF_BOOLEAN) (Result < ((EIF_INTEGER_32) 1L)) || (EIF_BOOLEAN) (Result > loc1))) {
			tb1 = F4124_50215(Current, loc4, Result, loc3);
		}
		if (tb1) break;
		RTHOOK(7);
		Result += loc2;
	}
	RTHOOK(8);
	if ((EIF_BOOLEAN) (Result > loc1)) {
		RTHOOK(9);
		RTHOOK(10);
		RTLE;
		RTEE;
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
	}
	RTHOOK(14);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.internal_append_into */
void F4124_50212 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_CHARACTER_8 arg3)
{
	GTCX
	RTEX;
	struct eif_ex_448 sloc1;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) sloc1.data;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_CHARACTER_32 tw1;
	EIF_CHARACTER_32 tw2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	RTLD;
	
	memset (&sloc1.overhead, 0, OVERHEAD + _OBJSIZ_0_0_0_0_0_0_0_0_);
	sloc1.overhead.ov_flags = EO_EXP | EO_STACK;
	RT_DFS(&sloc1.overhead, eif_new_type(494, 0x00).id);
	RTLI(4);
	RTLR(0,arg2);
	RTLR(1,arg1);
	RTLR(2,Current);
	RTLR(3,loc1);
	RTLIU(4);
	
	RTEAA("internal_append_into", 4123, Current, 1, 3, 52160);
	RTGC;
	RTHOOK(1);
	tb1 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R39089[Dtype(RTCW(arg2))-4011])(arg2);
	if ((EIF_BOOLEAN) !tb1) {
		RTHOOK(2);
		tb1 = '\0';
		tb2 = '\0';
		tb3 = '\0';
		if ((EIF_BOOLEAN)(arg3 != (EIF_CHARACTER_8) '\000')) {
			tb4 = F2697_32768(RTCW(arg1));
			tb3 = (EIF_BOOLEAN) !tb4;
		}
		if (tb3) {
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1) + O39200[Dtype(arg1)-4010]);
			ti4_2 = F4124_50203(Current);
			tb2 = (EIF_BOOLEAN) !F4124_50215(Current, arg1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_2) + ((EIF_INTEGER_32) 1L)), arg3);
		}
		if (tb2) {
			tw1 = (FUNCTION_CAST(EIF_CHARACTER_32, (EIF_REFERENCE, EIF_INTEGER_32)) R39075[Dtype(RTCW(arg2))-4011])(arg2, ((EIF_INTEGER_32) 1L));
			tw2 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '/';
			tb1 = (EIF_BOOLEAN)(tw1 != tw2);
		}
		if (tb1) {
			RTHOOK(3);
			if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
				RTHOOK(4);
				tw1 = (FUNCTION_CAST(EIF_CHARACTER_32, (EIF_REFERENCE, EIF_INTEGER_32)) R39075[Dtype(RTCW(arg2))-4011])(arg2, ((EIF_INTEGER_32) 1L));
				tw2 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '\\';
				if ((EIF_BOOLEAN)(tw1 != tw2)) {
					RTHOOK(5);
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R39368[Dtype(RTCW(arg1))-4018])(arg1, arg3);
					RTHOOK(6);
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R39368[Dtype(RTCW(arg1))-4018])(arg1, (EIF_CHARACTER_8) '\000');
				}
			} else {
				RTHOOK(7);
				(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R39368[Dtype(RTCW(arg1))-4018])(arg1, arg3);
			}
		}
		RTHOOK(8);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
			RTHOOK(9);
			F495_8487(RTCW(loc1), arg2, arg1);
		} else {
			RTHOOK(10);
			F495_8462(RTCW(loc1), arg2, arg1);
		}
	}
	RTHOOK(11);
	RTLE;
	RTEE;
}

/* {PATH}.internal_path_append_into */
void F4124_50213 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_CHARACTER_8 arg3)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,arg2);
	RTLIU(3);
	
	RTEAA("internal_path_append_into", 4123, Current, 0, 3, 52161);
	RTGC;
	RTHOOK(1);
	tb1 = '\0';
	tb2 = '\0';
	tb3 = '\0';
	if ((EIF_BOOLEAN)(arg3 != (EIF_CHARACTER_8) '\000')) {
		tb4 = F2697_32768(RTCW(arg1));
		tb3 = (EIF_BOOLEAN) !tb4;
	}
	if (tb3) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1) + O39200[Dtype(arg1)-4010]);
		ti4_2 = F4124_50203(Current);
		tb2 = (EIF_BOOLEAN) !F4124_50215(Current, arg1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_2) + ((EIF_INTEGER_32) 1L)), arg3);
	}
	if (tb2) {
		tb1 = (EIF_BOOLEAN) !F4124_50215(Current, arg2, ((EIF_INTEGER_32) 1L), arg3);
	}
	if (tb1) {
		RTHOOK(2);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R39368[Dtype(RTCW(arg1))-4018])(arg1, arg3);
		RTHOOK(3);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
			RTHOOK(4);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R39368[Dtype(RTCW(arg1))-4018])(arg1, (EIF_CHARACTER_8) '\000');
		}
	}
	RTHOOK(5);
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R39364[Dtype(RTCW(arg1))-4018])(arg1, arg2);
	RTHOOK(6);
	RTLE;
	RTEE;
}

/* {PATH}.internal_path_append_substring_into */
void F4124_50214 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_CHARACTER_8 arg5)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,arg2);
	RTLIU(3);
	
	RTEAA("internal_path_append_substring_into", 4123, Current, 0, 5, 52162);
	RTGC;
	RTHOOK(1);
	tb1 = '\0';
	tb2 = '\0';
	tb3 = '\0';
	if ((EIF_BOOLEAN)(arg5 != (EIF_CHARACTER_8) '\000')) {
		tb4 = F2697_32768(RTCW(arg1));
		tb3 = (EIF_BOOLEAN) !tb4;
	}
	if (tb3) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1) + O39200[Dtype(arg1)-4010]);
		ti4_2 = F4124_50203(Current);
		tb2 = (EIF_BOOLEAN) !F4124_50215(Current, arg1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_2) + ((EIF_INTEGER_32) 1L)), arg5);
	}
	if (tb2) {
		tb1 = (EIF_BOOLEAN) !F4124_50215(Current, arg2, arg3, arg5);
	}
	if (tb1) {
		RTHOOK(2);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R39368[Dtype(RTCW(arg1))-4018])(arg1, arg5);
		RTHOOK(3);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
			RTHOOK(4);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R39368[Dtype(RTCW(arg1))-4018])(arg1, (EIF_CHARACTER_8) '\000');
		}
	}
	RTHOOK(5);
	F4019_48087(RTCW(arg1), arg2, arg3, arg4);
	RTHOOK(6);
	RTLE;
	RTEE;
}

/* {PATH}.is_character */
EIF_BOOLEAN F4124_50215 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_INTEGER_32 arg2, EIF_CHARACTER_8 arg3)
{
	GTCX
	RTEX;
	EIF_CHARACTER_8 tc1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLIU(2);
	
	RTEAA("is_character", 4123, Current, 0, 3, 52163);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
		RTHOOK(2);
		Result = '\0';
		tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R28871[Dtype(RTCW(arg1))-2846])(arg1, arg2));
		if ((EIF_BOOLEAN)(tc1 == arg3)) {
			tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R28871[Dtype(RTCW(arg1))-2846])(arg1, (EIF_INTEGER_32) (arg2 + ((EIF_INTEGER_32) 1L))));
			Result = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\000');
		}
	} else {
		RTHOOK(3);
		tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R28871[Dtype(RTCW(arg1))-2846])(arg1, arg2));
		Result = (EIF_BOOLEAN) (EIF_BOOLEAN)(tc1 == arg3);
	}
	RTHOOK(5);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.c_same_files */
EIF_BOOLEAN F4124_50218 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2)
{
	GTCX
	RTEX;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("c_same_files", 4123, Current, 0, 2, 52166);
	Result = EIF_TEST(inline_F4124_50218 ((EIF_POINTER) arg1, (EIF_POINTER) arg2));
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

void EIF_Minit3013 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
