note
	description: "[
		Windows error messages in human-readable form.
		
		Note: Automatically generated from WinError.h.
	]"
	legal: "See notice at end of class."
	status: "See notice at end of class."

class
	WEL_WINDOWS_ERROR_MESSAGES

feature -- Access

	error_message (i: INTEGER): STRING_32
		local
			l_error: WEL_ERROR
		do
			create l_error
			Result := l_error.text_for_error_code (i)
		ensure
			error_message_not_void: Result /= Void
		end

	error_messages: HASH_TABLE [STRING, INTEGER]
			-- Error messages.
		obsolete
			"Use `error_message' instead [2017-05-31]."
		local
			i: INTEGER
			l_msg: STRING_32
		once
			create Result.make (max_error_code)
			from
				i := 0
			until
				i > max_error_code
			loop
				l_msg := error_message (i)
				if not l_msg.is_empty then
					Result.put (l_msg.as_string_8, i)
				end
				i := i + 1
			end
		end

	Error_success_value: INTEGER = 0
	Error_invalid_function_value: INTEGER = 1
	Error_file_not_found_value: INTEGER = 2
	Error_path_not_found_value: INTEGER = 3
	Error_too_many_open_files_value: INTEGER = 4
	Error_access_denied_value: INTEGER = 5
	Error_invalid_handle_value: INTEGER = 6
	Error_arena_trashed_value: INTEGER = 7
	Error_not_enough_memory_value: INTEGER = 8
	Error_invalid_block_value: INTEGER = 9
	Error_bad_environment_value: INTEGER = 10
	Error_bad_format_value: INTEGER = 11
	Error_invalid_access_value: INTEGER = 12
	Error_invalid_data_value: INTEGER = 13
	Error_outofmemory_value: INTEGER = 14
	Error_invalid_drive_value: INTEGER = 15
	Error_current_directory_value: INTEGER = 16
	Error_not_same_device_value: INTEGER = 17
	Error_no_more_files_value: INTEGER = 18
	Error_write_protect_value: INTEGER = 19
	Error_bad_unit_value: INTEGER = 20
	Error_not_ready_value: INTEGER = 21
	Error_bad_command_value: INTEGER = 22
	Error_crc_value: INTEGER = 23
	Error_bad_length_value: INTEGER = 24
	Error_seek_value: INTEGER = 25
	Error_not_dos_disk_value: INTEGER = 26
	Error_sector_not_found_value: INTEGER = 27
	Error_out_of_paper_value: INTEGER = 28
	Error_write_fault_value: INTEGER = 29
	Error_read_fault_value: INTEGER = 30
	Error_gen_failure_value: INTEGER = 31
	Error_sharing_violation_value: INTEGER = 32
	Error_lock_violation_value: INTEGER = 33
	Error_wrong_disk_value: INTEGER = 34
	Error_sharing_buffer_exceeded_value: INTEGER = 36
	Error_handle_eof_value: INTEGER = 38
	Error_handle_disk_full_value: INTEGER = 39
	Error_not_supported_value: INTEGER = 50
	Error_rem_not_list_value: INTEGER = 51
	Error_dup_name_value: INTEGER = 52
	Error_bad_netpath_value: INTEGER = 53
	Error_network_busy_value: INTEGER = 54
	Error_dev_not_exist_value: INTEGER = 55
	Error_too_many_cmds_value: INTEGER = 56
	Error_adap_hdw_err_value: INTEGER = 57
	Error_bad_net_resp_value: INTEGER = 58
	Error_unexp_net_err_value: INTEGER = 59
	Error_bad_rem_adap_value: INTEGER = 60
	Error_printq_full_value: INTEGER = 61
	Error_no_spool_space_value: INTEGER = 62
	Error_print_cancelled_value: INTEGER = 63
	Error_netname_deleted_value: INTEGER = 64
	Error_network_access_denied_value: INTEGER = 65
	Error_bad_dev_type_value: INTEGER = 66
	Error_bad_net_name_value: INTEGER = 67
	Error_too_many_names_value: INTEGER = 68
	Error_too_many_sess_value: INTEGER = 69
	Error_sharing_paused_value: INTEGER = 70
	Error_req_not_accep_value: INTEGER = 71
	Error_redir_paused_value: INTEGER = 72
	Error_file_exists_value: INTEGER = 80
	Error_cannot_make_value: INTEGER = 82
	Error_fail_i24_value: INTEGER = 83
	Error_out_of_structures_value: INTEGER = 84
	Error_already_assigned_value: INTEGER = 85
	Error_invalid_password_value: INTEGER = 86
	Error_invalid_parameter_value: INTEGER = 87
	Error_net_write_fault_value: INTEGER = 88
	Error_no_proc_slots_value: INTEGER = 89
	Error_too_many_semaphores_value: INTEGER = 100
	Error_excl_sem_already_owned_value: INTEGER = 101
	Error_sem_is_set_value: INTEGER = 102
	Error_too_many_sem_requests_value: INTEGER = 103
	Error_invalid_at_interrupt_time_value: INTEGER = 104
	Error_sem_owner_died_value: INTEGER = 105
	Error_sem_user_limit_value: INTEGER = 106
	Error_disk_change_value: INTEGER = 107
	Error_drive_locked_value: INTEGER = 108
	Error_broken_pipe_value: INTEGER = 109
	Error_open_failed_value: INTEGER = 110
	Error_buffer_overflow_value: INTEGER = 111
	Error_disk_full_value: INTEGER = 112
	Error_no_more_search_handles_value: INTEGER = 113
	Error_invalid_target_handle_value: INTEGER = 114
	Error_invalid_category_value: INTEGER = 117
	Error_invalid_verify_switch_value: INTEGER = 118
	Error_bad_driver_level_value: INTEGER = 119
	Error_call_not_implemented_value: INTEGER = 120
	Error_sem_timeout_value: INTEGER = 121
	Error_insufficient_buffer_value: INTEGER = 122
	Error_invalid_name_value: INTEGER = 123
	Error_invalid_level_value: INTEGER = 124
	Error_no_volume_label_value: INTEGER = 125
	Error_mod_not_found_value: INTEGER = 126
	Error_proc_not_found_value: INTEGER = 127
	Error_wait_no_children_value: INTEGER = 128
	Error_child_not_complete_value: INTEGER = 129
	Error_direct_access_handle_value: INTEGER = 130
	Error_negative_seek_value: INTEGER = 131
	Error_seek_on_device_value: INTEGER = 132
	Error_is_join_target_value: INTEGER = 133
	Error_is_joined_value: INTEGER = 134
	Error_is_substed_value: INTEGER = 135
	Error_not_joined_value: INTEGER = 136
	Error_not_substed_value: INTEGER = 137
	Error_join_to_join_value: INTEGER = 138
	Error_subst_to_subst_value: INTEGER = 139
	Error_join_to_subst_value: INTEGER = 140
	Error_subst_to_join_value: INTEGER = 141
	Error_busy_drive_value: INTEGER = 142
	Error_same_drive_value: INTEGER = 143
	Error_dir_not_root_value: INTEGER = 144
	Error_dir_not_empty_value: INTEGER = 145
	Error_is_subst_path_value: INTEGER = 146
	Error_is_join_path_value: INTEGER = 147
	Error_path_busy_value: INTEGER = 148
	Error_is_subst_target_value: INTEGER = 149
	Error_system_trace_value: INTEGER = 150
	Error_invalid_event_count_value: INTEGER = 151
	Error_too_many_muxwaiters_value: INTEGER = 152
	Error_invalid_list_format_value: INTEGER = 153
	Error_label_too_long_value: INTEGER = 154
	Error_too_many_tcbs_value: INTEGER = 155
	Error_signal_refused_value: INTEGER = 156
	Error_discarded_value: INTEGER = 157
	Error_not_locked_value: INTEGER = 158
	Error_bad_threadid_addr_value: INTEGER = 159
	Error_bad_arguments_value: INTEGER = 160
	Error_bad_pathname_value: INTEGER = 161
	Error_signal_pending_value: INTEGER = 162
	Error_max_thrds_reached_value: INTEGER = 164
	Error_lock_failed_value: INTEGER = 167
	Error_busy_value: INTEGER = 170
	Error_cancel_violation_value: INTEGER = 173
	Error_atomic_locks_not_supported_value: INTEGER = 174
	Error_invalid_segment_number_value: INTEGER = 180
	Error_invalid_ordinal_value: INTEGER = 182
	Error_already_exists_value: INTEGER = 183
	Error_invalid_flag_number_value: INTEGER = 186
	Error_sem_not_found_value: INTEGER = 187
	Error_invalid_starting_codeseg_value: INTEGER = 188
	Error_invalid_stackseg_value: INTEGER = 189
	Error_invalid_moduletype_value: INTEGER = 190
	Error_invalid_exe_signature_value: INTEGER = 191
	Error_exe_marked_invalid_value: INTEGER = 192
	Error_bad_exe_format_value: INTEGER = 193
	Error_iterated_data_exceeds_64k_value: INTEGER = 194
	Error_invalid_minallocsize_value: INTEGER = 195
	Error_dynlink_from_invalid_ring_value: INTEGER = 196
	Error_iopl_not_enabled_value: INTEGER = 197
	Error_invalid_segdpl_value: INTEGER = 198
	Error_autodataseg_exceeds_64k_value: INTEGER = 199
	Error_ring2seg_must_be_movable_value: INTEGER = 200
	Error_reloc_chain_xeeds_seglim_value: INTEGER = 201
	Error_infloop_in_reloc_chain_value: INTEGER = 202
	Error_envvar_not_found_value: INTEGER = 203
	Error_no_signal_sent_value: INTEGER = 205
	Error_filename_exced_range_value: INTEGER = 206
	Error_ring2_stack_in_use_value: INTEGER = 207
	Error_meta_expansion_too_long_value: INTEGER = 208
	Error_invalid_signal_number_value: INTEGER = 209
	Error_thread_1_inactive_value: INTEGER = 210
	Error_locked_value: INTEGER = 212
	Error_too_many_modules_value: INTEGER = 214
	Error_nesting_not_allowed_value: INTEGER = 215
	Error_exe_machine_type_mismatch_value: INTEGER = 216
	Error_bad_pipe_value: INTEGER = 230
	Error_pipe_busy_value: INTEGER = 231
	Error_no_data_value: INTEGER = 232
	Error_pipe_not_connected_value: INTEGER = 233
	Error_more_data_value: INTEGER = 234
	Error_vc_disconnected_value: INTEGER = 240
	Error_invalid_ea_name_value: INTEGER = 254
	Error_ea_list_inconsistent_value: INTEGER = 255
	Wait_timeout_value: INTEGER = 258
	Error_no_more_items_value: INTEGER = 259
	Error_cannot_copy_value: INTEGER = 266
	Error_directory_value: INTEGER = 267
	Error_eas_didnt_fit_value: INTEGER = 275
	Error_ea_file_corrupt_value: INTEGER = 276
	Error_ea_table_full_value: INTEGER = 277
	Error_invalid_ea_handle_value: INTEGER = 278
	Error_eas_not_supported_value: INTEGER = 282
	Error_not_owner_value: INTEGER = 288
	Error_too_many_posts_value: INTEGER = 298
	Error_partial_copy_value: INTEGER = 299
	Error_oplock_not_granted_value: INTEGER = 300
	Error_invalid_oplock_protocol_value: INTEGER = 301
	Error_mr_mid_not_found_value: INTEGER = 317
	Error_invalid_address_value: INTEGER = 487
	Error_arithmetic_overflow_value: INTEGER = 534
	Error_pipe_connected_value: INTEGER = 535
	Error_pipe_listening_value: INTEGER = 536
	Error_ea_access_denied_value: INTEGER = 994
	Error_operation_aborted_value: INTEGER = 995
	Error_io_incomplete_value: INTEGER = 996
	Error_io_pending_value: INTEGER = 997
	Error_noaccess_value: INTEGER = 998
	Error_swaperror_value: INTEGER = 999
	Error_stack_overflow_value: INTEGER = 1001
	Error_invalid_message_value: INTEGER = 1002
	Error_can_not_complete_value: INTEGER = 1003
	Error_invalid_flags_value: INTEGER = 1004
	Error_unrecognized_volume_value: INTEGER = 1005
	Error_file_invalid_value: INTEGER = 1006
	Error_fullscreen_mode_value: INTEGER = 1007
	Error_no_token_value: INTEGER = 1008
	Error_baddb_value: INTEGER = 1009
	Error_badkey_value: INTEGER = 1010
	Error_cantopen_value: INTEGER = 1011
	Error_cantread_value: INTEGER = 1012
	Error_cantwrite_value: INTEGER = 1013
	Error_registry_recovered_value: INTEGER = 1014
	Error_registry_corrupt_value: INTEGER = 1015
	Error_registry_io_failed_value: INTEGER = 1016
	Error_not_registry_file_value: INTEGER = 1017
	Error_key_deleted_value: INTEGER = 1018
	Error_no_log_space_value: INTEGER = 1019
	Error_key_has_children_value: INTEGER = 1020
	Error_child_must_be_volatile_value: INTEGER = 1021
	Error_notify_enum_dir_value: INTEGER = 1022
	Error_dependent_services_running_value: INTEGER = 1051
	Error_invalid_service_control_value: INTEGER = 1052
	Error_service_request_timeout_value: INTEGER = 1053
	Error_service_no_thread_value: INTEGER = 1054
	Error_service_database_locked_value: INTEGER = 1055
	Error_service_already_running_value: INTEGER = 1056
	Error_invalid_service_account_value: INTEGER = 1057
	Error_service_disabled_value: INTEGER = 1058
	Error_circular_dependency_value: INTEGER = 1059
	Error_service_does_not_exist_value: INTEGER = 1060
	Error_service_cannot_accept_ctrl_value: INTEGER = 1061
	Error_service_not_active_value: INTEGER = 1062
	Error_failed_service_controller_connect_value: INTEGER = 1063
	Error_exception_in_service_value: INTEGER = 1064
	Error_database_does_not_exist_value: INTEGER = 1065
	Error_service_specific_error_value: INTEGER = 1066
	Error_process_aborted_value: INTEGER = 1067
	Error_service_dependency_fail_value: INTEGER = 1068
	Error_service_logon_failed_value: INTEGER = 1069
	Error_service_start_hang_value: INTEGER = 1070
	Error_invalid_service_lock_value: INTEGER = 1071
	Error_service_marked_for_delete_value: INTEGER = 1072
	Error_service_exists_value: INTEGER = 1073
	Error_already_running_lkg_value: INTEGER = 1074
	Error_service_dependency_deleted_value: INTEGER = 1075
	Error_boot_already_accepted_value: INTEGER = 1076
	Error_service_never_started_value: INTEGER = 1077
	Error_duplicate_service_name_value: INTEGER = 1078
	Error_different_service_account_value: INTEGER = 1079
	Error_cannot_detect_driver_failure_value: INTEGER = 1080
	Error_cannot_detect_process_abort_value: INTEGER = 1081
	Error_no_recovery_program_value: INTEGER = 1082
	Error_service_not_in_exe_value: INTEGER = 1083
	Error_end_of_media_value: INTEGER = 1100
	Error_filemark_detected_value: INTEGER = 1101
	Error_beginning_of_media_value: INTEGER = 1102
	Error_setmark_detected_value: INTEGER = 1103
	Error_no_data_detected_value: INTEGER = 1104
	Error_partition_failure_value: INTEGER = 1105
	Error_invalid_block_length_value: INTEGER = 1106
	Error_device_not_partitioned_value: INTEGER = 1107
	Error_unable_to_lock_media_value: INTEGER = 1108
	Error_unable_to_unload_media_value: INTEGER = 1109
	Error_media_changed_value: INTEGER = 1110
	Error_bus_reset_value: INTEGER = 1111
	Error_no_media_in_drive_value: INTEGER = 1112
	Error_no_unicode_translation_value: INTEGER = 1113
	Error_dll_init_failed_value: INTEGER = 1114
	Error_shutdown_in_progress_value: INTEGER = 1115
	Error_no_shutdown_in_progress_value: INTEGER = 1116
	Error_io_device_value: INTEGER = 1117
	Error_serial_no_device_value: INTEGER = 1118
	Error_irq_busy_value: INTEGER = 1119
	Error_more_writes_value: INTEGER = 1120
	Error_counter_timeout_value: INTEGER = 1121
	Error_floppy_id_mark_not_found_value: INTEGER = 1122
	Error_floppy_wrong_cylinder_value: INTEGER = 1123
	Error_floppy_unknown_error_value: INTEGER = 1124
	Error_floppy_bad_registers_value: INTEGER = 1125
	Error_disk_recalibrate_failed_value: INTEGER = 1126
	Error_disk_operation_failed_value: INTEGER = 1127
	Error_disk_reset_failed_value: INTEGER = 1128
	Error_eom_overflow_value: INTEGER = 1129
	Error_not_enough_server_memory_value: INTEGER = 1130
	Error_possible_deadlock_value: INTEGER = 1131
	Error_mapped_alignment_value: INTEGER = 1132
	Error_set_power_state_vetoed_value: INTEGER = 1140
	Error_set_power_state_failed_value: INTEGER = 1141
	Error_too_many_links_value: INTEGER = 1142
	Error_old_win_version_value: INTEGER = 1150
	Error_app_wrong_os_value: INTEGER = 1151
	Error_single_instance_app_value: INTEGER = 1152
	Error_rmode_app_value: INTEGER = 1153
	Error_invalid_dll_value: INTEGER = 1154
	Error_no_association_value: INTEGER = 1155
	Error_dde_fail_value: INTEGER = 1156
	Error_dll_not_found_value: INTEGER = 1157
	Error_no_more_user_handles_value: INTEGER = 1158
	Error_message_sync_only_value: INTEGER = 1159
	Error_source_element_empty_value: INTEGER = 1160
	Error_destination_element_full_value: INTEGER = 1161
	Error_illegal_element_address_value: INTEGER = 1162
	Error_magazine_not_present_value: INTEGER = 1163
	Error_device_reinitialization_needed_value: INTEGER = 1164
	Error_device_requires_cleaning_value: INTEGER = 1165
	Error_device_door_open_value: INTEGER = 1166
	Error_device_not_connected_value: INTEGER = 1167
	Error_not_found_value: INTEGER = 1168
	Error_no_match_value: INTEGER = 1169
	Error_set_not_found_value: INTEGER = 1170
	Error_point_not_found_value: INTEGER = 1171
	Error_no_tracking_service_value: INTEGER = 1172
	Error_no_volume_id_value: INTEGER = 1173
	Error_unable_to_remove_replaced_value: INTEGER = 1175
	Error_unable_to_move_replacement_value: INTEGER = 1176
	Error_unable_to_move_replacement_2_value: INTEGER = 1177
	Error_journal_delete_in_progress_value: INTEGER = 1178
	Error_journal_not_active_value: INTEGER = 1179
	Error_potential_file_found_value: INTEGER = 1180
	Error_journal_entry_deleted_value: INTEGER = 1181
	Error_bad_device_value: INTEGER = 1200
	Error_connection_unavail_value: INTEGER = 1201
	Error_device_already_remembered_value: INTEGER = 1202
	Error_no_net_or_bad_path_value: INTEGER = 1203
	Error_bad_provider_value: INTEGER = 1204
	Error_cannot_open_profile_value: INTEGER = 1205
	Error_bad_profile_value: INTEGER = 1206
	Error_not_container_value: INTEGER = 1207
	Error_extended_error_value: INTEGER = 1208
	Error_invalid_groupname_value: INTEGER = 1209
	Error_invalid_computername_value: INTEGER = 1210
	Error_invalid_eventname_value: INTEGER = 1211
	Error_invalid_domainname_value: INTEGER = 1212
	Error_invalid_servicename_value: INTEGER = 1213
	Error_invalid_netname_value: INTEGER = 1214
	Error_invalid_sharename_value: INTEGER = 1215
	Error_invalid_passwordname_value: INTEGER = 1216
	Error_invalid_messagename_value: INTEGER = 1217
	Error_invalid_messagedest_value: INTEGER = 1218
	Error_session_credential_conflict_value: INTEGER = 1219
	Error_remote_session_limit_exceeded_value: INTEGER = 1220
	Error_dup_domainname_value: INTEGER = 1221
	Error_no_network_value: INTEGER = 1222
	Error_cancelled_value: INTEGER = 1223
	Error_user_mapped_file_value: INTEGER = 1224
	Error_connection_refused_value: INTEGER = 1225
	Error_graceful_disconnect_value: INTEGER = 1226
	Error_address_already_associated_value: INTEGER = 1227
	Error_address_not_associated_value: INTEGER = 1228
	Error_connection_invalid_value: INTEGER = 1229
	Error_connection_active_value: INTEGER = 1230
	Error_network_unreachable_value: INTEGER = 1231
	Error_host_unreachable_value: INTEGER = 1232
	Error_protocol_unreachable_value: INTEGER = 1233
	Error_port_unreachable_value: INTEGER = 1234
	Error_request_aborted_value: INTEGER = 1235
	Error_connection_aborted_value: INTEGER = 1236
	Error_retry_value: INTEGER = 1237
	Error_connection_count_limit_value: INTEGER = 1238
	Error_login_time_restriction_value: INTEGER = 1239
	Error_login_wksta_restriction_value: INTEGER = 1240
	Error_incorrect_address_value: INTEGER = 1241
	Error_already_registered_value: INTEGER = 1242
	Error_service_not_found_value: INTEGER = 1243
	Error_not_authenticated_value: INTEGER = 1244
	Error_not_logged_on_value: INTEGER = 1245
	Error_continue_value: INTEGER = 1246
	Error_already_initialized_value: INTEGER = 1247
	Error_no_more_devices_value: INTEGER = 1248
	Error_no_such_site_value: INTEGER = 1249
	Error_domain_controller_exists_value: INTEGER = 1250
	Error_only_if_connected_value: INTEGER = 1251
	Error_override_nochanges_value: INTEGER = 1252
	Error_bad_user_profile_value: INTEGER = 1253
	Error_not_supported_on_sbs_value: INTEGER = 1254
	Error_not_all_assigned_value: INTEGER = 1300
	Error_some_not_mapped_value: INTEGER = 1301
	Error_no_quotas_for_account_value: INTEGER = 1302
	Error_local_user_session_key_value: INTEGER = 1303
	Error_null_lm_password_value: INTEGER = 1304
	Error_unknown_revision_value: INTEGER = 1305
	Error_revision_mismatch_value: INTEGER = 1306
	Error_invalid_owner_value: INTEGER = 1307
	Error_invalid_primary_group_value: INTEGER = 1308
	Error_no_impersonation_token_value: INTEGER = 1309
	Error_cant_disable_mandatory_value: INTEGER = 1310
	Error_no_logon_servers_value: INTEGER = 1311
	Error_no_such_logon_session_value: INTEGER = 1312
	Error_no_such_privilege_value: INTEGER = 1313
	Error_privilege_not_held_value: INTEGER = 1314
	Error_invalid_account_name_value: INTEGER = 1315
	Error_user_exists_value: INTEGER = 1316
	Error_no_such_user_value: INTEGER = 1317
	Error_group_exists_value: INTEGER = 1318
	Error_no_such_group_value: INTEGER = 1319
	Error_member_in_group_value: INTEGER = 1320
	Error_member_not_in_group_value: INTEGER = 1321
	Error_last_admin_value: INTEGER = 1322
	Error_wrong_password_value: INTEGER = 1323
	Error_ill_formed_password_value: INTEGER = 1324
	Error_password_restriction_value: INTEGER = 1325
	Error_logon_failure_value: INTEGER = 1326
	Error_account_restriction_value: INTEGER = 1327
	Error_invalid_logon_hours_value: INTEGER = 1328
	Error_invalid_workstation_value: INTEGER = 1329
	Error_password_expired_value: INTEGER = 1330
	Error_account_disabled_value: INTEGER = 1331
	Error_none_mapped_value: INTEGER = 1332
	Error_too_many_luids_requested_value: INTEGER = 1333
	Error_luids_exhausted_value: INTEGER = 1334
	Error_invalid_sub_authority_value: INTEGER = 1335
	Error_invalid_acl_value: INTEGER = 1336
	Error_invalid_sid_value: INTEGER = 1337
	Error_invalid_security_descr_value: INTEGER = 1338
	Error_bad_inheritance_acl_value: INTEGER = 1340
	Error_server_disabled_value: INTEGER = 1341
	Error_server_not_disabled_value: INTEGER = 1342
	Error_invalid_id_authority_value: INTEGER = 1343
	Error_allotted_space_exceeded_value: INTEGER = 1344
	Error_invalid_group_attributes_value: INTEGER = 1345
	Error_bad_impersonation_level_value: INTEGER = 1346
	Error_cant_open_anonymous_value: INTEGER = 1347
	Error_bad_validation_class_value: INTEGER = 1348
	Error_bad_token_type_value: INTEGER = 1349
	Error_no_security_on_object_value: INTEGER = 1350
	Error_cant_access_domain_info_value: INTEGER = 1351
	Error_invalid_server_state_value: INTEGER = 1352
	Error_invalid_domain_state_value: INTEGER = 1353
	Error_invalid_domain_role_value: INTEGER = 1354
	Error_no_such_domain_value: INTEGER = 1355
	Error_domain_exists_value: INTEGER = 1356
	Error_domain_limit_exceeded_value: INTEGER = 1357
	Error_internal_db_corruption_value: INTEGER = 1358
	Error_internal_error_value: INTEGER = 1359
	Error_generic_not_mapped_value: INTEGER = 1360
	Error_bad_descriptor_format_value: INTEGER = 1361
	Error_not_logon_process_value: INTEGER = 1362
	Error_logon_session_exists_value: INTEGER = 1363
	Error_no_such_package_value: INTEGER = 1364
	Error_bad_logon_session_state_value: INTEGER = 1365
	Error_logon_session_collision_value: INTEGER = 1366
	Error_invalid_logon_type_value: INTEGER = 1367
	Error_cannot_impersonate_value: INTEGER = 1368
	Error_rxact_invalid_state_value: INTEGER = 1369
	Error_rxact_commit_failure_value: INTEGER = 1370
	Error_special_account_value: INTEGER = 1371
	Error_special_group_value: INTEGER = 1372
	Error_special_user_value: INTEGER = 1373
	Error_members_primary_group_value: INTEGER = 1374
	Error_token_already_in_use_value: INTEGER = 1375
	Error_no_such_alias_value: INTEGER = 1376
	Error_member_not_in_alias_value: INTEGER = 1377
	Error_member_in_alias_value: INTEGER = 1378
	Error_alias_exists_value: INTEGER = 1379
	Error_logon_not_granted_value: INTEGER = 1380
	Error_too_many_secrets_value: INTEGER = 1381
	Error_secret_too_long_value: INTEGER = 1382
	Error_internal_db_error_value: INTEGER = 1383
	Error_too_many_context_ids_value: INTEGER = 1384
	Error_logon_type_not_granted_value: INTEGER = 1385
	Error_nt_cross_encryption_required_value: INTEGER = 1386
	Error_no_such_member_value: INTEGER = 1387
	Error_invalid_member_value: INTEGER = 1388
	Error_too_many_sids_value: INTEGER = 1389
	Error_lm_cross_encryption_required_value: INTEGER = 1390
	Error_no_inheritance_value: INTEGER = 1391
	Error_file_corrupt_value: INTEGER = 1392
	Error_disk_corrupt_value: INTEGER = 1393
	Error_no_user_session_key_value: INTEGER = 1394
	Error_license_quota_exceeded_value: INTEGER = 1395
	Error_wrong_target_name_value: INTEGER = 1396
	Error_mutual_auth_failed_value: INTEGER = 1397
	Error_time_skew_value: INTEGER = 1398
	Error_invalid_window_handle_value: INTEGER = 1400
	Error_invalid_menu_handle_value: INTEGER = 1401
	Error_invalid_cursor_handle_value: INTEGER = 1402
	Error_invalid_accel_handle_value: INTEGER = 1403
	Error_invalid_hook_handle_value: INTEGER = 1404
	Error_invalid_dwp_handle_value: INTEGER = 1405
	Error_tlw_with_wschild_value: INTEGER = 1406
	Error_cannot_find_wnd_class_value: INTEGER = 1407
	Error_window_of_other_thread_value: INTEGER = 1408
	Error_hotkey_already_registered_value: INTEGER = 1409
	Error_class_already_exists_value: INTEGER = 1410
	Error_class_does_not_exist_value: INTEGER = 1411
	Error_class_has_windows_value: INTEGER = 1412
	Error_invalid_index_value: INTEGER = 1413
	Error_invalid_icon_handle_value: INTEGER = 1414
	Error_private_dialog_index_value: INTEGER = 1415
	Error_listbox_id_not_found_value: INTEGER = 1416
	Error_no_wildcard_characters_value: INTEGER = 1417
	Error_clipboard_not_open_value: INTEGER = 1418
	Error_hotkey_not_registered_value: INTEGER = 1419
	Error_window_not_dialog_value: INTEGER = 1420
	Error_control_id_not_found_value: INTEGER = 1421
	Error_invalid_combobox_message_value: INTEGER = 1422
	Error_window_not_combobox_value: INTEGER = 1423
	Error_invalid_edit_height_value: INTEGER = 1424
	Error_dc_not_found_value: INTEGER = 1425
	Error_invalid_hook_filter_value: INTEGER = 1426
	Error_invalid_filter_proc_value: INTEGER = 1427
	Error_hook_needs_hmod_value: INTEGER = 1428
	Error_global_only_hook_value: INTEGER = 1429
	Error_journal_hook_set_value: INTEGER = 1430
	Error_hook_not_installed_value: INTEGER = 1431
	Error_invalid_lb_message_value: INTEGER = 1432
	Error_setcount_on_bad_lb_value: INTEGER = 1433
	Error_lb_without_tabstops_value: INTEGER = 1434
	Error_destroy_object_of_other_thread_value: INTEGER = 1435
	Error_child_window_menu_value: INTEGER = 1436
	Error_no_system_menu_value: INTEGER = 1437
	Error_invalid_msgbox_style_value: INTEGER = 1438
	Error_invalid_spi_value_value: INTEGER = 1439
	Error_screen_already_locked_value: INTEGER = 1440
	Error_hwnds_have_diff_parent_value: INTEGER = 1441
	Error_not_child_window_value: INTEGER = 1442
	Error_invalid_gw_command_value: INTEGER = 1443
	Error_invalid_thread_id_value: INTEGER = 1444
	Error_non_mdichild_window_value: INTEGER = 1445
	Error_popup_already_active_value: INTEGER = 1446
	Error_no_scrollbars_value: INTEGER = 1447
	Error_invalid_scrollbar_range_value: INTEGER = 1448
	Error_invalid_showwin_command_value: INTEGER = 1449
	Error_no_system_resources_value: INTEGER = 1450
	Error_nonpaged_system_resources_value: INTEGER = 1451
	Error_paged_system_resources_value: INTEGER = 1452
	Error_working_set_quota_value: INTEGER = 1453
	Error_pagefile_quota_value: INTEGER = 1454
	Error_commitment_limit_value: INTEGER = 1455
	Error_menu_item_not_found_value: INTEGER = 1456
	Error_invalid_keyboard_handle_value: INTEGER = 1457
	Error_hook_type_not_allowed_value: INTEGER = 1458
	Error_requires_interactive_windowstation_value: INTEGER = 1459
	Error_timeout_value: INTEGER = 1460
	Error_invalid_monitor_handle_value: INTEGER = 1461
	Error_eventlog_file_corrupt_value: INTEGER = 1500
	Error_eventlog_cant_start_value: INTEGER = 1501
	Error_log_file_full_value: INTEGER = 1502
	Error_eventlog_file_changed_value: INTEGER = 1503
	Error_install_service_failure_value: INTEGER = 1601
	Error_install_userexit_value: INTEGER = 1602
	Error_install_failure_value: INTEGER = 1603
	Error_install_suspend_value: INTEGER = 1604
	Error_unknown_product_value: INTEGER = 1605
	Error_unknown_feature_value: INTEGER = 1606
	Error_unknown_component_value: INTEGER = 1607
	Error_unknown_property_value: INTEGER = 1608
	Error_invalid_handle_state_value: INTEGER = 1609
	Error_bad_configuration_value: INTEGER = 1610
	Error_index_absent_value: INTEGER = 1611
	Error_install_source_absent_value: INTEGER = 1612
	Error_install_package_version_value: INTEGER = 1613
	Error_product_uninstalled_value: INTEGER = 1614
	Error_bad_query_syntax_value: INTEGER = 1615
	Error_invalid_field_value: INTEGER = 1616
	Error_device_removed_value: INTEGER = 1617
	Error_install_already_running_value: INTEGER = 1618
	Error_install_package_open_failed_value: INTEGER = 1619
	Error_install_package_invalid_value: INTEGER = 1620
	Error_install_ui_failure_value: INTEGER = 1621
	Error_install_log_failure_value: INTEGER = 1622
	Error_install_language_unsupported_value: INTEGER = 1623
	Error_install_transform_failure_value: INTEGER = 1624
	Error_install_package_rejected_value: INTEGER = 1625
	Error_function_not_called_value: INTEGER = 1626
	Error_function_failed_value: INTEGER = 1627
	Error_invalid_table_value: INTEGER = 1628
	Error_datatype_mismatch_value: INTEGER = 1629
	Error_unsupported_type_value: INTEGER = 1630
	Error_create_failed_value: INTEGER = 1631
	Error_install_temp_unwritable_value: INTEGER = 1632
	Error_install_platform_unsupported_value: INTEGER = 1633
	Error_install_notused_value: INTEGER = 1634
	Error_patch_package_open_failed_value: INTEGER = 1635
	Error_patch_package_invalid_value: INTEGER = 1636
	Error_patch_package_unsupported_value: INTEGER = 1637
	Error_product_version_value: INTEGER = 1638
	Error_invalid_command_line_value: INTEGER = 1639
	Error_install_remote_disallowed_value: INTEGER = 1640
	Error_success_reboot_initiated_value: INTEGER = 1641
	Error_patch_target_not_found_value: INTEGER = 1642
	Rpc_s_invalid_string_binding_value: INTEGER = 1700
	Rpc_s_wrong_kind_of_binding_value: INTEGER = 1701
	Rpc_s_invalid_binding_value: INTEGER = 1702
	Rpc_s_protseq_not_supported_value: INTEGER = 1703
	Rpc_s_invalid_rpc_protseq_value: INTEGER = 1704
	Rpc_s_invalid_string_uuid_value: INTEGER = 1705
	Rpc_s_invalid_endpoint_format_value: INTEGER = 1706
	Rpc_s_invalid_net_addr_value: INTEGER = 1707
	Rpc_s_no_endpoint_found_value: INTEGER = 1708
	Rpc_s_invalid_timeout_value: INTEGER = 1709
	Rpc_s_object_not_found_value: INTEGER = 1710
	Rpc_s_already_registered_value: INTEGER = 1711
	Rpc_s_type_already_registered_value: INTEGER = 1712
	Rpc_s_already_listening_value: INTEGER = 1713
	Rpc_s_no_protseqs_registered_value: INTEGER = 1714
	Rpc_s_not_listening_value: INTEGER = 1715
	Rpc_s_unknown_mgr_type_value: INTEGER = 1716
	Rpc_s_unknown_if_value: INTEGER = 1717
	Rpc_s_no_bindings_value: INTEGER = 1718
	Rpc_s_no_protseqs_value: INTEGER = 1719
	Rpc_s_cant_create_endpoint_value: INTEGER = 1720
	Rpc_s_out_of_resources_value: INTEGER = 1721
	Rpc_s_server_unavailable_value: INTEGER = 1722
	Rpc_s_server_too_busy_value: INTEGER = 1723
	Rpc_s_invalid_network_options_value: INTEGER = 1724
	Rpc_s_no_call_active_value: INTEGER = 1725
	Rpc_s_call_failed_value: INTEGER = 1726
	Rpc_s_call_failed_dne_value: INTEGER = 1727
	Rpc_s_protocol_error_value: INTEGER = 1728
	Rpc_s_unsupported_trans_syn_value: INTEGER = 1730
	Rpc_s_unsupported_type_value: INTEGER = 1732
	Rpc_s_invalid_tag_value: INTEGER = 1733
	Rpc_s_invalid_bound_value: INTEGER = 1734
	Rpc_s_no_entry_name_value: INTEGER = 1735
	Rpc_s_invalid_name_syntax_value: INTEGER = 1736
	Rpc_s_unsupported_name_syntax_value: INTEGER = 1737
	Rpc_s_uuid_no_address_value: INTEGER = 1739
	Rpc_s_duplicate_endpoint_value: INTEGER = 1740
	Rpc_s_unknown_authn_type_value: INTEGER = 1741
	Rpc_s_max_calls_too_small_value: INTEGER = 1742
	Rpc_s_string_too_long_value: INTEGER = 1743
	Rpc_s_protseq_not_found_value: INTEGER = 1744
	Rpc_s_procnum_out_of_range_value: INTEGER = 1745
	Rpc_s_binding_has_no_auth_value: INTEGER = 1746
	Rpc_s_unknown_authn_service_value: INTEGER = 1747
	Rpc_s_unknown_authn_level_value: INTEGER = 1748
	Rpc_s_invalid_auth_identity_value: INTEGER = 1749
	Rpc_s_unknown_authz_service_value: INTEGER = 1750
	Ept_s_invalid_entry_value: INTEGER = 1751
	Ept_s_cant_perform_op_value: INTEGER = 1752
	Ept_s_not_registered_value: INTEGER = 1753
	Rpc_s_nothing_to_export_value: INTEGER = 1754
	Rpc_s_incomplete_name_value: INTEGER = 1755
	Rpc_s_invalid_vers_option_value: INTEGER = 1756
	Rpc_s_no_more_members_value: INTEGER = 1757
	Rpc_s_not_all_objs_unexported_value: INTEGER = 1758
	Rpc_s_interface_not_found_value: INTEGER = 1759
	Rpc_s_entry_already_exists_value: INTEGER = 1760
	Rpc_s_entry_not_found_value: INTEGER = 1761
	Rpc_s_name_service_unavailable_value: INTEGER = 1762
	Rpc_s_invalid_naf_id_value: INTEGER = 1763
	Rpc_s_cannot_support_value: INTEGER = 1764
	Rpc_s_no_context_available_value: INTEGER = 1765
	Rpc_s_internal_error_value: INTEGER = 1766
	Rpc_s_zero_divide_value: INTEGER = 1767
	Rpc_s_address_error_value: INTEGER = 1768
	Rpc_s_fp_div_zero_value: INTEGER = 1769
	Rpc_s_fp_underflow_value: INTEGER = 1770
	Rpc_s_fp_overflow_value: INTEGER = 1771
	Rpc_x_no_more_entries_value: INTEGER = 1772
	Rpc_x_ss_char_trans_open_fail_value: INTEGER = 1773
	Rpc_x_ss_char_trans_short_file_value: INTEGER = 1774
	Rpc_x_ss_in_null_context_value: INTEGER = 1775
	Rpc_x_ss_context_damaged_value: INTEGER = 1777
	Rpc_x_ss_handles_mismatch_value: INTEGER = 1778
	Rpc_x_ss_cannot_get_call_handle_value: INTEGER = 1779
	Rpc_x_null_ref_pointer_value: INTEGER = 1780
	Rpc_x_enum_value_out_of_range_value: INTEGER = 1781
	Rpc_x_byte_count_too_small_value: INTEGER = 1782
	Rpc_x_bad_stub_data_value: INTEGER = 1783
	Error_invalid_user_buffer_value: INTEGER = 1784
	Error_unrecognized_media_value: INTEGER = 1785
	Error_no_trust_lsa_secret_value: INTEGER = 1786
	Error_no_trust_sam_account_value: INTEGER = 1787
	Error_trusted_domain_failure_value: INTEGER = 1788
	Error_trusted_relationship_failure_value: INTEGER = 1789
	Error_trust_failure_value: INTEGER = 1790
	Rpc_s_call_in_progress_value: INTEGER = 1791
	Error_netlogon_not_started_value: INTEGER = 1792
	Error_account_expired_value: INTEGER = 1793
	Error_redirector_has_open_handles_value: INTEGER = 1794
	Error_printer_driver_already_installed_value: INTEGER = 1795
	Error_unknown_port_value: INTEGER = 1796
	Error_unknown_printer_driver_value: INTEGER = 1797
	Error_unknown_printprocessor_value: INTEGER = 1798
	Error_invalid_separator_file_value: INTEGER = 1799
	Error_invalid_priority_value: INTEGER = 1800
	Error_invalid_printer_name_value: INTEGER = 1801
	Error_printer_already_exists_value: INTEGER = 1802
	Error_invalid_printer_command_value: INTEGER = 1803
	Error_invalid_datatype_value: INTEGER = 1804
	Error_invalid_environment_value: INTEGER = 1805
	Rpc_s_no_more_bindings_value: INTEGER = 1806
	Error_nologon_interdomain_trust_account_value: INTEGER = 1807
	Error_nologon_workstation_trust_account_value: INTEGER = 1808
	Error_nologon_server_trust_account_value: INTEGER = 1809
	Error_domain_trust_inconsistent_value: INTEGER = 1810
	Error_server_has_open_handles_value: INTEGER = 1811
	Error_resource_data_not_found_value: INTEGER = 1812
	Error_resource_type_not_found_value: INTEGER = 1813
	Error_resource_name_not_found_value: INTEGER = 1814
	Error_resource_lang_not_found_value: INTEGER = 1815
	Error_not_enough_quota_value: INTEGER = 1816
	Rpc_s_no_interfaces_value: INTEGER = 1817
	Rpc_s_call_cancelled_value: INTEGER = 1818
	Rpc_s_binding_incomplete_value: INTEGER = 1819
	Rpc_s_comm_failure_value: INTEGER = 1820
	Rpc_s_unsupported_authn_level_value: INTEGER = 1821
	Rpc_s_no_princ_name_value: INTEGER = 1822
	Rpc_s_not_rpc_error_value: INTEGER = 1823
	Rpc_s_uuid_local_only_value: INTEGER = 1824
	Rpc_s_sec_pkg_error_value: INTEGER = 1825
	Rpc_s_not_cancelled_value: INTEGER = 1826
	Rpc_x_invalid_es_action_value: INTEGER = 1827
	Rpc_x_wrong_es_version_value: INTEGER = 1828
	Rpc_x_wrong_stub_version_value: INTEGER = 1829
	Rpc_x_invalid_pipe_object_value: INTEGER = 1830
	Rpc_x_wrong_pipe_order_value: INTEGER = 1831
	Rpc_x_wrong_pipe_version_value: INTEGER = 1832
	Rpc_s_group_member_not_found_value: INTEGER = 1898
	Ept_s_cant_create_value: INTEGER = 1899
	Rpc_s_invalid_object_value: INTEGER = 1900
	Error_invalid_time_value: INTEGER = 1901
	Error_invalid_form_name_value: INTEGER = 1902
	Error_invalid_form_size_value: INTEGER = 1903
	Error_already_waiting_value: INTEGER = 1904
	Error_printer_deleted_value: INTEGER = 1905
	Error_invalid_printer_state_value: INTEGER = 1906
	Error_password_must_change_value: INTEGER = 1907
	Error_domain_controller_not_found_value: INTEGER = 1908
	Error_account_locked_out_value: INTEGER = 1909
	Or_invalid_oxid_value: INTEGER = 1910
	Or_invalid_oid_value: INTEGER = 1911
	Or_invalid_set_value: INTEGER = 1912
	Rpc_s_send_incomplete_value: INTEGER = 1913
	Rpc_s_invalid_async_handle_value: INTEGER = 1914
	Rpc_s_invalid_async_call_value: INTEGER = 1915
	Rpc_x_pipe_closed_value: INTEGER = 1916
	Rpc_x_pipe_discipline_error_value: INTEGER = 1917
	Rpc_x_pipe_empty_value: INTEGER = 1918
	Error_no_sitename_value: INTEGER = 1919
	Error_cant_access_file_value: INTEGER = 1920
	Error_cant_resolve_filename_value: INTEGER = 1921
	Rpc_s_entry_type_mismatch_value: INTEGER = 1922
	Rpc_s_not_all_objs_exported_value: INTEGER = 1923
	Rpc_s_interface_not_exported_value: INTEGER = 1924
	Rpc_s_profile_not_added_value: INTEGER = 1925
	Rpc_s_prf_elt_not_added_value: INTEGER = 1926
	Rpc_s_prf_elt_not_removed_value: INTEGER = 1927
	Rpc_s_grp_elt_not_added_value: INTEGER = 1928
	Rpc_s_grp_elt_not_removed_value: INTEGER = 1929
	Error_no_browser_servers_found_value: INTEGER = 6118
	Error_invalid_pixel_format_value: INTEGER = 2000
	Error_bad_driver_value: INTEGER = 2001
	Error_invalid_window_style_value: INTEGER = 2002
	Error_metafile_not_supported_value: INTEGER = 2003
	Error_transform_not_supported_value: INTEGER = 2004
	Error_clipping_not_supported_value: INTEGER = 2005
	Error_invalid_cmm_value: INTEGER = 2010
	Error_invalid_profile_value: INTEGER = 2011
	Error_tag_not_found_value: INTEGER = 2012
	Error_tag_not_present_value: INTEGER = 2013
	Error_duplicate_tag_value: INTEGER = 2014
	Error_profile_not_associated_with_device_value: INTEGER = 2015
	Error_profile_not_found_value: INTEGER = 2016
	Error_invalid_colorspace_value: INTEGER = 2017
	Error_icm_not_enabled_value: INTEGER = 2018
	Error_deleting_icm_xform_value: INTEGER = 2019
	Error_invalid_transform_value: INTEGER = 2020
	Error_colorspace_mismatch_value: INTEGER = 2021
	Error_invalid_colorindex_value: INTEGER = 2022
	Error_connected_other_password_value: INTEGER = 2108
	Error_bad_username_value: INTEGER = 2202
	Error_not_connected_value: INTEGER = 2250
	Error_open_files_value: INTEGER = 2401
	Error_active_connections_value: INTEGER = 2402
	Error_device_in_use_value: INTEGER = 2404
	Error_unknown_print_monitor_value: INTEGER = 3000
	Error_printer_driver_in_use_value: INTEGER = 3001
	Error_spool_file_not_found_value: INTEGER = 3002
	Error_spl_no_startdoc_value: INTEGER = 3003
	Error_spl_no_addjob_value: INTEGER = 3004
	Error_print_processor_already_installed_value: INTEGER = 3005
	Error_print_monitor_already_installed_value: INTEGER = 3006
	Error_invalid_print_monitor_value: INTEGER = 3007
	Error_print_monitor_in_use_value: INTEGER = 3008
	Error_printer_has_jobs_queued_value: INTEGER = 3009
	Error_success_reboot_required_value: INTEGER = 3010
	Error_success_restart_required_value: INTEGER = 3011
	Error_printer_not_found_value: INTEGER = 3012
	Error_wins_internal_value: INTEGER = 4000
	Error_can_not_del_local_wins_value: INTEGER = 4001
	Error_static_init_value: INTEGER = 4002
	Error_inc_backup_value: INTEGER = 4003
	Error_full_backup_value: INTEGER = 4004
	Error_rec_non_existent_value: INTEGER = 4005
	Error_rpl_not_allowed_value: INTEGER = 4006
	Error_dhcp_address_conflict_value: INTEGER = 4100
	Error_wmi_guid_not_found_value: INTEGER = 4200
	Error_wmi_instance_not_found_value: INTEGER = 4201
	Error_wmi_itemid_not_found_value: INTEGER = 4202
	Error_wmi_try_again_value: INTEGER = 4203
	Error_wmi_dp_not_found_value: INTEGER = 4204
	Error_wmi_unresolved_instance_ref_value: INTEGER = 4205
	Error_wmi_already_enabled_value: INTEGER = 4206
	Error_wmi_guid_disconnected_value: INTEGER = 4207
	Error_wmi_server_unavailable_value: INTEGER = 4208
	Error_wmi_dp_failed_value: INTEGER = 4209
	Error_wmi_invalid_mof_value: INTEGER = 4210
	Error_wmi_invalid_reginfo_value: INTEGER = 4211
	Error_wmi_already_disabled_value: INTEGER = 4212
	Error_wmi_read_only_value: INTEGER = 4213
	Error_wmi_set_failure_value: INTEGER = 4214
	Error_invalid_media_value: INTEGER = 4300
	Error_invalid_library_value: INTEGER = 4301
	Error_invalid_media_pool_value: INTEGER = 4302
	Error_drive_media_mismatch_value: INTEGER = 4303
	Error_media_offline_value: INTEGER = 4304
	Error_library_offline_value: INTEGER = 4305
	Error_empty_value: INTEGER = 4306
	Error_not_empty_value: INTEGER = 4307
	Error_media_unavailable_value: INTEGER = 4308
	Error_resource_disabled_value: INTEGER = 4309
	Error_invalid_cleaner_value: INTEGER = 4310
	Error_unable_to_clean_value: INTEGER = 4311
	Error_object_not_found_value: INTEGER = 4312
	Error_database_failure_value: INTEGER = 4313
	Error_database_full_value: INTEGER = 4314
	Error_media_incompatible_value: INTEGER = 4315
	Error_resource_not_present_value: INTEGER = 4316
	Error_invalid_operation_value: INTEGER = 4317
	Error_media_not_available_value: INTEGER = 4318
	Error_device_not_available_value: INTEGER = 4319
	Error_request_refused_value: INTEGER = 4320
	Error_invalid_drive_object_value: INTEGER = 4321
	Error_library_full_value: INTEGER = 4322
	Error_medium_not_accessible_value: INTEGER = 4323
	Error_unable_to_load_medium_value: INTEGER = 4324
	Error_unable_to_inventory_drive_value: INTEGER = 4325
	Error_unable_to_inventory_slot_value: INTEGER = 4326
	Error_unable_to_inventory_transport_value: INTEGER = 4327
	Error_transport_full_value: INTEGER = 4328
	Error_controlling_ieport_value: INTEGER = 4329
	Error_unable_to_eject_mounted_media_value: INTEGER = 4330
	Error_cleaner_slot_set_value: INTEGER = 4331
	Error_cleaner_slot_not_set_value: INTEGER = 4332
	Error_cleaner_cartridge_spent_value: INTEGER = 4333
	Error_unexpected_omid_value: INTEGER = 4334
	Error_cant_delete_last_item_value: INTEGER = 4335
	Error_message_exceeds_max_size_value: INTEGER = 4336
	Error_volume_contains_sys_files_value: INTEGER = 4337
	Error_indigenous_type_value: INTEGER = 4338
	Error_no_supporting_drives_value: INTEGER = 4339
	Error_file_offline_value: INTEGER = 4350
	Error_remote_storage_not_active_value: INTEGER = 4351
	Error_remote_storage_media_error_value: INTEGER = 4352
	Error_not_a_reparse_point_value: INTEGER = 4390
	Error_reparse_attribute_conflict_value: INTEGER = 4391
	Error_invalid_reparse_data_value: INTEGER = 4392
	Error_reparse_tag_invalid_value: INTEGER = 4393
	Error_reparse_tag_mismatch_value: INTEGER = 4394
	Error_volume_not_sis_enabled_value: INTEGER = 4500
	Error_dependent_resource_exists_value: INTEGER = 5001
	Error_dependency_not_found_value: INTEGER = 5002
	Error_dependency_already_exists_value: INTEGER = 5003
	Error_resource_not_online_value: INTEGER = 5004
	Error_host_node_not_available_value: INTEGER = 5005
	Error_resource_not_available_value: INTEGER = 5006
	Error_resource_not_found_value: INTEGER = 5007
	Error_shutdown_cluster_value: INTEGER = 5008
	Error_cant_evict_active_node_value: INTEGER = 5009
	Error_object_already_exists_value: INTEGER = 5010
	Error_object_in_list_value: INTEGER = 5011
	Error_group_not_available_value: INTEGER = 5012
	Error_group_not_found_value: INTEGER = 5013
	Error_group_not_online_value: INTEGER = 5014
	Error_host_node_not_resource_owner_value: INTEGER = 5015
	Error_host_node_not_group_owner_value: INTEGER = 5016
	Error_resmon_create_failed_value: INTEGER = 5017
	Error_resmon_online_failed_value: INTEGER = 5018
	Error_resource_online_value: INTEGER = 5019
	Error_quorum_resource_value: INTEGER = 5020
	Error_not_quorum_capable_value: INTEGER = 5021
	Error_cluster_shutting_down_value: INTEGER = 5022
	Error_invalid_state_value: INTEGER = 5023
	Error_resource_properties_stored_value: INTEGER = 5024
	Error_not_quorum_class_value: INTEGER = 5025
	Error_core_resource_value: INTEGER = 5026
	Error_quorum_resource_online_failed_value: INTEGER = 5027
	Error_quorumlog_open_failed_value: INTEGER = 5028
	Error_clusterlog_corrupt_value: INTEGER = 5029
	Error_clusterlog_record_exceeds_maxsize_value: INTEGER = 5030
	Error_clusterlog_exceeds_maxsize_value: INTEGER = 5031
	Error_clusterlog_chkpoint_not_found_value: INTEGER = 5032
	Error_clusterlog_not_enough_space_value: INTEGER = 5033
	Error_quorum_owner_alive_value: INTEGER = 5034
	Error_network_not_available_value: INTEGER = 5035
	Error_node_not_available_value: INTEGER = 5036
	Error_all_nodes_not_available_value: INTEGER = 5037
	Error_resource_failed_value: INTEGER = 5038
	Error_cluster_invalid_node_value: INTEGER = 5039
	Error_cluster_node_exists_value: INTEGER = 5040
	Error_cluster_join_in_progress_value: INTEGER = 5041
	Error_cluster_node_not_found_value: INTEGER = 5042
	Error_cluster_local_node_not_found_value: INTEGER = 5043
	Error_cluster_network_exists_value: INTEGER = 5044
	Error_cluster_network_not_found_value: INTEGER = 5045
	Error_cluster_netinterface_exists_value: INTEGER = 5046
	Error_cluster_netinterface_not_found_value: INTEGER = 5047
	Error_cluster_invalid_request_value: INTEGER = 5048
	Error_cluster_invalid_network_provider_value: INTEGER = 5049
	Error_cluster_node_down_value: INTEGER = 5050
	Error_cluster_node_unreachable_value: INTEGER = 5051
	Error_cluster_node_not_member_value: INTEGER = 5052
	Error_cluster_join_not_in_progress_value: INTEGER = 5053
	Error_cluster_invalid_network_value: INTEGER = 5054
	Error_cluster_node_up_value: INTEGER = 5056
	Error_cluster_ipaddr_in_use_value: INTEGER = 5057
	Error_cluster_node_not_paused_value: INTEGER = 5058
	Error_cluster_no_security_context_value: INTEGER = 5059
	Error_cluster_network_not_internal_value: INTEGER = 5060
	Error_cluster_node_already_up_value: INTEGER = 5061
	Error_cluster_node_already_down_value: INTEGER = 5062
	Error_cluster_network_already_online_value: INTEGER = 5063
	Error_cluster_network_already_offline_value: INTEGER = 5064
	Error_cluster_node_already_member_value: INTEGER = 5065
	Error_cluster_last_internal_network_value: INTEGER = 5066
	Error_cluster_network_has_dependents_value: INTEGER = 5067
	Error_invalid_operation_on_quorum_value: INTEGER = 5068
	Error_dependency_not_allowed_value: INTEGER = 5069
	Error_cluster_node_paused_value: INTEGER = 5070
	Error_node_cant_host_resource_value: INTEGER = 5071
	Error_cluster_node_not_ready_value: INTEGER = 5072
	Error_cluster_node_shutting_down_value: INTEGER = 5073
	Error_cluster_join_aborted_value: INTEGER = 5074
	Error_cluster_incompatible_versions_value: INTEGER = 5075
	Error_cluster_maxnum_of_resources_exceeded_value: INTEGER = 5076
	Error_cluster_system_config_changed_value: INTEGER = 5077
	Error_cluster_resource_type_not_found_value: INTEGER = 5078
	Error_cluster_restype_not_supported_value: INTEGER = 5079
	Error_cluster_resname_not_found_value: INTEGER = 5080
	Error_cluster_no_rpc_packages_registered_value: INTEGER = 5081
	Error_cluster_owner_not_in_preflist_value: INTEGER = 5082
	Error_cluster_database_seqmismatch_value: INTEGER = 5083
	Error_resmon_invalid_state_value: INTEGER = 5084
	Error_cluster_gum_not_locker_value: INTEGER = 5085
	Error_quorum_disk_not_found_value: INTEGER = 5086
	Error_database_backup_corrupt_value: INTEGER = 5087
	Error_cluster_node_already_has_dfs_root_value: INTEGER = 5088
	Error_resource_property_unchangeable_value: INTEGER = 5089
	Error_encryption_failed_value: INTEGER = 6000
	Error_decryption_failed_value: INTEGER = 6001
	Error_file_encrypted_value: INTEGER = 6002
	Error_no_recovery_policy_value: INTEGER = 6003
	Error_no_efs_value: INTEGER = 6004
	Error_wrong_efs_value: INTEGER = 6005
	Error_no_user_keys_value: INTEGER = 6006
	Error_file_not_encrypted_value: INTEGER = 6007
	Error_not_export_format_value: INTEGER = 6008
	Error_file_read_only_value: INTEGER = 6009
	Error_dir_efs_disallowed_value: INTEGER = 6010
	Error_efs_server_not_trusted_value: INTEGER = 6011
	Sched_e_service_not_localsystem_value: INTEGER = 6200
	Error_ctx_winstation_name_invalid_value: INTEGER = 7001
	Error_ctx_invalid_pd_value: INTEGER = 7002
	Error_ctx_pd_not_found_value: INTEGER = 7003
	Error_ctx_wd_not_found_value: INTEGER = 7004
	Error_ctx_cannot_make_eventlog_entry_value: INTEGER = 7005
	Error_ctx_service_name_collision_value: INTEGER = 7006
	Error_ctx_close_pending_value: INTEGER = 7007
	Error_ctx_no_outbuf_value: INTEGER = 7008
	Error_ctx_modem_inf_not_found_value: INTEGER = 7009
	Error_ctx_invalid_modemname_value: INTEGER = 7010
	Error_ctx_modem_response_error_value: INTEGER = 7011
	Error_ctx_modem_response_timeout_value: INTEGER = 7012
	Error_ctx_modem_response_no_carrier_value: INTEGER = 7013
	Error_ctx_modem_response_no_dialtone_value: INTEGER = 7014
	Error_ctx_modem_response_busy_value: INTEGER = 7015
	Error_ctx_modem_response_voice_value: INTEGER = 7016
	Error_ctx_td_error_value: INTEGER = 7017
	Error_ctx_winstation_not_found_value: INTEGER = 7022
	Error_ctx_winstation_already_exists_value: INTEGER = 7023
	Error_ctx_winstation_busy_value: INTEGER = 7024
	Error_ctx_bad_video_mode_value: INTEGER = 7025
	Error_ctx_graphics_invalid_value: INTEGER = 7035
	Error_ctx_logon_disabled_value: INTEGER = 7037
	Error_ctx_not_console_value: INTEGER = 7038
	Error_ctx_client_query_timeout_value: INTEGER = 7040
	Error_ctx_console_disconnect_value: INTEGER = 7041
	Error_ctx_console_connect_value: INTEGER = 7042
	Error_ctx_shadow_denied_value: INTEGER = 7044
	Error_ctx_winstation_access_denied_value: INTEGER = 7045
	Error_ctx_invalid_wd_value: INTEGER = 7049
	Error_ctx_shadow_invalid_value: INTEGER = 7050
	Error_ctx_shadow_disabled_value: INTEGER = 7051
	Error_ctx_client_license_in_use_value: INTEGER = 7052
	Error_ctx_client_license_not_set_value: INTEGER = 7053
	Error_ctx_license_not_available_value: INTEGER = 7054
	Error_ctx_license_client_invalid_value: INTEGER = 7055
	Error_ctx_license_expired_value: INTEGER = 7056
	Frs_err_invalid_api_sequence_value: INTEGER = 8001
	Frs_err_starting_service_value: INTEGER = 8002
	Frs_err_stopping_service_value: INTEGER = 8003
	Frs_err_internal_api_value: INTEGER = 8004
	Frs_err_internal_value: INTEGER = 8005
	Frs_err_service_comm_value: INTEGER = 8006
	Frs_err_insufficient_priv_value: INTEGER = 8007
	Frs_err_authentication_value: INTEGER = 8008
	Frs_err_parent_insufficient_priv_value: INTEGER = 8009
	Frs_err_parent_authentication_value: INTEGER = 8010
	Frs_err_child_to_parent_comm_value: INTEGER = 8011
	Frs_err_parent_to_child_comm_value: INTEGER = 8012
	Frs_err_sysvol_populate_value: INTEGER = 8013
	Frs_err_sysvol_populate_timeout_value: INTEGER = 8014
	Frs_err_sysvol_is_busy_value: INTEGER = 8015
	Frs_err_sysvol_demote_value: INTEGER = 8016
	Frs_err_invalid_service_parameter_value: INTEGER = 8017
	Error_ds_not_installed_value: INTEGER = 8200
	Error_ds_membership_evaluated_locally_value: INTEGER = 8201
	Error_ds_no_attribute_or_value_value: INTEGER = 8202
	Error_ds_invalid_attribute_syntax_value: INTEGER = 8203
	Error_ds_attribute_type_undefined_value: INTEGER = 8204
	Error_ds_attribute_or_value_exists_value: INTEGER = 8205
	Error_ds_busy_value: INTEGER = 8206
	Error_ds_unavailable_value: INTEGER = 8207
	Error_ds_no_rids_allocated_value: INTEGER = 8208
	Error_ds_no_more_rids_value: INTEGER = 8209
	Error_ds_incorrect_role_owner_value: INTEGER = 8210
	Error_ds_ridmgr_init_error_value: INTEGER = 8211
	Error_ds_obj_class_violation_value: INTEGER = 8212
	Error_ds_cant_on_non_leaf_value: INTEGER = 8213
	Error_ds_cant_on_rdn_value: INTEGER = 8214
	Error_ds_cant_mod_obj_class_value: INTEGER = 8215
	Error_ds_cross_dom_move_error_value: INTEGER = 8216
	Error_ds_gc_not_available_value: INTEGER = 8217
	Error_shared_policy_value: INTEGER = 8218
	Error_policy_object_not_found_value: INTEGER = 8219
	Error_policy_only_in_ds_value: INTEGER = 8220
	Error_promotion_active_value: INTEGER = 8221
	Error_no_promotion_active_value: INTEGER = 8222
	Error_ds_operations_error_value: INTEGER = 8224
	Error_ds_protocol_error_value: INTEGER = 8225
	Error_ds_timelimit_exceeded_value: INTEGER = 8226
	Error_ds_sizelimit_exceeded_value: INTEGER = 8227
	Error_ds_admin_limit_exceeded_value: INTEGER = 8228
	Error_ds_compare_false_value: INTEGER = 8229
	Error_ds_compare_true_value: INTEGER = 8230
	Error_ds_auth_method_not_supported_value: INTEGER = 8231
	Error_ds_strong_auth_required_value: INTEGER = 8232
	Error_ds_inappropriate_auth_value: INTEGER = 8233
	Error_ds_auth_unknown_value: INTEGER = 8234
	Error_ds_referral_value: INTEGER = 8235
	Error_ds_unavailable_crit_extension_value: INTEGER = 8236
	Error_ds_confidentiality_required_value: INTEGER = 8237
	Error_ds_inappropriate_matching_value: INTEGER = 8238
	Error_ds_constraint_violation_value: INTEGER = 8239
	Error_ds_no_such_object_value: INTEGER = 8240
	Error_ds_alias_problem_value: INTEGER = 8241
	Error_ds_invalid_dn_syntax_value: INTEGER = 8242
	Error_ds_is_leaf_value: INTEGER = 8243
	Error_ds_alias_deref_problem_value: INTEGER = 8244
	Error_ds_unwilling_to_perform_value: INTEGER = 8245
	Error_ds_loop_detect_value: INTEGER = 8246
	Error_ds_naming_violation_value: INTEGER = 8247
	Error_ds_object_results_too_large_value: INTEGER = 8248
	Error_ds_affects_multiple_dsas_value: INTEGER = 8249
	Error_ds_server_down_value: INTEGER = 8250
	Error_ds_local_error_value: INTEGER = 8251
	Error_ds_encoding_error_value: INTEGER = 8252
	Error_ds_decoding_error_value: INTEGER = 8253
	Error_ds_filter_unknown_value: INTEGER = 8254
	Error_ds_param_error_value: INTEGER = 8255
	Error_ds_not_supported_value: INTEGER = 8256
	Error_ds_no_results_returned_value: INTEGER = 8257
	Error_ds_control_not_found_value: INTEGER = 8258
	Error_ds_client_loop_value: INTEGER = 8259
	Error_ds_referral_limit_exceeded_value: INTEGER = 8260
	Error_ds_root_must_be_nc_value: INTEGER = 8301
	Error_ds_add_replica_inhibited_value: INTEGER = 8302
	Error_ds_att_not_def_in_schema_value: INTEGER = 8303
	Error_ds_max_obj_size_exceeded_value: INTEGER = 8304
	Error_ds_obj_string_name_exists_value: INTEGER = 8305
	Error_ds_no_rdn_defined_in_schema_value: INTEGER = 8306
	Error_ds_rdn_doesnt_match_schema_value: INTEGER = 8307
	Error_ds_no_requested_atts_found_value: INTEGER = 8308
	Error_ds_user_buffer_to_small_value: INTEGER = 8309
	Error_ds_att_is_not_on_obj_value: INTEGER = 8310
	Error_ds_illegal_mod_operation_value: INTEGER = 8311
	Error_ds_obj_too_large_value: INTEGER = 8312
	Error_ds_bad_instance_type_value: INTEGER = 8313
	Error_ds_masterdsa_required_value: INTEGER = 8314
	Error_ds_object_class_required_value: INTEGER = 8315
	Error_ds_missing_required_att_value: INTEGER = 8316
	Error_ds_att_not_def_for_class_value: INTEGER = 8317
	Error_ds_att_already_exists_value: INTEGER = 8318
	Error_ds_cant_add_att_values_value: INTEGER = 8320
	Error_ds_single_value_constraint_value: INTEGER = 8321
	Error_ds_range_constraint_value: INTEGER = 8322
	Error_ds_att_val_already_exists_value: INTEGER = 8323
	Error_ds_cant_rem_missing_att_value: INTEGER = 8324
	Error_ds_cant_rem_missing_att_val_value: INTEGER = 8325
	Error_ds_root_cant_be_subref_value: INTEGER = 8326
	Error_ds_no_chaining_value: INTEGER = 8327
	Error_ds_no_chained_eval_value: INTEGER = 8328
	Error_ds_no_parent_object_value: INTEGER = 8329
	Error_ds_parent_is_an_alias_value: INTEGER = 8330
	Error_ds_cant_mix_master_and_reps_value: INTEGER = 8331
	Error_ds_children_exist_value: INTEGER = 8332
	Error_ds_obj_not_found_value: INTEGER = 8333
	Error_ds_aliased_obj_missing_value: INTEGER = 8334
	Error_ds_bad_name_syntax_value: INTEGER = 8335
	Error_ds_alias_points_to_alias_value: INTEGER = 8336
	Error_ds_cant_deref_alias_value: INTEGER = 8337
	Error_ds_out_of_scope_value: INTEGER = 8338
	Error_ds_cant_delete_dsa_obj_value: INTEGER = 8340
	Error_ds_generic_error_value: INTEGER = 8341
	Error_ds_dsa_must_be_int_master_value: INTEGER = 8342
	Error_ds_class_not_dsa_value: INTEGER = 8343
	Error_ds_insuff_access_rights_value: INTEGER = 8344
	Error_ds_illegal_superior_value: INTEGER = 8345
	Error_ds_attribute_owned_by_sam_value: INTEGER = 8346
	Error_ds_name_too_many_parts_value: INTEGER = 8347
	Error_ds_name_too_long_value: INTEGER = 8348
	Error_ds_name_value_too_long_value: INTEGER = 8349
	Error_ds_name_unparseable_value: INTEGER = 8350
	Error_ds_name_type_unknown_value: INTEGER = 8351
	Error_ds_not_an_object_value: INTEGER = 8352
	Error_ds_sec_desc_too_short_value: INTEGER = 8353
	Error_ds_sec_desc_invalid_value: INTEGER = 8354
	Error_ds_no_deleted_name_value: INTEGER = 8355
	Error_ds_subref_must_have_parent_value: INTEGER = 8356
	Error_ds_ncname_must_be_nc_value: INTEGER = 8357
	Error_ds_cant_add_system_only_value: INTEGER = 8358
	Error_ds_class_must_be_concrete_value: INTEGER = 8359
	Error_ds_invalid_dmd_value: INTEGER = 8360
	Error_ds_obj_guid_exists_value: INTEGER = 8361
	Error_ds_not_on_backlink_value: INTEGER = 8362
	Error_ds_no_crossref_for_nc_value: INTEGER = 8363
	Error_ds_shutting_down_value: INTEGER = 8364
	Error_ds_unknown_operation_value: INTEGER = 8365
	Error_ds_invalid_role_owner_value: INTEGER = 8366
	Error_ds_couldnt_contact_fsmo_value: INTEGER = 8367
	Error_ds_cross_nc_dn_rename_value: INTEGER = 8368
	Error_ds_cant_mod_system_only_value: INTEGER = 8369
	Error_ds_replicator_only_value: INTEGER = 8370
	Error_ds_obj_class_not_defined_value: INTEGER = 8371
	Error_ds_obj_class_not_subclass_value: INTEGER = 8372
	Error_ds_name_reference_invalid_value: INTEGER = 8373
	Error_ds_cross_ref_exists_value: INTEGER = 8374
	Error_ds_cant_del_master_crossref_value: INTEGER = 8375
	Error_ds_subtree_notify_not_nc_head_value: INTEGER = 8376
	Error_ds_notify_filter_too_complex_value: INTEGER = 8377
	Error_ds_dup_rdn_value: INTEGER = 8378
	Error_ds_dup_oid_value: INTEGER = 8379
	Error_ds_dup_mapi_id_value: INTEGER = 8380
	Error_ds_dup_schema_id_guid_value: INTEGER = 8381
	Error_ds_dup_ldap_display_name_value: INTEGER = 8382
	Error_ds_semantic_att_test_value: INTEGER = 8383
	Error_ds_syntax_mismatch_value: INTEGER = 8384
	Error_ds_exists_in_must_have_value: INTEGER = 8385
	Error_ds_exists_in_may_have_value: INTEGER = 8386
	Error_ds_nonexistent_may_have_value: INTEGER = 8387
	Error_ds_nonexistent_must_have_value: INTEGER = 8388
	Error_ds_aux_cls_test_fail_value: INTEGER = 8389
	Error_ds_nonexistent_poss_sup_value: INTEGER = 8390
	Error_ds_sub_cls_test_fail_value: INTEGER = 8391
	Error_ds_bad_rdn_att_id_syntax_value: INTEGER = 8392
	Error_ds_exists_in_aux_cls_value: INTEGER = 8393
	Error_ds_exists_in_sub_cls_value: INTEGER = 8394
	Error_ds_exists_in_poss_sup_value: INTEGER = 8395
	Error_ds_recalcschema_failed_value: INTEGER = 8396
	Error_ds_tree_delete_not_finished_value: INTEGER = 8397
	Error_ds_cant_delete_value: INTEGER = 8398
	Error_ds_att_schema_req_id_value: INTEGER = 8399
	Error_ds_bad_att_schema_syntax_value: INTEGER = 8400
	Error_ds_cant_cache_att_value: INTEGER = 8401
	Error_ds_cant_cache_class_value: INTEGER = 8402
	Error_ds_cant_remove_att_cache_value: INTEGER = 8403
	Error_ds_cant_remove_class_cache_value: INTEGER = 8404
	Error_ds_cant_retrieve_dn_value: INTEGER = 8405
	Error_ds_missing_supref_value: INTEGER = 8406
	Error_ds_cant_retrieve_instance_value: INTEGER = 8407
	Error_ds_code_inconsistency_value: INTEGER = 8408
	Error_ds_database_error_value: INTEGER = 8409
	Error_ds_governsid_missing_value: INTEGER = 8410
	Error_ds_missing_expected_att_value: INTEGER = 8411
	Error_ds_ncname_missing_cr_ref_value: INTEGER = 8412
	Error_ds_security_checking_error_value: INTEGER = 8413
	Error_ds_schema_not_loaded_value: INTEGER = 8414
	Error_ds_schema_alloc_failed_value: INTEGER = 8415
	Error_ds_att_schema_req_syntax_value: INTEGER = 8416
	Error_ds_gcverify_error_value: INTEGER = 8417
	Error_ds_dra_schema_mismatch_value: INTEGER = 8418
	Error_ds_cant_find_dsa_obj_value: INTEGER = 8419
	Error_ds_cant_find_expected_nc_value: INTEGER = 8420
	Error_ds_cant_find_nc_in_cache_value: INTEGER = 8421
	Error_ds_cant_retrieve_child_value: INTEGER = 8422
	Error_ds_security_illegal_modify_value: INTEGER = 8423
	Error_ds_cant_replace_hidden_rec_value: INTEGER = 8424
	Error_ds_bad_hierarchy_file_value: INTEGER = 8425
	Error_ds_build_hierarchy_table_failed_value: INTEGER = 8426
	Error_ds_config_param_missing_value: INTEGER = 8427
	Error_ds_counting_ab_indices_failed_value: INTEGER = 8428
	Error_ds_hierarchy_table_malloc_failed_value: INTEGER = 8429
	Error_ds_internal_failure_value: INTEGER = 8430
	Error_ds_unknown_error_value: INTEGER = 8431
	Error_ds_root_requires_class_top_value: INTEGER = 8432
	Error_ds_refusing_fsmo_roles_value: INTEGER = 8433
	Error_ds_missing_fsmo_settings_value: INTEGER = 8434
	Error_ds_unable_to_surrender_roles_value: INTEGER = 8435
	Error_ds_dra_generic_value: INTEGER = 8436
	Error_ds_dra_invalid_parameter_value: INTEGER = 8437
	Error_ds_dra_busy_value: INTEGER = 8438
	Error_ds_dra_bad_dn_value: INTEGER = 8439
	Error_ds_dra_bad_nc_value: INTEGER = 8440
	Error_ds_dra_dn_exists_value: INTEGER = 8441
	Error_ds_dra_internal_error_value: INTEGER = 8442
	Error_ds_dra_inconsistent_dit_value: INTEGER = 8443
	Error_ds_dra_connection_failed_value: INTEGER = 8444
	Error_ds_dra_bad_instance_type_value: INTEGER = 8445
	Error_ds_dra_out_of_mem_value: INTEGER = 8446
	Error_ds_dra_mail_problem_value: INTEGER = 8447
	Error_ds_dra_ref_already_exists_value: INTEGER = 8448
	Error_ds_dra_ref_not_found_value: INTEGER = 8449
	Error_ds_dra_obj_is_rep_source_value: INTEGER = 8450
	Error_ds_dra_db_error_value: INTEGER = 8451
	Error_ds_dra_no_replica_value: INTEGER = 8452
	Error_ds_dra_access_denied_value: INTEGER = 8453
	Error_ds_dra_not_supported_value: INTEGER = 8454
	Error_ds_dra_rpc_cancelled_value: INTEGER = 8455
	Error_ds_dra_source_disabled_value: INTEGER = 8456
	Error_ds_dra_sink_disabled_value: INTEGER = 8457
	Error_ds_dra_name_collision_value: INTEGER = 8458
	Error_ds_dra_source_reinstalled_value: INTEGER = 8459
	Error_ds_dra_missing_parent_value: INTEGER = 8460
	Error_ds_dra_preempted_value: INTEGER = 8461
	Error_ds_dra_abandon_sync_value: INTEGER = 8462
	Error_ds_dra_shutdown_value: INTEGER = 8463
	Error_ds_dra_incompatible_partial_set_value: INTEGER = 8464
	Error_ds_dra_source_is_partial_replica_value: INTEGER = 8465
	Error_ds_dra_extn_connection_failed_value: INTEGER = 8466
	Error_ds_install_schema_mismatch_value: INTEGER = 8467
	Error_ds_dup_link_id_value: INTEGER = 8468
	Error_ds_name_error_resolving_value: INTEGER = 8469
	Error_ds_name_error_not_found_value: INTEGER = 8470
	Error_ds_name_error_not_unique_value: INTEGER = 8471
	Error_ds_name_error_no_mapping_value: INTEGER = 8472
	Error_ds_name_error_domain_only_value: INTEGER = 8473
	Error_ds_name_error_no_syntactical_mapping_value: INTEGER = 8474
	Error_ds_constructed_att_mod_value: INTEGER = 8475
	Error_ds_wrong_om_obj_class_value: INTEGER = 8476
	Error_ds_dra_repl_pending_value: INTEGER = 8477
	Error_ds_ds_required_value: INTEGER = 8478
	Error_ds_invalid_ldap_display_name_value: INTEGER = 8479
	Error_ds_non_base_search_value: INTEGER = 8480
	Error_ds_cant_retrieve_atts_value: INTEGER = 8481
	Error_ds_backlink_without_link_value: INTEGER = 8482
	Error_ds_epoch_mismatch_value: INTEGER = 8483
	Error_ds_src_name_mismatch_value: INTEGER = 8484
	Error_ds_src_and_dst_nc_identical_value: INTEGER = 8485
	Error_ds_dst_nc_mismatch_value: INTEGER = 8486
	Error_ds_not_authoritive_for_dst_nc_value: INTEGER = 8487
	Error_ds_src_guid_mismatch_value: INTEGER = 8488
	Error_ds_cant_move_deleted_object_value: INTEGER = 8489
	Error_ds_pdc_operation_in_progress_value: INTEGER = 8490
	Error_ds_cross_domain_cleanup_reqd_value: INTEGER = 8491
	Error_ds_illegal_xdom_move_operation_value: INTEGER = 8492
	Error_ds_cant_with_acct_group_membershps_value: INTEGER = 8493
	Error_ds_nc_must_have_nc_parent_value: INTEGER = 8494
	Error_ds_cr_impossible_to_validate_value: INTEGER = 8495
	Error_ds_dst_domain_not_native_value: INTEGER = 8496
	Error_ds_missing_infrastructure_container_value: INTEGER = 8497
	Error_ds_cant_move_account_group_value: INTEGER = 8498
	Error_ds_cant_move_resource_group_value: INTEGER = 8499
	Error_ds_invalid_search_flag_value: INTEGER = 8500
	Error_ds_no_tree_delete_above_nc_value: INTEGER = 8501
	Error_ds_couldnt_lock_tree_for_delete_value: INTEGER = 8502
	Error_ds_couldnt_identify_objects_for_tree_delete_value: INTEGER = 8503
	Error_ds_sam_init_failure_value: INTEGER = 8504
	Error_ds_sensitive_group_violation_value: INTEGER = 8505
	Error_ds_cant_mod_primarygroupid_value: INTEGER = 8506
	Error_ds_illegal_base_schema_mod_value: INTEGER = 8507
	Error_ds_nonsafe_schema_change_value: INTEGER = 8508
	Error_ds_schema_update_disallowed_value: INTEGER = 8509
	Error_ds_cant_create_under_schema_value: INTEGER = 8510
	Error_ds_install_no_src_sch_version_value: INTEGER = 8511
	Error_ds_install_no_sch_version_in_inifile_value: INTEGER = 8512
	Error_ds_invalid_group_type_value: INTEGER = 8513
	Error_ds_no_nest_globalgroup_in_mixeddomain_value: INTEGER = 8514
	Error_ds_no_nest_localgroup_in_mixeddomain_value: INTEGER = 8515
	Error_ds_global_cant_have_local_member_value: INTEGER = 8516
	Error_ds_global_cant_have_universal_member_value: INTEGER = 8517
	Error_ds_universal_cant_have_local_member_value: INTEGER = 8518
	Error_ds_global_cant_have_crossdomain_member_value: INTEGER = 8519
	Error_ds_local_cant_have_crossdomain_local_member_value: INTEGER = 8520
	Error_ds_have_primary_members_value: INTEGER = 8521
	Error_ds_string_sd_conversion_failed_value: INTEGER = 8522
	Error_ds_naming_master_gc_value: INTEGER = 8523
	Error_ds_dns_lookup_failure_value: INTEGER = 8524
	Error_ds_couldnt_update_spns_value: INTEGER = 8525
	Error_ds_cant_retrieve_sd_value: INTEGER = 8526
	Error_ds_key_not_unique_value: INTEGER = 8527
	Error_ds_wrong_linked_att_syntax_value: INTEGER = 8528
	Error_ds_sam_need_bootkey_password_value: INTEGER = 8529
	Error_ds_sam_need_bootkey_floppy_value: INTEGER = 8530
	Error_ds_cant_start_value: INTEGER = 8531
	Error_ds_init_failure_value: INTEGER = 8532
	Error_ds_no_pkt_privacy_on_connection_value: INTEGER = 8533
	Error_ds_source_domain_in_forest_value: INTEGER = 8534
	Error_ds_destination_domain_not_in_forest_value: INTEGER = 8535
	Error_ds_destination_auditing_not_enabled_value: INTEGER = 8536
	Error_ds_cant_find_dc_for_src_domain_value: INTEGER = 8537
	Error_ds_src_obj_not_group_or_user_value: INTEGER = 8538
	Error_ds_src_sid_exists_in_forest_value: INTEGER = 8539
	Error_ds_src_and_dst_object_class_mismatch_value: INTEGER = 8540
	Error_sam_init_failure_value: INTEGER = 8541
	Error_ds_dra_schema_info_ship_value: INTEGER = 8542
	Error_ds_dra_schema_conflict_value: INTEGER = 8543
	Error_ds_dra_earlier_schema_conflict_value: INTEGER = 8544
	Error_ds_dra_obj_nc_mismatch_value: INTEGER = 8545
	Error_ds_nc_still_has_dsas_value: INTEGER = 8546
	Error_ds_gc_required_value: INTEGER = 8547
	Error_ds_local_member_of_local_only_value: INTEGER = 8548
	Error_ds_no_fpo_in_universal_groups_value: INTEGER = 8549
	Error_ds_cant_add_to_gc_value: INTEGER = 8550
	Error_ds_no_checkpoint_with_pdc_value: INTEGER = 8551
	Error_ds_source_auditing_not_enabled_value: INTEGER = 8552
	Error_ds_cant_create_in_nondomain_nc_value: INTEGER = 8553
	Error_ds_invalid_name_for_spn_value: INTEGER = 8554
	Error_ds_filter_uses_contructed_attrs_value: INTEGER = 8555
	Error_ds_unicodepwd_not_in_quotes_value: INTEGER = 8556
	Error_ds_machine_account_quota_exceeded_value: INTEGER = 8557
	Error_ds_must_be_run_on_dst_dc_value: INTEGER = 8558
	Error_ds_src_dc_must_be_sp4_or_greater_value: INTEGER = 8559
	Error_ds_cant_tree_delete_critical_obj_value: INTEGER = 8560
	Dns_error_rcode_format_error_value: INTEGER = 9001
	Dns_error_rcode_server_failure_value: INTEGER = 9002
	Dns_error_rcode_name_error_value: INTEGER = 9003
	Dns_error_rcode_not_implemented_value: INTEGER = 9004
	Dns_error_rcode_refused_value: INTEGER = 9005
	Dns_error_rcode_yxdomain_value: INTEGER = 9006
	Dns_error_rcode_yxrrset_value: INTEGER = 9007
	Dns_error_rcode_nxrrset_value: INTEGER = 9008
	Dns_error_rcode_notauth_value: INTEGER = 9009
	Dns_error_rcode_notzone_value: INTEGER = 9010
	Dns_error_rcode_badsig_value: INTEGER = 9016
	Dns_error_rcode_badkey_value: INTEGER = 9017
	Dns_error_rcode_badtime_value: INTEGER = 9018
	Dns_info_no_records_value: INTEGER = 9501
	Dns_error_bad_packet_value: INTEGER = 9502
	Dns_error_no_packet_value: INTEGER = 9503
	Dns_error_rcode_value: INTEGER = 9504
	Dns_error_unsecure_packet_value: INTEGER = 9505
	Dns_error_invalid_type_value: INTEGER = 9551
	Dns_error_invalid_ip_address_value: INTEGER = 9552
	Dns_error_invalid_property_value: INTEGER = 9553
	Dns_error_try_again_later_value: INTEGER = 9554
	Dns_error_not_unique_value: INTEGER = 9555
	Dns_error_non_rfc_name_value: INTEGER = 9556
	Dns_status_fqdn_value: INTEGER = 9557
	Dns_status_dotted_name_value: INTEGER = 9558
	Dns_status_single_part_name_value: INTEGER = 9559
	Dns_error_invalid_name_char_value: INTEGER = 9560
	Dns_error_numeric_name_value: INTEGER = 9561
	Dns_error_zone_does_not_exist_value: INTEGER = 9601
	Dns_error_no_zone_info_value: INTEGER = 9602
	Dns_error_invalid_zone_operation_value: INTEGER = 9603
	Dns_error_zone_configuration_error_value: INTEGER = 9604
	Dns_error_zone_has_no_soa_record_value: INTEGER = 9605
	Dns_error_zone_has_no_ns_records_value: INTEGER = 9606
	Dns_error_zone_locked_value: INTEGER = 9607
	Dns_error_zone_creation_failed_value: INTEGER = 9608
	Dns_error_zone_already_exists_value: INTEGER = 9609
	Dns_error_autozone_already_exists_value: INTEGER = 9610
	Dns_error_invalid_zone_type_value: INTEGER = 9611
	Dns_error_secondary_requires_master_ip_value: INTEGER = 9612
	Dns_error_zone_not_secondary_value: INTEGER = 9613
	Dns_error_need_secondary_addresses_value: INTEGER = 9614
	Dns_error_wins_init_failed_value: INTEGER = 9615
	Dns_error_need_wins_servers_value: INTEGER = 9616
	Dns_error_nbstat_init_failed_value: INTEGER = 9617
	Dns_error_soa_delete_invalid_value: INTEGER = 9618
	Dns_error_primary_requires_datafile_value: INTEGER = 9651
	Dns_error_invalid_datafile_name_value: INTEGER = 9652
	Dns_error_datafile_open_failure_value: INTEGER = 9653
	Dns_error_file_writeback_failed_value: INTEGER = 9654
	Dns_error_datafile_parsing_value: INTEGER = 9655
	Dns_error_record_does_not_exist_value: INTEGER = 9701
	Dns_error_record_format_value: INTEGER = 9702
	Dns_error_node_creation_failed_value: INTEGER = 9703
	Dns_error_unknown_record_type_value: INTEGER = 9704
	Dns_error_record_timed_out_value: INTEGER = 9705
	Dns_error_name_not_in_zone_value: INTEGER = 9706
	Dns_error_cname_loop_value: INTEGER = 9707
	Dns_error_node_is_cname_value: INTEGER = 9708
	Dns_error_cname_collision_value: INTEGER = 9709
	Dns_error_record_only_at_zone_root_value: INTEGER = 9710
	Dns_error_record_already_exists_value: INTEGER = 9711
	Dns_error_secondary_data_value: INTEGER = 9712
	Dns_error_no_create_cache_data_value: INTEGER = 9713
	Dns_error_name_does_not_exist_value: INTEGER = 9714
	Dns_warning_ptr_create_failed_value: INTEGER = 9715
	Dns_warning_domain_undeleted_value: INTEGER = 9716
	Dns_error_ds_unavailable_value: INTEGER = 9717
	Dns_error_ds_zone_already_exists_value: INTEGER = 9718
	Dns_error_no_bootfile_if_ds_zone_value: INTEGER = 9719
	Dns_info_axfr_complete_value: INTEGER = 9751
	Dns_error_axfr_value: INTEGER = 9752
	Dns_info_added_local_wins_value: INTEGER = 9753
	Dns_status_continue_needed_value: INTEGER = 9801
	Dns_error_no_tcpip_value: INTEGER = 9851
	Dns_error_no_dns_servers_value: INTEGER = 9852
	Wsaeintr_value: INTEGER = 10004
	Wsaebadf_value: INTEGER = 10009
	Wsaeacces_value: INTEGER = 10013
	Wsaefault_value: INTEGER = 10014
	Wsaeinval_value: INTEGER = 10022
	Wsaemfile_value: INTEGER = 10024
	Wsaewouldblock_value: INTEGER = 10035
	Wsaeinprogress_value: INTEGER = 10036
	Wsaealready_value: INTEGER = 10037
	Wsaenotsock_value: INTEGER = 10038
	Wsaedestaddrreq_value: INTEGER = 10039
	Wsaemsgsize_value: INTEGER = 10040
	Wsaeprototype_value: INTEGER = 10041
	Wsaenoprotoopt_value: INTEGER = 10042
	Wsaeprotonosupport_value: INTEGER = 10043
	Wsaesocktnosupport_value: INTEGER = 10044
	Wsaeopnotsupp_value: INTEGER = 10045
	Wsaepfnosupport_value: INTEGER = 10046
	Wsaeafnosupport_value: INTEGER = 10047
	Wsaeaddrinuse_value: INTEGER = 10048
	Wsaeaddrnotavail_value: INTEGER = 10049
	Wsaenetdown_value: INTEGER = 10050
	Wsaenetunreach_value: INTEGER = 10051
	Wsaenetreset_value: INTEGER = 10052
	Wsaeconnaborted_value: INTEGER = 10053
	Wsaeconnreset_value: INTEGER = 10054
	Wsaenobufs_value: INTEGER = 10055
	Wsaeisconn_value: INTEGER = 10056
	Wsaenotconn_value: INTEGER = 10057
	Wsaeshutdown_value: INTEGER = 10058
	Wsaetoomanyrefs_value: INTEGER = 10059
	Wsaetimedout_value: INTEGER = 10060
	Wsaeconnrefused_value: INTEGER = 10061
	Wsaeloop_value: INTEGER = 10062
	Wsaenametoolong_value: INTEGER = 10063
	Wsaehostdown_value: INTEGER = 10064
	Wsaehostunreach_value: INTEGER = 10065
	Wsaenotempty_value: INTEGER = 10066
	Wsaeproclim_value: INTEGER = 10067
	Wsaeusers_value: INTEGER = 10068
	Wsaedquot_value: INTEGER = 10069
	Wsaestale_value: INTEGER = 10070
	Wsaeremote_value: INTEGER = 10071
	Wsasysnotready_value: INTEGER = 10091
	Wsavernotsupported_value: INTEGER = 10092
	Wsanotinitialised_value: INTEGER = 10093
	Wsaediscon_value: INTEGER = 10101
	Wsaenomore_value: INTEGER = 10102
	Wsaecancelled_value: INTEGER = 10103
	Wsaeinvalidproctable_value: INTEGER = 10104
	Wsaeinvalidprovider_value: INTEGER = 10105
	Wsaeproviderfailedinit_value: INTEGER = 10106
	Wsasyscallfailure_value: INTEGER = 10107
	Wsaservice_not_found_value: INTEGER = 10108
	Wsatype_not_found_value: INTEGER = 10109
	Wsa_e_no_more_value: INTEGER = 10110
	Wsa_e_cancelled_value: INTEGER = 10111
	Wsaerefused_value: INTEGER = 10112
	Wsahost_not_found_value: INTEGER = 11001
	Wsatry_again_value: INTEGER = 11002
	Wsano_recovery_value: INTEGER = 11003
	Wsano_data_value: INTEGER = 11004
	Wsa_qos_receivers_value: INTEGER = 11005
	Wsa_qos_senders_value: INTEGER = 11006
	Wsa_qos_no_senders_value: INTEGER = 11007
	Wsa_qos_no_receivers_value: INTEGER = 11008
	Wsa_qos_request_confirmed_value: INTEGER = 11009
	Wsa_qos_admission_failure_value: INTEGER = 11010
	Wsa_qos_policy_failure_value: INTEGER = 11011
	Wsa_qos_bad_style_value: INTEGER = 11012
	Wsa_qos_bad_object_value: INTEGER = 11013
	Wsa_qos_traffic_ctrl_error_value: INTEGER = 11014
	Wsa_qos_generic_error_value: INTEGER = 11015
	Wsa_qos_eservicetype_value: INTEGER = 11016
	Wsa_qos_eflowspec_value: INTEGER = 11017
	Wsa_qos_eprovspecbuf_value: INTEGER = 11018
	Wsa_qos_efilterstyle_value: INTEGER = 11019
	Wsa_qos_efiltertype_value: INTEGER = 11020
	Wsa_qos_efiltercount_value: INTEGER = 11021
	Wsa_qos_eobjlength_value: INTEGER = 11022
	Wsa_qos_eflowcount_value: INTEGER = 11023
	Wsa_qos_eunkownpsobj_value: INTEGER = 11024
	Wsa_qos_epolicyobj_value: INTEGER = 11025
	Wsa_qos_eflowdesc_value: INTEGER = 11026
	Wsa_qos_epsflowspec_value: INTEGER = 11027
	Wsa_qos_epsfilterspec_value: INTEGER = 11028
	Wsa_qos_esdmodeobj_value: INTEGER = 11029
	Wsa_qos_eshaperateobj_value: INTEGER = 11030
	Wsa_qos_reserved_petype_value: INTEGER = 11031;

	Max_error_code: INTEGER = 11031;

note
	copyright:	"Copyright (c) 1984-2017, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			Eiffel Software
			5949 Hollister Ave., Goleta, CA 93117 USA
			Telephone 805-685-1006, Fax 805-685-6869
			Website http://www.eiffel.com
			Customer support http://support.eiffel.com
		]"

end -- class WEL_WINDOWS_ERROR_MESSAGES

