note
	description: "Implemented `IEnumWorkItems' interface."
	generator: "Automatically generated by the EiffelCOM Wizard."

class
	IENUM_WORK_ITEMS_IMPL_PROXY

inherit
	IENUM_WORK_ITEMS_INTERFACE

	ECOM_QUERIABLE

create
	make_from_other,
	make_from_pointer

feature {NONE}  -- Initialization

	make_from_pointer (a_object: POINTER)
			-- Make from pointer
		do
			initializer := ccom_create_ienum_work_items_impl_proxy_from_pointer(a_object)
			item := ccom_item (initializer)
		end

feature -- Basic Operations

	next (celt: INTEGER; rgpwsz_names: CELL [CELL [STRING]]; pcelt_fetched: INTEGER_REF)
			-- Retrieves the next set of tasks in the enumeration sequence.
			-- `celt' [in].  
			-- `rgpwsz_names' [out].  
			-- `pcelt_fetched' [out].  
		do
			ccom_next (initializer, celt, rgpwsz_names, pcelt_fetched)
		end

	skip (celt: INTEGER)
			-- Skips the next set of tasks in the enumeration sequence.
			-- `celt' [in].  
		do
			ccom_skip (initializer, celt)
		end

	reset
			-- Resets the enumeration sequence to the beginning. 
		do
			ccom_reset (initializer)
		end

	clone1 (pp_enum_work_items: CELL [IENUM_WORK_ITEMS_INTERFACE])
			-- Creates a new enumeration object in the same state as the current enumeration object: the new object points to the same place in the enumeration sequence.
			-- `pp_enum_work_items' [out].  
		do
			ccom_clone1 (initializer, pp_enum_work_items)
		end

feature {NONE}  -- Implementation

	delete_wrapper
			-- Delete wrapper
		do
			ccom_delete_ienum_work_items_impl_proxy(initializer)
		end

feature {NONE}  -- Externals

	ccom_next (a_object: POINTER; celt: INTEGER; rgpwsz_names: CELL [CELL [STRING]]; pcelt_fetched: INTEGER_REF)
			-- Retrieves the next set of tasks in the enumeration sequence.
		external
			"C++ [ecom_MS_TaskSched_lib::IEnumWorkItems_impl_proxy %"ecom_MS_TaskSched_lib_IEnumWorkItems_impl_proxy.h%"](EIF_INTEGER,EIF_OBJECT,EIF_OBJECT)"
		end

	ccom_skip (a_object: POINTER; celt: INTEGER)
			-- Skips the next set of tasks in the enumeration sequence.
		external
			"C++ [ecom_MS_TaskSched_lib::IEnumWorkItems_impl_proxy %"ecom_MS_TaskSched_lib_IEnumWorkItems_impl_proxy.h%"](EIF_INTEGER)"
		end

	ccom_reset (a_object: POINTER)
			-- Resets the enumeration sequence to the beginning. 
		external
			"C++ [ecom_MS_TaskSched_lib::IEnumWorkItems_impl_proxy %"ecom_MS_TaskSched_lib_IEnumWorkItems_impl_proxy.h%"]()"
		end

	ccom_clone1 (a_object: POINTER; pp_enum_work_items: CELL [IENUM_WORK_ITEMS_INTERFACE])
			-- Creates a new enumeration object in the same state as the current enumeration object: the new object points to the same place in the enumeration sequence.
		external
			"C++ [ecom_MS_TaskSched_lib::IEnumWorkItems_impl_proxy %"ecom_MS_TaskSched_lib_IEnumWorkItems_impl_proxy.h%"](EIF_OBJECT)"
		end

	ccom_delete_ienum_work_items_impl_proxy (a_pointer: POINTER)
			-- Release resource
		external
			"C++ [delete ecom_MS_TaskSched_lib::IEnumWorkItems_impl_proxy %"ecom_MS_TaskSched_lib_IEnumWorkItems_impl_proxy.h%"]()"
		end

	ccom_create_ienum_work_items_impl_proxy_from_pointer (a_pointer: POINTER): POINTER
			-- Create from pointer
		external
			"C++ [new ecom_MS_TaskSched_lib::IEnumWorkItems_impl_proxy %"ecom_MS_TaskSched_lib_IEnumWorkItems_impl_proxy.h%"](IUnknown *)"
		end

	ccom_item (a_object: POINTER): POINTER
			-- Item
		external
			"C++ [ecom_MS_TaskSched_lib::IEnumWorkItems_impl_proxy %"ecom_MS_TaskSched_lib_IEnumWorkItems_impl_proxy.h%"](): EIF_POINTER"
		end

end -- IENUM_WORK_ITEMS_IMPL_PROXY


