/*
 * Code for class PATH
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "pa1129.h"
#include "eif_path_name.h"
#include "eif_built_in.h"
#include "eif_eiffel.h"
#include <ctype.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F1968_18827
static int inline_F1968_18827 (EIF_POINTER arg1, EIF_POINTER arg2)
{
	EIF_BOOLEAN Result = EIF_FALSE;
#ifdef EIF_WINDOWS
		/* To check this, we use `CreateFileW' to open both file, and then using the information
		 * returned by `GetFileInformationByHandle' we can check whether or not they are indeed
		 * the same.
		 * Note: it is important to use the W version of CreateFileW because arguments
		 * are Unicode, not ASCII. */
	BY_HANDLE_FILE_INFORMATION l_path1_info, l_path2_info;
	HANDLE l_path2_file = CreateFileW ((LPCWSTR) arg2, GENERIC_READ, FILE_SHARE_READ, NULL,
		OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	HANDLE l_path1_file = CreateFileW ((LPCWSTR) arg1, GENERIC_READ, FILE_SHARE_READ, NULL,
			OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);

	if ((l_path2_file == INVALID_HANDLE_VALUE) || (l_path1_file == INVALID_HANDLE_VALUE)) {
			/* We do not need the handles anymore, simply close them. Since Microsoft
			 * API accepts INVALID_HANDLE_VALUE we don't check the validity of arguments. */
		CloseHandle(l_path2_file);
		CloseHandle(l_path1_file);
	} else {
		BOOL success = GetFileInformationByHandle (l_path2_file, &l_path2_info);
		success = success && GetFileInformationByHandle (l_path1_file, &l_path1_info);
			/* We do not need the handles anymore, simply close them. */
		CloseHandle(l_path2_file);
		CloseHandle(l_path1_file);
		if (success) {
				/* Check that `path2' and `path1' do not represent the same file. */
			if
				((l_path2_info.dwVolumeSerialNumber == l_path1_info.dwVolumeSerialNumber) &&
				(l_path2_info.nFileIndexLow == l_path1_info.nFileIndexLow) &&
				(l_path2_info.nFileIndexHigh == l_path1_info.nFileIndexHigh))
			{
				Result = EIF_TRUE;
			}
		}
	}
#else
	struct stat buf1, buf2;
	int status;
	#ifdef HAS_LSTAT
		status = lstat(arg1, &buf1);
		if (status == 0) {
				/* We found a file, now let's check if it is not a symbolic link. If it is, we use `stat'
			 	 * to ensure the validity of the link. */
			if ((buf1.st_mode & S_IFLNK) == S_IFLNK) {
				status = stat (arg1, &buf1);
			}
		}
		
		if (status == 0) {
			status = lstat(arg2, &buf2);
			if (status == 0) {
					/* We found a file, now let's check if it is not a symbolic link. If it is, we use `stat'
				 	 * to ensure the validity of the link. */
				if ((buf2.st_mode & S_IFLNK) == S_IFLNK) {
					status = stat (arg2, &buf2);
				}
			}
		}
	#else
		status = stat (arg1, &buf1);
		if (status == 0) {
			status = stat (arg2, &buf2);
		}
	#endif
	if (status == 0) {
			/* Both files are present, check they represent the same one. */
		if ((buf1.st_dev == buf2.st_dev) && (buf1.st_ino == buf2.st_ino)) {
			Result = EIF_TRUE;
		}
	}
#endif
return Result;
	;
}
#define INLINE_F1968_18827
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {PATH}.make_empty */
void F1968_18766 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = RTLNSMART(eif_new_type(2217, 0).id);
	F2213_21539(RTCW(tr1));
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	{
		/* INLINED CODE (PATH.reset_internal_data) */
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {PATH}.make_current */
void F1968_18767 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = RTLNSMART(eif_new_type(2217, 0).id);
	ti4_1 = F1968_18812(Current);
	F2216_21669(RTCW(tr1), ti4_1);
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	tr1 = *(EIF_REFERENCE *)(Current);
	F2218_21794(RTCW(tr1), (EIF_CHARACTER_8) '.');
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
		tr1 = *(EIF_REFERENCE *)(Current);
		F2218_21794(RTCW(tr1), (EIF_CHARACTER_8) '\000');
	}
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	{
		/* INLINED CODE (PATH.reset_internal_data) */
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {PATH}.make_from_string */
void F1968_18768 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,arg1);
	RTLIU(3);
	
	RTGC;
	tr1 = RTLNSMART(eif_new_type(2217, 0).id);
	ti4_1 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R16822[Dtype(RTCW(arg1))-2216])(arg1);
	ti4_2 = F1968_18812(Current);
	F2216_21669(RTCW(tr1), (EIF_INTEGER_32) (ti4_1 * ti4_2));
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	tb1 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R16800[Dtype(RTCW(arg1))-2216])(arg1);
	if ((EIF_BOOLEAN) !tb1) {
		F1968_18821(Current, *(EIF_REFERENCE *)(Current), arg1, (EIF_CHARACTER_8) '\000');
		F1968_18814(Current);
	} else {
		*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	}
	{
		/* INLINED CODE (PATH.reset_internal_data) */
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {PATH}.make_from_storage */
void F1968_18770 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,arg1);
	RTLIU(2);
	
	RTGC;
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) arg1;
	F1968_18814(Current);
	{
		/* INLINED CODE (PATH.reset_internal_data) */
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {PATH}.make_from_normalized_storage */
void F1968_18771 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,arg1);
	RTLIU(2);
	
	RTGC;
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) arg1;
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	{
		/* INLINED CODE (PATH.reset_internal_data) */
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {PATH}.make_from_pointer */
void F1968_18772 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,loc1);
	RTLR(2,tr1);
	RTLIU(3);
	
	RTGC;
	loc2 = F753_10592(Current, arg1);
	{
		/* INLINED CODE (PATH.unit_size) */
		ti4_1 = (EIF_INTEGER_32)  0;
		tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
		if (tb1) {
			ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
		} else {
			ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		}
		/* END INLINED CODE */
	}
	loc2 -= (EIF_INTEGER_32) (loc2 % ti4_1);
	loc1 = RTLNS(eif_new_type(877, 0x00).id, 877, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F878_12745(RTCW(loc1), arg1, loc2);
	tr1 = F878_12752(RTCW(loc1), ((EIF_INTEGER_32) 1L), loc2);
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	tr1 = *(EIF_REFERENCE *)(Current);
	{
		/* INLINED CODE (FINITE.is_empty) */
		tb1 = (EIF_BOOLEAN)  0;
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tb1 = tb1;
	if ((EIF_BOOLEAN) !tb1) {
		F1968_18814(Current);
	}
	{
		/* INLINED CODE (PATH.reset_internal_data) */
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {PATH}.is_current_symbol */
EIF_BOOLEAN F1968_18773 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	{
		/* INLINED CODE (PATH.unit_size) */
		ti4_2 = (EIF_INTEGER_32)  0;
		tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
		if (tb1) {
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
		} else {
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		}
		/* END INLINED CODE */
	}
	if ((EIF_BOOLEAN)(ti4_1 == ti4_2)) {
		RTLE;
		return (EIF_BOOLEAN) F1968_18824(Current, *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '.');
	}
	RTLE;
	return (EIF_BOOLEAN) 0;
}

/* {PATH}.is_parent_symbol */
EIF_BOOLEAN F1968_18774 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	{
		/* INLINED CODE (PATH.unit_size) */
		ti4_2 = (EIF_INTEGER_32)  0;
		tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
		if (tb1) {
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
		} else {
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		}
		/* END INLINED CODE */
	}
	if ((EIF_BOOLEAN)(ti4_1 == (EIF_INTEGER_32) (((EIF_INTEGER_32) 2L) * ti4_2))) {
		Result = F1968_18824(Current, *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '.');
		tr1 = *(EIF_REFERENCE *)(Current);
		{
			/* INLINED CODE (PATH.unit_size) */
			ti4_1 = (EIF_INTEGER_32)  0;
			tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
			if (tb1) {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
			} else {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
			/* END INLINED CODE */
		}
		ti4_2 = ti4_1;
		Result = F1968_18824(Current, tr1, (EIF_INTEGER_32) (((EIF_INTEGER_32) 1L) + ti4_2), (EIF_CHARACTER_8) '.');
	}
	RTLE;
	return Result;
}

/* {PATH}.has_root */
EIF_BOOLEAN F1968_18775 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTGC;
	ti4_1 = F1968_18818(Current);
	Result = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 != ((EIF_INTEGER_32) 0L));
	RTLE;
	return Result;
}

/* {PATH}.is_empty */
EIF_BOOLEAN F1968_18776 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	{
		/* INLINED CODE (FINITE.is_empty) */
		tb1 = (EIF_BOOLEAN)  0;
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	Result = tb1;
	RTLE;
	return Result;
}

/* {PATH}.is_relative */
EIF_BOOLEAN F1968_18777 (EIF_REFERENCE Current)
{
	GTCX
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTGC;
	Result = F1968_18778(Current);
	Result = (EIF_BOOLEAN) (EIF_BOOLEAN) !Result;
	RTLE;
	return Result;
}

/* {PATH}.is_absolute */
EIF_BOOLEAN F1968_18778 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	loc1 = F1968_18818(Current);
	if ((EIF_BOOLEAN) (loc1 > ((EIF_INTEGER_32) 0L))) {
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
			tr1 = *(EIF_REFERENCE *)(Current);
			{
				/* INLINED CODE (PATH.unit_size) */
				ti4_1 = (EIF_INTEGER_32)  0;
				tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
				if (tb1) {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
				} else {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
				}
				/* END INLINED CODE */
			}
			ti4_2 = ti4_1;
			{
				/* INLINED CODE (PATH.directory_separator) */
				tc1 = (EIF_CHARACTER_8)  0;
				tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
				if (tb1) {
					tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
				} else {
					tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
				}
				/* END INLINED CODE */
			}
			tc2 = tc1;
			Result = F1968_18824(Current, tr1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (loc1 - ti4_2) + ((EIF_INTEGER_32) 1L)), tc2);
		} else {
			RTLE;
			return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.is_same_file_as */
EIF_BOOLEAN F1968_18780 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_POINTER tp2;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,loc2);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTGC;
	loc1 = F1968_18809(Current);
	loc2 = F1968_18809(RTCW(arg1));
	tp1 = *(EIF_POINTER *)(RTCW(loc1)+ _PTROFF_0_1_0_1_0_0_);
	tp2 = *(EIF_POINTER *)(RTCW(loc2)+ _PTROFF_0_1_0_1_0_0_);
	Result = EIF_TEST (inline_F1968_18827(tp1, tp2));
	RTLE;
	return Result;
}

/* {PATH}.has_extension */
EIF_BOOLEAN F1968_18781 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTGC;
	Result = '\0';
	tr1 = F1968_18785(Current);
	loc1 = tr1;
	if (EIF_TEST(loc1)) {
		tb1 = F2213_21581(loc1, arg1);
		Result = tb1;
	}
	RTLE;
	return Result;
}

/* {PATH}.root */
EIF_REFERENCE F1968_18782 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLIU(3);
	
	RTGC;
	loc1 = F1968_18818(Current);
	if ((EIF_BOOLEAN)(loc1 != ((EIF_INTEGER_32) 0L))) {
		tr1 = *(EIF_REFERENCE *)(Current);
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		if ((EIF_BOOLEAN)(loc1 == ti4_1)) {
			tr1 = RTLNS(eif_new_type(1967, 0x00).id, 1967, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F1968_18771(RTCW(tr1), *(EIF_REFERENCE *)(Current));
			RTLE;
			return (EIF_REFERENCE) tr1;
		} else {
			Result = RTLNS(eif_new_type(1967, 0x00).id, 1967, _OBJSIZ_2_1_0_0_0_0_0_0_);
			tr1 = *(EIF_REFERENCE *)(Current);
			tr1 = F2218_21826(RTCW(tr1), ((EIF_INTEGER_32) 1L), loc1);
			F1968_18771(RTCW(Result), tr1);
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.parent */
EIF_REFERENCE F1968_18783 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,loc3);
	RTLR(2,tr1);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	loc1 = F1968_18819(Current);
	if ((EIF_BOOLEAN)(loc1 == ((EIF_INTEGER_32) 0L))) {
		tr1 = F1968_18782(Current);
		loc3 = tr1;
		if (EIF_TEST(loc3)) {
			RTLE;
			return (EIF_REFERENCE) loc3;
		} else {
			tr1 = RTLNS(eif_new_type(1967, 0x00).id, 1967, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F1968_18767(RTCW(tr1));
			RTLE;
			return (EIF_REFERENCE) tr1;
		}
	} else {
		{
			/* INLINED CODE (PATH.unit_size) */
			ti4_1 = (EIF_INTEGER_32)  0;
			tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
			if (tb1) {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
			} else {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
			/* END INLINED CODE */
		}
		if ((EIF_BOOLEAN)(loc1 == ti4_1)) {
			Result = RTLNS(eif_new_type(1967, 0x00).id, 1967, _OBJSIZ_2_1_0_0_0_0_0_0_);
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = F1968_18812(Current);
			tr1 = F2218_21826(RTCW(tr1), ((EIF_INTEGER_32) 1L), ti4_1);
			F1968_18771(RTCW(Result), tr1);
		} else {
			loc2 = F1968_18818(Current);
			if ((EIF_BOOLEAN) (loc1 <= loc2)) {
				tr1 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
				if ((EIF_BOOLEAN)(loc2 == ti4_1)) {
					RTLE;
					return (EIF_REFERENCE) Current;
				} else {
					Result = RTLNS(eif_new_type(1967, 0x00).id, 1967, _OBJSIZ_2_1_0_0_0_0_0_0_);
					tr1 = *(EIF_REFERENCE *)(Current);
					tr1 = F2218_21826(RTCW(tr1), ((EIF_INTEGER_32) 1L), loc2);
					F1968_18771(RTCW(Result), tr1);
				}
			} else {
				Result = RTLNS(eif_new_type(1967, 0x00).id, 1967, _OBJSIZ_2_1_0_0_0_0_0_0_);
				tr1 = *(EIF_REFERENCE *)(Current);
				ti4_1 = F1968_18812(Current);
				tr1 = F2218_21826(RTCW(tr1), ((EIF_INTEGER_32) 1L), (EIF_INTEGER_32) (loc1 - ti4_1));
				F1968_18771(RTCW(Result), tr1);
			}
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.entry */
EIF_REFERENCE F1968_18784 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	loc1 = F1968_18819(Current);
	if ((EIF_BOOLEAN)(loc1 == ((EIF_INTEGER_32) 0L))) {
		loc2 = F1968_18818(Current);
		if ((EIF_BOOLEAN) (loc2 > ((EIF_INTEGER_32) 0L))) {
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
			if ((EIF_BOOLEAN) (loc2 < ti4_1)) {
				Result = RTLNS(eif_new_type(1967, 0x00).id, 1967, _OBJSIZ_2_1_0_0_0_0_0_0_);
				tr1 = *(EIF_REFERENCE *)(Current);
				tr2 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2)+ _LNGOFF_1_1_0_2_);
				tr1 = F2218_21826(RTCW(tr1), (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)), ti4_1);
				F1968_18771(RTCW(Result), tr1);
			}
		} else {
			Result = (EIF_REFERENCE) Current;
		}
	} else {
		loc2 = F1968_18818(Current);
		if ((EIF_BOOLEAN) (loc1 <= loc2)) {
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
			if ((EIF_BOOLEAN) (loc2 < ti4_1)) {
				Result = RTLNS(eif_new_type(1967, 0x00).id, 1967, _OBJSIZ_2_1_0_0_0_0_0_0_);
				tr1 = *(EIF_REFERENCE *)(Current);
				tr2 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2)+ _LNGOFF_1_1_0_2_);
				tr1 = F2218_21826(RTCW(tr1), (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)), ti4_1);
				F1968_18771(RTCW(Result), tr1);
			}
		} else {
			Result = RTLNS(eif_new_type(1967, 0x00).id, 1967, _OBJSIZ_2_1_0_0_0_0_0_0_);
			tr1 = *(EIF_REFERENCE *)(Current);
			tr2 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2)+ _LNGOFF_1_1_0_2_);
			tr1 = F2218_21826(RTCW(tr1), (EIF_INTEGER_32) (loc1 + ((EIF_INTEGER_32) 1L)), ti4_1);
			F1968_18771(RTCW(Result), tr1);
		}
	}
	tb1 = '\0';
	if ((EIF_BOOLEAN)(Result != NULL)) {
		tb2 = '\01';
		tb3 = '\01';
		{
			/* INLINED CODE (PATH.is_empty) */
			tb4 = (EIF_BOOLEAN)  0;
			tr1 = *(EIF_REFERENCE *)(RTCW(Result));
			tb4 = F1312_14086(RTCW(tr1));
			/* END INLINED CODE */
		}
		tb4 = tb4;
		if (!tb4) {
			{
				/* INLINED CODE (PATH.is_current_symbol) */
				tb4 = (EIF_BOOLEAN)  0;
				tr1 = *(EIF_REFERENCE *)(RTCW(Result));
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
				ti4_2 = F1968_18812(RTCW(Result));
				if ((EIF_BOOLEAN)(ti4_1 == ti4_2)) {
					tb4 = F1968_18824(RTCW(Result), *(EIF_REFERENCE *)(RTCW(Result)), ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '.');
				}
				/* END INLINED CODE */
			}
			tb4 = tb4;
			tb3 = tb4;
		}
		if (!tb3) {
			tb3 = F1968_18774(RTCW(Result));
			tb2 = tb3;
		}
		tb1 = tb2;
	}
	if (tb1) {
		RTLE;
		return (EIF_REFERENCE) NULL;
	}
	RTLE;
	return Result;
}

/* {PATH}.extension */
EIF_REFERENCE F1968_18785 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_CHARACTER_32 tw1;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc4);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc1);
	RTLIU(4);
	
	RTGC;
	tr1 = F1968_18784(Current);
	loc4 = tr1;
	if (EIF_TEST(loc4)) {
		loc1 = F1968_18807(loc4);
		loc3 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_0_0_2_);
		tw1 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '.';
		loc2 = F2220_21844(RTCW(loc1), tw1, loc3);
		if ((EIF_BOOLEAN) ((EIF_BOOLEAN)(loc2 != ((EIF_INTEGER_32) 0L)) && (EIF_BOOLEAN)(loc2 != loc3))) {
			tr1 = F2221_21898(RTCW(loc1), (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)), loc3);
			RTLE;
			return (EIF_REFERENCE) tr1;
		}
	}
	RTLE;
	return (EIF_REFERENCE) 0;
}

/* {PATH}.components */
EIF_REFERENCE F1968_18786 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,Result);
	RTLR(2,loc1);
	RTLR(3,tr1);
	RTLIU(4);
	
	RTGC;
	{
		static EIF_TYPE_INDEX typarr0[] = {1522,1967,0xFFFF};
		EIF_TYPE typres0;
		static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
		
		typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), typarr0)));
		Result = RTLNS(typres0.id, 1522, _OBJSIZ_1_1_0_1_0_0_0_0_);
	}
	F1523_14940(RTCW(Result), ((EIF_INTEGER_32) 10L));
	loc3 = F1968_18818(Current);
	if ((EIF_BOOLEAN) (loc3 > ((EIF_INTEGER_32) 0L))) {
		loc1 = RTLNS(eif_new_type(2217, 0x00).id, 2217, _OBJSIZ_1_1_0_3_0_0_0_0_);
		F2216_21669(RTCW(loc1), loc3);
		F2218_21781(RTCW(loc1), *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 1L), loc3);
		tr1 = RTLNS(eif_new_type(1967, 0x00).id, 1967, _OBJSIZ_2_1_0_0_0_0_0_0_);
		F1968_18771(RTCW(tr1), loc1);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R11865[Dtype(RTCW(Result))-1210])(Result, tr1);
		loc3++;
	} else {
		loc3 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	}
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	if ((EIF_BOOLEAN) (loc3 <= ti4_1)) {
		loc2 = (EIF_INTEGER_32) loc3;
		loc3 = F1968_18820(Current, loc2);
		for (;;) {
			if ((EIF_BOOLEAN)(loc3 == ((EIF_INTEGER_32) 0L))) break;
			loc1 = RTLNS(eif_new_type(2217, 0x00).id, 2217, _OBJSIZ_1_1_0_3_0_0_0_0_);
			F2216_21669(RTCW(loc1), (EIF_INTEGER_32) (loc3 - loc2));
			F2218_21781(RTCW(loc1), *(EIF_REFERENCE *)(Current), loc2, (EIF_INTEGER_32) (loc3 - ((EIF_INTEGER_32) 1L)));
			tr1 = RTLNS(eif_new_type(1967, 0x00).id, 1967, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F1968_18771(RTCW(tr1), loc1);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R11865[Dtype(RTCW(Result))-1210])(Result, tr1);
			{
				/* INLINED CODE (PATH.unit_size) */
				ti4_1 = (EIF_INTEGER_32)  0;
				tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
				if (tb1) {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
				} else {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
				}
				/* END INLINED CODE */
			}
			loc2 = ti4_1;
			loc2 = (EIF_INTEGER_32) (EIF_INTEGER_32) (loc3 + loc2);
			loc3 = F1968_18820(Current, loc2);
		}
		tr1 = *(EIF_REFERENCE *)(Current);
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		if ((EIF_BOOLEAN) (loc2 <= ti4_1)) {
			loc1 = RTLNS(eif_new_type(2217, 0x00).id, 2217, _OBJSIZ_1_1_0_3_0_0_0_0_);
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
			F2216_21669(RTCW(loc1), (EIF_INTEGER_32) (ti4_1 - loc2));
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
			F2218_21781(RTCW(loc1), *(EIF_REFERENCE *)(Current), loc2, ti4_1);
			tr1 = RTLNS(eif_new_type(1967, 0x00).id, 1967, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F1968_18771(RTCW(tr1), loc1);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R11865[Dtype(RTCW(Result))-1210])(Result, tr1);
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.absolute_path */
EIF_REFERENCE F1968_18787 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLIU(3);
	
	RTGC;
	tr1 = F755_10617(RTCV(RTOSCF(18817,F1968_18817, (Current))));
	Result = F1968_18788(Current, tr1);
	RTLE;
	return Result;
}

/* {PATH}.absolute_path_in */
EIF_REFERENCE F1968_18788 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE tr3 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(8);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,arg1);
	RTLR(3,loc1);
	RTLR(4,tr2);
	RTLR(5,tr3);
	RTLR(6,Result);
	RTLR(7,loc2);
	RTLIU(8);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	{
		/* INLINED CODE (FINITE.is_empty) */
		tb1 = (EIF_BOOLEAN)  0;
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tb1 = tb1;
	if (tb1) {
		RTLE;
		return (EIF_REFERENCE) arg1;
	} else {
		if (F1968_18778(Current)) {
			RTLE;
			return (EIF_REFERENCE) Current;
		} else {
			if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
				tr1 = F1968_18782(Current);
				loc1 = tr1;
				if (EIF_TEST(loc1)) {
					tb1 = '\0';
					tb2 = '\0';
					tr1 = *(EIF_REFERENCE *)(loc1);
					ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
					if ((EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 4L))) {
						tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
						ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
						tb2 = (EIF_BOOLEAN) (ti4_1 >= ((EIF_INTEGER_32) 4L));
					}
					if (tb2) {
						tb2 = '\0';
						tr1 = *(EIF_REFERENCE *)(loc1);
						{
							/* INLINED CODE (STRING_8.item) */
							ti4_1 = ((EIF_INTEGER_32) 1L);
							tc1 = (EIF_CHARACTER_8)  0;
							tr2 = tr1;
							tr3 = *(EIF_REFERENCE *)(RTCW(tr2));
							tc1 = 
								/* INLINED CODE (SPECIAL.item) */
								*((EIF_CHARACTER_8 *)RTCW(tr3) + ((EIF_INTEGER_32) (ti4_1 - ((EIF_INTEGER_32) 1L))))
								/* END INLINED CODE */;
							/* END INLINED CODE */
						}
						tc1 = tc1;
						tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
						{
							/* INLINED CODE (STRING_8.item) */
							ti4_1 = ((EIF_INTEGER_32) 1L);
							tc2 = (EIF_CHARACTER_8)  0;
							tr2 = tr1;
							tr3 = *(EIF_REFERENCE *)(RTCW(tr2));
							tc2 = 
								/* INLINED CODE (SPECIAL.item) */
								*((EIF_CHARACTER_8 *)RTCW(tr3) + ((EIF_INTEGER_32) (ti4_1 - ((EIF_INTEGER_32) 1L))))
								/* END INLINED CODE */;
							/* END INLINED CODE */
						}
						tc2 = tc2;
						if ((EIF_BOOLEAN)(tc1 == tc2)) {
							tr1 = *(EIF_REFERENCE *)(loc1);
							{
								/* INLINED CODE (STRING_8.item) */
								ti4_1 = ((EIF_INTEGER_32) 3L);
								tc1 = (EIF_CHARACTER_8)  0;
								tr2 = tr1;
								tr3 = *(EIF_REFERENCE *)(RTCW(tr2));
								tc1 = 
									/* INLINED CODE (SPECIAL.item) */
									*((EIF_CHARACTER_8 *)RTCW(tr3) + ((EIF_INTEGER_32) (ti4_1 - ((EIF_INTEGER_32) 1L))))
									/* END INLINED CODE */;
								/* END INLINED CODE */
							}
							tc1 = tc1;
							tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
							{
								/* INLINED CODE (STRING_8.item) */
								ti4_1 = ((EIF_INTEGER_32) 3L);
								tc2 = (EIF_CHARACTER_8)  0;
								tr2 = tr1;
								tr3 = *(EIF_REFERENCE *)(RTCW(tr2));
								tc2 = 
									/* INLINED CODE (SPECIAL.item) */
									*((EIF_CHARACTER_8 *)RTCW(tr3) + ((EIF_INTEGER_32) (ti4_1 - ((EIF_INTEGER_32) 1L))))
									/* END INLINED CODE */;
								/* END INLINED CODE */
							}
							tc2 = tc2;
							tb2 = (EIF_BOOLEAN)(tc1 == tc2);
						}
						tb1 = tb2;
					}
					if (tb1) {
						Result = (EIF_REFERENCE) eif_builtin_ANY_twin (arg1);
					} else {
						Result = (EIF_REFERENCE) loc1;
					}
					tr1 = *(EIF_REFERENCE *)(RTCW(Result));
					tr2 = *(EIF_REFERENCE *)(Current);
					tr3 = *(EIF_REFERENCE *)(loc1);
					ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr3)+ _LNGOFF_1_1_0_2_);
					tr3 = *(EIF_REFERENCE *)(Current);
					ti4_2 = *(EIF_INTEGER_32 *)(RTCW(tr3)+ _LNGOFF_1_1_0_2_);
					{
						/* INLINED CODE (PATH.directory_separator) */
						tc1 = (EIF_CHARACTER_8)  0;
						tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
						if (tb1) {
							tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
						} else {
							tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
						}
						/* END INLINED CODE */
					}
					tc2 = tc1;
					F1968_18823(Current, tr1, tr2, (EIF_INTEGER_32) (ti4_1 + ((EIF_INTEGER_32) 1L)), ti4_2, tc2);
				} else {
					if (F1968_18824(Current, *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '\\')) {
						Result = (EIF_REFERENCE) eif_builtin_ANY_twin (arg1);
						tr1 = F1968_18782(RTCW(Result));
						loc2 = tr1;
						if (EIF_TEST(loc2)) {
							Result = (EIF_REFERENCE) loc2;
						}
					} else {
						Result = (EIF_REFERENCE) eif_builtin_ANY_twin (arg1);
					}
					tr1 = *(EIF_REFERENCE *)(RTCW(Result));
					tr2 = *(EIF_REFERENCE *)(Current);
					{
						/* INLINED CODE (PATH.directory_separator) */
						tc1 = (EIF_CHARACTER_8)  0;
						tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
						if (tb1) {
							tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
						} else {
							tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
						}
						/* END INLINED CODE */
					}
					tc2 = tc1;
					F1968_18822(Current, tr1, tr2, tc2);
				}
			} else {
				Result = (EIF_REFERENCE) eif_builtin_ANY_twin (arg1);
				tr1 = *(EIF_REFERENCE *)(RTCW(Result));
				tr2 = *(EIF_REFERENCE *)(Current);
				{
					/* INLINED CODE (PATH.directory_separator) */
					tc1 = (EIF_CHARACTER_8)  0;
					tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
					if (tb1) {
						tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
					} else {
						tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
					}
					/* END INLINED CODE */
				}
				tc2 = tc1;
				F1968_18822(Current, tr1, tr2, tc2);
			}
			{
				/* INLINED CODE (PATH.reset_internal_data) */
				*(EIF_REFERENCE *)(RTCW(Result) + _REFACS_1_) = (EIF_REFERENCE) NULL;
				/* END INLINED CODE */
			}
			;
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.canonical_path */
EIF_REFERENCE F1968_18789 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc5 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE tr3 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	RTLD;
	
	RTLI(9);
	RTLR(0,loc2);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLR(4,loc4);
	RTLR(5,loc3);
	RTLR(6,loc1);
	RTLR(7,tr3);
	RTLR(8,loc5);
	RTLIU(9);
	
	RTGC;
	{
		/* INLINED CODE (PATH.absolute_path) */
		tr1 = (EIF_REFERENCE)  0;
		tr2 = RTOSCF(18817,F1968_18817, (Current));
		tr2 = F755_10617(RTCW(tr2));
		tr1 = F1968_18788(Current, tr2);
		/* END INLINED CODE */
	}
	loc2 = tr1;
	tr1 = F1968_18782(RTCW(loc2));
	loc4 = tr1;
	if (EIF_TEST(loc4)) {
		loc3 = RTLNSMART(eif_new_type(2217, 0).id);
		tr1 = *(EIF_REFERENCE *)(RTCW(loc2));
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		F2216_21669(RTCW(loc3), ti4_1);
		loc1 = F1968_18786(RTCW(loc2));
		{
			/* INLINED CODE (ARRAYED_LIST.start) */
			*(EIF_INTEGER_32 *)(RTCW(loc1) + O12384[Dtype(loc1)-1522]) = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			/* END INLINED CODE */
		}
		;
		{
			/* INLINED CODE (ARRAYED_LIST.item) */
			tr1 = (EIF_REFERENCE)  0;
			tr1 = *(EIF_REFERENCE *)(RTCW(loc1));
			tr1 = 
				/* INLINED CODE (SPECIAL.item) */
				*((EIF_REFERENCE *)RTCW(tr1) + ((EIF_INTEGER_32) (*(EIF_INTEGER_32 *)(RTCW(loc1) + O12384[Dtype(loc1)-1522]) - ((EIF_INTEGER_32) 1L))))
				/* END INLINED CODE */;
			/* END INLINED CODE */
		}
		tr1 = tr1;
		tr1 = *(EIF_REFERENCE *)(RTCW(tr1));
		{
			/* INLINED CODE (PATH.directory_separator) */
			tc1 = (EIF_CHARACTER_8)  0;
			tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
			if (tb1) {
				tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
			} else {
				tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
			}
			/* END INLINED CODE */
		}
		tc2 = tc1;
		F1968_18822(Current, loc3, tr1, tc2);
		(FUNCTION_CAST(void, (EIF_REFERENCE)) R11916[Dtype(RTCW(loc1))-1372])(loc1);
		for (;;) {
			{
				/* INLINED CODE (LIST.after) */
				tb1 = (EIF_BOOLEAN)  0;
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1) + O12384[Dtype(loc1)-1522]);
				ti4_2 = F1523_14961(RTCW(loc1));
				tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == (EIF_INTEGER_32) (ti4_2 + ((EIF_INTEGER_32) 1L)));
				/* END INLINED CODE */
			}
			tb1 = tb1;
			if (tb1) break;
			{
				/* INLINED CODE (ARRAYED_LIST.item) */
				tr1 = (EIF_REFERENCE)  0;
				tr1 = *(EIF_REFERENCE *)(RTCW(loc1));
				tr1 = 
					/* INLINED CODE (SPECIAL.item) */
					*((EIF_REFERENCE *)RTCW(tr1) + ((EIF_INTEGER_32) (*(EIF_INTEGER_32 *)(RTCW(loc1) + O12384[Dtype(loc1)-1522]) - ((EIF_INTEGER_32) 1L))))
					/* END INLINED CODE */;
				/* END INLINED CODE */
			}
			tr1 = tr1;
			{
				/* INLINED CODE (PATH.is_current_symbol) */
				tb2 = (EIF_BOOLEAN)  0;
				tr2 = tr1;
				tr3 = *(EIF_REFERENCE *)(RTCW(tr2));
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr3)+ _LNGOFF_1_1_0_2_);
				ti4_2 = F1968_18812(RTCW(tr2));
				if ((EIF_BOOLEAN)(ti4_1 == ti4_2)) {
					tb2 = F1968_18824(RTCW(tr2), *(EIF_REFERENCE *)(RTCW(tr2)), ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '.');
				}
				/* END INLINED CODE */
			}
			tb2 = tb2;
			if (tb2) {
				(FUNCTION_CAST(void, (EIF_REFERENCE)) R11916[Dtype(RTCW(loc1))-1372])(loc1);
			} else {
				{
					/* INLINED CODE (ARRAYED_LIST.item) */
					tr1 = (EIF_REFERENCE)  0;
					tr1 = *(EIF_REFERENCE *)(RTCW(loc1));
					tr1 = 
						/* INLINED CODE (SPECIAL.item) */
						*((EIF_REFERENCE *)RTCW(tr1) + ((EIF_INTEGER_32) (*(EIF_INTEGER_32 *)(RTCW(loc1) + O12384[Dtype(loc1)-1522]) - ((EIF_INTEGER_32) 1L))))
						/* END INLINED CODE */;
					/* END INLINED CODE */
				}
				tr1 = tr1;
				tb2 = F1968_18774(RTCW(tr1));
				if (tb2) {
					{
						/* INLINED CODE (CHAIN.isfirst) */
						tb2 = (EIF_BOOLEAN)  0;
						tb2 = '\0';
						tb3 = F1304_14086(RTCW(loc1));
						if ((EIF_BOOLEAN) !tb3) {
							ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1) + O12384[Dtype(loc1)-1522]);
							tb2 = (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 1L));
						}
						/* END INLINED CODE */
					}
					tb2 = tb2;
					if ((EIF_BOOLEAN) !tb2) {
						{
							/* INLINED CODE (ARRAYED_LIST.back) */
							(*(EIF_INTEGER_32 *)(RTCW(loc1) + O12384[Dtype(loc1)-1522]))--;
							/* END INLINED CODE */
						}
						;
						(FUNCTION_CAST(void, (EIF_REFERENCE)) R11916[Dtype(RTCW(loc1))-1372])(loc1);
					}
					(FUNCTION_CAST(void, (EIF_REFERENCE)) R11916[Dtype(RTCW(loc1))-1372])(loc1);
				} else {
					{
						/* INLINED CODE (ARRAYED_LIST.forth) */
						(*(EIF_INTEGER_32 *)(RTCW(loc1) + O12384[Dtype(loc1)-1522]))++;
						/* END INLINED CODE */
					}
					;
				}
			}
		}
		loc5 = F1523_14954(RTCW(loc1));
		for (;;) {
			{
				/* INLINED CODE (GENERAL_SPECIAL_ITERATION_CURSOR.after) */
				tb2 = (EIF_BOOLEAN)  0;
				ti4_1 = *(EIF_INTEGER_32 *)(loc5+ _LNGOFF_2_0_0_0_);
				ti4_2 = *(EIF_INTEGER_32 *)(loc5+ _LNGOFF_2_0_0_1_);
				tb2 = (EIF_BOOLEAN) (EIF_BOOLEAN) (ti4_1 > ti4_2);
				/* END INLINED CODE */
			}
			tb2 = tb2;
			if (tb2) break;
			{
				/* INLINED CODE (GENERAL_SPECIAL_ITERATION_CURSOR.item) */
				tr1 = (EIF_REFERENCE)  0;
				tr2 = *(EIF_REFERENCE *)(loc5);
				tr1 = 
					/* INLINED CODE (SPECIAL.item) */
					*((EIF_REFERENCE *)RTCW(tr2) + (*(EIF_INTEGER_32 *)(loc5+ _LNGOFF_2_0_0_0_)))
					/* END INLINED CODE */;
				/* END INLINED CODE */
			}
			tr1 = tr1;
			tr1 = *(EIF_REFERENCE *)(RTCW(tr1));
			{
				/* INLINED CODE (PATH.directory_separator) */
				tc1 = (EIF_CHARACTER_8)  0;
				tb3 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
				if (tb3) {
					tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
				} else {
					tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
				}
				/* END INLINED CODE */
			}
			tc2 = tc1;
			F1968_18822(Current, loc3, tr1, tc2);
			{
				/* INLINED CODE (GENERAL_SPECIAL_ITERATION_CURSOR.forth) */
				(*(EIF_INTEGER_32 *)(loc5+ _LNGOFF_2_0_0_0_))++;
				/* END INLINED CODE */
			}
			;
		}
		tr1 = RTLNS(eif_new_type(1967, 0x00).id, 1967, _OBJSIZ_2_1_0_0_0_0_0_0_);
		F1968_18771(RTCW(tr1), loc3);
		RTLE;
		return (EIF_REFERENCE) tr1;
	} else {
		RTLE;
		return (EIF_REFERENCE) loc2;
	}/* NOTREACHED */
	
}

/* {PATH}.hash_code */
EIF_INTEGER_32 F1968_18790 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	if ((EIF_BOOLEAN) EIF_TEST(eif_case_sensitive_path_names())) {
		tr1 = *(EIF_REFERENCE *)(Current);
		Result = F2213_21548(RTCW(tr1));
	} else {
		Result = F2213_21549(RTCV(F1968_18807(Current)));
	}
	RTLE;
	return Result;
}

/* {PATH}.directory_separator */
EIF_CHARACTER_8 F1968_18794 (EIF_REFERENCE Current)
{
	GTCX
	
	
	RTGC;
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
		return (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
	} else {
		return (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
	}/* NOTREACHED */
	
}

/* {PATH}.extended */
EIF_REFERENCE F1968_18795 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_INTEGER_32 ti4_4;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTGC;
	loc1 = RTLNSMART(eif_new_type(2217, 0).id);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R16822[Dtype(RTCW(arg1))-2216])(arg1);
	ti4_3 = F1968_18812(Current);
	ti4_4 = F1968_18812(Current);
	F2216_21669(RTCW(loc1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + (EIF_INTEGER_32) (ti4_2 * ti4_3)) + ti4_4));
	F2218_21780(RTCW(loc1), *(EIF_REFERENCE *)(Current));
	tb1 = '\0';
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
	if ((EIF_BOOLEAN) (ti4_1 > ((EIF_INTEGER_32) 0L))) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN)(F1968_18818(Current) == ti4_1);
	}
	if (tb1) {
		F1968_18821(Current, loc1, arg1, (EIF_CHARACTER_8) '\000');
	} else {
		{
			/* INLINED CODE (PATH.directory_separator) */
			tc1 = (EIF_CHARACTER_8)  0;
			tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
			if (tb1) {
				tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
			} else {
				tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
			}
			/* END INLINED CODE */
		}
		tc2 = tc1;
		F1968_18821(Current, loc1, arg1, tc2);
	}
	tr1 = RTLNS(eif_new_type(1967, 0x00).id, 1967, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F1968_18770(RTCW(tr1), loc1);
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.extended_path */
EIF_REFERENCE F1968_18796 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTGC;
	loc1 = RTLNSMART(eif_new_type(2217, 0).id);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
	ti4_2 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	ti4_3 = F1968_18812(Current);
	F2216_21669(RTCW(loc1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + ti4_2) + ti4_3));
	F2218_21780(RTCW(loc1), *(EIF_REFERENCE *)(Current));
	tb1 = '\0';
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
	if ((EIF_BOOLEAN) (ti4_1 > ((EIF_INTEGER_32) 0L))) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN)(F1968_18818(Current) == ti4_1);
	}
	if (tb1) {
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
		F1968_18822(Current, loc1, tr1, (EIF_CHARACTER_8) '\000');
	} else {
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
		{
			/* INLINED CODE (PATH.directory_separator) */
			tc1 = (EIF_CHARACTER_8)  0;
			tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
			if (tb1) {
				tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
			} else {
				tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
			}
			/* END INLINED CODE */
		}
		tc2 = tc1;
		F1968_18822(Current, loc1, tr1, tc2);
	}
	tr1 = RTLNS(eif_new_type(1967, 0x00).id, 1967, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F1968_18771(RTCW(tr1), loc1);
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.appended */
EIF_REFERENCE F1968_18797 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTGC;
	loc1 = RTLNSMART(eif_new_type(2217, 0).id);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R16822[Dtype(RTCW(arg1))-2216])(arg1);
	ti4_3 = F1968_18812(Current);
	F2216_21669(RTCW(loc1), (EIF_INTEGER_32) (ti4_1 + (EIF_INTEGER_32) (ti4_2 * ti4_3)));
	F2218_21780(RTCW(loc1), *(EIF_REFERENCE *)(Current));
	F1968_18821(Current, loc1, arg1, (EIF_CHARACTER_8) '\000');
	tr1 = RTLNS(eif_new_type(1967, 0x00).id, 1967, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F1968_18770(RTCW(tr1), loc1);
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.appended_with_extension */
EIF_REFERENCE F1968_18798 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_INTEGER_32 ti4_4;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTGC;
	loc1 = RTLNSMART(eif_new_type(2217, 0).id);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R16822[Dtype(RTCW(arg1))-2216])(arg1);
	ti4_3 = F1968_18812(Current);
	ti4_4 = F1968_18812(Current);
	F2216_21669(RTCW(loc1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + (EIF_INTEGER_32) (ti4_2 * ti4_3)) + ti4_4));
	F2218_21780(RTCW(loc1), *(EIF_REFERENCE *)(Current));
	F1968_18821(Current, loc1, arg1, (EIF_CHARACTER_8) '.');
	tr1 = RTLNS(eif_new_type(1967, 0x00).id, 1967, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F1968_18771(RTCW(tr1), loc1);
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.same_as */
EIF_BOOLEAN F1968_18799 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(4);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTGC;
	if ((EIF_BOOLEAN)(arg1 == NULL)) {
	} else {
		if ((EIF_BOOLEAN)(arg1 == Current)) {
			RTLE;
			return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		} else {
			if ((EIF_BOOLEAN) EIF_TEST(eif_case_sensitive_path_names())) {
				{
					/* INLINED CODE (PATH.is_case_sensitive_equal) */
					tb1 = (EIF_BOOLEAN)  0;
					if ((EIF_BOOLEAN)(arg1 == Current)) {
						tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
					} else {
						tr1 = *(EIF_REFERENCE *)(Current);
						tr2 = *(EIF_REFERENCE *)(RTCW(arg1));
						tb1 = F2216_21693(RTCW(tr1), tr2);
					}
					/* END INLINED CODE */
				}
				RTLE;
				return (EIF_BOOLEAN) tb1;
			} else {
				RTLE;
				return (EIF_BOOLEAN) F1968_18803(Current, arg1);
			}
		}
	}
	RTLE;
	return (EIF_BOOLEAN) 0;
}

/* {PATH}.is_less */
EIF_BOOLEAN F1968_18800 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,arg1);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTGC;
	if ((EIF_BOOLEAN) EIF_TEST(eif_case_sensitive_path_names())) {
		tr1 = *(EIF_REFERENCE *)(Current);
		tr2 = *(EIF_REFERENCE *)(RTCW(arg1));
		Result = F2216_21698(RTCW(tr1), tr2);
	} else {
		tr1 = F2221_21895(RTCV(F1968_18807(Current)));
		tr2 = F1968_18807(RTCW(arg1));
		tr2 = F2221_21895(RTCW(tr2));
		Result = F2220_21860(RTCW(tr1), tr2);
	}
	RTLE;
	return Result;
}

/* {PATH}.is_equal */
EIF_BOOLEAN F1968_18801 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	
	
	return (EIF_BOOLEAN) F1968_18799(Current, arg1);
}

/* {PATH}.is_case_sensitive_equal */
EIF_BOOLEAN F1968_18802 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTGC;
	if ((EIF_BOOLEAN)(arg1 == Current)) {
		RTLE;
		return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	} else {
		tr1 = *(EIF_REFERENCE *)(Current);
		tr2 = *(EIF_REFERENCE *)(RTCW(arg1));
		Result = F2216_21693(RTCW(tr1), tr2);
	}
	RTLE;
	return Result;
}

/* {PATH}.is_case_insensitive_equal */
EIF_BOOLEAN F1968_18803 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTGC;
	if ((EIF_BOOLEAN)(arg1 == Current)) {
		RTLE;
		return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	} else {
		tr1 = F1968_18807(Current);
		tr2 = F1968_18807(RTCW(arg1));
		Result = F2220_21856(RTCW(tr1), tr2);
	}
	RTLE;
	return Result;
}

/* {PATH}.copy */
void F1968_18804 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLIU(3);
	
	RTGC;
	if ((EIF_BOOLEAN)(arg1 != Current)) {
		eif_builtin_ANY_standard_copy (Current, arg1);
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
		tr1 = (EIF_REFERENCE) eif_builtin_ANY_twin (tr1);
		RTAR(Current, tr1);
		*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	}
	RTLE;
}

/* {PATH}.out */
EIF_REFERENCE F1968_18805 (EIF_REFERENCE Current)
{
	GTCX
	
	
	return (EIF_REFERENCE) F1968_18806(Current);
}

/* {PATH}.utf_8_name */
EIF_REFERENCE F1968_18806 (EIF_REFERENCE Current)
{
	GTCX
	struct eif_ex_130 sloc1;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) sloc1.data;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	memset (&sloc1.overhead, 0, OVERHEAD + _OBJSIZ_0_0_0_0_0_0_0_0_);
	sloc1.overhead.ov_flags = EO_EXP | EO_STACK;
	RT_DFS(&sloc1.overhead, eif_new_type(157, 0x00).id);
	RTLI(5);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLR(4,Result);
	RTLIU(5);
	
	RTGC;
	tr1 = F1968_18807(Current);
	{
		/* INLINED CODE (UTF_CONVERTER.utf_32_string_to_utf_8_string_8) */
		tr2 = (EIF_REFERENCE)  0;
		tr2 = RTLNS(eif_new_type(2217, 0x00).id, 2217, _OBJSIZ_1_1_0_3_0_0_0_0_);
		ti4_1 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R16822[Dtype(RTCW(tr1))-2216])(tr1);
		F2216_21669(RTCW(tr2), ti4_1);
		F158_2851(RTCW(loc1), tr1, tr2);
		/* END INLINED CODE */
	}
	Result = tr2;
	RTLE;
	return Result;
}

/* {PATH}.name */
EIF_REFERENCE F1968_18807 (EIF_REFERENCE Current)
{
	GTCX
	struct eif_ex_130 sloc1;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) sloc1.data;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	memset (&sloc1.overhead, 0, OVERHEAD + _OBJSIZ_0_0_0_0_0_0_0_0_);
	sloc1.overhead.ov_flags = EO_EXP | EO_STACK;
	RT_DFS(&sloc1.overhead, eif_new_type(157, 0x00).id);
	RTLI(5);
	RTLR(0,loc2);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc1);
	RTLR(4,Result);
	RTLIU(5);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_1_);
	loc2 = tr1;
	if (EIF_TEST(loc2)) {
		RTLE;
		return (EIF_REFERENCE) loc2;
	} else {
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
			Result = RTLNS(eif_new_type(2220, 0x00).id, 2220, _OBJSIZ_1_0_0_4_0_0_0_0_);
			tr1 = F158_2892(RTCW(loc1), *(EIF_REFERENCE *)(Current));
			F2220_21834(RTCW(Result), tr1);
		} else {
			Result = RTLNS(eif_new_type(2220, 0x00).id, 2220, _OBJSIZ_1_0_0_4_0_0_0_0_);
			tr1 = F158_2865(RTCW(loc1), *(EIF_REFERENCE *)(Current));
			F2220_21834(RTCW(Result), tr1);
		}
		RTAR(Current, Result);
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) Result;
	}
	RTLE;
	return Result;
}

/* {PATH}.to_pointer */
EIF_REFERENCE F1968_18809 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	RTLD;
	
	RTLI(3);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLIU(3);
	
	RTGC;
	loc1 = RTLNS(eif_new_type(877, 0x00).id, 877, _OBJSIZ_1_0_0_1_0_0_0_0_);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	ti4_2 = F1968_18812(Current);
	F878_12741(RTCW(loc1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + ti4_2) - ((EIF_INTEGER_32) 1L)));
	{
		/* INLINED CODE (C_STRING.set_string) */
		tr1 = *(EIF_REFERENCE *)(Current);
		ti4_1 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R16822[Dtype(RTCW(tr1))-2216])(tr1);
		F878_12766(RTCW(loc1), tr1, ((EIF_INTEGER_32) 1L), ti4_1);
		/* END INLINED CODE */
	}
	;
	tr1 = *(EIF_REFERENCE *)(RTCW(loc1));
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.unit_size */
EIF_INTEGER_32 F1968_18812 (EIF_REFERENCE Current)
{
	GTCX
	
	
	RTGC;
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
	} else {
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	}/* NOTREACHED */
	
}

/* {PATH}.reset_internal_data */
void F1968_18813 (EIF_REFERENCE Current)
{
	GTCX
	
	
	*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
}

/* {PATH}.normalize */
void F1968_18814 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc4 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc5 = (EIF_INTEGER_32) 0;
	EIF_BOOLEAN loc6 = (EIF_BOOLEAN) 0;
	EIF_BOOLEAN loc7 = (EIF_BOOLEAN) 0;
	EIF_BOOLEAN loc8 = (EIF_BOOLEAN) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	RTLD;
	
	RTLI(3);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLIU(3);
	
	RTGC;
	loc1 = *(EIF_REFERENCE *)(Current);
	loc4 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
		loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		if ((EIF_BOOLEAN) (loc4 >= ((EIF_INTEGER_32) 10L))) {
			tb1 = '\01';
			tb2 = '\0';
			if (F1968_18824(Current, loc1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '/')) {
				tb3 = '\01';
				if (!F1968_18824(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '/')) {
					tb3 = F1968_18824(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '\\');
				}
				tb2 = tb3;
			}
			if (!(tb2)) {
				tb2 = '\0';
				if (F1968_18824(Current, loc1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '\\')) {
					tb3 = '\01';
					if (!F1968_18824(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '\\')) {
						tb3 = F1968_18824(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '/');
					}
					tb2 = tb3;
				}
				tb1 = tb2;
			}
			if (tb1) {
				tb1 = '\0';
				if ((EIF_BOOLEAN) !F1968_18824(Current, loc1, ((EIF_INTEGER_32) 5L), (EIF_CHARACTER_8) '/')) {
					tb1 = (EIF_BOOLEAN) !F1968_18824(Current, loc1, ((EIF_INTEGER_32) 5L), (EIF_CHARACTER_8) '\\');
				}
				if (tb1) {
					loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 5L);
					loc8 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
				}
			}
		}
		loc3 = (EIF_INTEGER_32) loc2;
		loc7 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		for (;;) {
			if ((EIF_BOOLEAN) (loc2 > loc4)) break;
			if (loc6) {
				loc7 = '\0';
				if ((EIF_BOOLEAN) !F1968_18824(Current, loc1, loc2, (EIF_CHARACTER_8) '\\')) {
					loc7 = (EIF_BOOLEAN) !F1968_18824(Current, loc1, loc2, (EIF_CHARACTER_8) '/');
				}
				loc6 = (EIF_BOOLEAN) (EIF_BOOLEAN) !loc7;
			} else {
				if (F1968_18824(Current, loc1, loc2, (EIF_CHARACTER_8) '/')) {
					{
						/* INLINED CODE (STRING_8.put) */
						tc1 = (EIF_CHARACTER_8) '\\';
						tr1 = *(EIF_REFERENCE *)(RTCW(loc1));
						/* INLINED CODE (SPECIAL.put) */
						*((EIF_CHARACTER_8 *)RTCW(tr1) + ((EIF_INTEGER_32) (loc2 - ((EIF_INTEGER_32) 1L)))) = tc1;
						/* END INLINED CODE */;
						F2215_21637(RTCW(loc1));
						/* END INLINED CODE */
					}
					;
					loc6 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
				} else {
					loc6 = F1968_18824(Current, loc1, loc2, (EIF_CHARACTER_8) '\\');
				}
			}
			if (loc7) {
				if ((EIF_BOOLEAN)(loc2 != loc3)) {
					{
						/* INLINED CODE (STRING_8.item) */
						tc1 = (EIF_CHARACTER_8)  0;
						tr1 = *(EIF_REFERENCE *)(RTCW(loc1));
						tc1 = 
							/* INLINED CODE (SPECIAL.item) */
							*((EIF_CHARACTER_8 *)RTCW(tr1) + ((EIF_INTEGER_32) (loc2 - ((EIF_INTEGER_32) 1L))))
							/* END INLINED CODE */;
						/* END INLINED CODE */
					}
					tc1 = tc1;
					{
						/* INLINED CODE (STRING_8.put) */
						tr1 = *(EIF_REFERENCE *)(RTCW(loc1));
						/* INLINED CODE (SPECIAL.put) */
						*((EIF_CHARACTER_8 *)RTCW(tr1) + ((EIF_INTEGER_32) (loc3 - ((EIF_INTEGER_32) 1L)))) = tc1;
						/* END INLINED CODE */;
						F2215_21637(RTCW(loc1));
						/* END INLINED CODE */
					}
					;
					{
						/* INLINED CODE (STRING_8.item) */
						ti4_1 = (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L));
						tc1 = (EIF_CHARACTER_8)  0;
						tr1 = *(EIF_REFERENCE *)(RTCW(loc1));
						tc1 = 
							/* INLINED CODE (SPECIAL.item) */
							*((EIF_CHARACTER_8 *)RTCW(tr1) + ((EIF_INTEGER_32) (ti4_1 - ((EIF_INTEGER_32) 1L))))
							/* END INLINED CODE */;
						/* END INLINED CODE */
					}
					tc1 = tc1;
					{
						/* INLINED CODE (STRING_8.put) */
						ti4_1 = (EIF_INTEGER_32) (loc3 + ((EIF_INTEGER_32) 1L));
						tr1 = *(EIF_REFERENCE *)(RTCW(loc1));
						/* INLINED CODE (SPECIAL.put) */
						*((EIF_CHARACTER_8 *)RTCW(tr1) + ((EIF_INTEGER_32) (ti4_1 - ((EIF_INTEGER_32) 1L)))) = tc1;
						/* END INLINED CODE */;
						F2215_21637(RTCW(loc1));
						/* END INLINED CODE */
					}
					;
				}
				loc3 += ((EIF_INTEGER_32) 2L);
			}
			loc2 += ((EIF_INTEGER_32) 2L);
		}
	} else {
		loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		loc3 = (EIF_INTEGER_32) loc2;
		loc7 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		for (;;) {
			if ((EIF_BOOLEAN) (loc2 > loc4)) break;
			if (loc6) {
				loc7 = F1968_18824(Current, loc1, loc2, (EIF_CHARACTER_8) '/');
				loc7 = (EIF_BOOLEAN) (EIF_BOOLEAN) !loc7;
				loc6 = (EIF_BOOLEAN) (EIF_BOOLEAN) !loc7;
			} else {
				loc6 = F1968_18824(Current, loc1, loc2, (EIF_CHARACTER_8) '/');
			}
			if (loc7) {
				if ((EIF_BOOLEAN)(loc2 != loc3)) {
					{
						/* INLINED CODE (STRING_8.item) */
						tc1 = (EIF_CHARACTER_8)  0;
						tr1 = *(EIF_REFERENCE *)(RTCW(loc1));
						tc1 = 
							/* INLINED CODE (SPECIAL.item) */
							*((EIF_CHARACTER_8 *)RTCW(tr1) + ((EIF_INTEGER_32) (loc2 - ((EIF_INTEGER_32) 1L))))
							/* END INLINED CODE */;
						/* END INLINED CODE */
					}
					tc1 = tc1;
					{
						/* INLINED CODE (STRING_8.put) */
						tr1 = *(EIF_REFERENCE *)(RTCW(loc1));
						/* INLINED CODE (SPECIAL.put) */
						*((EIF_CHARACTER_8 *)RTCW(tr1) + ((EIF_INTEGER_32) (loc3 - ((EIF_INTEGER_32) 1L)))) = tc1;
						/* END INLINED CODE */;
						F2215_21637(RTCW(loc1));
						/* END INLINED CODE */
					}
					;
				}
				loc3++;
			}
			loc2++;
		}
	}
	if ((EIF_BOOLEAN)(loc2 != loc3)) {
		{
			/* INLINED CODE (STRING_8.keep_head) */
			ti4_1 = (EIF_INTEGER_32) (loc3 - ((EIF_INTEGER_32) 1L));
			if ((EIF_BOOLEAN) (ti4_1 < *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_))) {
				*(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_) = (EIF_INTEGER_32) ti4_1;
				F2215_21637(RTCW(loc1));
			}
			/* END INLINED CODE */
		}
		;
	}
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	if (loc8) {
		loc5 = F1968_18818(Current);
		if ((EIF_BOOLEAN)(loc5 == ((EIF_INTEGER_32) 0L))) {
			{
				/* INLINED CODE (PATH.unit_size) */
				ti4_1 = (EIF_INTEGER_32)  0;
				tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
				if (tb1) {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
				} else {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
				}
				/* END INLINED CODE */
			}
			ti4_2 = ti4_1;
			{
				/* INLINED CODE (STRING_8.remove_head) */
				if ((EIF_BOOLEAN) (ti4_2 > *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_))) {
					*(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_) = (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
					F2215_21637(RTCW(loc1));
				} else {
					F2218_21763(RTCW(loc1), (EIF_INTEGER_32) (*(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_) - ti4_2));
				}
				/* END INLINED CODE */
			}
			;
		}
	}
	tb1 = '\0';
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
	{
		/* INLINED CODE (PATH.unit_size) */
		ti4_2 = (EIF_INTEGER_32)  0;
		tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
		if (tb2) {
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
		} else {
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		}
		/* END INLINED CODE */
	}
	ti4_3 = ti4_2;
	{
		/* INLINED CODE (PATH.directory_separator) */
		tc1 = (EIF_CHARACTER_8)  0;
		tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
		if (tb2) {
			tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
		} else {
			tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
		}
		/* END INLINED CODE */
	}
	tc2 = tc1;
	if (F1968_18824(Current, loc1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_3) + ((EIF_INTEGER_32) 1L)), tc2)) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN) (F1968_18818(Current) < ti4_1);
	}
	if (tb1) {
		{
			/* INLINED CODE (PATH.unit_size) */
			ti4_1 = (EIF_INTEGER_32)  0;
			tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
			if (tb1) {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
			} else {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
			/* END INLINED CODE */
		}
		ti4_2 = ti4_1;
		{
			/* INLINED CODE (STRING_8.remove_tail) */
			ti4_3 = (EIF_INTEGER_32)  0;
			ti4_3 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
			if ((EIF_BOOLEAN) (ti4_2 > ti4_3)) {
				*(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_) = (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
				F2215_21637(RTCW(loc1));
			} else {
				F2218_21762(RTCW(loc1), (EIF_INTEGER_32) (ti4_3 - ti4_2));
			}
			/* END INLINED CODE */
		}
		;
	}
	RTLE;
}

/* {PATH}.env */
static EIF_REFERENCE F1968_18817_body (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	

	RTLI(1);
	RTLR(0,tr1);
	RTLIU(1);
	
	RTEV;
	RTGC;
	RTOSP (18817);
#define Result RTOSR(18817)
	RTOC_NEW(Result);
	tr1 = RTLNS(eif_new_type(754, 0x00).id, 754, _OBJSIZ_0_0_0_1_0_0_0_0_);
	Result = (EIF_REFERENCE) tr1;
	RTOSE (18817);
	RTLE;
	RTEE;
	return Result;
#undef Result
}

EIF_REFERENCE F1968_18817 (EIF_REFERENCE Current)
{
	GTCX
	return RTOSCF(18817,F1968_18817_body,(Current));
}

/* {PATH}.root_end_position */
EIF_INTEGER_32 F1968_18818 (EIF_REFERENCE Current)
{
	GTCX
	EIF_CHARACTER_8 loc1 = (EIF_CHARACTER_8) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_CHARACTER_8 tc1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLIU(3);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	{
		/* INLINED CODE (FINITE.is_empty) */
		tb1 = (EIF_BOOLEAN)  0;
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tb1 = tb1;
	if ((EIF_BOOLEAN) !tb1) {
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
			tb1 = '\0';
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
			{
				/* INLINED CODE (PATH.unit_size) */
				ti4_2 = (EIF_INTEGER_32)  0;
				tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
				if (tb2) {
					ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
				} else {
					ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
				}
				/* END INLINED CODE */
			}
			if ((EIF_BOOLEAN)(ti4_1 == ti4_2)) {
				tb1 = F1968_18824(Current, *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '\\');
			}
			if (tb1) {
				{
					/* INLINED CODE (PATH.unit_size) */
					ti4_1 = (EIF_INTEGER_32)  0;
					tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
					if (tb1) {
						ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
					} else {
						ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
					}
					/* END INLINED CODE */
				}
				RTLE;
				return (EIF_INTEGER_32) ti4_1;
			} else {
				tb1 = '\0';
				tr1 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
				if ((EIF_BOOLEAN) (ti4_1 >= ((EIF_INTEGER_32) 4L))) {
					tb2 = '\0';
					tr1 = *(EIF_REFERENCE *)(Current);
					{
						/* INLINED CODE (STRING_8.item) */
						ti4_1 = ((EIF_INTEGER_32) 2L);
						tc1 = (EIF_CHARACTER_8)  0;
						tr2 = *(EIF_REFERENCE *)(RTCW(tr1));
						tc1 = 
							/* INLINED CODE (SPECIAL.item) */
							*((EIF_CHARACTER_8 *)RTCW(tr2) + ((EIF_INTEGER_32) (ti4_1 - ((EIF_INTEGER_32) 1L))))
							/* END INLINED CODE */;
						/* END INLINED CODE */
					}
					tc1 = tc1;
					if ((EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\000')) {
						tr1 = *(EIF_REFERENCE *)(Current);
						{
							/* INLINED CODE (STRING_8.item) */
							ti4_1 = ((EIF_INTEGER_32) 4L);
							tc1 = (EIF_CHARACTER_8)  0;
							tr2 = *(EIF_REFERENCE *)(RTCW(tr1));
							tc1 = 
								/* INLINED CODE (SPECIAL.item) */
								*((EIF_CHARACTER_8 *)RTCW(tr2) + ((EIF_INTEGER_32) (ti4_1 - ((EIF_INTEGER_32) 1L))))
								/* END INLINED CODE */;
							/* END INLINED CODE */
						}
						tc1 = tc1;
						tb2 = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\000');
					}
					tb1 = tb2;
				}
				if (tb1) {
					tr1 = *(EIF_REFERENCE *)(Current);
					{
						/* INLINED CODE (STRING_8.item) */
						ti4_1 = ((EIF_INTEGER_32) 1L);
						tc1 = (EIF_CHARACTER_8)  0;
						tr2 = *(EIF_REFERENCE *)(RTCW(tr1));
						tc1 = 
							/* INLINED CODE (SPECIAL.item) */
							*((EIF_CHARACTER_8 *)RTCW(tr2) + ((EIF_INTEGER_32) (ti4_1 - ((EIF_INTEGER_32) 1L))))
							/* END INLINED CODE */;
						/* END INLINED CODE */
					}
					loc1 = tc1;
					loc1 = (EIF_CHARACTER_8) tolower(loc1);
					tb1 = '\0';
					if ((EIF_BOOLEAN) ((EIF_BOOLEAN) (loc1 >= (EIF_CHARACTER_8) 'a') && (EIF_BOOLEAN) (loc1 <= (EIF_CHARACTER_8) 'z'))) {
						tr1 = *(EIF_REFERENCE *)(Current);
						{
							/* INLINED CODE (STRING_8.item) */
							ti4_1 = ((EIF_INTEGER_32) 3L);
							tc1 = (EIF_CHARACTER_8)  0;
							tr2 = *(EIF_REFERENCE *)(RTCW(tr1));
							tc1 = 
								/* INLINED CODE (SPECIAL.item) */
								*((EIF_CHARACTER_8 *)RTCW(tr2) + ((EIF_INTEGER_32) (ti4_1 - ((EIF_INTEGER_32) 1L))))
								/* END INLINED CODE */;
							/* END INLINED CODE */
						}
						tc1 = tc1;
						tb1 = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) ':');
					}
					if (tb1) {
						tb1 = '\0';
						tr1 = *(EIF_REFERENCE *)(Current);
						ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
						{
							/* INLINED CODE (PATH.unit_size) */
							ti4_2 = (EIF_INTEGER_32)  0;
							tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
							if (tb2) {
								ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
							} else {
								ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
							}
							/* END INLINED CODE */
						}
						if ((EIF_BOOLEAN) (ti4_1 >= (EIF_INTEGER_32) (((EIF_INTEGER_32) 3L) * ti4_2))) {
							tb1 = F1968_18824(Current, *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 5L), (EIF_CHARACTER_8) '\\');
						}
						if (tb1) {
							RTLE;
							return (EIF_INTEGER_32) ((EIF_INTEGER_32) 6L);
						} else {
							RTLE;
							return (EIF_INTEGER_32) ((EIF_INTEGER_32) 4L);
						}
					} else {
						tb1 = '\0';
						if ((EIF_BOOLEAN)(loc1 == (EIF_CHARACTER_8) '\\')) {
							tr1 = *(EIF_REFERENCE *)(Current);
							{
								/* INLINED CODE (STRING_8.item) */
								ti4_1 = ((EIF_INTEGER_32) 3L);
								tc1 = (EIF_CHARACTER_8)  0;
								tr2 = *(EIF_REFERENCE *)(RTCW(tr1));
								tc1 = 
									/* INLINED CODE (SPECIAL.item) */
									*((EIF_CHARACTER_8 *)RTCW(tr2) + ((EIF_INTEGER_32) (ti4_1 - ((EIF_INTEGER_32) 1L))))
									/* END INLINED CODE */;
								/* END INLINED CODE */
							}
							tc1 = tc1;
							tb1 = (EIF_BOOLEAN)(tc1 != (EIF_CHARACTER_8) '\\');
						}
						if (tb1) {
							{
								/* INLINED CODE (PATH.unit_size) */
								ti4_1 = (EIF_INTEGER_32)  0;
								tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
								if (tb1) {
									ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
								} else {
									ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
								}
								/* END INLINED CODE */
							}
							Result = ti4_1;
						} else {
							tb1 = '\0';
							tb2 = '\0';
							tb3 = '\0';
							tr1 = *(EIF_REFERENCE *)(Current);
							ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
							if ((EIF_BOOLEAN) (ti4_1 >= ((EIF_INTEGER_32) 10L))) {
								tb3 = (EIF_BOOLEAN)(loc1 == (EIF_CHARACTER_8) '\\');
							}
							if (tb3) {
								tr1 = *(EIF_REFERENCE *)(Current);
								{
									/* INLINED CODE (STRING_8.item) */
									ti4_1 = ((EIF_INTEGER_32) 3L);
									tc1 = (EIF_CHARACTER_8)  0;
									tr2 = *(EIF_REFERENCE *)(RTCW(tr1));
									tc1 = 
										/* INLINED CODE (SPECIAL.item) */
										*((EIF_CHARACTER_8 *)RTCW(tr2) + ((EIF_INTEGER_32) (ti4_1 - ((EIF_INTEGER_32) 1L))))
										/* END INLINED CODE */;
									/* END INLINED CODE */
								}
								tc1 = tc1;
								tb2 = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\\');
							}
							if (tb2) {
								tr1 = *(EIF_REFERENCE *)(Current);
								{
									/* INLINED CODE (STRING_8.item) */
									ti4_1 = ((EIF_INTEGER_32) 5L);
									tc1 = (EIF_CHARACTER_8)  0;
									tr2 = *(EIF_REFERENCE *)(RTCW(tr1));
									tc1 = 
										/* INLINED CODE (SPECIAL.item) */
										*((EIF_CHARACTER_8 *)RTCW(tr2) + ((EIF_INTEGER_32) (ti4_1 - ((EIF_INTEGER_32) 1L))))
										/* END INLINED CODE */;
									/* END INLINED CODE */
								}
								tc1 = tc1;
								tb1 = (EIF_BOOLEAN)(tc1 != (EIF_CHARACTER_8) '\\');
							}
							if (tb1) {
								loc2 = F1968_18820(Current, ((EIF_INTEGER_32) 7L));
								tb1 = '\0';
								if ((EIF_BOOLEAN) (loc2 > ((EIF_INTEGER_32) 0L))) {
									{
										/* INLINED CODE (PATH.unit_size) */
										ti4_1 = (EIF_INTEGER_32)  0;
										tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
										if (tb2) {
											ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
										} else {
											ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
										}
										/* END INLINED CODE */
									}
									tr1 = *(EIF_REFERENCE *)(Current);
									ti4_2 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
									tb1 = (EIF_BOOLEAN) ((EIF_INTEGER_32) (loc2 + ti4_1) <= ti4_2);
								}
								if (tb1) {
									{
										/* INLINED CODE (PATH.unit_size) */
										ti4_1 = (EIF_INTEGER_32)  0;
										tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
										if (tb1) {
											ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
										} else {
											ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
										}
										/* END INLINED CODE */
									}
									ti4_2 = ti4_1;
									ti4_1 = F1968_18820(Current, (EIF_INTEGER_32) (loc2 + ti4_2));
									loc2 = (EIF_INTEGER_32) ti4_1;
									if ((EIF_BOOLEAN) (loc2 > ((EIF_INTEGER_32) 0L))) {
										RTLE;
										return (EIF_INTEGER_32) (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L));
									} else {
										tr1 = *(EIF_REFERENCE *)(Current);
										Result = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
									}
								}
							}
						}
					}
				}
			}
		} else {
			tr1 = *(EIF_REFERENCE *)(Current);
			{
				/* INLINED CODE (STRING_8.item) */
				ti4_1 = ((EIF_INTEGER_32) 1L);
				tc1 = (EIF_CHARACTER_8)  0;
				tr2 = *(EIF_REFERENCE *)(RTCW(tr1));
				tc1 = 
					/* INLINED CODE (SPECIAL.item) */
					*((EIF_CHARACTER_8 *)RTCW(tr2) + ((EIF_INTEGER_32) (ti4_1 - ((EIF_INTEGER_32) 1L))))
					/* END INLINED CODE */;
				/* END INLINED CODE */
			}
			tc1 = tc1;
			if ((EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '/')) {
				RTLE;
				return (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.end_position_of_last_directory_separator */
EIF_INTEGER_32 F1968_18819 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	{
		/* INLINED CODE (FINITE.is_empty) */
		tb1 = (EIF_BOOLEAN)  0;
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tb1 = tb1;
	if ((EIF_BOOLEAN) !tb1) {
		tr1 = *(EIF_REFERENCE *)(Current);
		Result = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		{
			/* INLINED CODE (PATH.unit_size) */
			ti4_1 = (EIF_INTEGER_32)  0;
			tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
			if (tb1) {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
			} else {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
			/* END INLINED CODE */
		}
		ti4_2 = ti4_1;
		Result = (EIF_INTEGER_32) (EIF_INTEGER_32) ((EIF_INTEGER_32) (Result - ti4_2) + ((EIF_INTEGER_32) 1L));
		if ((EIF_BOOLEAN) (Result >= ((EIF_INTEGER_32) 1L))) {
			for (;;) {
				tb1 = '\01';
				if (!(EIF_BOOLEAN) (Result < ((EIF_INTEGER_32) 1L))) {
					tr1 = *(EIF_REFERENCE *)(Current);
					{
						/* INLINED CODE (PATH.directory_separator) */
						tc1 = (EIF_CHARACTER_8)  0;
						tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
						if (tb2) {
							tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
						} else {
							tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
						}
						/* END INLINED CODE */
					}
					tc2 = tc1;
					tb1 = F1968_18824(Current, tr1, Result, tc2);
				}
				if (tb1) break;
				{
					/* INLINED CODE (PATH.unit_size) */
					ti4_1 = (EIF_INTEGER_32)  0;
					tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
					if (tb2) {
						ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
					} else {
						ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
					}
					/* END INLINED CODE */
				}
				Result -= ti4_1;
			}
		}
		if ((EIF_BOOLEAN) (Result < ((EIF_INTEGER_32) 0L))) {
			RTLE;
			return (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
		} else {
			{
				/* INLINED CODE (PATH.unit_size) */
				ti4_1 = (EIF_INTEGER_32)  0;
				tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
				if (tb2) {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
				} else {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
				}
				/* END INLINED CODE */
			}
			ti4_2 = ti4_1;
			Result = (EIF_INTEGER_32) (EIF_INTEGER_32) ((EIF_INTEGER_32) (Result + ti4_2) - ((EIF_INTEGER_32) 1L));
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.next_directory_separator */
EIF_INTEGER_32 F1968_18820 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_CHARACTER_8 loc3 = (EIF_CHARACTER_8) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,loc4);
	RTLIU(2);
	
	RTGC;
	{
		/* INLINED CODE (PATH.unit_size) */
		ti4_1 = (EIF_INTEGER_32)  0;
		tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
		if (tb1) {
			ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
		} else {
			ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		}
		/* END INLINED CODE */
	}
	loc2 = ti4_1;
	{
		/* INLINED CODE (PATH.directory_separator) */
		tc1 = (EIF_CHARACTER_8)  0;
		tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
		if (tb1) {
			tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
		} else {
			tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
		}
		/* END INLINED CODE */
	}
	loc3 = tc1;
	Result = (EIF_INTEGER_32) arg1;
	loc4 = *(EIF_REFERENCE *)(Current);
	loc1 = *(EIF_INTEGER_32 *)(RTCW(loc4)+ _LNGOFF_1_1_0_2_);
	for (;;) {
		tb1 = '\01';
		if (!(EIF_BOOLEAN) ((EIF_BOOLEAN) (Result < ((EIF_INTEGER_32) 1L)) || (EIF_BOOLEAN) (Result > loc1))) {
			tb1 = F1968_18824(Current, loc4, Result, loc3);
		}
		if (tb1) break;
		Result += loc2;
	}
	if ((EIF_BOOLEAN) (Result > loc1)) {
		RTLE;
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
	}
	RTLE;
	return Result;
}

/* {PATH}.internal_append_into */
void F1968_18821 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_CHARACTER_8 arg3)
{
	GTCX
	struct eif_ex_130 sloc1;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) sloc1.data;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_CHARACTER_32 tw1;
	EIF_CHARACTER_32 tw2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	RTLD;
	
	memset (&sloc1.overhead, 0, OVERHEAD + _OBJSIZ_0_0_0_0_0_0_0_0_);
	sloc1.overhead.ov_flags = EO_EXP | EO_STACK;
	RT_DFS(&sloc1.overhead, eif_new_type(157, 0x00).id);
	RTLI(4);
	RTLR(0,arg2);
	RTLR(1,arg1);
	RTLR(2,Current);
	RTLR(3,loc1);
	RTLIU(4);
	
	RTGC;
	tb1 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R16800[Dtype(RTCW(arg2))-2216])(arg2);
	if ((EIF_BOOLEAN) !tb1) {
		tb1 = '\0';
		tb2 = '\0';
		tb3 = '\0';
		if ((EIF_BOOLEAN)(arg3 != (EIF_CHARACTER_8) '\000')) {
			{
				/* INLINED CODE (FINITE.is_empty) */
				tb4 = (EIF_BOOLEAN)  0;
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1)+ _LNGOFF_1_1_0_2_);
				tb4 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
				/* END INLINED CODE */
			}
			tb4 = tb4;
			tb3 = (EIF_BOOLEAN) !tb4;
		}
		if (tb3) {
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1)+ _LNGOFF_1_1_0_2_);
			{
				/* INLINED CODE (PATH.unit_size) */
				ti4_2 = (EIF_INTEGER_32)  0;
				tb3 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
				if (tb3) {
					ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
				} else {
					ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
				}
				/* END INLINED CODE */
			}
			ti4_3 = ti4_2;
			tb2 = (EIF_BOOLEAN) !F1968_18824(Current, arg1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_3) + ((EIF_INTEGER_32) 1L)), arg3);
		}
		if (tb2) {
			tw1 = (FUNCTION_CAST(EIF_CHARACTER_32, (EIF_REFERENCE, EIF_INTEGER_32)) R16786[Dtype(RTCW(arg2))-2216])(arg2, ((EIF_INTEGER_32) 1L));
			tw2 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '/';
			tb1 = (EIF_BOOLEAN)(tw1 != tw2);
		}
		if (tb1) {
			if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
				tw1 = (FUNCTION_CAST(EIF_CHARACTER_32, (EIF_REFERENCE, EIF_INTEGER_32)) R16786[Dtype(RTCW(arg2))-2216])(arg2, ((EIF_INTEGER_32) 1L));
				tw2 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '\\';
				if ((EIF_BOOLEAN)(tw1 != tw2)) {
					F2218_21794(RTCW(arg1), arg3);
					F2218_21794(RTCW(arg1), (EIF_CHARACTER_8) '\000');
				}
			} else {
				F2218_21794(RTCW(arg1), arg3);
			}
		}
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
			F158_2879(RTCW(loc1), arg2, arg1);
		} else {
			F158_2854(RTCW(loc1), arg2, arg1);
		}
	}
	RTLE;
}

/* {PATH}.internal_path_append_into */
void F1968_18822 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_CHARACTER_8 arg3)
{
	GTCX
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,arg2);
	RTLIU(3);
	
	RTGC;
	tb1 = '\0';
	tb2 = '\0';
	tb3 = '\0';
	if ((EIF_BOOLEAN)(arg3 != (EIF_CHARACTER_8) '\000')) {
		{
			/* INLINED CODE (FINITE.is_empty) */
			tb4 = (EIF_BOOLEAN)  0;
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1)+ _LNGOFF_1_1_0_2_);
			tb4 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
			/* END INLINED CODE */
		}
		tb4 = tb4;
		tb3 = (EIF_BOOLEAN) !tb4;
	}
	if (tb3) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1)+ _LNGOFF_1_1_0_2_);
		{
			/* INLINED CODE (PATH.unit_size) */
			ti4_2 = (EIF_INTEGER_32)  0;
			tb3 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
			if (tb3) {
				ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
			} else {
				ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
			/* END INLINED CODE */
		}
		ti4_3 = ti4_2;
		tb2 = (EIF_BOOLEAN) !F1968_18824(Current, arg1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_3) + ((EIF_INTEGER_32) 1L)), arg3);
	}
	if (tb2) {
		tb1 = (EIF_BOOLEAN) !F1968_18824(Current, arg2, ((EIF_INTEGER_32) 1L), arg3);
	}
	if (tb1) {
		F2218_21794(RTCW(arg1), arg3);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
			F2218_21794(RTCW(arg1), (EIF_CHARACTER_8) '\000');
		}
	}
	F2218_21780(RTCW(arg1), arg2);
	RTLE;
}

/* {PATH}.internal_path_append_substring_into */
void F1968_18823 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_CHARACTER_8 arg5)
{
	GTCX
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,arg2);
	RTLIU(3);
	
	RTGC;
	tb1 = '\0';
	tb2 = '\0';
	tb3 = '\0';
	if ((EIF_BOOLEAN)(arg5 != (EIF_CHARACTER_8) '\000')) {
		{
			/* INLINED CODE (FINITE.is_empty) */
			tb4 = (EIF_BOOLEAN)  0;
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1)+ _LNGOFF_1_1_0_2_);
			tb4 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
			/* END INLINED CODE */
		}
		tb4 = tb4;
		tb3 = (EIF_BOOLEAN) !tb4;
	}
	if (tb3) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1)+ _LNGOFF_1_1_0_2_);
		{
			/* INLINED CODE (PATH.unit_size) */
			ti4_2 = (EIF_INTEGER_32)  0;
			tb3 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
			if (tb3) {
				ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
			} else {
				ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
			/* END INLINED CODE */
		}
		ti4_3 = ti4_2;
		tb2 = (EIF_BOOLEAN) !F1968_18824(Current, arg1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_3) + ((EIF_INTEGER_32) 1L)), arg5);
	}
	if (tb2) {
		tb1 = (EIF_BOOLEAN) !F1968_18824(Current, arg2, arg3, arg5);
	}
	if (tb1) {
		F2218_21794(RTCW(arg1), arg5);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
			F2218_21794(RTCW(arg1), (EIF_CHARACTER_8) '\000');
		}
	}
	F2218_21781(RTCW(arg1), arg2, arg3, arg4);
	RTLE;
}

/* {PATH}.is_character */
EIF_BOOLEAN F1968_18824 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_INTEGER_32 arg2, EIF_CHARACTER_8 arg3)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_CHARACTER_8 tc1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,arg1);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
		Result = '\0';
		{
			/* INLINED CODE (STRING_8.item) */
			tc1 = (EIF_CHARACTER_8)  0;
			tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
			tc1 = 
				/* INLINED CODE (SPECIAL.item) */
				*((EIF_CHARACTER_8 *)RTCW(tr1) + ((EIF_INTEGER_32) (arg2 - ((EIF_INTEGER_32) 1L))))
				/* END INLINED CODE */;
			/* END INLINED CODE */
		}
		tc1 = tc1;
		if ((EIF_BOOLEAN)(tc1 == arg3)) {
			{
				/* INLINED CODE (STRING_8.item) */
				ti4_1 = (EIF_INTEGER_32) (arg2 + ((EIF_INTEGER_32) 1L));
				tc1 = (EIF_CHARACTER_8)  0;
				tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
				tc1 = 
					/* INLINED CODE (SPECIAL.item) */
					*((EIF_CHARACTER_8 *)RTCW(tr1) + ((EIF_INTEGER_32) (ti4_1 - ((EIF_INTEGER_32) 1L))))
					/* END INLINED CODE */;
				/* END INLINED CODE */
			}
			tc1 = tc1;
			Result = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\000');
		}
	} else {
		{
			/* INLINED CODE (STRING_8.item) */
			tc1 = (EIF_CHARACTER_8)  0;
			tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
			tc1 = 
				/* INLINED CODE (SPECIAL.item) */
				*((EIF_CHARACTER_8 *)RTCW(tr1) + ((EIF_INTEGER_32) (arg2 - ((EIF_INTEGER_32) 1L))))
				/* END INLINED CODE */;
			/* END INLINED CODE */
		}
		tc1 = tc1;
		Result = (EIF_BOOLEAN) (EIF_BOOLEAN)(tc1 == arg3);
	}
	RTLE;
	return Result;
}

/* {PATH}.c_same_files */
EIF_BOOLEAN F1968_18827 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2)
{
	GTCX
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	
	
	Result = EIF_TEST(inline_F1968_18827 ((EIF_POINTER) arg1, (EIF_POINTER) arg2));
	return Result;
}

void EIF_Minit1129 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
