/*
 * Code for class PATH
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "pa1121.h"
#include "eif_built_in.h"
#include "eif_eiffel.h"
#include <ctype.h>
#include "eif_path_name.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F1943_18663
static int inline_F1943_18663 (EIF_POINTER arg1, EIF_POINTER arg2)
{
	EIF_BOOLEAN Result = EIF_FALSE;
#ifdef EIF_WINDOWS
		/* To check this, we use `CreateFileW' to open both file, and then using the information
		 * returned by `GetFileInformationByHandle' we can check whether or not they are indeed
		 * the same.
		 * Note: it is important to use the W version of CreateFileW because arguments
		 * are Unicode, not ASCII. */
	BY_HANDLE_FILE_INFORMATION l_path1_info, l_path2_info;
	HANDLE l_path2_file = CreateFileW ((LPCWSTR) arg2, GENERIC_READ, FILE_SHARE_READ, NULL,
		OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	HANDLE l_path1_file = CreateFileW ((LPCWSTR) arg1, GENERIC_READ, FILE_SHARE_READ, NULL,
			OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);

	if ((l_path2_file == INVALID_HANDLE_VALUE) || (l_path1_file == INVALID_HANDLE_VALUE)) {
			/* We do not need the handles anymore, simply close them. Since Microsoft
			 * API accepts INVALID_HANDLE_VALUE we don't check the validity of arguments. */
		CloseHandle(l_path2_file);
		CloseHandle(l_path1_file);
	} else {
		BOOL success = GetFileInformationByHandle (l_path2_file, &l_path2_info);
		success = success && GetFileInformationByHandle (l_path1_file, &l_path1_info);
			/* We do not need the handles anymore, simply close them. */
		CloseHandle(l_path2_file);
		CloseHandle(l_path1_file);
		if (success) {
				/* Check that `path2' and `path1' do not represent the same file. */
			if
				((l_path2_info.dwVolumeSerialNumber == l_path1_info.dwVolumeSerialNumber) &&
				(l_path2_info.nFileIndexLow == l_path1_info.nFileIndexLow) &&
				(l_path2_info.nFileIndexHigh == l_path1_info.nFileIndexHigh))
			{
				Result = EIF_TRUE;
			}
		}
	}
#else
	struct stat buf1, buf2;
	int status;
	#ifdef HAS_LSTAT
		status = lstat(arg1, &buf1);
		if (status == 0) {
				/* We found a file, now let's check if it is not a symbolic link. If it is, we use `stat'
			 	 * to ensure the validity of the link. */
			if ((buf1.st_mode & S_IFLNK) == S_IFLNK) {
				status = stat (arg1, &buf1);
			}
		}
		
		if (status == 0) {
			status = lstat(arg2, &buf2);
			if (status == 0) {
					/* We found a file, now let's check if it is not a symbolic link. If it is, we use `stat'
				 	 * to ensure the validity of the link. */
				if ((buf2.st_mode & S_IFLNK) == S_IFLNK) {
					status = stat (arg2, &buf2);
				}
			}
		}
	#else
		status = stat (arg1, &buf1);
		if (status == 0) {
			status = stat (arg2, &buf2);
		}
	#endif
	if (status == 0) {
			/* Both files are present, check they represent the same one. */
		if ((buf1.st_dev == buf2.st_dev) && (buf1.st_ino == buf2.st_ino)) {
			Result = EIF_TRUE;
		}
	}
#endif
return Result;
	;
}
#define INLINE_F1943_18663
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {PATH}.make_empty */
void F1943_18602 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = RTLNSMART(eif_new_type(2189, 0).id);
	F2185_21342(RTCW(tr1));
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	{
		/* INLINED CODE (reset_internal_data) */
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {PATH}.make_current */
void F1943_18603 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = RTLNSMART(eif_new_type(2189, 0).id);
	ti4_1 = F1943_18648(Current);
	F2187_21438(RTCW(tr1), ti4_1);
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	tr1 = *(EIF_REFERENCE *)(Current);
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R16825[Dtype(tr1)-2189])(RTCW(tr1), (EIF_CHARACTER_8) '.');
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
		tr1 = *(EIF_REFERENCE *)(Current);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R16825[Dtype(tr1)-2189])(RTCW(tr1), (EIF_CHARACTER_8) '\000');
	}
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	{
		/* INLINED CODE (reset_internal_data) */
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {PATH}.make_from_string */
void F1943_18604 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,arg1);
	RTLIU(3);
	
	RTGC;
	tr1 = RTLNSMART(eif_new_type(2189, 0).id);
	ti4_1 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R16676[Dtype(arg1)-2186])(RTCW(arg1));
	ti4_2 = F1943_18648(Current);
	F2187_21438(RTCW(tr1), (EIF_INTEGER_32) (ti4_1 * ti4_2));
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	tb1 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R16654[Dtype(arg1)-2187])(RTCW(arg1));
	if ((EIF_BOOLEAN) !tb1) {
		tr1 = *(EIF_REFERENCE *)(Current);
		F1943_18657(Current, tr1, arg1, (EIF_CHARACTER_8) '\000');
		F1943_18650(Current);
	} else {
		*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	}
	{
		/* INLINED CODE (reset_internal_data) */
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {PATH}.make_from_storage */
void F1943_18606 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,arg1);
	RTLIU(2);
	
	RTGC;
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) arg1;
	F1943_18650(Current);
	{
		/* INLINED CODE (reset_internal_data) */
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {PATH}.make_from_normalized_storage */
void F1943_18607 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,arg1);
	RTLIU(2);
	
	RTGC;
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) arg1;
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	{
		/* INLINED CODE (reset_internal_data) */
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {PATH}.make_from_pointer */
void F1943_18608 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,loc1);
	RTLR(2,tr1);
	RTLIU(3);
	
	RTGC;
	loc2 = F742_10506(Current, arg1);
	{
		/* INLINED CODE (unit_size) */
		ti4_1 = (EIF_INTEGER_32)  0;
		tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
		if (tb1) {
			ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
		} else {
			ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		}
		/* END INLINED CODE */
	}
	loc2 -= (EIF_INTEGER_32) (loc2 % ti4_1);
	tr1 = RTLNS(eif_new_type(865, 0x00).id, 865, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F866_12671(RTCW(tr1), arg1, loc2);
	loc1 = (EIF_REFERENCE) tr1;
	tr1 = F866_12678(RTCW(loc1), ((EIF_INTEGER_32) 1L), loc2);
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	tr1 = *(EIF_REFERENCE *)(Current);
	{
		/* INLINED CODE (is_empty) */
		tb1 = (EIF_BOOLEAN)  0;
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tb1 = tb1;
	if ((EIF_BOOLEAN) !tb1) {
		F1943_18650(Current);
	}
	{
		/* INLINED CODE (reset_internal_data) */
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {PATH}.is_current_symbol */
EIF_BOOLEAN F1943_18609 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	{
		/* INLINED CODE (unit_size) */
		ti4_2 = (EIF_INTEGER_32)  0;
		tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
		if (tb1) {
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
		} else {
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		}
		/* END INLINED CODE */
	}
	if ((EIF_BOOLEAN)(ti4_1 == ti4_2)) {
		tr1 = *(EIF_REFERENCE *)(Current);
		RTLE;
		return (EIF_BOOLEAN) F1943_18660(Current, tr1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '.');
	}
	RTLE;
	return (EIF_BOOLEAN) 0;
}

/* {PATH}.is_parent_symbol */
EIF_BOOLEAN F1943_18610 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	{
		/* INLINED CODE (unit_size) */
		ti4_2 = (EIF_INTEGER_32)  0;
		tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
		if (tb1) {
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
		} else {
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		}
		/* END INLINED CODE */
	}
	if ((EIF_BOOLEAN)(ti4_1 == (EIF_INTEGER_32) (((EIF_INTEGER_32) 2L) * ti4_2))) {
		tr1 = *(EIF_REFERENCE *)(Current);
		Result = F1943_18660(Current, tr1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '.');
		tr1 = *(EIF_REFERENCE *)(Current);
		{
			/* INLINED CODE (unit_size) */
			ti4_1 = (EIF_INTEGER_32)  0;
			tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
			if (tb1) {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
			} else {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
			/* END INLINED CODE */
		}
		ti4_2 = ti4_1;
		Result = F1943_18660(Current, tr1, (EIF_INTEGER_32) (((EIF_INTEGER_32) 1L) + ti4_2), (EIF_CHARACTER_8) '.');
	}
	RTLE;
	return Result;
}

/* {PATH}.has_root */
EIF_BOOLEAN F1943_18611 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTGC;
	ti4_1 = F1943_18654(Current);
	Result = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 != ((EIF_INTEGER_32) 0L));
	RTLE;
	return Result;
}

/* {PATH}.is_empty */
EIF_BOOLEAN F1943_18612 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	{
		/* INLINED CODE (is_empty) */
		tb1 = (EIF_BOOLEAN)  0;
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	Result = tb1;
	RTLE;
	return Result;
}

/* {PATH}.is_relative */
EIF_BOOLEAN F1943_18613 (EIF_REFERENCE Current)
{
	GTCX
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTGC;
	Result = F1943_18614(Current);
	Result = (EIF_BOOLEAN) (EIF_BOOLEAN) !Result;
	RTLE;
	return Result;
}

/* {PATH}.is_absolute */
EIF_BOOLEAN F1943_18614 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	loc1 = F1943_18654(Current);
	if ((EIF_BOOLEAN) (loc1 > ((EIF_INTEGER_32) 0L))) {
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
			tr1 = *(EIF_REFERENCE *)(Current);
			{
				/* INLINED CODE (unit_size) */
				ti4_1 = (EIF_INTEGER_32)  0;
				tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
				if (tb1) {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
				} else {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
				}
				/* END INLINED CODE */
			}
			ti4_2 = ti4_1;
			{
				/* INLINED CODE (directory_separator) */
				tc1 = (EIF_CHARACTER_8)  0;
				tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
				if (tb1) {
					tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
				} else {
					tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
				}
				/* END INLINED CODE */
			}
			tc2 = tc1;
			Result = F1943_18660(Current, tr1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (loc1 - ti4_2) + ((EIF_INTEGER_32) 1L)), tc2);
		} else {
			RTLE;
			return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.is_same_file_as */
EIF_BOOLEAN F1943_18616 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_POINTER tp2;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,loc2);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTGC;
	loc1 = F1943_18645(Current);
	loc2 = F1943_18645(RTCW(arg1));
	tp1 = *(EIF_POINTER *)(RTCW(loc1)+ _PTROFF_0_1_0_1_0_0_);
	tp2 = *(EIF_POINTER *)(RTCW(loc2)+ _PTROFF_0_1_0_1_0_0_);
	Result = EIF_TEST (inline_F1943_18663(tp1, tp2));
	RTLE;
	return Result;
}

/* {PATH}.has_extension */
EIF_BOOLEAN F1943_18617 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTGC;
	Result = '\0';
	tr1 = F1943_18621(Current);
	loc1 = tr1;
	if (EIF_TEST(loc1)) {
		tb1 = F2185_21384(loc1, arg1);
		Result = tb1;
	}
	RTLE;
	return Result;
}

/* {PATH}.root */
EIF_REFERENCE F1943_18618 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	loc1 = F1943_18654(Current);
	if ((EIF_BOOLEAN)(loc1 != ((EIF_INTEGER_32) 0L))) {
		tr1 = *(EIF_REFERENCE *)(Current);
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		if ((EIF_BOOLEAN)(loc1 == ti4_1)) {
			tr1 = RTLNS(eif_new_type(1942, 0x00).id, 1942, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F1943_18607(RTCW(tr1), *(EIF_REFERENCE *)(Current));
			RTLE;
			return (EIF_REFERENCE) tr1;
		} else {
			tr1 = RTLNS(eif_new_type(1942, 0x00).id, 1942, _OBJSIZ_2_1_0_0_0_0_0_0_);
			tr2 = *(EIF_REFERENCE *)(Current);
			tr2 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R16717[Dtype(tr2)-2187])(RTCW(tr2), ((EIF_INTEGER_32) 1L), loc1);
			F1943_18607(RTCW(tr1), tr2);
			Result = (EIF_REFERENCE) tr1;
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.parent */
EIF_REFERENCE F1943_18619 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(5);
	RTLR(0,Current);
	RTLR(1,loc3);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLR(4,Result);
	RTLIU(5);
	
	RTGC;
	loc1 = F1943_18655(Current);
	if ((EIF_BOOLEAN)(loc1 == ((EIF_INTEGER_32) 0L))) {
		tr1 = F1943_18618(Current);
		loc3 = tr1;
		if (EIF_TEST(loc3)) {
			RTLE;
			return (EIF_REFERENCE) loc3;
		} else {
			tr1 = RTLNS(eif_new_type(1942, 0x00).id, 1942, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F1943_18603(RTCW(tr1));
			RTLE;
			return (EIF_REFERENCE) tr1;
		}
	} else {
		{
			/* INLINED CODE (unit_size) */
			ti4_1 = (EIF_INTEGER_32)  0;
			tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
			if (tb1) {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
			} else {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
			/* END INLINED CODE */
		}
		if ((EIF_BOOLEAN)(loc1 == ti4_1)) {
			tr1 = RTLNS(eif_new_type(1942, 0x00).id, 1942, _OBJSIZ_2_1_0_0_0_0_0_0_);
			tr2 = *(EIF_REFERENCE *)(Current);
			ti4_1 = F1943_18648(Current);
			tr2 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R16717[Dtype(tr2)-2187])(RTCW(tr2), ((EIF_INTEGER_32) 1L), ti4_1);
			F1943_18607(RTCW(tr1), tr2);
			Result = (EIF_REFERENCE) tr1;
		} else {
			loc2 = F1943_18654(Current);
			if ((EIF_BOOLEAN) (loc1 <= loc2)) {
				tr1 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
				if ((EIF_BOOLEAN)(loc2 == ti4_1)) {
					RTLE;
					return (EIF_REFERENCE) Current;
				} else {
					tr1 = RTLNS(eif_new_type(1942, 0x00).id, 1942, _OBJSIZ_2_1_0_0_0_0_0_0_);
					tr2 = *(EIF_REFERENCE *)(Current);
					tr2 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R16717[Dtype(tr2)-2187])(RTCW(tr2), ((EIF_INTEGER_32) 1L), loc2);
					F1943_18607(RTCW(tr1), tr2);
					Result = (EIF_REFERENCE) tr1;
				}
			} else {
				tr1 = RTLNS(eif_new_type(1942, 0x00).id, 1942, _OBJSIZ_2_1_0_0_0_0_0_0_);
				tr2 = *(EIF_REFERENCE *)(Current);
				ti4_1 = F1943_18648(Current);
				tr2 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R16717[Dtype(tr2)-2187])(RTCW(tr2), ((EIF_INTEGER_32) 1L), (EIF_INTEGER_32) (loc1 - ti4_1));
				F1943_18607(RTCW(tr1), tr2);
				Result = (EIF_REFERENCE) tr1;
			}
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.entry */
EIF_REFERENCE F1943_18620 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE tr3 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(5);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,tr3);
	RTLR(4,Result);
	RTLIU(5);
	
	RTGC;
	loc1 = F1943_18655(Current);
	if ((EIF_BOOLEAN)(loc1 == ((EIF_INTEGER_32) 0L))) {
		loc2 = F1943_18654(Current);
		if ((EIF_BOOLEAN) (loc2 > ((EIF_INTEGER_32) 0L))) {
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
			if ((EIF_BOOLEAN) (loc2 < ti4_1)) {
				tr1 = RTLNS(eif_new_type(1942, 0x00).id, 1942, _OBJSIZ_2_1_0_0_0_0_0_0_);
				tr2 = *(EIF_REFERENCE *)(Current);
				tr3 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr3)+ _LNGOFF_1_1_0_2_);
				tr2 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R16717[Dtype(tr2)-2187])(RTCW(tr2), (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)), ti4_1);
				F1943_18607(RTCW(tr1), tr2);
				Result = (EIF_REFERENCE) tr1;
			}
		} else {
			Result = (EIF_REFERENCE) Current;
		}
	} else {
		loc2 = F1943_18654(Current);
		if ((EIF_BOOLEAN) (loc1 <= loc2)) {
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
			if ((EIF_BOOLEAN) (loc2 < ti4_1)) {
				tr1 = RTLNS(eif_new_type(1942, 0x00).id, 1942, _OBJSIZ_2_1_0_0_0_0_0_0_);
				tr2 = *(EIF_REFERENCE *)(Current);
				tr3 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr3)+ _LNGOFF_1_1_0_2_);
				tr2 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R16717[Dtype(tr2)-2187])(RTCW(tr2), (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)), ti4_1);
				F1943_18607(RTCW(tr1), tr2);
				Result = (EIF_REFERENCE) tr1;
			}
		} else {
			tr1 = RTLNS(eif_new_type(1942, 0x00).id, 1942, _OBJSIZ_2_1_0_0_0_0_0_0_);
			tr2 = *(EIF_REFERENCE *)(Current);
			tr3 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr3)+ _LNGOFF_1_1_0_2_);
			tr2 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R16717[Dtype(tr2)-2187])(RTCW(tr2), (EIF_INTEGER_32) (loc1 + ((EIF_INTEGER_32) 1L)), ti4_1);
			F1943_18607(RTCW(tr1), tr2);
			Result = (EIF_REFERENCE) tr1;
		}
	}
	tb1 = '\0';
	if ((EIF_BOOLEAN)(Result != NULL)) {
		tb2 = '\01';
		tb3 = '\01';
		{
			/* INLINED CODE (is_empty) */
			tb4 = (EIF_BOOLEAN)  0;
			tr1 = *(EIF_REFERENCE *)(RTCW(Result));
			tb4 = F1289_14012(RTCW(tr1));
			/* END INLINED CODE */
		}
		tb4 = tb4;
		if (!tb4) {
			{
				/* INLINED CODE (is_current_symbol) */
				tb4 = (EIF_BOOLEAN)  0;
				tr1 = *(EIF_REFERENCE *)(RTCW(Result));
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
				ti4_2 = F1943_18648(RTCW(Result));
				if ((EIF_BOOLEAN)(ti4_1 == ti4_2)) {
					tr1 = *(EIF_REFERENCE *)(RTCW(Result));
					tb4 = F1943_18660(RTCW(Result), tr1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '.');
				}
				/* END INLINED CODE */
			}
			tb4 = tb4;
			tb3 = tb4;
		}
		if (!tb3) {
			tb3 = F1943_18610(RTCW(Result));
			tb2 = tb3;
		}
		tb1 = tb2;
	}
	if (tb1) {
		RTLE;
		return (EIF_REFERENCE) NULL;
	}
	RTLE;
	return Result;
}

/* {PATH}.extension */
EIF_REFERENCE F1943_18621 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_CHARACTER_32 tw1;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc4);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc1);
	RTLIU(4);
	
	RTGC;
	tr1 = F1943_18620(Current);
	loc4 = tr1;
	if (EIF_TEST(loc4)) {
		loc1 = F1943_18643(loc4);
		loc3 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_0_0_2_);
		tw1 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '.';
		loc2 = F2194_21677(RTCW(loc1), tw1, loc3);
		if ((EIF_BOOLEAN) ((EIF_BOOLEAN)(loc2 != ((EIF_INTEGER_32) 0L)) && (EIF_BOOLEAN)(loc2 != loc3))) {
			tr1 = F2195_21731(RTCW(loc1), (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)), loc3);
			RTLE;
			return (EIF_REFERENCE) tr1;
		}
	}
	RTLE;
	return (EIF_REFERENCE) 0;
}

/* {PATH}.components */
EIF_REFERENCE F1943_18622 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(5);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLR(3,loc1);
	RTLR(4,tr2);
	RTLIU(5);
	
	RTGC;
	{
		static EIF_TYPE_INDEX typarr0[] = {1500,1942,0xFFFF};
		EIF_TYPE typres0;
		static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
		
		typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), typarr0)));
		tr1 = RTLNS(typres0.id, 1500, _OBJSIZ_1_1_0_1_0_0_0_0_);
	}
	F1501_14859(RTCW(tr1), ((EIF_INTEGER_32) 10L));
	Result = (EIF_REFERENCE) tr1;
	loc3 = F1943_18654(Current);
	if ((EIF_BOOLEAN) (loc3 > ((EIF_INTEGER_32) 0L))) {
		tr1 = RTLNS(eif_new_type(2189, 0x00).id, 2189, _OBJSIZ_1_1_0_3_0_0_0_0_);
		F2187_21438(RTCW(tr1), loc3);
		loc1 = (EIF_REFERENCE) tr1;
		tr1 = *(EIF_REFERENCE *)(Current);
		F2190_21584(RTCW(loc1), tr1, ((EIF_INTEGER_32) 1L), loc3);
		tr1 = RTLNS(eif_new_type(1942, 0x00).id, 1942, _OBJSIZ_2_1_0_0_0_0_0_0_);
		F1943_18607(RTCW(tr1), loc1);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R11822[Dtype(Result)-1191])(RTCW(Result), tr1);
		loc3++;
	} else {
		loc3 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	}
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	if ((EIF_BOOLEAN) (loc3 <= ti4_1)) {
		loc2 = (EIF_INTEGER_32) loc3;
		loc3 = F1943_18656(Current, loc2);
		for (;;) {
			if ((EIF_BOOLEAN)(loc3 == ((EIF_INTEGER_32) 0L))) break;
			tr1 = RTLNS(eif_new_type(2189, 0x00).id, 2189, _OBJSIZ_1_1_0_3_0_0_0_0_);
			F2187_21438(RTCW(tr1), (EIF_INTEGER_32) (loc3 - loc2));
			loc1 = (EIF_REFERENCE) tr1;
			tr1 = *(EIF_REFERENCE *)(Current);
			F2190_21584(RTCW(loc1), tr1, loc2, (EIF_INTEGER_32) (loc3 - ((EIF_INTEGER_32) 1L)));
			tr1 = RTLNS(eif_new_type(1942, 0x00).id, 1942, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F1943_18607(RTCW(tr1), loc1);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R11822[Dtype(Result)-1191])(RTCW(Result), tr1);
			{
				/* INLINED CODE (unit_size) */
				ti4_1 = (EIF_INTEGER_32)  0;
				tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
				if (tb1) {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
				} else {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
				}
				/* END INLINED CODE */
			}
			loc2 = ti4_1;
			loc2 = (EIF_INTEGER_32) (EIF_INTEGER_32) (loc3 + loc2);
			loc3 = F1943_18656(Current, loc2);
		}
		tr1 = *(EIF_REFERENCE *)(Current);
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		if ((EIF_BOOLEAN) (loc2 <= ti4_1)) {
			tr1 = RTLNS(eif_new_type(2189, 0x00).id, 2189, _OBJSIZ_1_1_0_3_0_0_0_0_);
			tr2 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2)+ _LNGOFF_1_1_0_2_);
			F2187_21438(RTCW(tr1), (EIF_INTEGER_32) (ti4_1 - loc2));
			loc1 = (EIF_REFERENCE) tr1;
			tr1 = *(EIF_REFERENCE *)(Current);
			tr2 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2)+ _LNGOFF_1_1_0_2_);
			F2190_21584(RTCW(loc1), tr1, loc2, ti4_1);
			tr1 = RTLNS(eif_new_type(1942, 0x00).id, 1942, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F1943_18607(RTCW(tr1), loc1);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R11822[Dtype(Result)-1191])(RTCW(Result), tr1);
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.absolute_path */
EIF_REFERENCE F1943_18623 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLIU(3);
	
	RTGC;
	tr1 = F744_10531(RTCV(RTOSCF(18653,F1943_18653,(Current))));
	Result = F1943_18624(Current, tr1);
	RTLE;
	return Result;
}

/* {PATH}.absolute_path_in */
EIF_REFERENCE F1943_18624 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE tr3 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(8);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,arg1);
	RTLR(3,loc1);
	RTLR(4,Result);
	RTLR(5,tr2);
	RTLR(6,tr3);
	RTLR(7,loc2);
	RTLIU(8);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	{
		/* INLINED CODE (is_empty) */
		tb1 = (EIF_BOOLEAN)  0;
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tb1 = tb1;
	if (tb1) {
		RTLE;
		return (EIF_REFERENCE) arg1;
	} else {
		if (F1943_18614(Current)) {
			RTLE;
			return (EIF_REFERENCE) Current;
		} else {
			if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
				tr1 = F1943_18618(Current);
				loc1 = tr1;
				if (EIF_TEST(loc1)) {
					tb1 = '\0';
					tb2 = '\0';
					tr1 = *(EIF_REFERENCE *)(loc1);
					ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
					if ((EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 4L))) {
						tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
						ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
						tb2 = (EIF_BOOLEAN) (ti4_1 >= ((EIF_INTEGER_32) 4L));
					}
					if (tb2) {
						tb2 = '\0';
						tr1 = *(EIF_REFERENCE *)(loc1);
						tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R12123[Dtype(tr1)-1408])(RTCW(tr1), ((EIF_INTEGER_32) 1L)));
						tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
						tc2 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R12123[Dtype(tr1)-1408])(RTCW(tr1), ((EIF_INTEGER_32) 1L)));
						if ((EIF_BOOLEAN)(tc1 == tc2)) {
							tr1 = *(EIF_REFERENCE *)(loc1);
							tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R12123[Dtype(tr1)-1408])(RTCW(tr1), ((EIF_INTEGER_32) 3L)));
							tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
							tc2 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R12123[Dtype(tr1)-1408])(RTCW(tr1), ((EIF_INTEGER_32) 3L)));
							tb2 = (EIF_BOOLEAN)(tc1 == tc2);
						}
						tb1 = tb2;
					}
					if (tb1) {
						Result = (EIF_REFERENCE) eif_builtin_ANY_twin (arg1);
					} else {
						Result = (EIF_REFERENCE) loc1;
					}
					tr1 = *(EIF_REFERENCE *)(RTCW(Result));
					tr2 = *(EIF_REFERENCE *)(Current);
					tr3 = *(EIF_REFERENCE *)(loc1);
					ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr3)+ _LNGOFF_1_1_0_2_);
					tr3 = *(EIF_REFERENCE *)(Current);
					ti4_2 = *(EIF_INTEGER_32 *)(RTCW(tr3)+ _LNGOFF_1_1_0_2_);
					{
						/* INLINED CODE (directory_separator) */
						tc1 = (EIF_CHARACTER_8)  0;
						tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
						if (tb1) {
							tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
						} else {
							tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
						}
						/* END INLINED CODE */
					}
					tc2 = tc1;
					F1943_18659(Current, tr1, tr2, (EIF_INTEGER_32) (ti4_1 + ((EIF_INTEGER_32) 1L)), ti4_2, tc2);
				} else {
					tr1 = *(EIF_REFERENCE *)(Current);
					if (F1943_18660(Current, tr1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '\\')) {
						Result = (EIF_REFERENCE) eif_builtin_ANY_twin (arg1);
						tr1 = F1943_18618(RTCW(Result));
						loc2 = tr1;
						if (EIF_TEST(loc2)) {
							Result = (EIF_REFERENCE) loc2;
						}
					} else {
						Result = (EIF_REFERENCE) eif_builtin_ANY_twin (arg1);
					}
					tr1 = *(EIF_REFERENCE *)(RTCW(Result));
					tr2 = *(EIF_REFERENCE *)(Current);
					{
						/* INLINED CODE (directory_separator) */
						tc1 = (EIF_CHARACTER_8)  0;
						tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
						if (tb1) {
							tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
						} else {
							tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
						}
						/* END INLINED CODE */
					}
					tc2 = tc1;
					F1943_18658(Current, tr1, tr2, tc2);
				}
			} else {
				Result = (EIF_REFERENCE) eif_builtin_ANY_twin (arg1);
				tr1 = *(EIF_REFERENCE *)(RTCW(Result));
				tr2 = *(EIF_REFERENCE *)(Current);
				{
					/* INLINED CODE (directory_separator) */
					tc1 = (EIF_CHARACTER_8)  0;
					tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
					if (tb1) {
						tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
					} else {
						tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
					}
					/* END INLINED CODE */
				}
				tc2 = tc1;
				F1943_18658(Current, tr1, tr2, tc2);
			}
			{
				/* INLINED CODE (reset_internal_data) */
				*(EIF_REFERENCE *)(RTCW(Result) + _REFACS_1_) = (EIF_REFERENCE) NULL;
				/* END INLINED CODE */
			}
			;
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.canonical_path */
EIF_REFERENCE F1943_18625 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc5 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE tr3 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	RTLD;
	
	RTLI(9);
	RTLR(0,loc2);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLR(4,loc4);
	RTLR(5,loc3);
	RTLR(6,loc1);
	RTLR(7,tr3);
	RTLR(8,loc5);
	RTLIU(9);
	
	RTGC;
	{
		/* INLINED CODE (absolute_path) */
		tr1 = (EIF_REFERENCE)  0;
		tr2 = RTOSCF(18653,F1943_18653,(Current));
		tr2 = F744_10531(RTCW(tr2));
		tr1 = F1943_18624(Current, tr2);
		/* END INLINED CODE */
	}
	loc2 = tr1;
	tr1 = F1943_18618(RTCW(loc2));
	loc4 = tr1;
	if (EIF_TEST(loc4)) {
		tr1 = RTLNSMART(eif_new_type(2189, 0).id);
		tr2 = *(EIF_REFERENCE *)(RTCW(loc2));
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2)+ _LNGOFF_1_1_0_2_);
		F2187_21438(RTCW(tr1), ti4_1);
		loc3 = (EIF_REFERENCE) tr1;
		loc1 = F1943_18622(RTCW(loc2));
		{
			/* INLINED CODE (start) */
			*(EIF_INTEGER_32 *)(RTCW(loc1) + O12334[Dtype(loc1)-1500]) = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			/* END INLINED CODE */
		}
		;
		tr1 = F1501_14864(RTCW(loc1));
		tr1 = *(EIF_REFERENCE *)(RTCW(tr1));
		{
			/* INLINED CODE (directory_separator) */
			tc1 = (EIF_CHARACTER_8)  0;
			tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
			if (tb1) {
				tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
			} else {
				tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
			}
			/* END INLINED CODE */
		}
		tc2 = tc1;
		F1943_18658(Current, loc3, tr1, tc2);
		(FUNCTION_CAST(void, (EIF_REFERENCE)) R11873[Dtype(loc1)-1280])(RTCW(loc1));
		for (;;) {
			{
				/* INLINED CODE (after) */
				tb1 = (EIF_BOOLEAN)  0;
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1) + O12334[Dtype(loc1)-1500]);
				ti4_2 = F1501_14880(RTCW(loc1));
				tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == (EIF_INTEGER_32) (ti4_2 + ((EIF_INTEGER_32) 1L)));
				/* END INLINED CODE */
			}
			tb1 = tb1;
			if (tb1) break;
			tr1 = F1501_14864(RTCW(loc1));
			{
				/* INLINED CODE (is_current_symbol) */
				tb2 = (EIF_BOOLEAN)  0;
				tr2 = tr1;
				tr3 = *(EIF_REFERENCE *)(RTCW(tr2));
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr3)+ _LNGOFF_1_1_0_2_);
				ti4_2 = F1943_18648(RTCW(tr2));
				if ((EIF_BOOLEAN)(ti4_1 == ti4_2)) {
					tr3 = *(EIF_REFERENCE *)(RTCW(tr2));
					tb2 = F1943_18660(RTCW(tr2), tr3, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '.');
				}
				/* END INLINED CODE */
			}
			tb2 = tb2;
			if (tb2) {
				(FUNCTION_CAST(void, (EIF_REFERENCE)) R11873[Dtype(loc1)-1280])(RTCW(loc1));
			} else {
				tr1 = F1501_14864(RTCW(loc1));
				tb2 = F1943_18610(RTCW(tr1));
				if (tb2) {
					{
						/* INLINED CODE (isfirst) */
						tb2 = (EIF_BOOLEAN)  0;
						tb2 = '\0';
						tb3 = F1284_14012(RTCW(loc1));
						if ((EIF_BOOLEAN) !tb3) {
							ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1) + O12334[Dtype(loc1)-1500]);
							tb2 = (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 1L));
						}
						/* END INLINED CODE */
					}
					tb2 = tb2;
					if ((EIF_BOOLEAN) !tb2) {
						{
							/* INLINED CODE (back) */
							(*(EIF_INTEGER_32 *)(RTCW(loc1) + O12334[Dtype(loc1)-1500]))--;
							/* END INLINED CODE */
						}
						;
						(FUNCTION_CAST(void, (EIF_REFERENCE)) R11873[Dtype(loc1)-1280])(RTCW(loc1));
					}
					(FUNCTION_CAST(void, (EIF_REFERENCE)) R11873[Dtype(loc1)-1280])(RTCW(loc1));
				} else {
					{
						/* INLINED CODE (forth) */
						(*(EIF_INTEGER_32 *)(RTCW(loc1) + O12334[Dtype(loc1)-1500]))++;
						/* END INLINED CODE */
					}
					;
				}
			}
		}
		loc5 = F1501_14873(RTCW(loc1));
		for (;;) {
			{
				/* INLINED CODE (after) */
				tb2 = (EIF_BOOLEAN)  0;
				ti4_1 = *(EIF_INTEGER_32 *)(loc5+ _LNGOFF_2_0_0_0_);
				ti4_2 = *(EIF_INTEGER_32 *)(loc5+ _LNGOFF_2_0_0_1_);
				tb2 = (EIF_BOOLEAN) (EIF_BOOLEAN) (ti4_1 > ti4_2);
				/* END INLINED CODE */
			}
			tb2 = tb2;
			if (tb2) break;
			tr1 = F1028_13603(loc5);
			tr1 = *(EIF_REFERENCE *)(RTCW(tr1));
			{
				/* INLINED CODE (directory_separator) */
				tc1 = (EIF_CHARACTER_8)  0;
				tb3 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
				if (tb3) {
					tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
				} else {
					tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
				}
				/* END INLINED CODE */
			}
			tc2 = tc1;
			F1943_18658(Current, loc3, tr1, tc2);
			{
				/* INLINED CODE (forth) */
				(*(EIF_INTEGER_32 *)(loc5+ _LNGOFF_2_0_0_0_))++;
				/* END INLINED CODE */
			}
			;
		}
		tr1 = RTLNS(eif_new_type(1942, 0x00).id, 1942, _OBJSIZ_2_1_0_0_0_0_0_0_);
		F1943_18607(RTCW(tr1), loc3);
		RTLE;
		return (EIF_REFERENCE) tr1;
	} else {
		RTLE;
		return (EIF_REFERENCE) loc2;
	}/* NOTREACHED */
	
}

/* {PATH}.hash_code */
EIF_INTEGER_32 F1943_18626 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	if ((EIF_BOOLEAN) EIF_TEST(eif_case_sensitive_path_names())) {
		tr1 = *(EIF_REFERENCE *)(Current);
		Result = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R14844[Dtype(tr1)-1932])(RTCW(tr1));
	} else {
		Result = F2185_21352(RTCV(F1943_18643(Current)));
	}
	RTLE;
	return Result;
}

/* {PATH}.directory_separator */
EIF_CHARACTER_8 F1943_18630 (EIF_REFERENCE Current)
{
	GTCX
	
	
	RTGC;
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
		return (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
	} else {
		return (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
	}/* NOTREACHED */
	
}

/* {PATH}.extended */
EIF_REFERENCE F1943_18631 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_INTEGER_32 ti4_4;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	RTLD;
	
	RTLI(5);
	RTLR(0,loc1);
	RTLR(1,tr1);
	RTLR(2,Current);
	RTLR(3,tr2);
	RTLR(4,arg1);
	RTLIU(5);
	
	RTGC;
	tr1 = RTLNSMART(eif_new_type(2189, 0).id);
	tr2 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2)+ _LNGOFF_1_1_0_2_);
	ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R16676[Dtype(arg1)-2186])(RTCW(arg1));
	ti4_3 = F1943_18648(Current);
	ti4_4 = F1943_18648(Current);
	F2187_21438(RTCW(tr1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + (EIF_INTEGER_32) (ti4_2 * ti4_3)) + ti4_4));
	loc1 = (EIF_REFERENCE) tr1;
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R16821[Dtype(loc1)-2189])(RTCW(loc1), *(EIF_REFERENCE *)(Current));
	tb1 = '\0';
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
	if ((EIF_BOOLEAN) (ti4_1 > ((EIF_INTEGER_32) 0L))) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN)(F1943_18654(Current) == ti4_1);
	}
	if (tb1) {
		F1943_18657(Current, loc1, arg1, (EIF_CHARACTER_8) '\000');
	} else {
		{
			/* INLINED CODE (directory_separator) */
			tc1 = (EIF_CHARACTER_8)  0;
			tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
			if (tb1) {
				tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
			} else {
				tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
			}
			/* END INLINED CODE */
		}
		tc2 = tc1;
		F1943_18657(Current, loc1, arg1, tc2);
	}
	tr1 = RTLNS(eif_new_type(1942, 0x00).id, 1942, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F1943_18606(RTCW(tr1), loc1);
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.extended_path */
EIF_REFERENCE F1943_18632 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	RTLD;
	
	RTLI(5);
	RTLR(0,loc1);
	RTLR(1,tr1);
	RTLR(2,Current);
	RTLR(3,tr2);
	RTLR(4,arg1);
	RTLIU(5);
	
	RTGC;
	tr1 = RTLNSMART(eif_new_type(2189, 0).id);
	tr2 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2)+ _LNGOFF_1_1_0_2_);
	tr2 = *(EIF_REFERENCE *)(RTCW(arg1));
	ti4_2 = *(EIF_INTEGER_32 *)(RTCW(tr2)+ _LNGOFF_1_1_0_2_);
	ti4_3 = F1943_18648(Current);
	F2187_21438(RTCW(tr1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + ti4_2) + ti4_3));
	loc1 = (EIF_REFERENCE) tr1;
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R16821[Dtype(loc1)-2189])(RTCW(loc1), *(EIF_REFERENCE *)(Current));
	tb1 = '\0';
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
	if ((EIF_BOOLEAN) (ti4_1 > ((EIF_INTEGER_32) 0L))) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN)(F1943_18654(Current) == ti4_1);
	}
	if (tb1) {
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
		F1943_18658(Current, loc1, tr1, (EIF_CHARACTER_8) '\000');
	} else {
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
		{
			/* INLINED CODE (directory_separator) */
			tc1 = (EIF_CHARACTER_8)  0;
			tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
			if (tb1) {
				tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
			} else {
				tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
			}
			/* END INLINED CODE */
		}
		tc2 = tc1;
		F1943_18658(Current, loc1, tr1, tc2);
	}
	tr1 = RTLNS(eif_new_type(1942, 0x00).id, 1942, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F1943_18607(RTCW(tr1), loc1);
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.appended */
EIF_REFERENCE F1943_18633 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	RTLD;
	
	RTLI(5);
	RTLR(0,loc1);
	RTLR(1,tr1);
	RTLR(2,Current);
	RTLR(3,tr2);
	RTLR(4,arg1);
	RTLIU(5);
	
	RTGC;
	tr1 = RTLNSMART(eif_new_type(2189, 0).id);
	tr2 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2)+ _LNGOFF_1_1_0_2_);
	ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R16676[Dtype(arg1)-2186])(RTCW(arg1));
	ti4_3 = F1943_18648(Current);
	F2187_21438(RTCW(tr1), (EIF_INTEGER_32) (ti4_1 + (EIF_INTEGER_32) (ti4_2 * ti4_3)));
	loc1 = (EIF_REFERENCE) tr1;
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R16821[Dtype(loc1)-2189])(RTCW(loc1), *(EIF_REFERENCE *)(Current));
	F1943_18657(Current, loc1, arg1, (EIF_CHARACTER_8) '\000');
	tr1 = RTLNS(eif_new_type(1942, 0x00).id, 1942, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F1943_18606(RTCW(tr1), loc1);
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.appended_with_extension */
EIF_REFERENCE F1943_18634 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_INTEGER_32 ti4_4;
	RTLD;
	
	RTLI(5);
	RTLR(0,loc1);
	RTLR(1,tr1);
	RTLR(2,Current);
	RTLR(3,tr2);
	RTLR(4,arg1);
	RTLIU(5);
	
	RTGC;
	tr1 = RTLNSMART(eif_new_type(2189, 0).id);
	tr2 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2)+ _LNGOFF_1_1_0_2_);
	ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R16676[Dtype(arg1)-2186])(RTCW(arg1));
	ti4_3 = F1943_18648(Current);
	ti4_4 = F1943_18648(Current);
	F2187_21438(RTCW(tr1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + (EIF_INTEGER_32) (ti4_2 * ti4_3)) + ti4_4));
	loc1 = (EIF_REFERENCE) tr1;
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R16821[Dtype(loc1)-2189])(RTCW(loc1), *(EIF_REFERENCE *)(Current));
	F1943_18657(Current, loc1, arg1, (EIF_CHARACTER_8) '.');
	tr1 = RTLNS(eif_new_type(1942, 0x00).id, 1942, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F1943_18607(RTCW(tr1), loc1);
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.same_as */
EIF_BOOLEAN F1943_18635 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(4);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTGC;
	if ((EIF_BOOLEAN)(arg1 == NULL)) {
	} else {
		if ((EIF_BOOLEAN)(arg1 == Current)) {
			RTLE;
			return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		} else {
			if ((EIF_BOOLEAN) EIF_TEST(eif_case_sensitive_path_names())) {
				{
					/* INLINED CODE (is_case_sensitive_equal) */
					tb1 = (EIF_BOOLEAN)  0;
					if ((EIF_BOOLEAN)(arg1 == Current)) {
						tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
					} else {
						tr1 = *(EIF_REFERENCE *)(Current);
						tr2 = *(EIF_REFERENCE *)(RTCW(arg1));
						tb1 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE, EIF_REFERENCE)) R11[Dtype(tr1)-0])(RTCW(tr1), tr2);
					}
					/* END INLINED CODE */
				}
				RTLE;
				return (EIF_BOOLEAN) tb1;
			} else {
				RTLE;
				return (EIF_BOOLEAN) F1943_18639(Current, arg1);
			}
		}
	}
	RTLE;
	return (EIF_BOOLEAN) 0;
}

/* {PATH}.is_less */
EIF_BOOLEAN F1943_18636 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,arg1);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTGC;
	if ((EIF_BOOLEAN) EIF_TEST(eif_case_sensitive_path_names())) {
		tr1 = *(EIF_REFERENCE *)(Current);
		tr2 = *(EIF_REFERENCE *)(RTCW(arg1));
		Result = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE, EIF_REFERENCE)) R9801[Dtype(tr1)-793])(RTCW(tr1), tr2);
	} else {
		tr1 = F2195_21728(RTCV(F1943_18643(Current)));
		tr2 = F1943_18643(RTCW(arg1));
		tr2 = F2195_21728(RTCW(tr2));
		Result = F2194_21693(RTCW(tr1), tr2);
	}
	RTLE;
	return Result;
}

/* {PATH}.is_equal */
EIF_BOOLEAN F1943_18637 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	
	
	return (EIF_BOOLEAN) F1943_18635(Current, arg1);
}

/* {PATH}.is_case_sensitive_equal */
EIF_BOOLEAN F1943_18638 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTGC;
	if ((EIF_BOOLEAN)(arg1 == Current)) {
		RTLE;
		return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	} else {
		tr1 = *(EIF_REFERENCE *)(Current);
		tr2 = *(EIF_REFERENCE *)(RTCW(arg1));
		Result = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE, EIF_REFERENCE)) R11[Dtype(tr1)-0])(RTCW(tr1), tr2);
	}
	RTLE;
	return Result;
}

/* {PATH}.is_case_insensitive_equal */
EIF_BOOLEAN F1943_18639 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTGC;
	if ((EIF_BOOLEAN)(arg1 == Current)) {
		RTLE;
		return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	} else {
		tr1 = F1943_18643(Current);
		tr2 = F1943_18643(RTCW(arg1));
		Result = F2194_21689(RTCW(tr1), tr2);
	}
	RTLE;
	return Result;
}

/* {PATH}.copy */
void F1943_18640 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLIU(3);
	
	RTGC;
	if ((EIF_BOOLEAN)(arg1 != Current)) {
		eif_builtin_ANY_standard_copy (Current, arg1);
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
		tr1 = (EIF_REFERENCE) eif_builtin_ANY_twin (tr1);
		RTAR(Current, tr1);
		*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	}
	RTLE;
}

/* {PATH}.out */
EIF_REFERENCE F1943_18641 (EIF_REFERENCE Current)
{
	GTCX
	
	
	return (EIF_REFERENCE) F1943_18642(Current);
}

/* {PATH}.utf_8_name */
EIF_REFERENCE F1943_18642 (EIF_REFERENCE Current)
{
	GTCX
	struct eif_ex_130 sloc1;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) sloc1.data;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	memset (&sloc1.overhead, 0, OVERHEAD + _OBJSIZ_0_0_0_0_0_0_0_0_);
	sloc1.overhead.ov_flags = EO_EXP | EO_STACK;
	RT_DFS(&sloc1.overhead, eif_new_type(142, 0x00).id);
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	tr1 = F1943_18643(Current);
	Result = F143_2687(RTCW(loc1), tr1);
	RTLE;
	return Result;
}

/* {PATH}.name */
EIF_REFERENCE F1943_18643 (EIF_REFERENCE Current)
{
	GTCX
	struct eif_ex_130 sloc1;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) sloc1.data;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	memset (&sloc1.overhead, 0, OVERHEAD + _OBJSIZ_0_0_0_0_0_0_0_0_);
	sloc1.overhead.ov_flags = EO_EXP | EO_STACK;
	RT_DFS(&sloc1.overhead, eif_new_type(142, 0x00).id);
	RTLI(6);
	RTLR(0,loc2);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc1);
	RTLR(4,tr2);
	RTLR(5,Result);
	RTLIU(6);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_1_);
	loc2 = tr1;
	if (EIF_TEST(loc2)) {
		RTLE;
		return (EIF_REFERENCE) loc2;
	} else {
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
			tr1 = RTLNS(eif_new_type(2194, 0x00).id, 2194, _OBJSIZ_1_0_0_4_0_0_0_0_);
			tr2 = F143_2729(RTCW(loc1), *(EIF_REFERENCE *)(Current));
			F2194_21667(RTCW(tr1), tr2);
			Result = (EIF_REFERENCE) tr1;
		} else {
			tr1 = RTLNS(eif_new_type(2194, 0x00).id, 2194, _OBJSIZ_1_0_0_4_0_0_0_0_);
			tr2 = F143_2702(RTCW(loc1), *(EIF_REFERENCE *)(Current));
			F2194_21667(RTCW(tr1), tr2);
			Result = (EIF_REFERENCE) tr1;
		}
		RTAR(Current, Result);
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) Result;
	}
	RTLE;
	return Result;
}

/* {PATH}.to_pointer */
EIF_REFERENCE F1943_18645 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,tr1);
	RTLR(2,Current);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTGC;
	tr1 = RTLNS(eif_new_type(865, 0x00).id, 865, _OBJSIZ_1_0_0_1_0_0_0_0_);
	tr2 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2)+ _LNGOFF_1_1_0_2_);
	ti4_2 = F1943_18648(Current);
	F866_12667(RTCW(tr1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + ti4_2) - ((EIF_INTEGER_32) 1L)));
	loc1 = (EIF_REFERENCE) tr1;
	{
		/* INLINED CODE (set_string) */
		tr1 = *(EIF_REFERENCE *)(Current);
		ti4_1 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R16676[Dtype(tr1)-2186])(RTCW(tr1));
		F866_12692(RTCW(loc1), tr1, ((EIF_INTEGER_32) 1L), ti4_1);
		/* END INLINED CODE */
	}
	;
	tr1 = *(EIF_REFERENCE *)(RTCW(loc1));
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.storage */
EIF_REFERENCE F1943_18647 (EIF_REFERENCE Current)
{
	return *(EIF_REFERENCE *)(Current);
}


/* {PATH}.unit_size */
EIF_INTEGER_32 F1943_18648 (EIF_REFERENCE Current)
{
	GTCX
	
	
	RTGC;
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
	} else {
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	}/* NOTREACHED */
	
}

/* {PATH}.reset_internal_data */
void F1943_18649 (EIF_REFERENCE Current)
{
	GTCX
	
	
	*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
}

/* {PATH}.normalize */
void F1943_18650 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc4 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc5 = (EIF_INTEGER_32) 0;
	EIF_BOOLEAN loc6 = (EIF_BOOLEAN) 0;
	EIF_BOOLEAN loc7 = (EIF_BOOLEAN) 0;
	EIF_BOOLEAN loc8 = (EIF_BOOLEAN) 0;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	RTLD;
	
	RTLI(2);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLIU(2);
	
	RTGC;
	loc1 = *(EIF_REFERENCE *)(Current);
	loc4 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
		loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		if ((EIF_BOOLEAN) (loc4 >= ((EIF_INTEGER_32) 10L))) {
			tb1 = '\01';
			tb2 = '\0';
			if (F1943_18660(Current, loc1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '/')) {
				tb3 = '\01';
				if (!F1943_18660(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '/')) {
					tb3 = F1943_18660(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '\\');
				}
				tb2 = tb3;
			}
			if (!(tb2)) {
				tb2 = '\0';
				if (F1943_18660(Current, loc1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '\\')) {
					tb3 = '\01';
					if (!F1943_18660(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '\\')) {
						tb3 = F1943_18660(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '/');
					}
					tb2 = tb3;
				}
				tb1 = tb2;
			}
			if (tb1) {
				tb1 = '\0';
				if ((EIF_BOOLEAN) !F1943_18660(Current, loc1, ((EIF_INTEGER_32) 5L), (EIF_CHARACTER_8) '/')) {
					tb1 = (EIF_BOOLEAN) !F1943_18660(Current, loc1, ((EIF_INTEGER_32) 5L), (EIF_CHARACTER_8) '\\');
				}
				if (tb1) {
					loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 5L);
					loc8 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
				}
			}
		}
		loc3 = (EIF_INTEGER_32) loc2;
		loc7 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		for (;;) {
			if ((EIF_BOOLEAN) (loc2 > loc4)) break;
			if (loc6) {
				loc7 = '\0';
				if ((EIF_BOOLEAN) !F1943_18660(Current, loc1, loc2, (EIF_CHARACTER_8) '\\')) {
					loc7 = (EIF_BOOLEAN) !F1943_18660(Current, loc1, loc2, (EIF_CHARACTER_8) '/');
				}
				loc6 = (EIF_BOOLEAN) (EIF_BOOLEAN) !loc7;
			} else {
				if (F1943_18660(Current, loc1, loc2, (EIF_CHARACTER_8) '/')) {
					tc1 = (EIF_CHARACTER_8) '\\';
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R11865[Dtype(loc1)-1408])(RTCW(loc1), (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &loc2);
					loc6 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
				} else {
					loc6 = F1943_18660(Current, loc1, loc2, (EIF_CHARACTER_8) '\\');
				}
			}
			if (loc7) {
				if ((EIF_BOOLEAN)(loc2 != loc3)) {
					tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R12123[Dtype(loc1)-1408])(RTCW(loc1), loc2));
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R11865[Dtype(loc1)-1408])(RTCW(loc1), (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &loc3);
					tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R12123[Dtype(loc1)-1408])(RTCW(loc1), (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L))));
					ti4_1 = (EIF_INTEGER_32) (loc3 + ((EIF_INTEGER_32) 1L));
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R11865[Dtype(loc1)-1408])(RTCW(loc1), (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &ti4_1);
				}
				loc3 += ((EIF_INTEGER_32) 2L);
			}
			loc2 += ((EIF_INTEGER_32) 2L);
		}
	} else {
		loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		loc3 = (EIF_INTEGER_32) loc2;
		loc7 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		for (;;) {
			if ((EIF_BOOLEAN) (loc2 > loc4)) break;
			if (loc6) {
				loc7 = F1943_18660(Current, loc1, loc2, (EIF_CHARACTER_8) '/');
				loc7 = (EIF_BOOLEAN) (EIF_BOOLEAN) !loc7;
				loc6 = (EIF_BOOLEAN) (EIF_BOOLEAN) !loc7;
			} else {
				loc6 = F1943_18660(Current, loc1, loc2, (EIF_CHARACTER_8) '/');
			}
			if (loc7) {
				if ((EIF_BOOLEAN)(loc2 != loc3)) {
					tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R12123[Dtype(loc1)-1408])(RTCW(loc1), loc2));
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R11865[Dtype(loc1)-1408])(RTCW(loc1), (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &loc3);
				}
				loc3++;
			}
			loc2++;
		}
	}
	if ((EIF_BOOLEAN)(loc2 != loc3)) {
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_INTEGER_32)) R16792[Dtype(loc1)-2189])(RTCW(loc1), (EIF_INTEGER_32) (loc3 - ((EIF_INTEGER_32) 1L)));
	}
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	if (loc8) {
		loc5 = F1943_18654(Current);
		if ((EIF_BOOLEAN)(loc5 == ((EIF_INTEGER_32) 0L))) {
			{
				/* INLINED CODE (unit_size) */
				ti4_1 = (EIF_INTEGER_32)  0;
				tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
				if (tb1) {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
				} else {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
				}
				/* END INLINED CODE */
			}
			ti4_2 = ti4_1;
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_INTEGER_32)) R16798[Dtype(loc1)-2189])(RTCW(loc1), ti4_2);
		}
	}
	tb1 = '\0';
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
	{
		/* INLINED CODE (unit_size) */
		ti4_2 = (EIF_INTEGER_32)  0;
		tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
		if (tb2) {
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
		} else {
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		}
		/* END INLINED CODE */
	}
	ti4_3 = ti4_2;
	{
		/* INLINED CODE (directory_separator) */
		tc1 = (EIF_CHARACTER_8)  0;
		tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
		if (tb2) {
			tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
		} else {
			tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
		}
		/* END INLINED CODE */
	}
	tc2 = tc1;
	if (F1943_18660(Current, loc1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_3) + ((EIF_INTEGER_32) 1L)), tc2)) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN) (F1943_18654(Current) < ti4_1);
	}
	if (tb1) {
		{
			/* INLINED CODE (unit_size) */
			ti4_1 = (EIF_INTEGER_32)  0;
			tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
			if (tb1) {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
			} else {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
			/* END INLINED CODE */
		}
		ti4_2 = ti4_1;
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_INTEGER_32)) R16800[Dtype(loc1)-2189])(RTCW(loc1), ti4_2);
	}
	RTLE;
}

/* {PATH}.internal_name */
EIF_REFERENCE F1943_18651 (EIF_REFERENCE Current)
{
	return *(EIF_REFERENCE *)(Current + _REFACS_1_);
}


/* {PATH}.env */
static EIF_REFERENCE F1943_18653_body (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	

	RTLI(1);
	RTLR(0,tr1);
	RTLIU(1);
	
	RTEV;
	RTGC;
	RTOSP (18653);
#define Result RTOSR(18653)
	RTOC_NEW(Result);
	tr1 = RTLNS(eif_new_type(743, 0x00).id, 743, _OBJSIZ_0_0_0_1_0_0_0_0_);
	Result = (EIF_REFERENCE) tr1;
	RTOSE (18653);
	RTLE;
	RTEE;
	return Result;
#undef Result
}

EIF_REFERENCE F1943_18653 (EIF_REFERENCE Current)
{
	GTCX
	return RTOSCF(18653,F1943_18653_body,(Current));
}

/* {PATH}.root_end_position */
EIF_INTEGER_32 F1943_18654 (EIF_REFERENCE Current)
{
	GTCX
	EIF_CHARACTER_8 loc1 = (EIF_CHARACTER_8) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_CHARACTER_8 tc1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	{
		/* INLINED CODE (is_empty) */
		tb1 = (EIF_BOOLEAN)  0;
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tb1 = tb1;
	if ((EIF_BOOLEAN) !tb1) {
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
			tb1 = '\0';
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
			{
				/* INLINED CODE (unit_size) */
				ti4_2 = (EIF_INTEGER_32)  0;
				tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
				if (tb2) {
					ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
				} else {
					ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
				}
				/* END INLINED CODE */
			}
			if ((EIF_BOOLEAN)(ti4_1 == ti4_2)) {
				tr1 = *(EIF_REFERENCE *)(Current);
				tb1 = F1943_18660(Current, tr1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '\\');
			}
			if (tb1) {
				{
					/* INLINED CODE (unit_size) */
					ti4_1 = (EIF_INTEGER_32)  0;
					tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
					if (tb1) {
						ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
					} else {
						ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
					}
					/* END INLINED CODE */
				}
				RTLE;
				return (EIF_INTEGER_32) ti4_1;
			} else {
				tb1 = '\0';
				tr1 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
				if ((EIF_BOOLEAN) (ti4_1 >= ((EIF_INTEGER_32) 4L))) {
					tb2 = '\0';
					tr1 = *(EIF_REFERENCE *)(Current);
					tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R12123[Dtype(tr1)-1408])(RTCW(tr1), ((EIF_INTEGER_32) 2L)));
					if ((EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\000')) {
						tr1 = *(EIF_REFERENCE *)(Current);
						tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R12123[Dtype(tr1)-1408])(RTCW(tr1), ((EIF_INTEGER_32) 4L)));
						tb2 = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\000');
					}
					tb1 = tb2;
				}
				if (tb1) {
					tr1 = *(EIF_REFERENCE *)(Current);
					loc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R12123[Dtype(tr1)-1408])(RTCW(tr1), ((EIF_INTEGER_32) 1L)));
					loc1 = (EIF_CHARACTER_8) tolower(loc1);
					tb1 = '\0';
					if ((EIF_BOOLEAN) ((EIF_BOOLEAN) (loc1 >= (EIF_CHARACTER_8) 'a') && (EIF_BOOLEAN) (loc1 <= (EIF_CHARACTER_8) 'z'))) {
						tr1 = *(EIF_REFERENCE *)(Current);
						tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R12123[Dtype(tr1)-1408])(RTCW(tr1), ((EIF_INTEGER_32) 3L)));
						tb1 = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) ':');
					}
					if (tb1) {
						tb1 = '\0';
						tr1 = *(EIF_REFERENCE *)(Current);
						ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
						{
							/* INLINED CODE (unit_size) */
							ti4_2 = (EIF_INTEGER_32)  0;
							tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
							if (tb2) {
								ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
							} else {
								ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
							}
							/* END INLINED CODE */
						}
						if ((EIF_BOOLEAN) (ti4_1 >= (EIF_INTEGER_32) (((EIF_INTEGER_32) 3L) * ti4_2))) {
							tr1 = *(EIF_REFERENCE *)(Current);
							tb1 = F1943_18660(Current, tr1, ((EIF_INTEGER_32) 5L), (EIF_CHARACTER_8) '\\');
						}
						if (tb1) {
							RTLE;
							return (EIF_INTEGER_32) ((EIF_INTEGER_32) 6L);
						} else {
							RTLE;
							return (EIF_INTEGER_32) ((EIF_INTEGER_32) 4L);
						}
					} else {
						tb1 = '\0';
						if ((EIF_BOOLEAN)(loc1 == (EIF_CHARACTER_8) '\\')) {
							tr1 = *(EIF_REFERENCE *)(Current);
							tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R12123[Dtype(tr1)-1408])(RTCW(tr1), ((EIF_INTEGER_32) 3L)));
							tb1 = (EIF_BOOLEAN)(tc1 != (EIF_CHARACTER_8) '\\');
						}
						if (tb1) {
							{
								/* INLINED CODE (unit_size) */
								ti4_1 = (EIF_INTEGER_32)  0;
								tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
								if (tb1) {
									ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
								} else {
									ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
								}
								/* END INLINED CODE */
							}
							Result = ti4_1;
						} else {
							tb1 = '\0';
							tb2 = '\0';
							tb3 = '\0';
							tr1 = *(EIF_REFERENCE *)(Current);
							ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
							if ((EIF_BOOLEAN) (ti4_1 >= ((EIF_INTEGER_32) 10L))) {
								tb3 = (EIF_BOOLEAN)(loc1 == (EIF_CHARACTER_8) '\\');
							}
							if (tb3) {
								tr1 = *(EIF_REFERENCE *)(Current);
								tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R12123[Dtype(tr1)-1408])(RTCW(tr1), ((EIF_INTEGER_32) 3L)));
								tb2 = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\\');
							}
							if (tb2) {
								tr1 = *(EIF_REFERENCE *)(Current);
								tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R12123[Dtype(tr1)-1408])(RTCW(tr1), ((EIF_INTEGER_32) 5L)));
								tb1 = (EIF_BOOLEAN)(tc1 != (EIF_CHARACTER_8) '\\');
							}
							if (tb1) {
								loc2 = F1943_18656(Current, ((EIF_INTEGER_32) 7L));
								tb1 = '\0';
								if ((EIF_BOOLEAN) (loc2 > ((EIF_INTEGER_32) 0L))) {
									{
										/* INLINED CODE (unit_size) */
										ti4_1 = (EIF_INTEGER_32)  0;
										tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
										if (tb2) {
											ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
										} else {
											ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
										}
										/* END INLINED CODE */
									}
									tr1 = *(EIF_REFERENCE *)(Current);
									ti4_2 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
									tb1 = (EIF_BOOLEAN) ((EIF_INTEGER_32) (loc2 + ti4_1) <= ti4_2);
								}
								if (tb1) {
									{
										/* INLINED CODE (unit_size) */
										ti4_1 = (EIF_INTEGER_32)  0;
										tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
										if (tb1) {
											ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
										} else {
											ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
										}
										/* END INLINED CODE */
									}
									ti4_2 = ti4_1;
									loc2 = F1943_18656(Current, (EIF_INTEGER_32) (loc2 + ti4_2));
									if ((EIF_BOOLEAN) (loc2 > ((EIF_INTEGER_32) 0L))) {
										RTLE;
										return (EIF_INTEGER_32) (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L));
									} else {
										tr1 = *(EIF_REFERENCE *)(Current);
										Result = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
									}
								}
							}
						}
					}
				}
			}
		} else {
			tr1 = *(EIF_REFERENCE *)(Current);
			tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R12123[Dtype(tr1)-1408])(RTCW(tr1), ((EIF_INTEGER_32) 1L)));
			if ((EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '/')) {
				RTLE;
				return (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.end_position_of_last_directory_separator */
EIF_INTEGER_32 F1943_18655 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	{
		/* INLINED CODE (is_empty) */
		tb1 = (EIF_BOOLEAN)  0;
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tb1 = tb1;
	if ((EIF_BOOLEAN) !tb1) {
		tr1 = *(EIF_REFERENCE *)(Current);
		Result = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		{
			/* INLINED CODE (unit_size) */
			ti4_1 = (EIF_INTEGER_32)  0;
			tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
			if (tb1) {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
			} else {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
			/* END INLINED CODE */
		}
		ti4_2 = ti4_1;
		Result = (EIF_INTEGER_32) (EIF_INTEGER_32) ((EIF_INTEGER_32) (Result - ti4_2) + ((EIF_INTEGER_32) 1L));
		if ((EIF_BOOLEAN) (Result >= ((EIF_INTEGER_32) 1L))) {
			for (;;) {
				tb1 = '\01';
				if (!(EIF_BOOLEAN) (Result < ((EIF_INTEGER_32) 1L))) {
					tr1 = *(EIF_REFERENCE *)(Current);
					{
						/* INLINED CODE (directory_separator) */
						tc1 = (EIF_CHARACTER_8)  0;
						tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
						if (tb2) {
							tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
						} else {
							tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
						}
						/* END INLINED CODE */
					}
					tc2 = tc1;
					tb1 = F1943_18660(Current, tr1, Result, tc2);
				}
				if (tb1) break;
				{
					/* INLINED CODE (unit_size) */
					ti4_1 = (EIF_INTEGER_32)  0;
					tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
					if (tb2) {
						ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
					} else {
						ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
					}
					/* END INLINED CODE */
				}
				Result -= ti4_1;
			}
		}
		if ((EIF_BOOLEAN) (Result < ((EIF_INTEGER_32) 0L))) {
			RTLE;
			return (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
		} else {
			{
				/* INLINED CODE (unit_size) */
				ti4_1 = (EIF_INTEGER_32)  0;
				tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
				if (tb2) {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
				} else {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
				}
				/* END INLINED CODE */
			}
			ti4_2 = ti4_1;
			Result = (EIF_INTEGER_32) (EIF_INTEGER_32) ((EIF_INTEGER_32) (Result + ti4_2) - ((EIF_INTEGER_32) 1L));
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.next_directory_separator */
EIF_INTEGER_32 F1943_18656 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_CHARACTER_8 loc3 = (EIF_CHARACTER_8) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,loc4);
	RTLIU(2);
	
	RTGC;
	{
		/* INLINED CODE (unit_size) */
		ti4_1 = (EIF_INTEGER_32)  0;
		tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
		if (tb1) {
			ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
		} else {
			ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		}
		/* END INLINED CODE */
	}
	loc2 = ti4_1;
	{
		/* INLINED CODE (directory_separator) */
		tc1 = (EIF_CHARACTER_8)  0;
		tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
		if (tb1) {
			tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
		} else {
			tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
		}
		/* END INLINED CODE */
	}
	loc3 = tc1;
	Result = (EIF_INTEGER_32) arg1;
	loc4 = *(EIF_REFERENCE *)(Current);
	loc1 = *(EIF_INTEGER_32 *)(RTCW(loc4)+ _LNGOFF_1_1_0_2_);
	for (;;) {
		tb1 = '\01';
		if (!(EIF_BOOLEAN) ((EIF_BOOLEAN) (Result < ((EIF_INTEGER_32) 1L)) || (EIF_BOOLEAN) (Result > loc1))) {
			tb1 = F1943_18660(Current, loc4, Result, loc3);
		}
		if (tb1) break;
		Result += loc2;
	}
	if ((EIF_BOOLEAN) (Result > loc1)) {
		RTLE;
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
	}
	RTLE;
	return Result;
}

/* {PATH}.internal_append_into */
void F1943_18657 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_CHARACTER_8 arg3)
{
	GTCX
	struct eif_ex_130 sloc1;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) sloc1.data;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_CHARACTER_32 tw1;
	EIF_CHARACTER_32 tw2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	RTLD;
	
	memset (&sloc1.overhead, 0, OVERHEAD + _OBJSIZ_0_0_0_0_0_0_0_0_);
	sloc1.overhead.ov_flags = EO_EXP | EO_STACK;
	RT_DFS(&sloc1.overhead, eif_new_type(142, 0x00).id);
	RTLI(4);
	RTLR(0,arg2);
	RTLR(1,arg1);
	RTLR(2,Current);
	RTLR(3,loc1);
	RTLIU(4);
	
	RTGC;
	tb1 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R16654[Dtype(arg2)-2187])(RTCW(arg2));
	if ((EIF_BOOLEAN) !tb1) {
		tb1 = '\0';
		tb2 = '\0';
		tb3 = '\0';
		if ((EIF_BOOLEAN)(arg3 != (EIF_CHARACTER_8) '\000')) {
			{
				/* INLINED CODE (is_empty) */
				tb4 = (EIF_BOOLEAN)  0;
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1)+ _LNGOFF_1_1_0_2_);
				tb4 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
				/* END INLINED CODE */
			}
			tb4 = tb4;
			tb3 = (EIF_BOOLEAN) !tb4;
		}
		if (tb3) {
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1)+ _LNGOFF_1_1_0_2_);
			{
				/* INLINED CODE (unit_size) */
				ti4_2 = (EIF_INTEGER_32)  0;
				tb3 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
				if (tb3) {
					ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
				} else {
					ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
				}
				/* END INLINED CODE */
			}
			ti4_3 = ti4_2;
			tb2 = (EIF_BOOLEAN) !F1943_18660(Current, arg1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_3) + ((EIF_INTEGER_32) 1L)), arg3);
		}
		if (tb2) {
			tw1 = (FUNCTION_CAST(EIF_CHARACTER_32, (EIF_REFERENCE, EIF_INTEGER_32)) R16640[Dtype(arg2)-2187])(RTCW(arg2), ((EIF_INTEGER_32) 1L));
			tw2 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '/';
			tb1 = (EIF_BOOLEAN)(tw1 != tw2);
		}
		if (tb1) {
			if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
				tw1 = (FUNCTION_CAST(EIF_CHARACTER_32, (EIF_REFERENCE, EIF_INTEGER_32)) R16640[Dtype(arg2)-2187])(RTCW(arg2), ((EIF_INTEGER_32) 1L));
				tw2 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '\\';
				if ((EIF_BOOLEAN)(tw1 != tw2)) {
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R16825[Dtype(arg1)-2189])(RTCW(arg1), arg3);
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R16825[Dtype(arg1)-2189])(RTCW(arg1), (EIF_CHARACTER_8) '\000');
				}
			} else {
				(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R16825[Dtype(arg1)-2189])(RTCW(arg1), arg3);
			}
		}
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
			F143_2716(RTCW(loc1), arg2, arg1);
		} else {
			F143_2691(RTCW(loc1), arg2, arg1);
		}
	}
	RTLE;
}

/* {PATH}.internal_path_append_into */
void F1943_18658 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_CHARACTER_8 arg3)
{
	GTCX
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,arg2);
	RTLIU(3);
	
	RTGC;
	tb1 = '\0';
	tb2 = '\0';
	tb3 = '\0';
	if ((EIF_BOOLEAN)(arg3 != (EIF_CHARACTER_8) '\000')) {
		{
			/* INLINED CODE (is_empty) */
			tb4 = (EIF_BOOLEAN)  0;
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1)+ _LNGOFF_1_1_0_2_);
			tb4 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
			/* END INLINED CODE */
		}
		tb4 = tb4;
		tb3 = (EIF_BOOLEAN) !tb4;
	}
	if (tb3) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1)+ _LNGOFF_1_1_0_2_);
		{
			/* INLINED CODE (unit_size) */
			ti4_2 = (EIF_INTEGER_32)  0;
			tb3 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
			if (tb3) {
				ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
			} else {
				ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
			/* END INLINED CODE */
		}
		ti4_3 = ti4_2;
		tb2 = (EIF_BOOLEAN) !F1943_18660(Current, arg1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_3) + ((EIF_INTEGER_32) 1L)), arg3);
	}
	if (tb2) {
		tb1 = (EIF_BOOLEAN) !F1943_18660(Current, arg2, ((EIF_INTEGER_32) 1L), arg3);
	}
	if (tb1) {
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R16825[Dtype(arg1)-2189])(RTCW(arg1), arg3);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R16825[Dtype(arg1)-2189])(RTCW(arg1), (EIF_CHARACTER_8) '\000');
		}
	}
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R16821[Dtype(arg1)-2189])(RTCW(arg1), arg2);
	RTLE;
}

/* {PATH}.internal_path_append_substring_into */
void F1943_18659 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_CHARACTER_8 arg5)
{
	GTCX
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,arg2);
	RTLIU(3);
	
	RTGC;
	tb1 = '\0';
	tb2 = '\0';
	tb3 = '\0';
	if ((EIF_BOOLEAN)(arg5 != (EIF_CHARACTER_8) '\000')) {
		{
			/* INLINED CODE (is_empty) */
			tb4 = (EIF_BOOLEAN)  0;
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1)+ _LNGOFF_1_1_0_2_);
			tb4 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
			/* END INLINED CODE */
		}
		tb4 = tb4;
		tb3 = (EIF_BOOLEAN) !tb4;
	}
	if (tb3) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1)+ _LNGOFF_1_1_0_2_);
		{
			/* INLINED CODE (unit_size) */
			ti4_2 = (EIF_INTEGER_32)  0;
			tb3 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
			if (tb3) {
				ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
			} else {
				ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
			/* END INLINED CODE */
		}
		ti4_3 = ti4_2;
		tb2 = (EIF_BOOLEAN) !F1943_18660(Current, arg1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_3) + ((EIF_INTEGER_32) 1L)), arg5);
	}
	if (tb2) {
		tb1 = (EIF_BOOLEAN) !F1943_18660(Current, arg2, arg3, arg5);
	}
	if (tb1) {
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R16825[Dtype(arg1)-2189])(RTCW(arg1), arg5);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R16825[Dtype(arg1)-2189])(RTCW(arg1), (EIF_CHARACTER_8) '\000');
		}
	}
	F2190_21584(RTCW(arg1), arg2, arg3, arg4);
	RTLE;
}

/* {PATH}.is_character */
EIF_BOOLEAN F1943_18660 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_INTEGER_32 arg2, EIF_CHARACTER_8 arg3)
{
	GTCX
	EIF_CHARACTER_8 tc1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,arg1);
	RTLIU(1);
	
	RTGC;
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
		Result = '\0';
		tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R12123[Dtype(arg1)-1408])(RTCW(arg1), arg2));
		if ((EIF_BOOLEAN)(tc1 == arg3)) {
			tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R12123[Dtype(arg1)-1408])(RTCW(arg1), (EIF_INTEGER_32) (arg2 + ((EIF_INTEGER_32) 1L))));
			Result = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\000');
		}
	} else {
		tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R12123[Dtype(arg1)-1408])(RTCW(arg1), arg2));
		Result = (EIF_BOOLEAN) (EIF_BOOLEAN)(tc1 == arg3);
	}
	RTLE;
	return Result;
}

/* {PATH}.c_same_files */
EIF_BOOLEAN F1943_18663 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2)
{
	GTCX
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	
	
	Result = EIF_TEST(inline_F1943_18663 ((EIF_POINTER) arg1, (EIF_POINTER) arg2));
	return Result;
}

void EIF_Minit1121 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
