note
	description:
		"[
			Container that holds only one widget.
		]"
	appearance:
		"[
			---------------
			|             |
			|    item     |
			|             |
			---------------
		]"
	legal: "See notice at end of class."
	status: "See notice at end of class."
	keywords: "container"
	date: "$Date: 2013-05-20 16:15:17 -0700 (Mon, 20 May 2013) $"
	revision: "$Revision: 92557 $"

class
	EV_CELL

inherit
	EV_CONTAINER
		redefine
			implementation
		end

	EV_DOCKABLE_TARGET
		undefine
			is_in_default_state
		redefine
			implementation
		end

create
	default_create

feature -- Access

	has (v: EV_WIDGET): BOOLEAN
			-- Does `Current' include `v'?
		do
			Result := not is_destroyed and
				(v /= Void and then implementation.item = v)
		end

feature -- Status report

	is_empty, extendible: BOOLEAN
			-- Is there no element?
		do
			Result := not full
		end

	full: BOOLEAN
			-- Is structure filled to capacity?
		do
			Result := implementation.item /= Void and not is_destroyed
		end

	prunable: BOOLEAN
			-- May items be removed?
		do
			Result := not is_destroyed
		end

	writable: BOOLEAN
			-- Is there a current item that may be modified?
		do
			Result := not is_destroyed
		end

	readable: BOOLEAN
			-- Is there a current item that may be accessed?
		do
			Result := full and not is_destroyed
		end

	count: INTEGER
			-- Number of items in `Current'.
		do
			Result := implementation.count
		ensure then
			valid_result: Result = 0 or Result = 1
		end

feature -- Removal

	prune (v: EV_WIDGET)
			-- Remove `v' if contained.
		do
			if item = v then
				wipe_out
			end
		ensure then
			not has (v)
		end

	wipe_out
			-- Remove `item'.
		do
			implementation.replace (Void)
		end

feature -- Conversion

	linear_representation: LINEAR [like item]
			-- Representation as a linear structure
		local
			l: LINKED_LIST [like item]
		do
			create l.make
			if readable then
				l.extend (item)
			end
			Result := l
		end

feature {EV_ANY, EV_ANY_I, EV_SHARED_TRANSPORT_I} -- Implementation

	implementation: EV_CELL_I
			-- Responsible for interaction with native graphics toolkit.

feature {NONE} -- Implementation

	create_implementation
			-- Create implementation of `Current'.
		do
			create {EV_CELL_IMP} implementation.make
		end

note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"




end -- class EV_CELL










