note

	description:

		"Xace external clauses"

	library: "Gobo Eiffel Tools Library"
	copyright: "Copyright (c) 2001-2002, Andreas Leitner and others"
	license: "MIT License"
	date: "$Date: 2016-05-06 12:15:38 -0700 (Fri, 06 May 2016) $"
	revision: "$Revision: 98678 $"

class ET_XACE_EXTERNALS

create

	make

feature {NONE} -- Initialization

	make
			-- Create a new external clause.
		do
			create c_compiler_options.make
			create include_directories.make
			create link_libraries.make
		end

feature -- Status report

	is_empty: BOOLEAN
			-- Is current external clause empty?
		do
			Result := c_compiler_options.is_empty and include_directories.is_empty and link_libraries.is_empty
		end

	has_c_compiler_options: BOOLEAN
			-- Are there some C compiler options?
		do
			Result := not c_compiler_options.is_empty
		end

	has_include_directories: BOOLEAN
			-- Are there some include directories?
		do
			Result := not include_directories.is_empty
		end

	has_link_libraries: BOOLEAN
			-- Are there some link libraries?
		do
			Result := not link_libraries.is_empty
		end

feature -- Access

	c_compiler_options: DS_LINKED_LIST [STRING]
			-- C compiler options

	include_directories: DS_LINKED_LIST [STRING]
			-- Include directories

	link_libraries: DS_LINKED_LIST [STRING]
			-- Link libraries

feature -- Element change

	put_c_compiler_options (a_c_compiler_options: STRING)
			-- Add a 'c_compiler_options' value to current external clause.
		require
			a_c_compiler_options_not_void: a_c_compiler_options /= Void
		do
			c_compiler_options.force_last (a_c_compiler_options)
		end

	put_include_directory (a_directory: STRING)
			-- Add an include directory to current external clause.
		require
			a_directory_not_void: a_directory /= Void
		do
			include_directories.force_last (a_directory)
		end

	put_link_library (a_link_library: STRING)
			-- Add a link library to current external clause.
		require
			a_link_library_not_void: a_link_library /= Void
		do
			link_libraries.force_last (a_link_library)
		end

invariant

	c_compiler_options_not_void: c_compiler_options /= Void
	no_void_c_compiler_option: not c_compiler_options.has_void
	include_directories_not_void: include_directories /= Void
	no_void_include_directory: not include_directories.has_void
	link_libraries_not_void: link_libraries /= Void
	no_void_link_library: not link_libraries.has_void

end
