/*
 * Code for class PATH
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "pa1116.h"
#include "eif_path_name.h"
#include "eif_built_in.h"
#include <ctype.h>
#include "eif_eiffel.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F1935_18510
static int inline_F1935_18510 (EIF_POINTER arg1, EIF_POINTER arg2)
{
	EIF_BOOLEAN Result = EIF_FALSE;
#ifdef EIF_WINDOWS
		/* To check this, we use `CreateFileW' to open both file, and then using the information
		 * returned by `GetFileInformationByHandle' we can check whether or not they are indeed
		 * the same.
		 * Note: it is important to use the W version of CreateFileW because arguments
		 * are Unicode, not ASCII. */
	BY_HANDLE_FILE_INFORMATION l_path1_info, l_path2_info;
	HANDLE l_path2_file = CreateFileW ((LPCWSTR) arg2, GENERIC_READ, FILE_SHARE_READ, NULL,
		OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	HANDLE l_path1_file = CreateFileW ((LPCWSTR) arg1, GENERIC_READ, FILE_SHARE_READ, NULL,
			OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);

	if ((l_path2_file == INVALID_HANDLE_VALUE) || (l_path1_file == INVALID_HANDLE_VALUE)) {
			/* We do not need the handles anymore, simply close them. Since Microsoft
			 * API accepts INVALID_HANDLE_VALUE we don't check the validity of arguments. */
		CloseHandle(l_path2_file);
		CloseHandle(l_path1_file);
	} else {
		BOOL success = GetFileInformationByHandle (l_path2_file, &l_path2_info);
		success = success && GetFileInformationByHandle (l_path1_file, &l_path1_info);
			/* We do not need the handles anymore, simply close them. */
		CloseHandle(l_path2_file);
		CloseHandle(l_path1_file);
		if (success) {
				/* Check that `path2' and `path1' do not represent the same file. */
			if
				((l_path2_info.dwVolumeSerialNumber == l_path1_info.dwVolumeSerialNumber) &&
				(l_path2_info.nFileIndexLow == l_path1_info.nFileIndexLow) &&
				(l_path2_info.nFileIndexHigh == l_path1_info.nFileIndexHigh))
			{
				Result = EIF_TRUE;
			}
		}
	}
#else
	struct stat buf1, buf2;
	int status;
	#ifdef HAS_LSTAT
		status = lstat(arg1, &buf1);
		if (status == 0) {
				/* We found a file, now let's check if it is not a symbolic link. If it is, we use `stat'
			 	 * to ensure the validity of the link. */
			if ((buf1.st_mode & S_IFLNK) == S_IFLNK) {
				status = stat (arg1, &buf1);
			}
		}
		
		if (status == 0) {
			status = lstat(arg2, &buf2);
			if (status == 0) {
					/* We found a file, now let's check if it is not a symbolic link. If it is, we use `stat'
				 	 * to ensure the validity of the link. */
				if ((buf2.st_mode & S_IFLNK) == S_IFLNK) {
					status = stat (arg2, &buf2);
				}
			}
		}
	#else
		status = stat (arg1, &buf1);
		if (status == 0) {
			status = stat (arg2, &buf2);
		}
	#endif
	if (status == 0) {
			/* Both files are present, check they represent the same one. */
		if ((buf1.st_dev == buf2.st_dev) && (buf1.st_ino == buf2.st_ino)) {
			Result = EIF_TRUE;
		}
	}
#endif
return Result;
	;
}
#define INLINE_F1935_18510
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {PATH}.make_empty */
void F1935_18449 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = RTLNSMART(eif_new_type(2182, 0).id);
	F2178_21207(RTCW(tr1));
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	{
		/* INLINED CODE (reset_internal_data) */
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {PATH}.make_current */
void F1935_18450 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = RTLNSMART(eif_new_type(2182, 0).id);
	ti4_1 = F1935_18495(Current);
	F2181_21337(RTCW(tr1), ti4_1);
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	tr1 = *(EIF_REFERENCE *)(Current);
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R16731[Dtype(tr1)-2182])(RTCW(tr1), (EIF_CHARACTER_8) '.');
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
		tr1 = *(EIF_REFERENCE *)(Current);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R16731[Dtype(tr1)-2182])(RTCW(tr1), (EIF_CHARACTER_8) '\000');
	}
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	{
		/* INLINED CODE (reset_internal_data) */
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {PATH}.make_from_string */
void F1935_18451 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,arg1);
	RTLIU(3);
	
	RTGC;
	tr1 = RTLNSMART(eif_new_type(2182, 0).id);
	ti4_1 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R16582[Dtype(arg1)-2180])(RTCW(arg1));
	ti4_2 = F1935_18495(Current);
	F2181_21337(RTCW(tr1), (EIF_INTEGER_32) (ti4_1 * ti4_2));
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	tb1 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R16560[Dtype(arg1)-2181])(RTCW(arg1));
	if ((EIF_BOOLEAN) !tb1) {
		tr1 = *(EIF_REFERENCE *)(Current);
		F1935_18504(Current, tr1, arg1, (EIF_CHARACTER_8) '\000');
		F1935_18497(Current);
	} else {
		*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	}
	{
		/* INLINED CODE (reset_internal_data) */
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {PATH}.make_from_storage */
void F1935_18453 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,arg1);
	RTLIU(2);
	
	RTGC;
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) arg1;
	F1935_18497(Current);
	{
		/* INLINED CODE (reset_internal_data) */
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {PATH}.make_from_normalized_storage */
void F1935_18454 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,arg1);
	RTLIU(2);
	
	RTGC;
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) arg1;
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	{
		/* INLINED CODE (reset_internal_data) */
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {PATH}.make_from_pointer */
void F1935_18455 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,loc1);
	RTLR(2,tr1);
	RTLIU(3);
	
	RTGC;
	loc2 = F1013_10904(Current, arg1);
	{
		/* INLINED CODE (unit_size) */
		ti4_1 = (EIF_INTEGER_32)  0;
		tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
		if (tb1) {
			ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
		} else {
			ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		}
		/* END INLINED CODE */
	}
	loc2 -= (EIF_INTEGER_32) (loc2 % ti4_1);
	tr1 = RTLNS(eif_new_type(1167, 0x00).id, 1167, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F1168_13022(RTCW(tr1), arg1, loc2);
	loc1 = (EIF_REFERENCE) tr1;
	tr1 = F1168_13029(RTCW(loc1), ((EIF_INTEGER_32) 1L), loc2);
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	tr1 = *(EIF_REFERENCE *)(Current);
	{
		/* INLINED CODE (is_empty) */
		tb1 = (EIF_BOOLEAN)  0;
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tb1 = tb1;
	if ((EIF_BOOLEAN) !tb1) {
		F1935_18497(Current);
	}
	{
		/* INLINED CODE (reset_internal_data) */
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {PATH}.is_current_symbol */
EIF_BOOLEAN F1935_18456 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	{
		/* INLINED CODE (unit_size) */
		ti4_2 = (EIF_INTEGER_32)  0;
		tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
		if (tb1) {
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
		} else {
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		}
		/* END INLINED CODE */
	}
	if ((EIF_BOOLEAN)(ti4_1 == ti4_2)) {
		tr1 = *(EIF_REFERENCE *)(Current);
		RTLE;
		return (EIF_BOOLEAN) F1935_18507(Current, tr1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '.');
	}
	RTLE;
	return (EIF_BOOLEAN) 0;
}

/* {PATH}.is_parent_symbol */
EIF_BOOLEAN F1935_18457 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	{
		/* INLINED CODE (unit_size) */
		ti4_2 = (EIF_INTEGER_32)  0;
		tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
		if (tb1) {
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
		} else {
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		}
		/* END INLINED CODE */
	}
	if ((EIF_BOOLEAN)(ti4_1 == (EIF_INTEGER_32) (((EIF_INTEGER_32) 2L) * ti4_2))) {
		tr1 = *(EIF_REFERENCE *)(Current);
		Result = F1935_18507(Current, tr1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '.');
		tr1 = *(EIF_REFERENCE *)(Current);
		{
			/* INLINED CODE (unit_size) */
			ti4_1 = (EIF_INTEGER_32)  0;
			tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
			if (tb1) {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
			} else {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
			/* END INLINED CODE */
		}
		ti4_2 = ti4_1;
		Result = F1935_18507(Current, tr1, (EIF_INTEGER_32) (((EIF_INTEGER_32) 1L) + ti4_2), (EIF_CHARACTER_8) '.');
	}
	RTLE;
	return Result;
}

/* {PATH}.has_root */
EIF_BOOLEAN F1935_18458 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTGC;
	ti4_1 = F1935_18501(Current);
	Result = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 != ((EIF_INTEGER_32) 0L));
	RTLE;
	return Result;
}

/* {PATH}.is_empty */
EIF_BOOLEAN F1935_18459 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	{
		/* INLINED CODE (is_empty) */
		tb1 = (EIF_BOOLEAN)  0;
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	Result = tb1;
	RTLE;
	return Result;
}

/* {PATH}.is_relative */
EIF_BOOLEAN F1935_18460 (EIF_REFERENCE Current)
{
	GTCX
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTGC;
	Result = F1935_18461(Current);
	Result = (EIF_BOOLEAN) (EIF_BOOLEAN) !Result;
	RTLE;
	return Result;
}

/* {PATH}.is_absolute */
EIF_BOOLEAN F1935_18461 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	loc1 = F1935_18501(Current);
	if ((EIF_BOOLEAN) (loc1 > ((EIF_INTEGER_32) 0L))) {
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
			tr1 = *(EIF_REFERENCE *)(Current);
			{
				/* INLINED CODE (unit_size) */
				ti4_1 = (EIF_INTEGER_32)  0;
				tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
				if (tb1) {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
				} else {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
				}
				/* END INLINED CODE */
			}
			ti4_2 = ti4_1;
			{
				/* INLINED CODE (directory_separator) */
				tc1 = (EIF_CHARACTER_8)  0;
				tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
				if (tb1) {
					tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
				} else {
					tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
				}
				/* END INLINED CODE */
			}
			tc2 = tc1;
			Result = F1935_18507(Current, tr1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (loc1 - ti4_2) + ((EIF_INTEGER_32) 1L)), tc2);
		} else {
			RTLE;
			return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.is_same_file_as */
EIF_BOOLEAN F1935_18463 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_POINTER tp2;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,loc2);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTGC;
	loc1 = F1935_18492(Current);
	loc2 = F1935_18492(RTCW(arg1));
	tp1 = *(EIF_POINTER *)(RTCW(loc1)+ _PTROFF_0_1_0_1_0_0_);
	tp2 = *(EIF_POINTER *)(RTCW(loc2)+ _PTROFF_0_1_0_1_0_0_);
	Result = EIF_TEST (inline_F1935_18510(tp1, tp2));
	RTLE;
	return Result;
}

/* {PATH}.has_extension */
EIF_BOOLEAN F1935_18464 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTGC;
	Result = '\0';
	tr1 = F1935_18468(Current);
	loc1 = tr1;
	if (EIF_TEST(loc1)) {
		tb1 = F2178_21249(loc1, arg1);
		Result = tb1;
	}
	RTLE;
	return Result;
}

/* {PATH}.root */
EIF_REFERENCE F1935_18465 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	loc1 = F1935_18501(Current);
	if ((EIF_BOOLEAN)(loc1 != ((EIF_INTEGER_32) 0L))) {
		tr1 = *(EIF_REFERENCE *)(Current);
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		if ((EIF_BOOLEAN)(loc1 == ti4_1)) {
			tr1 = RTLNS(eif_new_type(1934, 0x00).id, 1934, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F1935_18454(RTCW(tr1), *(EIF_REFERENCE *)(Current));
			RTLE;
			return (EIF_REFERENCE) tr1;
		} else {
			tr1 = RTLNS(eif_new_type(1934, 0x00).id, 1934, _OBJSIZ_2_1_0_0_0_0_0_0_);
			tr2 = *(EIF_REFERENCE *)(Current);
			tr2 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R16623[Dtype(tr2)-2181])(RTCW(tr2), ((EIF_INTEGER_32) 1L), loc1);
			F1935_18454(RTCW(tr1), tr2);
			Result = (EIF_REFERENCE) tr1;
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.parent */
EIF_REFERENCE F1935_18466 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(5);
	RTLR(0,Current);
	RTLR(1,loc3);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLR(4,Result);
	RTLIU(5);
	
	RTGC;
	loc1 = F1935_18502(Current);
	if ((EIF_BOOLEAN)(loc1 == ((EIF_INTEGER_32) 0L))) {
		tr1 = F1935_18465(Current);
		loc3 = tr1;
		if (EIF_TEST(loc3)) {
			RTLE;
			return (EIF_REFERENCE) loc3;
		} else {
			tr1 = RTLNS(eif_new_type(1934, 0x00).id, 1934, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F1935_18450(RTCW(tr1));
			RTLE;
			return (EIF_REFERENCE) tr1;
		}
	} else {
		{
			/* INLINED CODE (unit_size) */
			ti4_1 = (EIF_INTEGER_32)  0;
			tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
			if (tb1) {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
			} else {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
			/* END INLINED CODE */
		}
		if ((EIF_BOOLEAN)(loc1 == ti4_1)) {
			tr1 = RTLNS(eif_new_type(1934, 0x00).id, 1934, _OBJSIZ_2_1_0_0_0_0_0_0_);
			tr2 = *(EIF_REFERENCE *)(Current);
			ti4_1 = F1935_18495(Current);
			tr2 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R16623[Dtype(tr2)-2181])(RTCW(tr2), ((EIF_INTEGER_32) 1L), ti4_1);
			F1935_18454(RTCW(tr1), tr2);
			Result = (EIF_REFERENCE) tr1;
		} else {
			loc2 = F1935_18501(Current);
			if ((EIF_BOOLEAN) (loc1 <= loc2)) {
				tr1 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
				if ((EIF_BOOLEAN)(loc2 == ti4_1)) {
					RTLE;
					return (EIF_REFERENCE) Current;
				} else {
					tr1 = RTLNS(eif_new_type(1934, 0x00).id, 1934, _OBJSIZ_2_1_0_0_0_0_0_0_);
					tr2 = *(EIF_REFERENCE *)(Current);
					tr2 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R16623[Dtype(tr2)-2181])(RTCW(tr2), ((EIF_INTEGER_32) 1L), loc2);
					F1935_18454(RTCW(tr1), tr2);
					Result = (EIF_REFERENCE) tr1;
				}
			} else {
				tr1 = RTLNS(eif_new_type(1934, 0x00).id, 1934, _OBJSIZ_2_1_0_0_0_0_0_0_);
				tr2 = *(EIF_REFERENCE *)(Current);
				ti4_1 = F1935_18495(Current);
				tr2 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R16623[Dtype(tr2)-2181])(RTCW(tr2), ((EIF_INTEGER_32) 1L), (EIF_INTEGER_32) (loc1 - ti4_1));
				F1935_18454(RTCW(tr1), tr2);
				Result = (EIF_REFERENCE) tr1;
			}
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.entry */
EIF_REFERENCE F1935_18467 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE tr3 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(5);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,tr3);
	RTLR(4,Result);
	RTLIU(5);
	
	RTGC;
	loc1 = F1935_18502(Current);
	if ((EIF_BOOLEAN)(loc1 == ((EIF_INTEGER_32) 0L))) {
		loc2 = F1935_18501(Current);
		if ((EIF_BOOLEAN) (loc2 > ((EIF_INTEGER_32) 0L))) {
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
			if ((EIF_BOOLEAN) (loc2 < ti4_1)) {
				tr1 = RTLNS(eif_new_type(1934, 0x00).id, 1934, _OBJSIZ_2_1_0_0_0_0_0_0_);
				tr2 = *(EIF_REFERENCE *)(Current);
				tr3 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr3)+ _LNGOFF_1_1_0_2_);
				tr2 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R16623[Dtype(tr2)-2181])(RTCW(tr2), (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)), ti4_1);
				F1935_18454(RTCW(tr1), tr2);
				Result = (EIF_REFERENCE) tr1;
			}
		} else {
			Result = (EIF_REFERENCE) Current;
		}
	} else {
		loc2 = F1935_18501(Current);
		if ((EIF_BOOLEAN) (loc1 <= loc2)) {
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
			if ((EIF_BOOLEAN) (loc2 < ti4_1)) {
				tr1 = RTLNS(eif_new_type(1934, 0x00).id, 1934, _OBJSIZ_2_1_0_0_0_0_0_0_);
				tr2 = *(EIF_REFERENCE *)(Current);
				tr3 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr3)+ _LNGOFF_1_1_0_2_);
				tr2 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R16623[Dtype(tr2)-2181])(RTCW(tr2), (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)), ti4_1);
				F1935_18454(RTCW(tr1), tr2);
				Result = (EIF_REFERENCE) tr1;
			}
		} else {
			tr1 = RTLNS(eif_new_type(1934, 0x00).id, 1934, _OBJSIZ_2_1_0_0_0_0_0_0_);
			tr2 = *(EIF_REFERENCE *)(Current);
			tr3 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr3)+ _LNGOFF_1_1_0_2_);
			tr2 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R16623[Dtype(tr2)-2181])(RTCW(tr2), (EIF_INTEGER_32) (loc1 + ((EIF_INTEGER_32) 1L)), ti4_1);
			F1935_18454(RTCW(tr1), tr2);
			Result = (EIF_REFERENCE) tr1;
		}
	}
	tb1 = '\0';
	if ((EIF_BOOLEAN)(Result != NULL)) {
		tb2 = '\01';
		tb3 = '\01';
		{
			/* INLINED CODE (is_empty) */
			tb4 = (EIF_BOOLEAN)  0;
			tr1 = *(EIF_REFERENCE *)(RTCW(Result));
			tb4 = F754_8261(RTCW(tr1));
			/* END INLINED CODE */
		}
		tb4 = tb4;
		if (!tb4) {
			{
				/* INLINED CODE (is_current_symbol) */
				tb4 = (EIF_BOOLEAN)  0;
				tr1 = *(EIF_REFERENCE *)(RTCW(Result));
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
				ti4_2 = F1935_18495(RTCW(Result));
				if ((EIF_BOOLEAN)(ti4_1 == ti4_2)) {
					tr1 = *(EIF_REFERENCE *)(RTCW(Result));
					tb4 = F1935_18507(RTCW(Result), tr1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '.');
				}
				/* END INLINED CODE */
			}
			tb4 = tb4;
			tb3 = tb4;
		}
		if (!tb3) {
			tb3 = F1935_18457(RTCW(Result));
			tb2 = tb3;
		}
		tb1 = tb2;
	}
	if (tb1) {
		RTLE;
		return (EIF_REFERENCE) NULL;
	}
	RTLE;
	return Result;
}

/* {PATH}.extension */
EIF_REFERENCE F1935_18468 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_CHARACTER_32 tw1;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc4);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc1);
	RTLIU(4);
	
	RTGC;
	tr1 = F1935_18467(Current);
	loc4 = tr1;
	if (EIF_TEST(loc4)) {
		loc1 = F1935_18490(loc4);
		loc3 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_0_0_2_);
		tw1 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '.';
		loc2 = F2187_21542(RTCW(loc1), tw1, loc3);
		if ((EIF_BOOLEAN) ((EIF_BOOLEAN)(loc2 != ((EIF_INTEGER_32) 0L)) && (EIF_BOOLEAN)(loc2 != loc3))) {
			tr1 = F2188_21596(RTCW(loc1), (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)), loc3);
			RTLE;
			return (EIF_REFERENCE) tr1;
		}
	}
	RTLE;
	return (EIF_REFERENCE) 0;
}

/* {PATH}.components */
EIF_REFERENCE F1935_18469 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(5);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLR(3,loc1);
	RTLR(4,tr2);
	RTLIU(5);
	
	RTGC;
	{
		static EIF_TYPE_INDEX typarr0[] = {1485,1934,0xFFFF};
		EIF_TYPE typres0;
		static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
		
		typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), typarr0)));
		tr1 = RTLNS(typres0.id, 1485, _OBJSIZ_1_1_0_1_0_0_0_0_);
	}
	F1486_14551(RTCW(tr1), ((EIF_INTEGER_32) 10L));
	Result = (EIF_REFERENCE) tr1;
	loc3 = F1935_18501(Current);
	if ((EIF_BOOLEAN) (loc3 > ((EIF_INTEGER_32) 0L))) {
		tr1 = RTLNS(eif_new_type(2182, 0x00).id, 2182, _OBJSIZ_1_1_0_3_0_0_0_0_);
		F2181_21337(RTCW(tr1), loc3);
		loc1 = (EIF_REFERENCE) tr1;
		tr1 = *(EIF_REFERENCE *)(Current);
		F2183_21449(RTCW(loc1), tr1, ((EIF_INTEGER_32) 1L), loc3);
		tr1 = RTLNS(eif_new_type(1934, 0x00).id, 1934, _OBJSIZ_2_1_0_0_0_0_0_0_);
		F1935_18454(RTCW(tr1), loc1);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R7396[Dtype(Result)-657])(RTCW(Result), tr1);
		loc3++;
	} else {
		loc3 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	}
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	if ((EIF_BOOLEAN) (loc3 <= ti4_1)) {
		loc2 = (EIF_INTEGER_32) loc3;
		loc3 = F1935_18503(Current, loc2);
		for (;;) {
			if ((EIF_BOOLEAN)(loc3 == ((EIF_INTEGER_32) 0L))) break;
			tr1 = RTLNS(eif_new_type(2182, 0x00).id, 2182, _OBJSIZ_1_1_0_3_0_0_0_0_);
			F2181_21337(RTCW(tr1), (EIF_INTEGER_32) (loc3 - loc2));
			loc1 = (EIF_REFERENCE) tr1;
			tr1 = *(EIF_REFERENCE *)(Current);
			F2183_21449(RTCW(loc1), tr1, loc2, (EIF_INTEGER_32) (loc3 - ((EIF_INTEGER_32) 1L)));
			tr1 = RTLNS(eif_new_type(1934, 0x00).id, 1934, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F1935_18454(RTCW(tr1), loc1);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R7396[Dtype(Result)-657])(RTCW(Result), tr1);
			{
				/* INLINED CODE (unit_size) */
				ti4_1 = (EIF_INTEGER_32)  0;
				tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
				if (tb1) {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
				} else {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
				}
				/* END INLINED CODE */
			}
			loc2 = ti4_1;
			loc2 = (EIF_INTEGER_32) (EIF_INTEGER_32) (loc3 + loc2);
			loc3 = F1935_18503(Current, loc2);
		}
		tr1 = *(EIF_REFERENCE *)(Current);
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		if ((EIF_BOOLEAN) (loc2 <= ti4_1)) {
			tr1 = RTLNS(eif_new_type(2182, 0x00).id, 2182, _OBJSIZ_1_1_0_3_0_0_0_0_);
			tr2 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2)+ _LNGOFF_1_1_0_2_);
			F2181_21337(RTCW(tr1), (EIF_INTEGER_32) (ti4_1 - loc2));
			loc1 = (EIF_REFERENCE) tr1;
			tr1 = *(EIF_REFERENCE *)(Current);
			tr2 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2)+ _LNGOFF_1_1_0_2_);
			F2183_21449(RTCW(loc1), tr1, loc2, ti4_1);
			tr1 = RTLNS(eif_new_type(1934, 0x00).id, 1934, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F1935_18454(RTCW(tr1), loc1);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R7396[Dtype(Result)-657])(RTCW(Result), tr1);
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.absolute_path */
EIF_REFERENCE F1935_18470 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLIU(3);
	
	RTGC;
	tr1 = F1016_10988(RTCV(RTOSCF(18500,F1935_18500,(Current))));
	Result = F1935_18471(Current, tr1);
	RTLE;
	return Result;
}

/* {PATH}.absolute_path_in */
EIF_REFERENCE F1935_18471 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE tr3 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(8);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,arg1);
	RTLR(3,loc1);
	RTLR(4,Result);
	RTLR(5,tr2);
	RTLR(6,tr3);
	RTLR(7,loc2);
	RTLIU(8);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	{
		/* INLINED CODE (is_empty) */
		tb1 = (EIF_BOOLEAN)  0;
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tb1 = tb1;
	if (tb1) {
		RTLE;
		return (EIF_REFERENCE) arg1;
	} else {
		if (F1935_18461(Current)) {
			RTLE;
			return (EIF_REFERENCE) Current;
		} else {
			if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
				tr1 = F1935_18465(Current);
				loc1 = tr1;
				if (EIF_TEST(loc1)) {
					tb1 = '\0';
					tb2 = '\0';
					tr1 = *(EIF_REFERENCE *)(loc1);
					ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
					if ((EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 4L))) {
						tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
						ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
						tb2 = (EIF_BOOLEAN) (ti4_1 >= ((EIF_INTEGER_32) 4L));
					}
					if (tb2) {
						tb2 = '\0';
						tr1 = *(EIF_REFERENCE *)(loc1);
						tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R11867[Dtype(tr1)-1393])(RTCW(tr1), ((EIF_INTEGER_32) 1L)));
						tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
						tc2 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R11867[Dtype(tr1)-1393])(RTCW(tr1), ((EIF_INTEGER_32) 1L)));
						if ((EIF_BOOLEAN)(tc1 == tc2)) {
							tr1 = *(EIF_REFERENCE *)(loc1);
							tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R11867[Dtype(tr1)-1393])(RTCW(tr1), ((EIF_INTEGER_32) 3L)));
							tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
							tc2 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R11867[Dtype(tr1)-1393])(RTCW(tr1), ((EIF_INTEGER_32) 3L)));
							tb2 = (EIF_BOOLEAN)(tc1 == tc2);
						}
						tb1 = tb2;
					}
					if (tb1) {
						Result = (EIF_REFERENCE) eif_builtin_ANY_twin (arg1);
					} else {
						Result = (EIF_REFERENCE) loc1;
					}
					tr1 = *(EIF_REFERENCE *)(RTCW(Result));
					tr2 = *(EIF_REFERENCE *)(Current);
					tr3 = *(EIF_REFERENCE *)(loc1);
					ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr3)+ _LNGOFF_1_1_0_2_);
					tr3 = *(EIF_REFERENCE *)(Current);
					ti4_2 = *(EIF_INTEGER_32 *)(RTCW(tr3)+ _LNGOFF_1_1_0_2_);
					{
						/* INLINED CODE (directory_separator) */
						tc1 = (EIF_CHARACTER_8)  0;
						tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
						if (tb1) {
							tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
						} else {
							tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
						}
						/* END INLINED CODE */
					}
					tc2 = tc1;
					F1935_18506(Current, tr1, tr2, (EIF_INTEGER_32) (ti4_1 + ((EIF_INTEGER_32) 1L)), ti4_2, tc2);
				} else {
					tr1 = *(EIF_REFERENCE *)(Current);
					if (F1935_18507(Current, tr1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '\\')) {
						Result = (EIF_REFERENCE) eif_builtin_ANY_twin (arg1);
						tr1 = F1935_18465(RTCW(Result));
						loc2 = tr1;
						if (EIF_TEST(loc2)) {
							Result = (EIF_REFERENCE) loc2;
						}
					} else {
						Result = (EIF_REFERENCE) eif_builtin_ANY_twin (arg1);
					}
					tr1 = *(EIF_REFERENCE *)(RTCW(Result));
					tr2 = *(EIF_REFERENCE *)(Current);
					{
						/* INLINED CODE (directory_separator) */
						tc1 = (EIF_CHARACTER_8)  0;
						tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
						if (tb1) {
							tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
						} else {
							tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
						}
						/* END INLINED CODE */
					}
					tc2 = tc1;
					F1935_18505(Current, tr1, tr2, tc2);
				}
			} else {
				Result = (EIF_REFERENCE) eif_builtin_ANY_twin (arg1);
				tr1 = *(EIF_REFERENCE *)(RTCW(Result));
				tr2 = *(EIF_REFERENCE *)(Current);
				{
					/* INLINED CODE (directory_separator) */
					tc1 = (EIF_CHARACTER_8)  0;
					tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
					if (tb1) {
						tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
					} else {
						tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
					}
					/* END INLINED CODE */
				}
				tc2 = tc1;
				F1935_18505(Current, tr1, tr2, tc2);
			}
			{
				/* INLINED CODE (reset_internal_data) */
				*(EIF_REFERENCE *)(RTCW(Result) + _REFACS_1_) = (EIF_REFERENCE) NULL;
				/* END INLINED CODE */
			}
			;
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.canonical_path */
EIF_REFERENCE F1935_18472 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc5 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE tr3 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	RTLD;
	
	RTLI(9);
	RTLR(0,loc2);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLR(4,loc4);
	RTLR(5,loc3);
	RTLR(6,loc1);
	RTLR(7,tr3);
	RTLR(8,loc5);
	RTLIU(9);
	
	RTGC;
	{
		/* INLINED CODE (absolute_path) */
		tr1 = (EIF_REFERENCE)  0;
		tr2 = RTOSCF(18500,F1935_18500,(Current));
		tr2 = F1016_10988(RTCW(tr2));
		tr1 = F1935_18471(Current, tr2);
		/* END INLINED CODE */
	}
	loc2 = tr1;
	tr1 = F1935_18465(RTCW(loc2));
	loc4 = tr1;
	if (EIF_TEST(loc4)) {
		tr1 = RTLNSMART(eif_new_type(2182, 0).id);
		tr2 = *(EIF_REFERENCE *)(RTCW(loc2));
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2)+ _LNGOFF_1_1_0_2_);
		F2181_21337(RTCW(tr1), ti4_1);
		loc3 = (EIF_REFERENCE) tr1;
		loc1 = F1935_18469(RTCW(loc2));
		{
			/* INLINED CODE (start) */
			*(EIF_INTEGER_32 *)(RTCW(loc1) + O12075[Dtype(loc1)-1485]) = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			/* END INLINED CODE */
		}
		;
		tr1 = F1486_14555(RTCW(loc1));
		tr1 = *(EIF_REFERENCE *)(RTCW(tr1));
		{
			/* INLINED CODE (directory_separator) */
			tc1 = (EIF_CHARACTER_8)  0;
			tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
			if (tb1) {
				tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
			} else {
				tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
			}
			/* END INLINED CODE */
		}
		tc2 = tc1;
		F1935_18505(Current, loc3, tr1, tc2);
		(FUNCTION_CAST(void, (EIF_REFERENCE)) R7446[Dtype(loc1)-746])(RTCW(loc1));
		for (;;) {
			{
				/* INLINED CODE (after) */
				tb1 = (EIF_BOOLEAN)  0;
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1) + O12075[Dtype(loc1)-1485]);
				ti4_2 = F1486_14571(RTCW(loc1));
				tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == (EIF_INTEGER_32) (ti4_2 + ((EIF_INTEGER_32) 1L)));
				/* END INLINED CODE */
			}
			tb1 = tb1;
			if (tb1) break;
			tr1 = F1486_14555(RTCW(loc1));
			{
				/* INLINED CODE (is_current_symbol) */
				tb2 = (EIF_BOOLEAN)  0;
				tr2 = tr1;
				tr3 = *(EIF_REFERENCE *)(RTCW(tr2));
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr3)+ _LNGOFF_1_1_0_2_);
				ti4_2 = F1935_18495(RTCW(tr2));
				if ((EIF_BOOLEAN)(ti4_1 == ti4_2)) {
					tr3 = *(EIF_REFERENCE *)(RTCW(tr2));
					tb2 = F1935_18507(RTCW(tr2), tr3, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '.');
				}
				/* END INLINED CODE */
			}
			tb2 = tb2;
			if (tb2) {
				(FUNCTION_CAST(void, (EIF_REFERENCE)) R7446[Dtype(loc1)-746])(RTCW(loc1));
			} else {
				tr1 = F1486_14555(RTCW(loc1));
				tb2 = F1935_18457(RTCW(tr1));
				if (tb2) {
					{
						/* INLINED CODE (isfirst) */
						tb2 = (EIF_BOOLEAN)  0;
						tb2 = '\0';
						tb3 = F750_8261(RTCW(loc1));
						if ((EIF_BOOLEAN) !tb3) {
							ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1) + O12075[Dtype(loc1)-1485]);
							tb2 = (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 1L));
						}
						/* END INLINED CODE */
					}
					tb2 = tb2;
					if ((EIF_BOOLEAN) !tb2) {
						{
							/* INLINED CODE (back) */
							(*(EIF_INTEGER_32 *)(RTCW(loc1) + O12075[Dtype(loc1)-1485]))--;
							/* END INLINED CODE */
						}
						;
						(FUNCTION_CAST(void, (EIF_REFERENCE)) R7446[Dtype(loc1)-746])(RTCW(loc1));
					}
					(FUNCTION_CAST(void, (EIF_REFERENCE)) R7446[Dtype(loc1)-746])(RTCW(loc1));
				} else {
					{
						/* INLINED CODE (forth) */
						(*(EIF_INTEGER_32 *)(RTCW(loc1) + O12075[Dtype(loc1)-1485]))++;
						/* END INLINED CODE */
					}
					;
				}
			}
		}
		loc5 = F1486_14564(RTCW(loc1));
		for (;;) {
			{
				/* INLINED CODE (after) */
				tb2 = (EIF_BOOLEAN)  0;
				ti4_1 = *(EIF_INTEGER_32 *)(loc5+ _LNGOFF_2_0_0_0_);
				ti4_2 = *(EIF_INTEGER_32 *)(loc5+ _LNGOFF_2_0_0_1_);
				tb2 = (EIF_BOOLEAN) (EIF_BOOLEAN) (ti4_1 > ti4_2);
				/* END INLINED CODE */
			}
			tb2 = tb2;
			if (tb2) break;
			tr1 = F1288_14046(loc5);
			tr1 = *(EIF_REFERENCE *)(RTCW(tr1));
			{
				/* INLINED CODE (directory_separator) */
				tc1 = (EIF_CHARACTER_8)  0;
				tb3 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
				if (tb3) {
					tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
				} else {
					tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
				}
				/* END INLINED CODE */
			}
			tc2 = tc1;
			F1935_18505(Current, loc3, tr1, tc2);
			{
				/* INLINED CODE (forth) */
				(*(EIF_INTEGER_32 *)(loc5+ _LNGOFF_2_0_0_0_))++;
				/* END INLINED CODE */
			}
			;
		}
		tr1 = RTLNS(eif_new_type(1934, 0x00).id, 1934, _OBJSIZ_2_1_0_0_0_0_0_0_);
		F1935_18454(RTCW(tr1), loc3);
		RTLE;
		return (EIF_REFERENCE) tr1;
	} else {
		RTLE;
		return (EIF_REFERENCE) loc2;
	}/* NOTREACHED */
	
}

/* {PATH}.hash_code */
EIF_INTEGER_32 F1935_18473 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	if ((EIF_BOOLEAN) EIF_TEST(eif_case_sensitive_path_names())) {
		tr1 = *(EIF_REFERENCE *)(Current);
		Result = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R14746[Dtype(tr1)-1924])(RTCW(tr1));
	} else {
		Result = F2178_21217(RTCV(F1935_18490(Current)));
	}
	RTLE;
	return Result;
}

/* {PATH}.directory_separator */
EIF_CHARACTER_8 F1935_18477 (EIF_REFERENCE Current)
{
	GTCX
	
	
	RTGC;
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
		return (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
	} else {
		return (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
	}/* NOTREACHED */
	
}

/* {PATH}.extended */
EIF_REFERENCE F1935_18478 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_INTEGER_32 ti4_4;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	RTLD;
	
	RTLI(5);
	RTLR(0,loc1);
	RTLR(1,tr1);
	RTLR(2,Current);
	RTLR(3,tr2);
	RTLR(4,arg1);
	RTLIU(5);
	
	RTGC;
	tr1 = RTLNSMART(eif_new_type(2182, 0).id);
	tr2 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2)+ _LNGOFF_1_1_0_2_);
	ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R16582[Dtype(arg1)-2180])(RTCW(arg1));
	ti4_3 = F1935_18495(Current);
	ti4_4 = F1935_18495(Current);
	F2181_21337(RTCW(tr1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + (EIF_INTEGER_32) (ti4_2 * ti4_3)) + ti4_4));
	loc1 = (EIF_REFERENCE) tr1;
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R16727[Dtype(loc1)-2182])(RTCW(loc1), *(EIF_REFERENCE *)(Current));
	tb1 = '\0';
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
	if ((EIF_BOOLEAN) (ti4_1 > ((EIF_INTEGER_32) 0L))) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN)(F1935_18501(Current) == ti4_1);
	}
	if (tb1) {
		F1935_18504(Current, loc1, arg1, (EIF_CHARACTER_8) '\000');
	} else {
		{
			/* INLINED CODE (directory_separator) */
			tc1 = (EIF_CHARACTER_8)  0;
			tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
			if (tb1) {
				tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
			} else {
				tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
			}
			/* END INLINED CODE */
		}
		tc2 = tc1;
		F1935_18504(Current, loc1, arg1, tc2);
	}
	tr1 = RTLNS(eif_new_type(1934, 0x00).id, 1934, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F1935_18453(RTCW(tr1), loc1);
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.extended_path */
EIF_REFERENCE F1935_18479 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	RTLD;
	
	RTLI(5);
	RTLR(0,loc1);
	RTLR(1,tr1);
	RTLR(2,Current);
	RTLR(3,tr2);
	RTLR(4,arg1);
	RTLIU(5);
	
	RTGC;
	tr1 = RTLNSMART(eif_new_type(2182, 0).id);
	tr2 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2)+ _LNGOFF_1_1_0_2_);
	tr2 = *(EIF_REFERENCE *)(RTCW(arg1));
	ti4_2 = *(EIF_INTEGER_32 *)(RTCW(tr2)+ _LNGOFF_1_1_0_2_);
	ti4_3 = F1935_18495(Current);
	F2181_21337(RTCW(tr1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + ti4_2) + ti4_3));
	loc1 = (EIF_REFERENCE) tr1;
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R16727[Dtype(loc1)-2182])(RTCW(loc1), *(EIF_REFERENCE *)(Current));
	tb1 = '\0';
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
	if ((EIF_BOOLEAN) (ti4_1 > ((EIF_INTEGER_32) 0L))) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN)(F1935_18501(Current) == ti4_1);
	}
	if (tb1) {
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
		F1935_18505(Current, loc1, tr1, (EIF_CHARACTER_8) '\000');
	} else {
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
		{
			/* INLINED CODE (directory_separator) */
			tc1 = (EIF_CHARACTER_8)  0;
			tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
			if (tb1) {
				tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
			} else {
				tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
			}
			/* END INLINED CODE */
		}
		tc2 = tc1;
		F1935_18505(Current, loc1, tr1, tc2);
	}
	tr1 = RTLNS(eif_new_type(1934, 0x00).id, 1934, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F1935_18454(RTCW(tr1), loc1);
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.appended */
EIF_REFERENCE F1935_18480 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	RTLD;
	
	RTLI(5);
	RTLR(0,loc1);
	RTLR(1,tr1);
	RTLR(2,Current);
	RTLR(3,tr2);
	RTLR(4,arg1);
	RTLIU(5);
	
	RTGC;
	tr1 = RTLNSMART(eif_new_type(2182, 0).id);
	tr2 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2)+ _LNGOFF_1_1_0_2_);
	ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R16582[Dtype(arg1)-2180])(RTCW(arg1));
	ti4_3 = F1935_18495(Current);
	F2181_21337(RTCW(tr1), (EIF_INTEGER_32) (ti4_1 + (EIF_INTEGER_32) (ti4_2 * ti4_3)));
	loc1 = (EIF_REFERENCE) tr1;
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R16727[Dtype(loc1)-2182])(RTCW(loc1), *(EIF_REFERENCE *)(Current));
	F1935_18504(Current, loc1, arg1, (EIF_CHARACTER_8) '\000');
	tr1 = RTLNS(eif_new_type(1934, 0x00).id, 1934, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F1935_18453(RTCW(tr1), loc1);
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.appended_with_extension */
EIF_REFERENCE F1935_18481 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_INTEGER_32 ti4_4;
	RTLD;
	
	RTLI(5);
	RTLR(0,loc1);
	RTLR(1,tr1);
	RTLR(2,Current);
	RTLR(3,tr2);
	RTLR(4,arg1);
	RTLIU(5);
	
	RTGC;
	tr1 = RTLNSMART(eif_new_type(2182, 0).id);
	tr2 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2)+ _LNGOFF_1_1_0_2_);
	ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R16582[Dtype(arg1)-2180])(RTCW(arg1));
	ti4_3 = F1935_18495(Current);
	ti4_4 = F1935_18495(Current);
	F2181_21337(RTCW(tr1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + (EIF_INTEGER_32) (ti4_2 * ti4_3)) + ti4_4));
	loc1 = (EIF_REFERENCE) tr1;
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R16727[Dtype(loc1)-2182])(RTCW(loc1), *(EIF_REFERENCE *)(Current));
	F1935_18504(Current, loc1, arg1, (EIF_CHARACTER_8) '.');
	tr1 = RTLNS(eif_new_type(1934, 0x00).id, 1934, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F1935_18454(RTCW(tr1), loc1);
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.same_as */
EIF_BOOLEAN F1935_18482 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(4);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTGC;
	if ((EIF_BOOLEAN)(arg1 == NULL)) {
	} else {
		if ((EIF_BOOLEAN)(arg1 == Current)) {
			RTLE;
			return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		} else {
			if ((EIF_BOOLEAN) EIF_TEST(eif_case_sensitive_path_names())) {
				{
					/* INLINED CODE (is_case_sensitive_equal) */
					tb1 = (EIF_BOOLEAN)  0;
					if ((EIF_BOOLEAN)(arg1 == Current)) {
						tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
					} else {
						tr1 = *(EIF_REFERENCE *)(Current);
						tr2 = *(EIF_REFERENCE *)(RTCW(arg1));
						tb1 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE, EIF_REFERENCE)) R11[Dtype(tr1)-0])(RTCW(tr1), tr2);
					}
					/* END INLINED CODE */
				}
				RTLE;
				return (EIF_BOOLEAN) tb1;
			} else {
				RTLE;
				return (EIF_BOOLEAN) F1935_18486(Current, arg1);
			}
		}
	}
	RTLE;
	return (EIF_BOOLEAN) 0;
}

/* {PATH}.is_less */
EIF_BOOLEAN F1935_18483 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,arg1);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTGC;
	if ((EIF_BOOLEAN) EIF_TEST(eif_case_sensitive_path_names())) {
		tr1 = *(EIF_REFERENCE *)(Current);
		tr2 = *(EIF_REFERENCE *)(RTCW(arg1));
		Result = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE, EIF_REFERENCE)) R10028[Dtype(tr1)-1095])(RTCW(tr1), tr2);
	} else {
		tr1 = F2188_21593(RTCV(F1935_18490(Current)));
		tr2 = F1935_18490(RTCW(arg1));
		tr2 = F2188_21593(RTCW(tr2));
		Result = F2187_21558(RTCW(tr1), tr2);
	}
	RTLE;
	return Result;
}

/* {PATH}.is_equal */
EIF_BOOLEAN F1935_18484 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	
	
	return (EIF_BOOLEAN) F1935_18482(Current, arg1);
}

/* {PATH}.is_case_sensitive_equal */
EIF_BOOLEAN F1935_18485 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTGC;
	if ((EIF_BOOLEAN)(arg1 == Current)) {
		RTLE;
		return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	} else {
		tr1 = *(EIF_REFERENCE *)(Current);
		tr2 = *(EIF_REFERENCE *)(RTCW(arg1));
		Result = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE, EIF_REFERENCE)) R11[Dtype(tr1)-0])(RTCW(tr1), tr2);
	}
	RTLE;
	return Result;
}

/* {PATH}.is_case_insensitive_equal */
EIF_BOOLEAN F1935_18486 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTGC;
	if ((EIF_BOOLEAN)(arg1 == Current)) {
		RTLE;
		return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	} else {
		tr1 = F1935_18490(Current);
		tr2 = F1935_18490(RTCW(arg1));
		Result = F2187_21554(RTCW(tr1), tr2);
	}
	RTLE;
	return Result;
}

/* {PATH}.copy */
void F1935_18487 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLIU(3);
	
	RTGC;
	if ((EIF_BOOLEAN)(arg1 != Current)) {
		eif_builtin_ANY_standard_copy (Current, arg1);
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
		tr1 = (EIF_REFERENCE) eif_builtin_ANY_twin (tr1);
		RTAR(Current, tr1);
		*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	}
	RTLE;
}

/* {PATH}.out */
EIF_REFERENCE F1935_18488 (EIF_REFERENCE Current)
{
	GTCX
	
	
	return (EIF_REFERENCE) F1935_18489(Current);
}

/* {PATH}.utf_8_name */
EIF_REFERENCE F1935_18489 (EIF_REFERENCE Current)
{
	GTCX
	struct eif_ex_131 sloc1;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) sloc1.data;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	memset (&sloc1.overhead, 0, OVERHEAD + _OBJSIZ_0_0_0_0_0_0_0_0_);
	sloc1.overhead.ov_flags = EO_EXP | EO_STACK;
	RT_DFS(&sloc1.overhead, eif_new_type(143, 0x00).id);
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	tr1 = F1935_18490(Current);
	Result = F144_2661(RTCW(loc1), tr1);
	RTLE;
	return Result;
}

/* {PATH}.name */
EIF_REFERENCE F1935_18490 (EIF_REFERENCE Current)
{
	GTCX
	struct eif_ex_131 sloc1;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) sloc1.data;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	memset (&sloc1.overhead, 0, OVERHEAD + _OBJSIZ_0_0_0_0_0_0_0_0_);
	sloc1.overhead.ov_flags = EO_EXP | EO_STACK;
	RT_DFS(&sloc1.overhead, eif_new_type(143, 0x00).id);
	RTLI(6);
	RTLR(0,loc2);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc1);
	RTLR(4,tr2);
	RTLR(5,Result);
	RTLIU(6);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_1_);
	loc2 = tr1;
	if (EIF_TEST(loc2)) {
		RTLE;
		return (EIF_REFERENCE) loc2;
	} else {
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
			tr1 = RTLNS(eif_new_type(2187, 0x00).id, 2187, _OBJSIZ_1_0_0_4_0_0_0_0_);
			tr2 = F144_2703(RTCW(loc1), *(EIF_REFERENCE *)(Current));
			F2187_21532(RTCW(tr1), tr2);
			Result = (EIF_REFERENCE) tr1;
		} else {
			tr1 = RTLNS(eif_new_type(2187, 0x00).id, 2187, _OBJSIZ_1_0_0_4_0_0_0_0_);
			tr2 = F144_2676(RTCW(loc1), *(EIF_REFERENCE *)(Current));
			F2187_21532(RTCW(tr1), tr2);
			Result = (EIF_REFERENCE) tr1;
		}
		RTAR(Current, Result);
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) Result;
	}
	RTLE;
	return Result;
}

/* {PATH}.to_pointer */
EIF_REFERENCE F1935_18492 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,tr1);
	RTLR(2,Current);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTGC;
	tr1 = RTLNS(eif_new_type(1167, 0x00).id, 1167, _OBJSIZ_1_0_0_1_0_0_0_0_);
	tr2 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2)+ _LNGOFF_1_1_0_2_);
	ti4_2 = F1935_18495(Current);
	F1168_13018(RTCW(tr1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + ti4_2) - ((EIF_INTEGER_32) 1L)));
	loc1 = (EIF_REFERENCE) tr1;
	{
		/* INLINED CODE (set_string) */
		tr1 = *(EIF_REFERENCE *)(Current);
		ti4_1 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R16582[Dtype(tr1)-2180])(RTCW(tr1));
		F1168_13043(RTCW(loc1), tr1, ((EIF_INTEGER_32) 1L), ti4_1);
		/* END INLINED CODE */
	}
	;
	tr1 = *(EIF_REFERENCE *)(RTCW(loc1));
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.storage */
EIF_REFERENCE F1935_18494 (EIF_REFERENCE Current)
{
	return *(EIF_REFERENCE *)(Current);
}


/* {PATH}.unit_size */
EIF_INTEGER_32 F1935_18495 (EIF_REFERENCE Current)
{
	GTCX
	
	
	RTGC;
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
	} else {
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	}/* NOTREACHED */
	
}

/* {PATH}.reset_internal_data */
void F1935_18496 (EIF_REFERENCE Current)
{
	GTCX
	
	
	*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
}

/* {PATH}.normalize */
void F1935_18497 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc4 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc5 = (EIF_INTEGER_32) 0;
	EIF_BOOLEAN loc6 = (EIF_BOOLEAN) 0;
	EIF_BOOLEAN loc7 = (EIF_BOOLEAN) 0;
	EIF_BOOLEAN loc8 = (EIF_BOOLEAN) 0;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	RTLD;
	
	RTLI(2);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLIU(2);
	
	RTGC;
	loc1 = *(EIF_REFERENCE *)(Current);
	loc4 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
		loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		if ((EIF_BOOLEAN) (loc4 >= ((EIF_INTEGER_32) 10L))) {
			tb1 = '\01';
			tb2 = '\0';
			if (F1935_18507(Current, loc1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '/')) {
				tb3 = '\01';
				if (!F1935_18507(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '/')) {
					tb3 = F1935_18507(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '\\');
				}
				tb2 = tb3;
			}
			if (!(tb2)) {
				tb2 = '\0';
				if (F1935_18507(Current, loc1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '\\')) {
					tb3 = '\01';
					if (!F1935_18507(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '\\')) {
						tb3 = F1935_18507(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '/');
					}
					tb2 = tb3;
				}
				tb1 = tb2;
			}
			if (tb1) {
				tb1 = '\0';
				if ((EIF_BOOLEAN) !F1935_18507(Current, loc1, ((EIF_INTEGER_32) 5L), (EIF_CHARACTER_8) '/')) {
					tb1 = (EIF_BOOLEAN) !F1935_18507(Current, loc1, ((EIF_INTEGER_32) 5L), (EIF_CHARACTER_8) '\\');
				}
				if (tb1) {
					loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 5L);
					loc8 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
				}
			}
		}
		loc3 = (EIF_INTEGER_32) loc2;
		loc7 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		for (;;) {
			if ((EIF_BOOLEAN) (loc2 > loc4)) break;
			if (loc6) {
				loc7 = '\0';
				if ((EIF_BOOLEAN) !F1935_18507(Current, loc1, loc2, (EIF_CHARACTER_8) '\\')) {
					loc7 = (EIF_BOOLEAN) !F1935_18507(Current, loc1, loc2, (EIF_CHARACTER_8) '/');
				}
				loc6 = (EIF_BOOLEAN) (EIF_BOOLEAN) !loc7;
			} else {
				if (F1935_18507(Current, loc1, loc2, (EIF_CHARACTER_8) '/')) {
					tc1 = (EIF_CHARACTER_8) '\\';
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R7438[Dtype(loc1)-1393])(RTCW(loc1), (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &loc2);
					loc6 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
				} else {
					loc6 = F1935_18507(Current, loc1, loc2, (EIF_CHARACTER_8) '\\');
				}
			}
			if (loc7) {
				if ((EIF_BOOLEAN)(loc2 != loc3)) {
					tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R11867[Dtype(loc1)-1393])(RTCW(loc1), loc2));
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R7438[Dtype(loc1)-1393])(RTCW(loc1), (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &loc3);
					tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R11867[Dtype(loc1)-1393])(RTCW(loc1), (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L))));
					ti4_1 = (EIF_INTEGER_32) (loc3 + ((EIF_INTEGER_32) 1L));
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R7438[Dtype(loc1)-1393])(RTCW(loc1), (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &ti4_1);
				}
				loc3 += ((EIF_INTEGER_32) 2L);
			}
			loc2 += ((EIF_INTEGER_32) 2L);
		}
	} else {
		loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		loc3 = (EIF_INTEGER_32) loc2;
		loc7 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		for (;;) {
			if ((EIF_BOOLEAN) (loc2 > loc4)) break;
			if (loc6) {
				loc7 = F1935_18507(Current, loc1, loc2, (EIF_CHARACTER_8) '/');
				loc7 = (EIF_BOOLEAN) (EIF_BOOLEAN) !loc7;
				loc6 = (EIF_BOOLEAN) (EIF_BOOLEAN) !loc7;
			} else {
				loc6 = F1935_18507(Current, loc1, loc2, (EIF_CHARACTER_8) '/');
			}
			if (loc7) {
				if ((EIF_BOOLEAN)(loc2 != loc3)) {
					tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R11867[Dtype(loc1)-1393])(RTCW(loc1), loc2));
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R7438[Dtype(loc1)-1393])(RTCW(loc1), (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &loc3);
				}
				loc3++;
			}
			loc2++;
		}
	}
	if ((EIF_BOOLEAN)(loc2 != loc3)) {
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_INTEGER_32)) R16661[Dtype(loc1)-2182])(RTCW(loc1), (EIF_INTEGER_32) (loc3 - ((EIF_INTEGER_32) 1L)));
	}
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	if (loc8) {
		loc5 = F1935_18501(Current);
		if ((EIF_BOOLEAN)(loc5 == ((EIF_INTEGER_32) 0L))) {
			{
				/* INLINED CODE (unit_size) */
				ti4_1 = (EIF_INTEGER_32)  0;
				tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
				if (tb1) {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
				} else {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
				}
				/* END INLINED CODE */
			}
			ti4_2 = ti4_1;
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_INTEGER_32)) R16667[Dtype(loc1)-2182])(RTCW(loc1), ti4_2);
		}
	}
	tb1 = '\0';
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
	{
		/* INLINED CODE (unit_size) */
		ti4_2 = (EIF_INTEGER_32)  0;
		tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
		if (tb2) {
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
		} else {
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		}
		/* END INLINED CODE */
	}
	ti4_3 = ti4_2;
	{
		/* INLINED CODE (directory_separator) */
		tc1 = (EIF_CHARACTER_8)  0;
		tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
		if (tb2) {
			tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
		} else {
			tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
		}
		/* END INLINED CODE */
	}
	tc2 = tc1;
	if (F1935_18507(Current, loc1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_3) + ((EIF_INTEGER_32) 1L)), tc2)) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN) (F1935_18501(Current) < ti4_1);
	}
	if (tb1) {
		{
			/* INLINED CODE (unit_size) */
			ti4_1 = (EIF_INTEGER_32)  0;
			tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
			if (tb1) {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
			} else {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
			/* END INLINED CODE */
		}
		ti4_2 = ti4_1;
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_INTEGER_32)) R16669[Dtype(loc1)-2182])(RTCW(loc1), ti4_2);
	}
	RTLE;
}

/* {PATH}.internal_name */
EIF_REFERENCE F1935_18498 (EIF_REFERENCE Current)
{
	return *(EIF_REFERENCE *)(Current + _REFACS_1_);
}


/* {PATH}.env */
static EIF_REFERENCE F1935_18500_body (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	

	RTLI(1);
	RTLR(0,tr1);
	RTLIU(1);
	
	RTEV;
	RTGC;
	RTOSP (18500);
#define Result RTOSR(18500)
	RTOC_NEW(Result);
	tr1 = RTLNS(eif_new_type(1015, 0x00).id, 1015, _OBJSIZ_0_0_0_1_0_0_0_0_);
	Result = (EIF_REFERENCE) tr1;
	RTOSE (18500);
	RTLE;
	RTEE;
	return Result;
#undef Result
}

EIF_REFERENCE F1935_18500 (EIF_REFERENCE Current)
{
	GTCX
	return RTOSCF(18500,F1935_18500_body,(Current));
}

/* {PATH}.root_end_position */
EIF_INTEGER_32 F1935_18501 (EIF_REFERENCE Current)
{
	GTCX
	EIF_CHARACTER_8 loc1 = (EIF_CHARACTER_8) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_CHARACTER_8 tc1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	{
		/* INLINED CODE (is_empty) */
		tb1 = (EIF_BOOLEAN)  0;
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tb1 = tb1;
	if ((EIF_BOOLEAN) !tb1) {
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
			tb1 = '\0';
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
			{
				/* INLINED CODE (unit_size) */
				ti4_2 = (EIF_INTEGER_32)  0;
				tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
				if (tb2) {
					ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
				} else {
					ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
				}
				/* END INLINED CODE */
			}
			if ((EIF_BOOLEAN)(ti4_1 == ti4_2)) {
				tr1 = *(EIF_REFERENCE *)(Current);
				tb1 = F1935_18507(Current, tr1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '\\');
			}
			if (tb1) {
				{
					/* INLINED CODE (unit_size) */
					ti4_1 = (EIF_INTEGER_32)  0;
					tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
					if (tb1) {
						ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
					} else {
						ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
					}
					/* END INLINED CODE */
				}
				RTLE;
				return (EIF_INTEGER_32) ti4_1;
			} else {
				tb1 = '\0';
				tr1 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
				if ((EIF_BOOLEAN) (ti4_1 >= ((EIF_INTEGER_32) 4L))) {
					tb2 = '\0';
					tr1 = *(EIF_REFERENCE *)(Current);
					tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R11867[Dtype(tr1)-1393])(RTCW(tr1), ((EIF_INTEGER_32) 2L)));
					if ((EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\000')) {
						tr1 = *(EIF_REFERENCE *)(Current);
						tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R11867[Dtype(tr1)-1393])(RTCW(tr1), ((EIF_INTEGER_32) 4L)));
						tb2 = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\000');
					}
					tb1 = tb2;
				}
				if (tb1) {
					tr1 = *(EIF_REFERENCE *)(Current);
					loc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R11867[Dtype(tr1)-1393])(RTCW(tr1), ((EIF_INTEGER_32) 1L)));
					loc1 = (EIF_CHARACTER_8) tolower(loc1);
					tb1 = '\0';
					if ((EIF_BOOLEAN) ((EIF_BOOLEAN) (loc1 >= (EIF_CHARACTER_8) 'a') && (EIF_BOOLEAN) (loc1 <= (EIF_CHARACTER_8) 'z'))) {
						tr1 = *(EIF_REFERENCE *)(Current);
						tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R11867[Dtype(tr1)-1393])(RTCW(tr1), ((EIF_INTEGER_32) 3L)));
						tb1 = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) ':');
					}
					if (tb1) {
						tb1 = '\0';
						tr1 = *(EIF_REFERENCE *)(Current);
						ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
						{
							/* INLINED CODE (unit_size) */
							ti4_2 = (EIF_INTEGER_32)  0;
							tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
							if (tb2) {
								ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
							} else {
								ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
							}
							/* END INLINED CODE */
						}
						if ((EIF_BOOLEAN) (ti4_1 >= (EIF_INTEGER_32) (((EIF_INTEGER_32) 3L) * ti4_2))) {
							tr1 = *(EIF_REFERENCE *)(Current);
							tb1 = F1935_18507(Current, tr1, ((EIF_INTEGER_32) 5L), (EIF_CHARACTER_8) '\\');
						}
						if (tb1) {
							RTLE;
							return (EIF_INTEGER_32) ((EIF_INTEGER_32) 6L);
						} else {
							RTLE;
							return (EIF_INTEGER_32) ((EIF_INTEGER_32) 4L);
						}
					} else {
						tb1 = '\0';
						if ((EIF_BOOLEAN)(loc1 == (EIF_CHARACTER_8) '\\')) {
							tr1 = *(EIF_REFERENCE *)(Current);
							tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R11867[Dtype(tr1)-1393])(RTCW(tr1), ((EIF_INTEGER_32) 3L)));
							tb1 = (EIF_BOOLEAN)(tc1 != (EIF_CHARACTER_8) '\\');
						}
						if (tb1) {
							{
								/* INLINED CODE (unit_size) */
								ti4_1 = (EIF_INTEGER_32)  0;
								tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
								if (tb1) {
									ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
								} else {
									ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
								}
								/* END INLINED CODE */
							}
							Result = ti4_1;
						} else {
							tb1 = '\0';
							tb2 = '\0';
							tb3 = '\0';
							tr1 = *(EIF_REFERENCE *)(Current);
							ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
							if ((EIF_BOOLEAN) (ti4_1 >= ((EIF_INTEGER_32) 10L))) {
								tb3 = (EIF_BOOLEAN)(loc1 == (EIF_CHARACTER_8) '\\');
							}
							if (tb3) {
								tr1 = *(EIF_REFERENCE *)(Current);
								tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R11867[Dtype(tr1)-1393])(RTCW(tr1), ((EIF_INTEGER_32) 3L)));
								tb2 = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\\');
							}
							if (tb2) {
								tr1 = *(EIF_REFERENCE *)(Current);
								tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R11867[Dtype(tr1)-1393])(RTCW(tr1), ((EIF_INTEGER_32) 5L)));
								tb1 = (EIF_BOOLEAN)(tc1 != (EIF_CHARACTER_8) '\\');
							}
							if (tb1) {
								loc2 = F1935_18503(Current, ((EIF_INTEGER_32) 7L));
								tb1 = '\0';
								if ((EIF_BOOLEAN) (loc2 > ((EIF_INTEGER_32) 0L))) {
									{
										/* INLINED CODE (unit_size) */
										ti4_1 = (EIF_INTEGER_32)  0;
										tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
										if (tb2) {
											ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
										} else {
											ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
										}
										/* END INLINED CODE */
									}
									tr1 = *(EIF_REFERENCE *)(Current);
									ti4_2 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
									tb1 = (EIF_BOOLEAN) ((EIF_INTEGER_32) (loc2 + ti4_1) <= ti4_2);
								}
								if (tb1) {
									{
										/* INLINED CODE (unit_size) */
										ti4_1 = (EIF_INTEGER_32)  0;
										tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
										if (tb1) {
											ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
										} else {
											ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
										}
										/* END INLINED CODE */
									}
									ti4_2 = ti4_1;
									loc2 = F1935_18503(Current, (EIF_INTEGER_32) (loc2 + ti4_2));
									if ((EIF_BOOLEAN) (loc2 > ((EIF_INTEGER_32) 0L))) {
										RTLE;
										return (EIF_INTEGER_32) (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L));
									} else {
										tr1 = *(EIF_REFERENCE *)(Current);
										Result = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
									}
								}
							}
						}
					}
				}
			}
		} else {
			tr1 = *(EIF_REFERENCE *)(Current);
			tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R11867[Dtype(tr1)-1393])(RTCW(tr1), ((EIF_INTEGER_32) 1L)));
			if ((EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '/')) {
				RTLE;
				return (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.end_position_of_last_directory_separator */
EIF_INTEGER_32 F1935_18502 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	{
		/* INLINED CODE (is_empty) */
		tb1 = (EIF_BOOLEAN)  0;
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tb1 = tb1;
	if ((EIF_BOOLEAN) !tb1) {
		tr1 = *(EIF_REFERENCE *)(Current);
		Result = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		{
			/* INLINED CODE (unit_size) */
			ti4_1 = (EIF_INTEGER_32)  0;
			tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
			if (tb1) {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
			} else {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
			/* END INLINED CODE */
		}
		ti4_2 = ti4_1;
		Result = (EIF_INTEGER_32) (EIF_INTEGER_32) ((EIF_INTEGER_32) (Result - ti4_2) + ((EIF_INTEGER_32) 1L));
		if ((EIF_BOOLEAN) (Result >= ((EIF_INTEGER_32) 1L))) {
			for (;;) {
				tb1 = '\01';
				if (!(EIF_BOOLEAN) (Result < ((EIF_INTEGER_32) 1L))) {
					tr1 = *(EIF_REFERENCE *)(Current);
					{
						/* INLINED CODE (directory_separator) */
						tc1 = (EIF_CHARACTER_8)  0;
						tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
						if (tb2) {
							tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
						} else {
							tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
						}
						/* END INLINED CODE */
					}
					tc2 = tc1;
					tb1 = F1935_18507(Current, tr1, Result, tc2);
				}
				if (tb1) break;
				{
					/* INLINED CODE (unit_size) */
					ti4_1 = (EIF_INTEGER_32)  0;
					tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
					if (tb2) {
						ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
					} else {
						ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
					}
					/* END INLINED CODE */
				}
				Result -= ti4_1;
			}
		}
		if ((EIF_BOOLEAN) (Result < ((EIF_INTEGER_32) 0L))) {
			RTLE;
			return (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
		} else {
			{
				/* INLINED CODE (unit_size) */
				ti4_1 = (EIF_INTEGER_32)  0;
				tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
				if (tb2) {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
				} else {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
				}
				/* END INLINED CODE */
			}
			ti4_2 = ti4_1;
			Result = (EIF_INTEGER_32) (EIF_INTEGER_32) ((EIF_INTEGER_32) (Result + ti4_2) - ((EIF_INTEGER_32) 1L));
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.next_directory_separator */
EIF_INTEGER_32 F1935_18503 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_CHARACTER_8 loc3 = (EIF_CHARACTER_8) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,loc4);
	RTLIU(2);
	
	RTGC;
	{
		/* INLINED CODE (unit_size) */
		ti4_1 = (EIF_INTEGER_32)  0;
		tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
		if (tb1) {
			ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
		} else {
			ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		}
		/* END INLINED CODE */
	}
	loc2 = ti4_1;
	{
		/* INLINED CODE (directory_separator) */
		tc1 = (EIF_CHARACTER_8)  0;
		tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
		if (tb1) {
			tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
		} else {
			tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
		}
		/* END INLINED CODE */
	}
	loc3 = tc1;
	Result = (EIF_INTEGER_32) arg1;
	loc4 = *(EIF_REFERENCE *)(Current);
	loc1 = *(EIF_INTEGER_32 *)(RTCW(loc4)+ _LNGOFF_1_1_0_2_);
	for (;;) {
		tb1 = '\01';
		if (!(EIF_BOOLEAN) ((EIF_BOOLEAN) (Result < ((EIF_INTEGER_32) 1L)) || (EIF_BOOLEAN) (Result > loc1))) {
			tb1 = F1935_18507(Current, loc4, Result, loc3);
		}
		if (tb1) break;
		Result += loc2;
	}
	if ((EIF_BOOLEAN) (Result > loc1)) {
		RTLE;
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
	}
	RTLE;
	return Result;
}

/* {PATH}.internal_append_into */
void F1935_18504 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_CHARACTER_8 arg3)
{
	GTCX
	struct eif_ex_131 sloc1;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) sloc1.data;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_CHARACTER_32 tw1;
	EIF_CHARACTER_32 tw2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	RTLD;
	
	memset (&sloc1.overhead, 0, OVERHEAD + _OBJSIZ_0_0_0_0_0_0_0_0_);
	sloc1.overhead.ov_flags = EO_EXP | EO_STACK;
	RT_DFS(&sloc1.overhead, eif_new_type(143, 0x00).id);
	RTLI(4);
	RTLR(0,arg2);
	RTLR(1,arg1);
	RTLR(2,Current);
	RTLR(3,loc1);
	RTLIU(4);
	
	RTGC;
	tb1 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R16560[Dtype(arg2)-2181])(RTCW(arg2));
	if ((EIF_BOOLEAN) !tb1) {
		tb1 = '\0';
		tb2 = '\0';
		tb3 = '\0';
		if ((EIF_BOOLEAN)(arg3 != (EIF_CHARACTER_8) '\000')) {
			{
				/* INLINED CODE (is_empty) */
				tb4 = (EIF_BOOLEAN)  0;
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1)+ _LNGOFF_1_1_0_2_);
				tb4 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
				/* END INLINED CODE */
			}
			tb4 = tb4;
			tb3 = (EIF_BOOLEAN) !tb4;
		}
		if (tb3) {
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1)+ _LNGOFF_1_1_0_2_);
			{
				/* INLINED CODE (unit_size) */
				ti4_2 = (EIF_INTEGER_32)  0;
				tb3 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
				if (tb3) {
					ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
				} else {
					ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
				}
				/* END INLINED CODE */
			}
			ti4_3 = ti4_2;
			tb2 = (EIF_BOOLEAN) !F1935_18507(Current, arg1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_3) + ((EIF_INTEGER_32) 1L)), arg3);
		}
		if (tb2) {
			tw1 = (FUNCTION_CAST(EIF_CHARACTER_32, (EIF_REFERENCE, EIF_INTEGER_32)) R16546[Dtype(arg2)-2181])(RTCW(arg2), ((EIF_INTEGER_32) 1L));
			tw2 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '/';
			tb1 = (EIF_BOOLEAN)(tw1 != tw2);
		}
		if (tb1) {
			if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
				tw1 = (FUNCTION_CAST(EIF_CHARACTER_32, (EIF_REFERENCE, EIF_INTEGER_32)) R16546[Dtype(arg2)-2181])(RTCW(arg2), ((EIF_INTEGER_32) 1L));
				tw2 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '\\';
				if ((EIF_BOOLEAN)(tw1 != tw2)) {
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R16731[Dtype(arg1)-2182])(RTCW(arg1), arg3);
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R16731[Dtype(arg1)-2182])(RTCW(arg1), (EIF_CHARACTER_8) '\000');
				}
			} else {
				(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R16731[Dtype(arg1)-2182])(RTCW(arg1), arg3);
			}
		}
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
			F144_2690(RTCW(loc1), arg2, arg1);
		} else {
			F144_2665(RTCW(loc1), arg2, arg1);
		}
	}
	RTLE;
}

/* {PATH}.internal_path_append_into */
void F1935_18505 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_CHARACTER_8 arg3)
{
	GTCX
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,arg2);
	RTLIU(3);
	
	RTGC;
	tb1 = '\0';
	tb2 = '\0';
	tb3 = '\0';
	if ((EIF_BOOLEAN)(arg3 != (EIF_CHARACTER_8) '\000')) {
		{
			/* INLINED CODE (is_empty) */
			tb4 = (EIF_BOOLEAN)  0;
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1)+ _LNGOFF_1_1_0_2_);
			tb4 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
			/* END INLINED CODE */
		}
		tb4 = tb4;
		tb3 = (EIF_BOOLEAN) !tb4;
	}
	if (tb3) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1)+ _LNGOFF_1_1_0_2_);
		{
			/* INLINED CODE (unit_size) */
			ti4_2 = (EIF_INTEGER_32)  0;
			tb3 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
			if (tb3) {
				ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
			} else {
				ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
			/* END INLINED CODE */
		}
		ti4_3 = ti4_2;
		tb2 = (EIF_BOOLEAN) !F1935_18507(Current, arg1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_3) + ((EIF_INTEGER_32) 1L)), arg3);
	}
	if (tb2) {
		tb1 = (EIF_BOOLEAN) !F1935_18507(Current, arg2, ((EIF_INTEGER_32) 1L), arg3);
	}
	if (tb1) {
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R16731[Dtype(arg1)-2182])(RTCW(arg1), arg3);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R16731[Dtype(arg1)-2182])(RTCW(arg1), (EIF_CHARACTER_8) '\000');
		}
	}
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R16727[Dtype(arg1)-2182])(RTCW(arg1), arg2);
	RTLE;
}

/* {PATH}.internal_path_append_substring_into */
void F1935_18506 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_CHARACTER_8 arg5)
{
	GTCX
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,arg2);
	RTLIU(3);
	
	RTGC;
	tb1 = '\0';
	tb2 = '\0';
	tb3 = '\0';
	if ((EIF_BOOLEAN)(arg5 != (EIF_CHARACTER_8) '\000')) {
		{
			/* INLINED CODE (is_empty) */
			tb4 = (EIF_BOOLEAN)  0;
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1)+ _LNGOFF_1_1_0_2_);
			tb4 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
			/* END INLINED CODE */
		}
		tb4 = tb4;
		tb3 = (EIF_BOOLEAN) !tb4;
	}
	if (tb3) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1)+ _LNGOFF_1_1_0_2_);
		{
			/* INLINED CODE (unit_size) */
			ti4_2 = (EIF_INTEGER_32)  0;
			tb3 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows;
			if (tb3) {
				ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
			} else {
				ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
			/* END INLINED CODE */
		}
		ti4_3 = ti4_2;
		tb2 = (EIF_BOOLEAN) !F1935_18507(Current, arg1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_3) + ((EIF_INTEGER_32) 1L)), arg5);
	}
	if (tb2) {
		tb1 = (EIF_BOOLEAN) !F1935_18507(Current, arg2, arg3, arg5);
	}
	if (tb1) {
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R16731[Dtype(arg1)-2182])(RTCW(arg1), arg5);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R16731[Dtype(arg1)-2182])(RTCW(arg1), (EIF_CHARACTER_8) '\000');
		}
	}
	F2183_21449(RTCW(arg1), arg2, arg3, arg4);
	RTLE;
}

/* {PATH}.is_character */
EIF_BOOLEAN F1935_18507 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_INTEGER_32 arg2, EIF_CHARACTER_8 arg3)
{
	GTCX
	EIF_CHARACTER_8 tc1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,arg1);
	RTLIU(1);
	
	RTGC;
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows) {
		Result = '\0';
		tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R11867[Dtype(arg1)-1393])(RTCW(arg1), arg2));
		if ((EIF_BOOLEAN)(tc1 == arg3)) {
			tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R11867[Dtype(arg1)-1393])(RTCW(arg1), (EIF_INTEGER_32) (arg2 + ((EIF_INTEGER_32) 1L))));
			Result = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\000');
		}
	} else {
		tc1 = *(EIF_CHARACTER_8 *)(eif_optimize_return = 1, (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R11867[Dtype(arg1)-1393])(RTCW(arg1), arg2));
		Result = (EIF_BOOLEAN) (EIF_BOOLEAN)(tc1 == arg3);
	}
	RTLE;
	return Result;
}

/* {PATH}.c_same_files */
EIF_BOOLEAN F1935_18510 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2)
{
	GTCX
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	
	
	Result = EIF_TEST(inline_F1935_18510 ((EIF_POINTER) arg1, (EIF_POINTER) arg2));
	return Result;
}

void EIF_Minit1116 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
