note

	description: "General notion of menu"
	legal: "See notice at end of class.";
	status: "See notice at end of class.";
	date: "$Date: 2008-12-29 12:27:11 -0800 (Mon, 29 Dec 2008) $";
	revision: "$Revision: 76420 $"

deferred class

	MENU  

inherit

	MANAGER
		redefine
			implementation
		end
	
feature -- Access

	title: STRING
			-- Title of menu
		require
			exists: not destroyed;
		do
			Result:= implementation.title
		end; 

feature -- Element change

	set_title (a_title: STRING)
			-- Set menu title to `a_title'.
		require
			exists: not destroyed;
			valid_title: a_title /= Void
		do
			implementation.set_title (a_title)
		end;

	remove_title
			-- Remove current menu title if any.
		require
			exists: not destroyed;
		do
			implementation.remove_title
		end

feature {G_ANY, G_ANY_I, WIDGET_I, TOOLKIT} -- Implementation

	implementation: MENU_I;;
			-- Implementation of menu

note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"




end -- class MENU

