note
	description: "Objects that ..."
	author: ""
	date: "$Date: 2013-06-03 16:53:45 -0700 (Mon, 03 Jun 2013) $"
	revision: "$Revision: 92667 $"

class

	INET_ADDRESS_IMPL_V6

inherit

	INET_ADDRESS_IMPL

feature -- Access

	local_host_name: STRING
		local
			data: MANAGED_POINTER
		do
			create data.make (256)
			get_local_host_name (data.item)
			create Result.make_from_c (data.item)
		end

	any_local_address: INET_ADDRESS
		once
			create {INET6_ADDRESS} Result.make_from_host_and_address("::",
			<<0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00>>);
		end

	loopback_address: INET_ADDRESS
		do
			create {INET6_ADDRESS} Result.make_from_host_and_address("::1",
			<<0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01>>)
		end

feature {NONE} -- Externals

	get_local_host_name (data: POINTER)
		external
			"C"
		alias
			"en_local_host_name"
		end


end
