note

	description:

		"Imported routines that ought to be in class ARRAY"

	library: "Gobo Eiffel Kernel Library"
	copyright: "Copyright (c) 1999-2013, Eric Bezault and others"
	license: "MIT License"
	date: "$Date: 2016-05-06 12:15:38 -0700 (Fri, 06 May 2016) $"
	revision: "$Revision: 98678 $"

class KL_IMPORTED_ARRAY_ROUTINES

feature -- Access

	ANY_ARRAY_: KL_ARRAY_ROUTINES [detachable ANY]
			-- Routines that ought to be in class ARRAY
		once
			create Result
		ensure
			any_array_routines_not_void: Result /= Void
		end

	INTEGER_ARRAY_: KL_ARRAY_ROUTINES [INTEGER]
			-- Routines that ought to be in class ARRAY
		once
			create Result
		ensure
			integer_array_routines_not_void: Result /= Void
		end

	BOOLEAN_ARRAY_: KL_ARRAY_ROUTINES [BOOLEAN]
			-- Routines that ought to be in class ARRAY
		once
			create Result
		ensure
			boolean_array_routines_not_void: Result /= Void
		end

	STRING_ARRAY_: KL_ARRAY_ROUTINES [detachable STRING]
			-- Routines that ought to be in class ARRAY
		once
			create Result
		ensure
			string_array_routines_not_void: Result /= Void
		end

	string_array_routines: KL_ARRAY_ROUTINES [STRING]
			-- Routines that ought to be in class ARRAY
		once
			create Result
		ensure
			string_array_routines_not_void: Result /= Void
		end

	detachable_string_array_routines: KL_ARRAY_ROUTINES [detachable STRING]
			-- Routines that ought to be in class ARRAY
		once
			create Result
		ensure
			detachable_string_array_routines_not_void: Result /= Void
		end

	ARRAY_SPECIAL_INTEGER_: KL_ARRAY_ROUTINES [detachable SPECIAL [INTEGER]]
			-- Routines that ought to be in class ARRAY
		once
			create Result
		ensure
			special_integer_array_routines_not_void: Result /= Void
		end

end
