note
	description: "Implemented `ITaskTrigger' interface."
	generator: "Automatically generated by the EiffelCOM Wizard."

class
	ITASK_TRIGGER_IMPL_PROXY

inherit
	ITASK_TRIGGER_INTERFACE

	ECOM_QUERIABLE

create
	make_from_other,
	make_from_pointer

feature {NONE}  -- Initialization

	make_from_pointer (a_object: POINTER)
			-- Make from pointer
		do
			initializer := ccom_create_itask_trigger_impl_proxy_from_pointer(a_object)
			item := ccom_item (initializer)
		end

feature -- Basic Operations

	set_trigger (p_trigger: PTASK_TRIGGER_ALIAS)
			-- Sets the task trigger values.
			-- `p_trigger' [in].  
		do
			ccom_set_trigger (initializer, p_trigger.item)
		end

	get_trigger (p_trigger: PTASK_TRIGGER_ALIAS)
			-- Retrieves the current task trigger.
			-- `p_trigger' [out].  
		do
			ccom_get_trigger (initializer, p_trigger.item)
		end

	get_trigger_string (ppwsz_trigger: CELL [STRING])
			-- Retrieves the current task trigger in the form of a string.
			-- `ppwsz_trigger' [out].  
		do
			ccom_get_trigger_string (initializer, ppwsz_trigger)
		end

feature {NONE}  -- Implementation

	delete_wrapper
			-- Delete wrapper
		do
			ccom_delete_itask_trigger_impl_proxy(initializer)
		end

feature {NONE}  -- Externals

	ccom_set_trigger (a_object: POINTER; p_trigger: POINTER)
			-- Sets the task trigger values.
		external
			"C++ [ecom_MS_TaskSched_lib::ITaskTrigger_impl_proxy %"ecom_MS_TaskSched_lib_ITaskTrigger_impl_proxy.h%"](ecom_MS_TaskSched_lib::PTASK_TRIGGER)"
		end

	ccom_get_trigger (a_object: POINTER; p_trigger: POINTER)
			-- Retrieves the current task trigger.
		external
			"C++ [ecom_MS_TaskSched_lib::ITaskTrigger_impl_proxy %"ecom_MS_TaskSched_lib_ITaskTrigger_impl_proxy.h%"](ecom_MS_TaskSched_lib::PTASK_TRIGGER)"
		end

	ccom_get_trigger_string (a_object: POINTER; ppwsz_trigger: CELL [STRING])
			-- Retrieves the current task trigger in the form of a string.
		external
			"C++ [ecom_MS_TaskSched_lib::ITaskTrigger_impl_proxy %"ecom_MS_TaskSched_lib_ITaskTrigger_impl_proxy.h%"](EIF_OBJECT)"
		end

	ccom_delete_itask_trigger_impl_proxy (a_pointer: POINTER)
			-- Release resource
		external
			"C++ [delete ecom_MS_TaskSched_lib::ITaskTrigger_impl_proxy %"ecom_MS_TaskSched_lib_ITaskTrigger_impl_proxy.h%"]()"
		end

	ccom_create_itask_trigger_impl_proxy_from_pointer (a_pointer: POINTER): POINTER
			-- Create from pointer
		external
			"C++ [new ecom_MS_TaskSched_lib::ITaskTrigger_impl_proxy %"ecom_MS_TaskSched_lib_ITaskTrigger_impl_proxy.h%"](IUnknown *)"
		end

	ccom_item (a_object: POINTER): POINTER
			-- Item
		external
			"C++ [ecom_MS_TaskSched_lib::ITaskTrigger_impl_proxy %"ecom_MS_TaskSched_lib_ITaskTrigger_impl_proxy.h%"](): EIF_POINTER"
		end

end -- ITASK_TRIGGER_IMPL_PROXY


