/*
 * Code for class EW_UNIX_OS
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "ew152.h"
#include <sys/wait.h>
#include <signal.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F58_777
static void inline_F58_777 (EIF_POINTER arg1, EIF_POINTER arg2)
{
	int rc;
  				int fd[2];
  				EIF_INTEGER * read_ptr;
  				EIF_INTEGER * write_ptr;

  				rc = pipe(fd);
  				if (rc != 0) {
    					xraise(EN_SYS);
  				}
  				read_ptr = (EIF_INTEGER *) arg1;
  				write_ptr = (EIF_INTEGER *) arg2;
  				*read_ptr = fd[0];
  				*write_ptr = fd[1];
	;
}
#define INLINE_F58_777
#endif
#ifndef INLINE_F58_780
static EIF_INTEGER_32 inline_F58_780 (void)
{
	pid_t pid;

  				pid = eif_thread_fork();
  				if (pid == (pid_t) -1) {
    					xraise(EN_SYS);
  				}
  				return (EIF_INTEGER) pid;
	;
}
#define INLINE_F58_780
#endif
#ifndef INLINE_F58_778
static EIF_POINTER inline_F58_778 (EIF_INTEGER_32 arg1)
{
	char ** result;

  				result = (char **) malloc((size_t) (arg1 * sizeof(char *)));
  				if (result == NULL) {
    					enomem();
  				}
  				return (EIF_POINTER) result;
	;
}
#define INLINE_F58_778
#endif
#ifndef INLINE_F58_776
static EIF_POINTER inline_F58_776 (EIF_POINTER arg1)
{
	void * result;

  				result = (char *) malloc((size_t) (strlen((char *) arg1) + 1));
  				if (result == NULL) {
    					enomem();
  				}
  				strcpy(result, arg1);
  				return (EIF_POINTER) result;
	;
}
#define INLINE_F58_776
#endif
#ifndef INLINE_F58_779
static void inline_F58_779 (EIF_POINTER arg1, EIF_INTEGER_32 arg2, EIF_POINTER arg3)
{
	char ** arguments;

				arguments = (char **) arg1;
				arguments[arg2] = (char *) arg3;
	;
}
#define INLINE_F58_779
#endif
#ifndef INLINE_F58_781
static void inline_F58_781 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4)
{
	int getdtablesize(void);
  				int max_descriptors;
  				int k, rc;
  
  				if (arg4 == EIF_TRUE) {
    					max_descriptors = getdtablesize();
  					for (k = 3; k < max_descriptors; k++) {
    						rc = fcntl(k, F_SETFD, 1);
    						if (rc == -1 && errno != EBADF) {
      							xraise(EN_SYS);
    						}
  					}
  				}
  				if (arg3 == NULL) {
    					(void) execv((char *) arg1, (char **) arg2);
  				} else {
    					(void) execve((char *) arg1, (char **) arg2, (char **) arg3);
  				}
  				xraise(EN_SYS);
	;
}
#define INLINE_F58_781
#endif
#ifndef INLINE_F58_783
static EIF_INTEGER_32 inline_F58_783 (EIF_INTEGER_32 arg1, EIF_BOOLEAN arg2, EIF_POINTER arg3)
{
	pid_t rc;
  				int status, options;
  				EIF_BOOLEAN * ptr;

  				options = ((arg2 == EIF_TRUE) ? 0 : WNOHANG) | WUNTRACED;
  				ptr = (EIF_BOOLEAN *) arg3;
  				rc = waitpid((pid_t) arg1, &status, options);
  				if (rc == (pid_t) -1) {
    					xraise(EN_SYS);
  				} else if (rc == (pid_t) 0) {	/* No process has status to report yet */
    					*ptr = EIF_FALSE;
  				} else {		/* Process reported status */
    					*ptr = EIF_TRUE;
  				}
  				return (EIF_INTEGER) status;
	;
}
#define INLINE_F58_783
#endif
#ifndef INLINE_F58_782
static void inline_F58_782 (EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	int rc;

  				rc = kill((pid_t) arg1, (int) arg2);
  				if (rc != 0 && errno != ESRCH) {
    					xraise(EN_SYS);
  				}
	;
}
#define INLINE_F58_782
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {EW_UNIX_OS}.null_file_name */

EIF_REFERENCE F391_2758 (EIF_REFERENCE Current)
{
	GTCX
	RTOSC (2758,RTMS_EX_H("/dev/null",9,2028729708));
}

/* {EW_UNIX_OS}.full_file_name */
EIF_REFERENCE F391_2759 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(5);
	RTLR(0,tr1);
	RTLR(1,arg1);
	RTLR(2,arg2);
	RTLR(3,Result);
	RTLR(4,Current);
	RTLIU(5);
	
	RTEAA("full_file_name", 390, Current, 0, 2, 3312);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNS(eif_new_type(824, 0x00).id, 824, _OBJSIZ_1_1_0_3_0_0_0_0_);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1)+ _LNGOFF_1_1_0_2_);
	ti4_2 = *(EIF_INTEGER_32 *)(RTCW(arg2)+ _LNGOFF_1_1_0_2_);
	F821_5222(RTCW(tr1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + ti4_2) + ((EIF_INTEGER_32) 1L)));
	Result = (EIF_REFERENCE) tr1;
	RTHOOK(2);
	tb1 = F194_1377(RTCW(arg1));
	if ((EIF_BOOLEAN) !tb1) {
		RTHOOK(3);
		F825_5458(RTCW(Result), arg1);
		RTHOOK(4);
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1)+ _LNGOFF_1_1_0_2_);
		tc1 = F825_5423(RTCW(arg1), ti4_1);
		if ((EIF_BOOLEAN)(tc1 != RTOSCF(1216,F117_1216,(Current)))) {
			RTHOOK(5);
			tc1 = RTOSCF(1216,F117_1216,(Current));
			F825_5473(RTCW(Result), tc1);
		}
	}
	RTHOOK(6);
	F825_5458(RTCW(Result), arg2);
	RTHOOK(7);
	RTLE;
	RTEE;
	return Result;
}

/* {EW_UNIX_OS}.executable_full_file_name */
EIF_REFERENCE F391_2760 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2)
{
	GTCX
	RTEX;
	
	
	RTEAA("executable_full_file_name", 390, Current, 0, 2, 3313);
	RTHOOK(1);
	RTHOOK(2);
	RTEE;
	return (EIF_REFERENCE) F391_2759(Current, arg1, arg2);
}

/* {EW_UNIX_OS}.full_directory_name */
EIF_REFERENCE F391_2761 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2)
{
	GTCX
	RTEX;
	
	
	RTEAA("full_directory_name", 390, Current, 0, 2, 3314);
	RTHOOK(1);
	RTHOOK(2);
	RTEE;
	return (EIF_REFERENCE) F391_2759(Current, arg1, arg2);
}

/* {EW_UNIX_OS}.new_pipe */
EIF_REFERENCE F391_2762 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(2);
	RTLR(0,tr1);
	RTLR(1,Current);
	RTLIU(2);
	
	RTEAA("new_pipe", 390, Current, 2, 0, 3315);
	RTGC;
	RTHOOK(1);
	inline_F58_777((EIF_INTEGER_32 *) &(loc1), (EIF_INTEGER_32 *) &(loc2));
	RTHOOK(2);
	tr1 = RTLNS(eif_new_type(891, 0x00).id, 891, _OBJSIZ_0_0_0_2_0_0_0_0_);
	F892_6073(RTCW(tr1), loc1, loc2);
	RTHOOK(3);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) tr1;
}

/* {EW_UNIX_OS}.fork_process */
EIF_INTEGER_32 F391_2763 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	
	
	RTEAA("fork_process", 390, Current, 0, 0, 3316);
	RTHOOK(1);
	RTHOOK(2);
	RTEE;
	return (EIF_INTEGER_32) inline_F58_780();
}

/* {EW_UNIX_OS}.exec_process */
void F391_2764 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc5 = (EIF_REFERENCE) 0;
	EIF_POINTER loc6 = (EIF_POINTER) 0;
	EIF_POINTER loc7 = (EIF_POINTER) 0;
	EIF_POINTER loc8 = (EIF_POINTER) 0;
	RTLD;
	
	RTLI(5);
	RTLR(0,arg2);
	RTLR(1,loc4);
	RTLR(2,arg1);
	RTLR(3,loc5);
	RTLR(4,Current);
	RTLIU(5);
	
	RTEAA("exec_process", 390, Current, 8, 4, 3317);
	RTGC;
	RTHOOK(1);
	loc2 = F530_3052(RTCW(arg2));
	RTHOOK(2);
	loc3 = *(EIF_INTEGER_32 *)(RTCW(arg2)+ _LNGOFF_1_1_0_1_);
	RTHOOK(3);
	loc4 = F825_5501(RTCW(arg1));
	RTHOOK(4);
	loc6 = inline_F58_778((EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)));
	RTHOOK(5);
	loc1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	for (;;) {
		RTHOOK(6);
		if ((EIF_BOOLEAN) (loc1 > loc2)) break;
		RTHOOK(7);
		loc5 = F530_3045(RTCW(arg2), (EIF_INTEGER_32) ((EIF_INTEGER_32) (loc3 + loc1) - ((EIF_INTEGER_32) 1L)));
		loc5 = F825_5501(RTCW(loc5));
		RTHOOK(8);
		loc7 = inline_F58_776(loc5);
		RTHOOK(9);
		inline_F58_779(loc6, (EIF_INTEGER_32) (loc1 - ((EIF_INTEGER_32) 1L)), loc7);
		RTHOOK(10);
		loc1++;
	}
	RTHOOK(11);
	inline_F58_779(loc6, loc2, loc8);
	RTHOOK(12);
	inline_F58_781(loc4, loc6, arg3, arg4);
	RTHOOK(13);
	RTLE;
	RTEE;
}

/* {EW_UNIX_OS}.wait_for_process_block */
EIF_INTEGER_32 F391_2765 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	EIF_BOOLEAN loc1 = (EIF_BOOLEAN) 0;
	
	
	RTEAA("wait_for_process_block", 390, Current, 1, 1, 3318);
	RTHOOK(1);
	RTHOOK(2);
	RTEE;
	return (EIF_INTEGER_32) inline_F58_783(arg1, (EIF_BOOLEAN) 1, (EIF_BOOLEAN *) &(loc1));
}

/* {EW_UNIX_OS}.send_signal */
void F391_2767 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	GTCX
	RTEX;
	
	
	RTEAA("send_signal", 390, Current, 0, 2, 3320);
	RTHOOK(1);
	inline_F58_782(arg2, arg1);
	RTHOOK(2);
	RTEE;
}

/* {EW_UNIX_OS}.terminate_hard */
void F391_2768 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("terminate_hard", 390, Current, 0, 1, 3321);
	RTGC;
	RTHOOK(1);
	ti4_1 = RTOSCF(796,F59_796,(Current));
	F391_2767(Current, ti4_1, arg1);
	RTHOOK(2);
	RTLE;
	RTEE;
}

void EIF_Minit152 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
