note

	description: 
		"Parent of any graphic application based on the Motif toolkit. %
		%This is an convenience class to automatically setup the %
		%environment for a motif application."
	legal: "See notice at end of class.";
	status: "See notice at end of class.";
	date: "$Date: 2008-12-29 12:27:11 -0800 (Mon, 29 Dec 2008) $";
	revision: "$Revision: 76420 $"

deferred class
	MEL_APPLICATION

feature {NONE} -- Initialization

	make
			-- Create the application.
		do
			set_default;
			create application_context.make;
			create display.make (application_context, Void, 
				Void, application_name);
			if display.is_valid then
				create top_level.make (application_name, Void, display.default_screen);
				build;
				top_level.realize;
				application_context.main_loop
			end
		end;

feature -- Access

	top_level: MEL_APPLICATION_SHELL;
			-- Top level of the application

	display: MEL_DISPLAY;
			-- Application display

	application_name: STRING
			-- Application name
		deferred
		end;

	application_context: MEL_APPLICATION_CONTEXT
			-- Application context

feature -- Basic operations

	exit
			-- Exit from the application
		do
			application_context.exit
		end;

	main_loop
			-- Loop the application.
		do
			application_context.main_loop
		end;

feature {NONE} -- Implementation

	set_default
			-- Define default parameters for the application.
		do
		end;

	build
			-- Build an application.
		do
		end;

note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"




end -- class MEL_APPLICATION


