note
	description: "Keygen platform specific operations, used to persist data"
	legal: "See notice at end of class."
	status: "See notice at end of class."
	date: "$Date: 2012-12-15 00:17:10 -0800 (Sat, 15 Dec 2012) $"
	revision: "$Revision: 96461 $"

deferred class
	KG_ENVIRONMENT_VARIABLES

inherit
	KG_CONSTANTS

	KG_PLATFORM

feature -- Access

	global_stored_value (name: STRING): STRING
			-- Value associated with storage name `name'.
		require
			non_void_name: name /= Void
			valid_name: not name.is_empty
		deferred
		end

	user_stored_value (name: STRING): STRING
			-- User specific value associated with storage name `name'.
		require
			non_void_name: name /= Void
			valid_name: not name.is_empty
		deferred
		end

	browser_command: STRING_32
			-- Retrieve internet browser command line
		deferred
		ensure
			non_void_command: Result /= Void
		end

	global_username (product, version: STRING): STRING
			-- Username for product `product' version `version'.
		require
			non_void_product: product /= Void
			non_void_version: version /= Void
			valid_product: not product.is_empty
			valid_version: not version.is_empty
		do
			Result := global_stored_value (username_storage (product, version))
		end

	user_username (product, version: STRING): STRING
			-- Username for product `product' version `version'.
		require
			non_void_product: product /= Void
			non_void_version: version /= Void
			valid_product: not product.is_empty
			valid_version: not version.is_empty
		do
			Result := user_stored_value (username_storage (product, version))
		end

	global_cd_key (product, version: STRING): STRING
			-- CD key for product `product' version `version'.
		require
			non_void_product: product /= Void
			non_void_version: version /= Void
			valid_product: not product.is_empty
			valid_version: not version.is_empty
		do
			Result := global_stored_value (cd_key_storage (product, version))
		end

	user_cd_key (product, version: STRING): STRING
			-- CD key for product `product' version `version'.
		require
			non_void_product: product /= Void
			non_void_version: version /= Void
			valid_product: not product.is_empty
			valid_version: not version.is_empty
		do
			Result := user_stored_value (cd_key_storage (product, version))
		end

	username_storage (product, version: STRING): STRING
			-- Key name to store username from username `username' for product `product' version `version'.
		require
			non_void_product: product /= Void
			non_void_version: version /= Void
			valid_product: not product.is_empty
			valid_version: not version.is_empty
		local
			s: STRING
		do
			s := product + "_" + version + "_" + platform
			s.to_lower
			s.replace_substring_all (" ", "_")
			Result := "username_" + s
		ensure
			valid_storage: Result /= Void and then not Result.is_empty
		end

	cd_key_storage (product, version: STRING): STRING
			-- Key name used to store cd key for product `product' version `version'.
		require
			non_void_product: product /= Void
			non_void_version: version /= Void
			valid_product: not product.is_empty
			valid_version: not version.is_empty
		local
			s: STRING
		do
			s := product + "_" + version + "_" + platform
			s.to_lower
			s.replace_substring_all (" ", "_")
			Result := "cd_key_" + s
		ensure
			valid_storage: Result /= Void and then not Result.is_empty
		end

	data_storage (product, version: STRING): STRING
			-- Key name used to store private data for product `product' version `version'.
		require
			non_void_product: product /= Void
			non_void_version: version /= Void
			valid_product: not product.is_empty
			valid_version: not version.is_empty
		local
			s: STRING
		do
			s := product + "_" + version + "_" + platform
			s.to_lower
			s.replace_substring_all (" ", "_")
			Result := "data_" + s
		ensure
			valid_storage: Result /= Void and then not Result.is_empty
		end

feature -- Element Setting

	set_global_stored_value (storage_name, value: STRING)
			-- Set `storage_name' with `value'.
		require
			non_void_storage_name: storage_name /= Void
			non_void_value: value /= Void
			valid_storage_name: not storage_name.is_empty
			valid_value: not value.is_empty
		deferred
		end

	set_user_stored_value (storage_name, value: STRING)
			-- Set user specific `storage_name' with `value'.
		require
			non_void_storage_name: storage_name /= Void
			non_void_value: value /= Void
			valid_storage_name: not storage_name.is_empty
			valid_value: not value.is_empty
		deferred
		end

	set_global_username (l_username, product, version: STRING)
			-- Set username for product `product' version `version' with `l_username'.
		require
			non_void_product: product /= Void
			non_void_version: version /= Void
			non_void_username: l_username /= Void
			valid_product: not product.is_empty
			valid_version: not version.is_empty
			valid_username: not l_username.is_empty
		do
			set_global_stored_value (username_storage (product, version), l_username)
		ensure
			global_username_set: global_username (product, version).is_equal (l_username)
		end

	set_user_username (l_username, product, version: STRING)
			-- Set user specific username for product `product' version `version' with `l_username'.
		require
			non_void_product: product /= Void
			non_void_version: version /= Void
			non_void_username: l_username /= Void
			valid_product: not product.is_empty
			valid_version: not version.is_empty
			valid_username: not l_username.is_empty
		do
			set_user_stored_value (username_storage (product, version), l_username)
		ensure
			user_username_set: user_username (product, version).is_equal (l_username)
		end

	set_global_cd_key (l_cd_key, product, version: STRING)
			-- Set CD key for product `product' version `version' with `l_cd_key'.
		require
			non_void_product: product /= Void
			non_void_version: version /= Void
			non_void_cd_key: l_cd_key /= Void
			valid_product: not product.is_empty
			valid_version: not version.is_empty
			valid_cd_key: not l_cd_key.is_empty
		do
			set_global_stored_value (cd_key_storage (product, version), l_cd_key)
		ensure
			global_cd_key_set: global_cd_key (product, version).is_equal (l_cd_key)
		end

	set_user_cd_key (l_cd_key, product, version: STRING)
			-- Set user specific CD key for product `product' version `version' with `l_cd_key'.
		require
			non_void_product: product /= Void
			non_void_version: version /= Void
			non_void_cd_key: l_cd_key /= Void
			valid_product: not product.is_empty
			valid_version: not version.is_empty
			valid_cd_key: not l_cd_key.is_empty
		do
			set_user_stored_value (cd_key_storage (product, version), l_cd_key)
		ensure
			user_cd_key_set: user_cd_key (product, version).is_equal (l_cd_key)
		end

note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"




end -- class KG_ENVIRONMENT_VARIABLES
