note
	description: "Used for registering EDK_WINDOW meta-types"
	author: ""
	date: "$Date: 2015-12-17 05:34:17 -0800 (Thu, 17 Dec 2015) $"
	revision: "$Revision: 98279 $"

class
	EDK_WINDOW_ATTRIBUTES

create
	make

feature {NONE} -- Initialization

	make (a_property_setter: like property_setter; a_property_getter: like property_getter; a_subwindow_compositor: like subwindow_compositor)
			-- Create Window Attributes for type `a_type_name'.
		do
			property_setter := a_property_setter
			property_getter := a_property_getter
			subwindow_compositor := a_subwindow_compositor
		end

feature -- Access

	property_setter: detachable PROCEDURE [NATURAL_8]
		-- Agent used for setting properties for instantiated windows of `type_name'.
		-- If detached the a generic setter is used.

	property_getter: detachable FUNCTION [NATURAL_8, ANY]
		-- Agent used for getting properties for instiantiated windows of `type_name'.
		-- If detached the a generic getter is used.

	subwindow_compositor: detachable PROCEDURE [LINEAR [NATIVE_WINDOW]];
		-- Agent used for positioning subwindows if present
		-- If detached then a default fair share compositor will be used.

end
