/*
	description: "Agent creation/deletion."
	date:		"$Date: 2015-06-26 01:01:47 -0700 (Fri, 26 Jun 2015) $"
	revision:	"$Revision: 97570 $"
	copyright:	"Copyright (c) 1985-2007, Eiffel Software."
	license:	"GPL version 2 see http://www.eiffel.com/licensing/gpl.txt)"
	licensing_options:	"Commercial license is available at http://www.eiffel.com/licensing"
	copying: "[
			This file is part of Eiffel Software's Runtime.

			Eiffel Software's Runtime is free software; you can
			redistribute it and/or modify it under the terms of the
			GNU General Public License as published by the Free
			Software Foundation, version 2 of the License
			(available at the URL listed under "license" above).

			Eiffel Software's Runtime is distributed in the hope
			that it will be useful,	but WITHOUT ANY WARRANTY;
			without even the implied warranty of MERCHANTABILITY
			or FITNESS FOR A PARTICULAR PURPOSE.
			See the	GNU General Public License for more details.

			You should have received a copy of the GNU General Public
			License along with Eiffel Software's Runtime; if not,
			write to the Free Software Foundation, Inc.,
			51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA
		]"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"
*/

/*
doc:<file name="rout_obj.c" header="eif_rout_obj.h" version="$Id: rout_obj.c 97570 2015-06-26 08:01:47Z manus $" summary="Routine objects">
*/

#include "eif_portable.h"
#include "rt_macros.h"
#include "rt_struct.h"
#include "eif_interp.h"
#include "eif_project.h"
#include "eif_rout_obj.h"
#include "rt_lmalloc.h"
#include "rt_garcol.h"
#include "rt_gen_types.h"
#include "rt_interp.h"
#include "rt_except.h"
#include "rt_assert.h"
#ifdef WORKBENCH
#include <string.h>
#endif

#ifdef WORKBENCH
/*------------------------------------------------------------------*/
/* Create a ROUTINE object of type `dftype'. Use the arguements for */
/* the call to `set_rout_disp'.									    */
/*------------------------------------------------------------------*/
rt_public EIF_REFERENCE rout_obj_create_wb ( EIF_TYPE_INDEX dftype, EIF_POINTER rout_disp, EIF_POINTER encaps_rout_disp,
										     EIF_POINTER calc_rout_addr, EIF_INTEGER routine_id,
										     EIF_REFERENCE open_map,
										     EIF_BOOLEAN is_basic, EIF_BOOLEAN is_target_closed,
										     EIF_INTEGER written_type_id_inline_agent, EIF_REFERENCE closed_operands, EIF_INTEGER open_count)
{
	EIF_GET_CONTEXT
	EIF_REFERENCE result = NULL;
	EIF_TYPED_VALUE u_rout_disp;
	EIF_TYPED_VALUE u_encaps_rout_disp;
	EIF_TYPED_VALUE u_calc_rout_addr;
	EIF_TYPED_VALUE u_routine_id;
	EIF_TYPED_VALUE u_open_map;
	EIF_TYPED_VALUE u_is_basic;
	EIF_TYPED_VALUE u_is_target_closed;
	EIF_TYPED_VALUE u_written_type_id_inline_agent;
	EIF_TYPED_VALUE u_closed_operands;
	EIF_TYPED_VALUE u_open_count;
	RTLD;

	u_rout_disp.type = SK_POINTER;
	u_rout_disp.it_p = rout_disp;
	u_encaps_rout_disp.type = SK_POINTER;
	u_encaps_rout_disp.it_p = encaps_rout_disp;
	u_calc_rout_addr.type = SK_POINTER;
	u_calc_rout_addr.it_p = calc_rout_addr;
	u_routine_id.type = SK_INT32;
	u_routine_id.it_i4 = routine_id;
	u_open_map.type = SK_REF;
	u_open_map.it_r = open_map;
	u_is_basic.type = SK_BOOL;
	u_is_basic.it_b = is_basic;
	u_is_target_closed.type = SK_BOOL;
	u_is_target_closed.it_b = is_target_closed;
	u_written_type_id_inline_agent.type = SK_INT32;
	u_written_type_id_inline_agent.it_i4 = written_type_id_inline_agent;
	u_closed_operands.type = SK_REF;
	u_closed_operands.it_r = closed_operands;
	u_open_count.type = SK_INT32;
	u_open_count.it_i4 = open_count;
		/* Protect address in case it moves */
 	RTLI(5);
	RTLR (0, result);
	RTLR (1, closed_operands);
	RTLR (2, open_map);
	RTLR (3, u_open_map.it_r);
	RTLR (4, u_closed_operands.it_r);
	RTLIU(5);

		/* Create ROUTINE object */
	result = emalloc(dftype);
	nstcall = 0;
		/* Call 'set_rout_disp' from ROUTINE */
	(*egc_routdisp_wb)(
		result,
		u_rout_disp,
		u_encaps_rout_disp,
		u_calc_rout_addr,
		u_routine_id,
		u_open_map,
		u_is_basic,
		u_is_target_closed,
		u_written_type_id_inline_agent,
		u_closed_operands,
		u_open_count
	);

	RTLE;
	return result;
}
#else
/*------------------------------------------------------------------*/
/* Create a ROUTINE object of type `dftype' in finalized mode.		*/
/* Use the arguements for the call to `set_rout_disp'.				*/
/*------------------------------------------------------------------*/
rt_public EIF_REFERENCE rout_obj_create_fl (EIF_TYPE_INDEX dftype, EIF_POINTER rout_disp, EIF_POINTER encaps_rout_disp, EIF_POINTER calc_rout_addr,
											EIF_REFERENCE closed_operands, EIF_BOOLEAN is_target_closed, EIF_INTEGER open_count)
{
	EIF_GET_CONTEXT
	EIF_REFERENCE result = NULL;
	RTLD;

		/* Protect address in case it moves */
 	RTLI(2);
	RTLR (0, result);
	RTLR (1, closed_operands);
	RTLIU(2);

		/* Create ROUTINE object */
	result = emalloc(dftype);
	nstcall = 0;
		/* Call 'set_rout_disp' from ROUTINE */
	(FUNCTION_CAST (void, ( EIF_REFERENCE,
							EIF_POINTER,
							EIF_POINTER,
							EIF_POINTER,
							EIF_REFERENCE,
							EIF_BOOLEAN,
							EIF_INTEGER)) egc_routdisp_fl)( result, rout_disp, encaps_rout_disp, calc_rout_addr,
														    closed_operands, is_target_closed, open_count);

	RTLE;
	return result;
}
#endif

/*------------------------------------------------------------------*/
/* Allocate argument structure for `count' arguments.               */
/*------------------------------------------------------------------*/

rt_public EIF_POINTER rout_obj_new_args (EIF_INTEGER count)

{
	EIF_POINTER result = (EIF_POINTER) 0;

	if (count > 0) {
		result = (EIF_POINTER) eif_malloc (count * sizeof (EIF_VALUE));
		if (result == (EIF_POINTER) 0)
			enomem();
	}

	return result;
}
/*------------------------------------------------------------------*/
/* Free argument structure.                                         */
/*------------------------------------------------------------------*/

rt_public void rout_obj_free_args (EIF_POINTER args)
{
	if (args != (EIF_POINTER) 0)
		eif_free (args);
}
/*------------------------------------------------------------------*/

#ifdef WORKBENCH

#include "eif_setup.h"
void fill_it (EIF_TYPED_VALUE* it, EIF_TYPED_VALUE* te);

rt_public void rout_obj_call_procedure_dynamic (
	int routine_id, int is_basic_type, int written_type_id_inline_agent,
	EIF_TYPED_VALUE* closed_args, int closed_count,
	EIF_TYPED_VALUE* open_args, int open_count,
	EIF_REFERENCE open_map)
{
	EIF_GET_CONTEXT
	int i = 2;
	int args_count = open_count + closed_count;
	int next_open = 0xFFFF;
	int open_idx = 1;
	int closed_idx = 1;
	rt_uint_ptr nb_pushed = 0;
	EIF_TYPED_VALUE* first_arg = NULL;
	EIF_INTEGER* open_positions = NULL;

	REQUIRE("valid_closed_args", (closed_count == 0) || closed_args);
	REQUIRE("valid_open_args", (open_count == 0) || open_args);

	if (open_count > 0) {
		open_positions = (EIF_INTEGER*)(*(EIF_REFERENCE*)open_map);
		if (open_positions [0] == 1) {
			first_arg = &(open_args [1]);
			open_idx = 2;
			if (open_count > 1) {
				next_open = open_positions [1];
			}
		} else  {
			next_open = open_positions [0];
		}
	}
	if (first_arg == NULL) {
		first_arg = &(closed_args [1]);
		closed_idx = 2;
	}
	while (i <= args_count) {
		if (i == next_open) {
			fill_it (eif_opstack_push_empty(&op_stack), &(open_args [open_idx]));
			nb_pushed++;
			if (open_idx < open_count) {
				next_open = open_positions [open_idx];
				open_idx++;
			} else {
				next_open = 0xFFFF;
			}
		} else {
			fill_it (eif_opstack_push_empty(&op_stack), &(closed_args [closed_idx]));
			nb_pushed++;
			closed_idx++;
		}
		i = i + 1;
	}
	fill_it (eif_opstack_push_empty(&op_stack), first_arg);
	nb_pushed++;

		/* We are calling a feature through an agent, in this case, we consider all calls
		 * as qualified so that the invariant is checked. */
	nstcall = 1;
	dynamic_eval (routine_id, written_type_id_inline_agent, is_basic_type, nb_pushed);
}

void fill_it (EIF_TYPED_VALUE* it, EIF_TYPED_VALUE* te)
{
	REQUIRE("it not null", it);
	REQUIRE("te not null", te);

	*it = *te;
}

rt_public void rout_obj_call_function_dynamic (
	int routine_id, int is_basic_type, int written_type_id_inline_agent,
	EIF_TYPED_VALUE* closed_args, int closed_count,
	EIF_TYPED_VALUE* open_args, int open_count,
	EIF_REFERENCE open_map, void* res)
{
	EIF_GET_CONTEXT
	EIF_TYPED_VALUE* it = NULL;

	rout_obj_call_procedure_dynamic (routine_id, is_basic_type, written_type_id_inline_agent,
									 closed_args, closed_count, open_args, open_count, open_map);

	it = eif_opstack_pop_address(&op_stack);

	switch (it->type)
	{
		case SK_BOOL: *((EIF_BOOLEAN *) res) = it->it_bool; break;
		case SK_CHAR8: *((EIF_CHARACTER_8 *) res) = it->it_char; break;
		case SK_REAL64: *((EIF_REAL_64 *)res) = it->it_real64; break;
		case SK_UINT8: *((EIF_NATURAL_8* )res) = it->it_uint8; break;
		case SK_UINT16: *((EIF_NATURAL_16 *)res) = it->it_uint16; break;
		case SK_UINT32: *((EIF_NATURAL_32 *)res) = it->it_uint32; break;
		case SK_UINT64: *((EIF_NATURAL_64 *)res)= it->it_uint64; break;
		case SK_INT8: *((EIF_INTEGER_8 *)res) = it->it_int8; break;
		case SK_INT16: *((EIF_INTEGER_16 *)res) = it->it_int16; break;
		case SK_INT32: *((EIF_INTEGER_32 *)res) = it->it_int32; break;
		case SK_INT64: *((EIF_INTEGER_64 *)res) = it->it_int64; break;
		case SK_POINTER: *((EIF_POINTER *)res) = it->it_ptr; break;
		case SK_REAL32: *((EIF_REAL_32 *)res) = it->it_real32; break;
		case SK_CHAR32: *((EIF_CHARACTER_32* )res) = it->it_wchar; break;
		default:
			*((EIF_REFERENCE *)res) = it->it_ref;
	}
}
#endif

/*------------------------------------------------------------------*/

rt_public char eif_sk_type_to_type_code (uint32 sk_type)
{
	switch (sk_type) {
		case SK_BOOL:    return EIF_BOOLEAN_CODE;
		case SK_CHAR8:    return EIF_CHARACTER_8_CODE;
		case SK_CHAR32:   return EIF_CHARACTER_32_CODE;
		case SK_INT8:    return EIF_INTEGER_8_CODE;
		case SK_INT16:   return EIF_INTEGER_16_CODE;
		case SK_INT32:   return EIF_INTEGER_32_CODE;
		case SK_INT64:   return EIF_INTEGER_64_CODE;
		case SK_UINT8:   return EIF_NATURAL_8_CODE;
		case SK_UINT16:  return EIF_NATURAL_16_CODE;
		case SK_UINT32:  return EIF_NATURAL_32_CODE;
		case SK_UINT64:  return EIF_NATURAL_64_CODE;
		case SK_POINTER: return EIF_POINTER_CODE;
		case SK_REAL32:  return EIF_REAL_32_CODE;
		case SK_REAL64:  return EIF_REAL_64_CODE;
		case SK_REF:     return EIF_REFERENCE_CODE;
	}
	return EIF_REFERENCE_CODE;
}


/*
doc:</file>
*/
