/*
 * Code for class PROCESS_UNIX_OS
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "pr229.h"
#include <string.h>
#include <fcntl.h>
#include <sys/types.h>
#include "eif_process.h"
#include <unistd.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F260_4285
static void inline_F260_4285 (EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	{
  int rc;
  rc = dup2(arg1, arg2);
  if (rc < 0) {
	    eraise(Strerror(errno), EN_SYS);
  }
}
	;
}
#define INLINE_F260_4285
#endif
#ifndef INLINE_F260_4286
static void inline_F260_4286 (EIF_INTEGER_32 arg1)
{
	{
	 int rc;
	  rc = close(arg1);
	  if (rc != 0) {
	    eraise(Strerror(errno), EN_SYS);
	  }
}
	;
}
#define INLINE_F260_4286
#endif
#ifndef INLINE_F260_4289
static void inline_F260_4289 (void)
{
	{
	setpgid (0, 0);
}
	;
}
#define INLINE_F260_4289
#endif
#ifndef INLINE_F260_4303
static void inline_F260_4303 (EIF_POINTER arg1, EIF_INTEGER_32 arg2, EIF_POINTER arg3)
{
	{
				  char ** arguments;
 				  arguments = (char **) arg1;
				  arguments[arg2] = (char *) arg3;
				}
	;
}
#define INLINE_F260_4303
#endif
#ifndef INLINE_F260_4301
static void inline_F260_4301 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4)
{
	{
				  int max_descriptors;
				  int k, rc;
  				  if (arg4 == EIF_TRUE) {
				    max_descriptors = getdtablesize();
					for (k = 3; k < max_descriptors; k++) {
					    rc = fcntl(k, F_SETFD, 1);
					    if (rc == -1 && errno != EBADF) {
						      eraise(Strerror(errno), EN_SYS);
					    }
			  	    }
				  }
				  if (arg3 == NULL) {
				    (void) execv((char *) arg1, (char **) arg2);
				  } else {
				    (void) execve((char *) arg1, (char **) arg2, (char **) arg3);
				  }
				  _exit(127);
				}
	;
}
#define INLINE_F260_4301
#endif
#ifndef INLINE_F260_4300
static void inline_F260_4300 (EIF_INTEGER_32* arg1)
{
	{
  pid_t pid;
  pid = fork();
  *arg1 = (EIF_INTEGER)pid;
}
	;
}
#define INLINE_F260_4300
#endif
#ifndef INLINE_F260_4296
static void inline_F260_4296 (EIF_POINTER arg1, EIF_POINTER* arg2)
{
	{
	  char *result;
	  result = (char *) malloc((unsigned) (strlen((char *) arg1) + 1));
	  if (result == NULL) {
    	enomem();
	  }
	  strcpy(result, arg1);
	  *arg2 = result;
	}
	;
}
#define INLINE_F260_4296
#endif
#ifndef INLINE_F260_4302
static void inline_F260_4302 (EIF_INTEGER_32 arg1, EIF_POINTER* arg2)
{
	{
	EIF_POINTER result;
	result = (EIF_POINTER) malloc((size_t) (arg1 * sizeof(char *)));
	if (result == NULL) {
		enomem();
	}
	*arg2 = result;
}
	;
}
#define INLINE_F260_4302
#endif
#ifndef INLINE_F260_4297
static void inline_F260_4297 (EIF_POINTER arg1, EIF_POINTER arg2)
{
	{
  int rc;
  int fd[2];
  EIF_INTEGER * read_ptr;
  EIF_INTEGER * write_ptr;
  rc = pipe(fd);
  if (rc != 0) {
    eraise(Strerror(errno), EN_SYS);
  }
  read_ptr = (EIF_INTEGER *) arg1;
  write_ptr = (EIF_INTEGER *) arg2;
  *read_ptr = fd[0];
  *write_ptr = fd[1];
}
	;
}
#define INLINE_F260_4297
#endif
#ifndef INLINE_F260_4299
static void inline_F260_4299 (EIF_INTEGER_32 arg1, EIF_BOOLEAN arg2, EIF_BOOLEAN* arg3, EIF_INTEGER_32* arg4, EIF_BOOLEAN* arg5)
{
	{
  pid_t rc;
  int status;
  
  rc = waitpid((pid_t) arg1, &status, (arg2 ? 0 : WNOHANG) | WUNTRACED);
  *(EIF_BOOLEAN *) arg5 = (rc != -1);
  if (rc != -1) {				    
	  if (rc == 0) { /* No process has status to report yet */
	    *(EIF_BOOLEAN *) arg3 = EIF_FALSE;
	  } else { /* Process reported status */
	    *(EIF_BOOLEAN *) arg3 = EIF_TRUE;
	  }
	  *(EIF_INTEGER *) arg4 = (EIF_INTEGER) status;
  }
}
	;
}
#define INLINE_F260_4299
#endif
#ifndef INLINE_F260_4304
static void inline_F260_4304 (EIF_INTEGER_32 arg1)
{
	{
	pid_t pgid = getpgid (arg1);
	tcsetpgrp (1, pgid);
	tcsetpgrp (2, pgid);
}
	;
}
#define INLINE_F260_4304
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {PROCESS_UNIX_OS}.duplicate_file_descriptor */
void F260_4285 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("duplicate_file_descriptor", 259, Current, 0, 2, 4369);
	inline_F260_4285 ((EIF_INTEGER_32) arg1, (EIF_INTEGER_32) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.close_file_descriptor */
void F260_4286 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("close_file_descriptor", 259, Current, 0, 1, 4370);
	inline_F260_4286 ((EIF_INTEGER_32) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.fork_process */
EIF_INTEGER_32 F260_4288 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	
	
	RTEAA("fork_process", 259, Current, 0, 0, 4372);
	RTHOOK(1);
	RTHOOK(2);
	RTEE;
	return (EIF_INTEGER_32) F260_4293(Current);
}

/* {PROCESS_UNIX_OS}.new_process_group */
void F260_4289 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("new_process_group", 259, Current, 0, 0, 4373);
	inline_F260_4289 ();
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.exec_process */
void F260_4290 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_BOOLEAN arg3, EIF_POINTER arg4)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_POINTER loc4 = (EIF_POINTER) 0;
	EIF_POINTER loc5 = (EIF_POINTER) 0;
	EIF_POINTER loc6 = (EIF_POINTER) 0;
	EIF_REFERENCE loc7 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(5);
	RTLR(0,arg2);
	RTLR(1,Current);
	RTLR(2,loc7);
	RTLR(3,tr1);
	RTLR(4,arg1);
	RTLIU(5);
	
	RTEAA("exec_process", 259, Current, 7, 4, 4374);
	RTGC;
	RTHOOK(1);
	loc2 = F1054_8647(RTCW(arg2));
	RTHOOK(2);
	loc3 = *(EIF_INTEGER_32 *)(RTCW(arg2)+ _LNGOFF_1_1_0_1_);
	RTHOOK(3);
	loc4 = F260_4295(Current, (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)));
	RTHOOK(4);
	tr1 = RTLNS(eif_new_type(764, 0x00).id, 764, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F765_7500(RTCW(tr1), ((EIF_INTEGER_32) 0L));
	loc7 = (EIF_REFERENCE) tr1;
	RTHOOK(5);
	loc1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	for (;;) {
		RTHOOK(6);
		if ((EIF_BOOLEAN) (loc1 > loc2)) break;
		RTHOOK(7);
		tr1 = F1054_8640(RTCW(arg2), (EIF_INTEGER_32) ((EIF_INTEGER_32) (loc3 + loc1) - ((EIF_INTEGER_32) 1L)));
		F765_7514(RTCW(loc7), tr1);
		RTHOOK(8);
		tp1 = F765_7506(RTCW(loc7));
		loc5 = F260_4294(Current, tp1);
		RTHOOK(9);
		inline_F260_4303(loc4, (EIF_INTEGER_32) (loc1 - ((EIF_INTEGER_32) 1L)), loc5);
		RTHOOK(10);
		loc1++;
	}
	RTHOOK(11);
	inline_F260_4303(loc4, loc2, loc6);
	RTHOOK(12);
	tr1 = RTLNS(eif_new_type(764, 0x00).id, 764, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F765_7499(RTCW(tr1), arg1);
	loc7 = (EIF_REFERENCE) tr1;
	RTHOOK(13);
	tp1 = F765_7506(RTCW(loc7));
	inline_F260_4301(tp1, loc4, arg4, arg3);
	RTHOOK(14);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.unix_fork_process */
EIF_INTEGER_32 F260_4293 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	
	
	RTEAA("unix_fork_process", 259, Current, 0, 0, 4377);
	RTHOOK(1);
	inline_F260_4300((EIF_INTEGER_32 *) &(Result));
	RTHOOK(2);
	RTEE;
	return Result;
}

/* {PROCESS_UNIX_OS}.str_dup */
EIF_POINTER F260_4294 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	
	
	RTEAA("str_dup", 259, Current, 0, 1, 4378);
	RTHOOK(1);
	inline_F260_4296(arg1, (EIF_POINTER *) &(Result));
	RTHOOK(2);
	RTEE;
	return Result;
}

/* {PROCESS_UNIX_OS}.unix_allocate_arg_memory */
EIF_POINTER F260_4295 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	
	
	RTEAA("unix_allocate_arg_memory", 259, Current, 0, 1, 4379);
	RTHOOK(1);
	inline_F260_4302(arg1, (EIF_POINTER *) &(Result));
	RTHOOK(2);
	RTEE;
	return Result;
}

/* {PROCESS_UNIX_OS}.c_str_dup */
void F260_4296 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER* arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("c_str_dup", 259, Current, 0, 2, 4380);
	inline_F260_4296 ((EIF_POINTER) arg1, (EIF_POINTER*) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.unix_pipe */
void F260_4297 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_pipe", 259, Current, 0, 2, 4381);
	inline_F260_4297 ((EIF_POINTER) arg1, (EIF_POINTER) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.unix_waitpid */
void F260_4299 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_BOOLEAN arg2, EIF_BOOLEAN* arg3, EIF_INTEGER_32* arg4, EIF_BOOLEAN* arg5)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_waitpid", 259, Current, 0, 5, 4383);
	EIF_ENTER_C;
	inline_F260_4299 ((EIF_INTEGER_32) arg1, (EIF_BOOLEAN) arg2, (EIF_BOOLEAN*) arg3, (EIF_INTEGER_32*) arg4, (EIF_BOOLEAN*) arg5);
	EIF_EXIT_C;
	RTGC;
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.c_unix_fork_process */
void F260_4300 (EIF_REFERENCE Current, EIF_INTEGER_32* arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("c_unix_fork_process", 259, Current, 0, 1, 4384);
	inline_F260_4300 ((EIF_INTEGER_32*) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.unix_exec_process */
void F260_4301 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_exec_process", 259, Current, 0, 4, 4385);
	inline_F260_4301 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_BOOLEAN) arg4);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.c_unix_allocate_arg_memory */
void F260_4302 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_POINTER* arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("c_unix_allocate_arg_memory", 259, Current, 0, 2, 4386);
	inline_F260_4302 ((EIF_INTEGER_32) arg1, (EIF_POINTER*) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.unix_set_arg_value */
void F260_4303 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_INTEGER_32 arg2, EIF_POINTER arg3)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_set_arg_value", 259, Current, 0, 3, 4387);
	inline_F260_4303 ((EIF_POINTER) arg1, (EIF_INTEGER_32) arg2, (EIF_POINTER) arg3);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.attach_terminals */
void F260_4304 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("attach_terminals", 259, Current, 0, 1, 4388);
	inline_F260_4304 ((EIF_INTEGER_32) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
}

void EIF_Minit229 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
