note
	description: "Error: Problem during the parsing of an ecf file."
	author: "Patrick Ruckstuhl <patrick@tario.org>"
	date: "$Date: 2016-05-10 06:21:18 -0700 (Tue, 10 May 2016) $"
	revision: "$Revision: 98715 $"

class
	ET_ECF_PARSE_ERROR

inherit
	UT_ERROR

create
	make

feature {NONE} -- Initialization

	make (a_error: STRING)
			-- Create a new error reporting that error.
		require
			a_error_ok: a_error /= Void and then not a_error.is_empty
		do
			create parameters.make (1, 1)
			parameters.put (a_error, 1)
		end

feature -- Access

	default_template: STRING = "$0: ECF parsing error: '$1'."
			-- Default template used to built the error message

	code: STRING = "ECF0001"
			-- Error code

invariant

	-- dollar0: $0 = program name
	-- dollar1: $1 = error

end
