note

	description:

		"Objects that convert strings to Unicode normalization form NFC."

	library: "Gobo Eiffel XSLT Library"
	copyright: "Copyright (c) 2007, Colin Adams and others"
	license: "MIT License"
	date: "$Date: 2016-05-06 12:15:38 -0700 (Fri, 06 May 2016) $"
	revision: "$Revision: 98678 $"

class XM_XSLT_NFC_NORMALIZER

inherit

	XM_XSLT_UNICODE_NORMALIZER


create

	make

feature {NONE} -- Initialization

	make
			-- Initialize `Current'.
		do
			-- nothing to do
		end

feature -- Access

	normalization_form: STRING = "NFC"
			-- Name of normalization form provided by `Current'

	normalized_string (a_string: STRING): UC_UTF8_STRING
			-- Normalized version of `a_string' according to `normalization_form'
		do
			Result := normalization.to_nfc (a_string)
		end

end
