note

	description:

		"Eiffel argument passings at run-time"

	library: "Gobo Eiffel Tools Library"
	copyright: "Copyright (c) 2004-2012, Eric Bezault and others"
	license: "MIT License"
	date: "$Date: 2016-05-06 12:15:38 -0700 (Fri, 06 May 2016) $"
	revision: "$Revision: 98678 $"

class ET_DYNAMIC_ARGUMENT_ATTACHMENT

inherit

	ET_DYNAMIC_ATTACHMENT
		rename
			attachment as actual_argument
		end

create

	make

feature {NONE} -- Initialization

	make (a_type_set: like source_type_set; an_argument: like actual_argument;
		a_current_feature: like current_feature; a_current_type: like current_type)
			-- Create a new argument passing.
		require
			a_type_set_not_void: a_type_set /= Void
			an_argument_not_void: an_argument /= Void
			a_current_feature_not_void: a_current_feature /= Void
			a_current_type_not_void: a_current_type /= Void
		do
			source_type_set := a_type_set
			actual_argument := an_argument
			current_feature := a_current_feature
			current_type := a_current_type
		ensure
			source_type_set_set: source_type_set = a_type_set
			actual_argument_set: actual_argument = an_argument
			current_feature_set: current_feature = a_current_feature
			current_type_set: current_type = a_current_type
		end

feature -- Access

	actual_argument: ET_ARGUMENT_OPERAND
			-- Actual argument

	position: ET_POSITION
			-- Position of attachment
		do
			Result := actual_argument.position
		end

	description: STRING
			-- Kind of attachment
		do
			if attached {ET_AGENT_IMPLICIT_OPEN_ARGUMENT} actual_argument as l_implicit then
				Result := implicit_open_argument_description + l_implicit.argument_index.out
			elseif actual_argument.is_open_operand then
				Result := open_argument_description
			else
				Result := argument_description
			end
		end

feature {NONE} -- Constants

	argument_description: STRING = "argument"
	open_argument_description: STRING = "open argument"
	implicit_open_argument_description: STRING = "implicit open argument #"
			-- Description constants

invariant

	actual_argument_not_void: actual_argument /= Void

end
