note

	description:

		"Eiffel 'free-operator' feature names"

	library: "Gobo Eiffel Tools Library"
	copyright: "Copyright (c) 2005-2012, Eric Bezault and others"
	license: "MIT License"
	date: "$Date: 2016-05-06 12:15:38 -0700 (Fri, 06 May 2016) $"
	revision: "$Revision: 98678 $"

deferred class ET_FREE_NAME

inherit

	ET_CALL_NAME

	KL_IMPORTED_STRING_ROUTINES
		export {NONE} all end

feature -- Access

	lower_name: STRING
			-- Lower-name of feature call
			-- (May return the same object as `name' if already in lower case.)
		local
			i, nb: INTEGER
			c: CHARACTER
		do
			Result := name
			nb := Result.count
			from i := 1 until i > nb loop
				c := Result.item (i)
				if c >= 'A' and c <= 'Z' then
					Result := Result.as_lower
					i := nb + 1 -- Jump out of the loop.
				else
					i := i + 1
				end
			end
		end

	free_operator_name: STRING
			-- Name of free operator
		deferred
		ensure
			free_operator_name_not_void: Result /= Void
			free_operator_name_not_empty: Result.count > 0
		end

	hash_code: INTEGER
			-- Hash code value

feature -- Comparison

	same_call_name (other: ET_CALL_NAME): BOOLEAN
			-- Are feature name and `other' the same feature call name?
			-- (case insensitive)
		do
			if other = Current then
				Result := True
			elseif attached {ET_FREE_NAME} other as op then
				if hash_code = op.hash_code then
					if is_infix_freeop /= op.is_infix_freeop then
						Result := False
					elseif op.free_operator_name = free_operator_name then
						Result := True
					else
						Result := STRING_.same_case_insensitive (free_operator_name, op.free_operator_name)
					end
				end
			end
		end

invariant

	is_freeop: is_infix_freeop xor is_prefix_freeop

end
