note

	description:

		"Eiffel result entities"

	library: "Gobo Eiffel Tools Library"
	copyright: "Copyright (c) 1999-2014, Eric Bezault and others"
	license: "MIT License"
	date: "$Date: 2016-05-06 12:15:38 -0700 (Fri, 06 May 2016) $"
	revision: "$Revision: 98678 $"

class ET_RESULT

inherit

	ET_WRITABLE
		undefine
			first_position,
			last_position,
			break
		redefine
			is_result
		end

	ET_KEYWORD
		rename
			make_result as make
		undefine
			is_current,
			is_false,
			is_result
		redefine
			process
		end

create

	make

feature -- Status report

	is_result: BOOLEAN = True
			-- Is current expression the 'Result' entity?

feature -- Processing

	process (a_processor: ET_AST_PROCESSOR)
			-- Process current node.
		do
			a_processor.process_result (Current)
		end

invariant

	is_result: is_result

end
