note

	description:

		"Eiffel call components (either feature calls or agents)"

	library: "Gobo Eiffel Tools Library"
	copyright: "Copyright (c) 2004-2014, Eric Bezault and others"
	license: "MIT License"
	date: "$Date: 2016-05-06 12:15:38 -0700 (Fri, 06 May 2016) $"
	revision: "$Revision: 98678 $"

deferred class ET_CALL_COMPONENT

inherit

	ET_AST_NODE

feature -- Access

	target: detachable ET_TARGET_OPERAND
			-- Target
		deferred
		end

	name: ET_CALL_NAME
			-- Feature name
		deferred
		ensure
			name_not_void: Result /= Void
		end

	arguments: detachable ET_ARGUMENT_OPERANDS
			-- Arguments
		deferred
		end

feature -- Status report

	is_qualified_call: BOOLEAN
			-- Is current call qualified?
		do
			Result := (target /= Void)
		ensure
			definition: Result implies (target /= Void)
		end

	is_tuple_label: BOOLEAN
			-- Is current call a call to a Tuple label?
		do
			Result := name.is_tuple_label
		ensure
			definition: Result = name.is_tuple_label
		end

	is_call_agent: BOOLEAN
			-- Is current call a call agent?
		do
			Result := False
		end

end
