note

	description:

		"Comparators for ordering options"

	library: "Gobo Eiffel Argument Library"
	copyright: "Copyright (c) 2006-2013, Bernd Schoeller and others"
	license: "MIT License"
	date: "$Date: 2016-05-06 12:15:38 -0700 (Fri, 06 May 2016) $"
	revision: "$Revision: 98678 $"

class AP_OPTION_COMPARATOR

inherit

	KL_COMPARATOR [AP_OPTION]

	KL_IMPORTED_STRING_ROUTINES

feature -- Status report

	less_than (u, v: AP_OPTION): BOOLEAN
			-- Is `u' considered less than `v'?
		local
			u_string, v_string: STRING
		do
			if attached u.long_form as l_u_long_form then
				u_string := l_u_long_form
			else
				u_string := u.short_form.out
			end
			if attached v.long_form as l_v_long_form then
				v_string := l_v_long_form
			else
				v_string := v.short_form.out
			end
			Result := STRING_.three_way_comparison (u_string, v_string) = -1
		end

end
