/*
 * Code for class EW_UNIX_EXTERNALS
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "ew64.h"
#include <time.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/wait.h>
#include <signal.h>
#include <errno.h>
#include <fcntl.h>
#include <string.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F79_1498
static void inline_F79_1498 (EIF_INTEGER_32 arg1)
{
	int rc;
rc = close(arg1);
if (rc != 0) {
	xraise(EN_SYS);
}
	;
}
#define INLINE_F79_1498
#endif
#ifndef INLINE_F79_1499
static void inline_F79_1499 (EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	int rc;

  				rc = dup2(arg1, arg2);
				if (rc < 0) {
					xraise(EN_SYS);
  				}
	;
}
#define INLINE_F79_1499
#endif
#ifndef INLINE_F79_1502
static EIF_INTEGER_32 inline_F79_1502 (void)
{
	time_t current_time;

  				current_time = time(&current_time);
  				if (current_time == (time_t) -1) {
    					eraise("time() call failed", EN_PROG);
  				}
  				return (EIF_INTEGER) current_time;
	;
}
#define INLINE_F79_1502
#endif
#ifndef INLINE_F79_1504
static EIF_POINTER inline_F79_1504 (EIF_POINTER arg1)
{
	void * result;

  				result = (char *) malloc((size_t) (strlen((char *) arg1) + 1));
  				if (result == NULL) {
    					enomem();
  				}
  				strcpy(result, arg1);
  				return (EIF_POINTER) result;
	;
}
#define INLINE_F79_1504
#endif
#ifndef INLINE_F79_1505
static void inline_F79_1505 (EIF_POINTER arg1, EIF_POINTER arg2)
{
	int rc;
  				int fd[2];
  				EIF_INTEGER * read_ptr;
  				EIF_INTEGER * write_ptr;

  				rc = pipe(fd);
  				if (rc != 0) {
    					xraise(EN_SYS);
  				}
  				read_ptr = (EIF_INTEGER *) arg1;
  				write_ptr = (EIF_INTEGER *) arg2;
  				*read_ptr = fd[0];
  				*write_ptr = fd[1];
	;
}
#define INLINE_F79_1505
#endif
#ifndef INLINE_F79_1506
static EIF_POINTER inline_F79_1506 (EIF_INTEGER_32 arg1)
{
	char ** result;

  				result = (char **) malloc((size_t) (arg1 * sizeof(char *)));
  				if (result == NULL) {
    					enomem();
  				}
  				return (EIF_POINTER) result;
	;
}
#define INLINE_F79_1506
#endif
#ifndef INLINE_F79_1507
static void inline_F79_1507 (EIF_POINTER arg1, EIF_INTEGER_32 arg2, EIF_POINTER arg3)
{
	char ** arguments;

				arguments = (char **) arg1;
				arguments[arg2] = (char *) arg3;
	;
}
#define INLINE_F79_1507
#endif
#ifndef INLINE_F79_1508
static EIF_INTEGER_32 inline_F79_1508 (void)
{
	pid_t pid;

  				pid = eif_thread_fork();
  				if (pid == (pid_t) -1) {
    					xraise(EN_SYS);
  				}
  				return (EIF_INTEGER) pid;
	;
}
#define INLINE_F79_1508
#endif
#ifndef INLINE_F79_1509
static void inline_F79_1509 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4)
{
	int getdtablesize(void);
  				int max_descriptors;
  				int k, rc;
  
  				if (arg4 == EIF_TRUE) {
    					max_descriptors = getdtablesize();
  					for (k = 3; k < max_descriptors; k++) {
    						rc = fcntl(k, F_SETFD, 1);
    						if (rc == -1 && errno != EBADF) {
      							xraise(EN_SYS);
    						}
  					}
  				}
  				if (arg3 == NULL) {
    					(void) execv((char *) arg1, (char **) arg2);
  				} else {
    					(void) execve((char *) arg1, (char **) arg2, (char **) arg3);
  				}
  				xraise(EN_SYS);
	;
}
#define INLINE_F79_1509
#endif
#ifndef INLINE_F79_1510
static void inline_F79_1510 (EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	int rc;

  				rc = kill((pid_t) arg1, (int) arg2);
  				if (rc != 0 && errno != ESRCH) {
    					xraise(EN_SYS);
  				}
	;
}
#define INLINE_F79_1510
#endif
#ifndef INLINE_F79_1511
static EIF_INTEGER_32 inline_F79_1511 (EIF_INTEGER_32 arg1, EIF_BOOLEAN arg2, EIF_POINTER arg3)
{
	pid_t rc;
  				int status, options;
  				EIF_BOOLEAN * ptr;

  				options = ((arg2 == EIF_TRUE) ? 0 : WNOHANG) | WUNTRACED;
  				ptr = (EIF_BOOLEAN *) arg3;
  				rc = waitpid((pid_t) arg1, &status, options);
  				if (rc == (pid_t) -1) {
    					xraise(EN_SYS);
  				} else if (rc == (pid_t) 0) {	/* No process has status to report yet */
    					*ptr = EIF_FALSE;
  				} else {		/* Process reported status */
    					*ptr = EIF_TRUE;
  				}
  				return (EIF_INTEGER) status;
	;
}
#define INLINE_F79_1511
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {EW_UNIX_EXTERNALS}.close_file_descriptor */
void F79_1498 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("close_file_descriptor", 78, Current, 0, 1, 1060);
	inline_F79_1498 ((EIF_INTEGER_32) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {EW_UNIX_EXTERNALS}.duplicate_file_descriptor */
void F79_1499 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("duplicate_file_descriptor", 78, Current, 0, 2, 1061);
	inline_F79_1499 ((EIF_INTEGER_32) arg1, (EIF_INTEGER_32) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {EW_UNIX_EXTERNALS}.valid_file_descriptor */
EIF_BOOLEAN F79_1500 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	
	
	RTEAA("valid_file_descriptor", 78, Current, 0, 1, 1062);
	RTHOOK(1);
	RTHOOK(2);
	RTEE;
	return (EIF_BOOLEAN) (EIF_BOOLEAN) (arg1 >= ((EIF_INTEGER_32) 0L));
}

/* {EW_UNIX_EXTERNALS}.current_time_in_seconds */
EIF_INTEGER_32 F79_1502 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("current_time_in_seconds", 78, Current, 0, 0, 1064);
	Result = inline_F79_1502 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {EW_UNIX_EXTERNALS}.str_dup */
EIF_POINTER F79_1504 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("str_dup", 78, Current, 0, 1, 1066);
	Result = inline_F79_1504 ((EIF_POINTER) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {EW_UNIX_EXTERNALS}.unix_pipe */
void F79_1505 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_pipe", 78, Current, 0, 2, 1067);
	inline_F79_1505 ((EIF_POINTER) arg1, (EIF_POINTER) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {EW_UNIX_EXTERNALS}.unix_allocate_arg_memory */
EIF_POINTER F79_1506 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_allocate_arg_memory", 78, Current, 0, 1, 1068);
	Result = inline_F79_1506 ((EIF_INTEGER_32) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {EW_UNIX_EXTERNALS}.unix_set_arg_value */
void F79_1507 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_INTEGER_32 arg2, EIF_POINTER arg3)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_set_arg_value", 78, Current, 0, 3, 1069);
	inline_F79_1507 ((EIF_POINTER) arg1, (EIF_INTEGER_32) arg2, (EIF_POINTER) arg3);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {EW_UNIX_EXTERNALS}.unix_fork_process */
EIF_INTEGER_32 F79_1508 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_fork_process", 78, Current, 0, 0, 1070);
	Result = inline_F79_1508 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {EW_UNIX_EXTERNALS}.unix_exec_process */
void F79_1509 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_exec_process", 78, Current, 0, 4, 1071);
	inline_F79_1509 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_BOOLEAN) arg4);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {EW_UNIX_EXTERNALS}.unix_kill */
void F79_1510 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_kill", 78, Current, 0, 2, 1072);
	inline_F79_1510 ((EIF_INTEGER_32) arg1, (EIF_INTEGER_32) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {EW_UNIX_EXTERNALS}.unix_waitpid */
EIF_INTEGER_32 F79_1511 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_BOOLEAN arg2, EIF_POINTER arg3)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_waitpid", 78, Current, 0, 3, 1073);
	Result = inline_F79_1511 ((EIF_INTEGER_32) arg1, (EIF_BOOLEAN) arg2, (EIF_POINTER) arg3);
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

void EIF_Minit64 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
