note
	description: "Conversion to and from Windows data type"
	legal: "See notice at end of class."
	status: "See notice at end of class."
	date: "$Date: 2011-10-04 12:48:52 -0700 (Tue, 04 Oct 2011) $"
	revision: "$Revision: 87391 $"

class
	WEL_DATA_TYPE

feature -- Conversion from Eiffel to Windows

	frozen to_lparam (i: INTEGER): POINTER
			-- Convert integer value `i' in a valid `LPARAM' value.
		external
			"C macro use <windows.h>"
		alias
			"(LPARAM)"
		end

	frozen to_wparam (i: INTEGER): POINTER
			-- Convert integer value `i' in a valid `WPARAM' value.
		external
			"C macro use <windows.h>"
		alias
			"(WPARAM)"
		end

	frozen to_lresult (i: INTEGER): POINTER
			-- Convert integer value `i' in a valid LRESULT value.
		external
			"C macro use <windows.h>"
		alias
			"(LRESULT)"
		end

note
	copyright:	"Copyright (c) 1984-2011, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			Eiffel Software
			5949 Hollister Ave., Goleta, CA 93117 USA
			Telephone 805-685-1006, Fax 805-685-6869
			Website http://www.eiffel.com
			Customer support http://support.eiffel.com
		]"




end -- class WEL_DATA_TYPE
