frozen class
	EDK_MESSAGE_IDS


feature -- EDK Messages

	EDK_DEFAULT: NATURAL_16 = 0x8000
		-- Default (NULL) Event type

	EDK_WINDOW_DESTROY: NATURAL_16 = 0x8001
		-- Event data `window: NATIVE_WINDOW'

	EDK_WINDOW_EXPOSE: NATURAL_16 = 0x8002
		-- Event data `window: NATIVE_WINDOW'

	EDK_BUTTON_PRESS: NATURAL_16 = 0x8003
		-- Event data `window: NATIVE_WINDOW', `time: NATURAL_32', `button: NATURAL_8',

	EDK_BUTTON_RELEASE: NATURAL_16 = 0x8004
		-- Event data `window: NATIVE_WINDOW', `time: NATURAL_32', `button: NATURAL_8',

	EDK_MOUSE_MOVE: NATURAL_16 = 0x8005

	EDK_WINDOW_FOCUS_CHANGE: NATURAL_16 = 0x8006

	EDK_WINDOW_MOVE: NATURAL_16 = 0x8007

	EDK_WINDOW_PROPERTY_SET: NATURAL_16 = 0x8008

	EDK_WINDOW_PROPERTY_GET: NATURAL_16 = 0x8009

	EDK_WINDOW_CLOSE: NATURAL_16 = 0x800A

	EDK_WINDOW_RESIZE: NATURAL_16 = 0x800B

	EDK_WINDOW_CREATE: NATURAL_16 = 0x800C
		-- Event data `window: NATIVE_WINDOW', `time: NATURAL_32'

	EDK_WINDOW_MAP: NATURAL_16 = 0x800D

	EDK_WINDOW_UNMAP: NATURAL_16 = 0x800E

	EDK_WINDOW_STATE: NATURAL_16 = 0x800F

	EDK_MOUSE_WHEEL: NATURAL_16 = 0x8010

	EDK_USER_MESSAGE_MASK: NATURAL_16 = 0xA000

	EDK_MESSAGE_ID_MASK: NATURAL_16 = 0x1FF;
		-- Mask for message id.

	EDK_META_FLAG_MASK: NATURAL_16 = 0x1E00
		-- Mask for meta flags

	EDK_MESSAGE_MASK: NATURAL_16 = 0xBFFF
		-- Mask of EDK EVENT

feature {EDK_DISPLAY, EDK_DESKTOP_EVENT_MANAGER} -- Native Windows API WM Message Constants

	WM_NULL: NATURAL_16 = 0
	WM_ACTIVATE: NATURAL_16 = 6
	WM_SETFOCUS: NATURAL_16 = 7
	WM_KILLFOCUS: NATURAL_16 = 8
	WM_GETMINMAXINFO: NATURAL_16 = 36
	WM_NCCREATE: NATURAL_16 = 129
	WM_NCCALCSIZE: NATURAL_16 = 131
	WM_CREATE: NATURAL_16 = 1
	WM_DESTROY: NATURAL_16 = 2
	WM_SHOWWINDOW: NATURAL_16 = 24
	WM_WINDOWPOSCHANGING: NATURAL_16 = 70
	WM_ACTIVATEAPP: NATURAL_16 = 28
	WM_NCACTIVATE: NATURAL_16 = 134
	WM_GETICON: NATURAL_16 = 127
	WM_IME_SETCONTEXT: NATURAL_16 = 641
	WM_IME_CONTROL: NATURAL_16 = 642
	WM_ERASEBKGND: NATURAL_16 = 20
	WM_WINDOWPOSCHANGED: NATURAL_16 = 71
	WM_NCPAINT: NATURAL_16 = 133
	WM_SIZE: NATURAL_16 = 5
	WM_MOVE: NATURAL_16 = 3
	WM_PAINT: NATURAL_16 = 15
	WM_SYNCPAINT: NATURAL_16 = 136
	WM_EXITSIZEMOVE: NATURAL_16 = 562
	WM_NCHITTEST: NATURAL_16 = 132
	WM_SETCURSOR: NATURAL_16 = 32
	WM_NCMOUSEMOVE: NATURAL_16 = 160
	WM_NCMOUSELEAVE: NATURAL_16 = 674
	WM_ENTERSIZEMOVE: NATURAL_16 = 561
	WM_MOVING: NATURAL_16 = 534
	WM_CAPTURECHANGED: NATURAL_16 = 533
	WM_MOUSEMOVE: NATURAL_16 = 512
	WM_LBUTTONDOWN: NATURAL_16 = 513
	WM_LBUTTONUP: NATURAL_16 = 514
	WM_LBUTTONDBLCLK: NATURAL_16 = 515
	WM_RBUTTONDOWN: NATURAL_16 = 516
	WM_RBUTTONUP: NATURAL_16 = 517
	WM_RBUTTONDBLCLK: NATURAL_16 = 518
	WM_MBUTTONDOWN: NATURAL_16 = 519
	WM_MBUTTONUP: NATURAL_16 = 520
	WM_MBUTTONDBLCLK: NATURAL_16 = 521
	WM_MOUSEWHEEL: NATURAL_16 = 522
	WM_XBUTTONDOWN: NATURAL_16 = 523
	WM_XBUTTONUP: NATURAL_16 = 524
	WM_XBUTTONDBLCLK: NATURAL_16 = 525
	WM_NCLBUTTONDOWN: NATURAL_16 = 161
	WM_NCLBUTTONUP: NATURAL_16 = 162
	WM_NCLBUTTONDBLCLK: NATURAL_16 = 163
	WM_NCRBUTTONDOWN: NATURAL_16 = 164
	WM_NCRBUTTONUP: NATURAL_16 = 165
	WM_NCRBUTTONDBLCLK: NATURAL_16 = 166
	WM_NCMBUTTONDOWN: NATURAL_16 = 167
	WM_NCMBUTTONUP: NATURAL_16 = 168
	WM_NCMBUTTONDBLCLK: NATURAL_16 = 169
	WM_NCXBUTTONDOWN: NATURAL_16 = 171
	WM_NCXBUTTONUP: NATURAL_16 = 172
	WM_NCXBUTTONDBLCLK: NATURAL_16 = 173
	WM_KEYDOWN: NATURAL_16 = 256
	WM_KEYFIRST: NATURAL_16 = 256
	WM_KEYUP: NATURAL_16 = 257
	WM_CHAR: NATURAL_16 = 258
	WM_DEADCHAR: NATURAL_16 = 259
	WM_SYSKEYDOWN: NATURAL_16 = 260
	WM_SYSKEYUP: NATURAL_16 = 261
	WM_SYSCHAR: NATURAL_16 = 262
	WM_SYSDEADCHAR: NATURAL_16 = 263
	WM_SIZING: NATURAL_16 = 532

feature {EDK_DISPLAY, EDK_DESKTOP_EVENT_MANAGER} -- Native GDK Window Message Constants

--	GDK_NOTHING: NATURAL_16 = -1,
	GDK_DELETE: NATURAL_16 = 0
	GDK_DESTROY: NATURAL_16 = 1
	GDK_EXPOSE: NATURAL_16 = 2
	GDK_MOTION_NOTIFY: NATURAL_16 = 3
	GDK_BUTTON_PRESS: NATURAL_16 = 4
	GDK_2BUTTON_PRESS: NATURAL_16 = 5
	GDK_3BUTTON_PRESS: NATURAL_16 = 6
	GDK_BUTTON_RELEASE: NATURAL_16 = 7
	GDK_KEY_PRESS: NATURAL_16 = 8
	GDK_KEY_RELEASE: NATURAL_16 = 9
	GDK_ENTER_NOTIFY: NATURAL_16 = 10
	GDK_LEAVE_NOTIFY: NATURAL_16 = 11
	GDK_FOCUS_CHANGE: NATURAL_16 = 12
	GDK_CONFIGURE: NATURAL_16 = 13
	GDK_MAP: NATURAL_16 = 14
	GDK_UNMAP: NATURAL_16 = 15
	GDK_PROPERTY_NOTIFY: NATURAL_16 = 16
	GDK_SELECTION_CLEAR: NATURAL_16 = 17
	GDK_SELECTION_REQUEST: NATURAL_16 = 18
	GDK_SELECTION_NOTIFY: NATURAL_16 = 19
	GDK_PROXIMITY_IN: NATURAL_16 = 20
	GDK_PROXIMITY_OUT: NATURAL_16 = 21
	GDK_DRAG_ENTER: NATURAL_16 = 22
	GDK_DRAG_LEAVE: NATURAL_16 = 23
	GDK_DRAG_MOTION: NATURAL_16 = 24
	GDK_DRAG_STATUS: NATURAL_16 = 25
	GDK_DROP_START: NATURAL_16 = 26
	GDK_DROP_FINISHED: NATURAL_16 = 27
	GDK_CLIENT_EVENT: NATURAL_16 = 28
	GDK_VISIBILITY_NOTIFY: NATURAL_16 = 29
	GDK_NO_EXPOSE: NATURAL_16 = 30
end
