/*
 * Code for class PROCESS_UNIX_OS
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "pr1182.h"
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <fcntl.h>
#include "eif_process.h"
#include <signal.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F1302_18528
static void inline_F1302_18528 (EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	{
  int rc;
  rc = dup2(arg1, arg2);
  if (rc < 0) {
	    eraise(Strerror(errno), EN_SYS);
  }
}
	;
}
#define INLINE_F1302_18528
#endif
#ifndef INLINE_F1302_18529
static void inline_F1302_18529 (EIF_INTEGER_32 arg1)
{
	{
	 int rc;
	  rc = close(arg1);
	  if (rc != 0) {
	    eraise(Strerror(errno), EN_SYS);
	  }
}
	;
}
#define INLINE_F1302_18529
#endif
#ifndef INLINE_F1302_18532
static void inline_F1302_18532 (void)
{
	{
	setpgid (0, 0);
}
	;
}
#define INLINE_F1302_18532
#endif
#ifndef INLINE_F1302_18546
static void inline_F1302_18546 (EIF_POINTER arg1, EIF_INTEGER_32 arg2, EIF_POINTER arg3)
{
	{
				  char ** arguments;
 				  arguments = (char **) arg1;
				  arguments[arg2] = (char *) arg3;
				}
	;
}
#define INLINE_F1302_18546
#endif
#ifndef INLINE_F1302_18544
static void inline_F1302_18544 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4)
{
	{
				  int max_descriptors;
				  int k, rc;
  				  if (arg4 == EIF_TRUE) {
				    max_descriptors = getdtablesize();
					for (k = 3; k < max_descriptors; k++) {
					    rc = fcntl(k, F_SETFD, 1);
					    if (rc == -1 && errno != EBADF) {
						      eraise(Strerror(errno), EN_SYS);
					    }
			  	    }
				  }
				  if (arg3 == NULL) {
				    (void) execv((char *) arg1, (char **) arg2);
				  } else {
				    (void) execve((char *) arg1, (char **) arg2, (char **) arg3);
				  }
				  _exit(127);
				}
	;
}
#define INLINE_F1302_18544
#endif
#ifndef INLINE_F1302_18541
static void inline_F1302_18541 (EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	{
	int rc;
	rc = kill((pid_t) arg1, (int) arg2);
    if (rc != 0 && errno != ESRCH) {
		eraise(Strerror(errno), EN_SYS);
	}
}
	;
}
#define INLINE_F1302_18541
#endif
#ifndef INLINE_F1302_18543
static void inline_F1302_18543 (EIF_INTEGER_32* arg1)
{
	{
  pid_t pid;
  pid = fork();
  *arg1 = (EIF_INTEGER)pid;
}
	;
}
#define INLINE_F1302_18543
#endif
#ifndef INLINE_F1302_18539
static void inline_F1302_18539 (EIF_POINTER arg1, EIF_POINTER* arg2)
{
	{
	  char *result;
	  result = (char *) malloc((unsigned) (strlen((char *) arg1) + 1));
	  if (result == NULL) {
    	enomem();
	  }
	  strcpy(result, arg1);
	  *arg2 = result;
	}
	;
}
#define INLINE_F1302_18539
#endif
#ifndef INLINE_F1302_18545
static void inline_F1302_18545 (EIF_INTEGER_32 arg1, EIF_POINTER* arg2)
{
	{
	EIF_POINTER result;
	result = (EIF_POINTER) malloc((size_t) (arg1 * sizeof(char *)));
	if (result == NULL) {
		enomem();
	}
	*arg2 = result;
}
	;
}
#define INLINE_F1302_18545
#endif
#ifndef INLINE_F1302_18540
static void inline_F1302_18540 (EIF_POINTER arg1, EIF_POINTER arg2)
{
	{
  int rc;
  int fd[2];
  EIF_INTEGER * read_ptr;
  EIF_INTEGER * write_ptr;
  rc = pipe(fd);
  if (rc != 0) {
    eraise(Strerror(errno), EN_SYS);
  }
  read_ptr = (EIF_INTEGER *) arg1;
  write_ptr = (EIF_INTEGER *) arg2;
  *read_ptr = fd[0];
  *write_ptr = fd[1];
}
	;
}
#define INLINE_F1302_18540
#endif
#ifndef INLINE_F1302_18542
static void inline_F1302_18542 (EIF_INTEGER_32 arg1, EIF_BOOLEAN arg2, EIF_BOOLEAN* arg3, EIF_INTEGER_32* arg4, EIF_BOOLEAN* arg5)
{
	{
  pid_t rc;
  int status;
  
  rc = waitpid((pid_t) arg1, &status, (arg2 ? 0 : WNOHANG) | WUNTRACED);
  *(EIF_BOOLEAN *) arg5 = (rc != -1);
  if (rc != -1) {				    
	  if (rc == 0) { /* No process has status to report yet */
	    *(EIF_BOOLEAN *) arg3 = EIF_FALSE;
	  } else { /* Process reported status */
	    *(EIF_BOOLEAN *) arg3 = EIF_TRUE;
	  }
	  *(EIF_INTEGER *) arg4 = (EIF_INTEGER) status;
  }
}
	;
}
#define INLINE_F1302_18542
#endif
#ifndef INLINE_F1302_18547
static void inline_F1302_18547 (EIF_INTEGER_32 arg1)
{
	{
	pid_t pgid = getpgid (arg1);
	tcsetpgrp (1, pgid);
	tcsetpgrp (2, pgid);
}
	;
}
#define INLINE_F1302_18547
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {PROCESS_UNIX_OS}.duplicate_file_descriptor */
void F1302_18528 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("duplicate_file_descriptor", 1301, Current, 0, 2, 16186);
	inline_F1302_18528 ((EIF_INTEGER_32) arg1, (EIF_INTEGER_32) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.close_file_descriptor */
void F1302_18529 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("close_file_descriptor", 1301, Current, 0, 1, 16187);
	inline_F1302_18529 ((EIF_INTEGER_32) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.fork_process */
EIF_INTEGER_32 F1302_18531 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	
	
	RTEAA("fork_process", 1301, Current, 0, 0, 16189);
	RTHOOK(1);
	RTHOOK(2);
	RTEE;
	return (EIF_INTEGER_32) F1302_18536(Current);
}

/* {PROCESS_UNIX_OS}.new_process_group */
void F1302_18532 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("new_process_group", 1301, Current, 0, 0, 16190);
	inline_F1302_18532 ();
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.exec_process */
void F1302_18533 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_BOOLEAN arg3, EIF_POINTER arg4)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_POINTER loc4 = (EIF_POINTER) 0;
	EIF_POINTER loc5 = (EIF_POINTER) 0;
	EIF_POINTER loc6 = (EIF_POINTER) 0;
	EIF_REFERENCE loc7 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(5);
	RTLR(0,arg2);
	RTLR(1,Current);
	RTLR(2,loc7);
	RTLR(3,tr1);
	RTLR(4,arg1);
	RTLIU(5);
	
	RTEAA("exec_process", 1301, Current, 7, 4, 16191);
	RTGC;
	RTHOOK(1);
	loc2 = F2554_28502(RTCW(arg2));
	RTHOOK(2);
	loc3 = *(EIF_INTEGER_32 *)(RTCW(arg2) + O24611[Dtype(arg2)-2553]);
	RTHOOK(3);
	loc4 = F1302_18538(Current, (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)));
	RTHOOK(4);
	tr1 = RTLNS(eif_new_type(2141, 0x00).id, 2141, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F2142_26037(RTCW(tr1), ((EIF_INTEGER_32) 0L));
	loc7 = (EIF_REFERENCE) tr1;
	RTHOOK(5);
	loc1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	for (;;) {
		RTHOOK(6);
		if ((EIF_BOOLEAN) (loc1 > loc2)) break;
		RTHOOK(7);
		tr1 = F2554_28495(RTCW(arg2), (EIF_INTEGER_32) ((EIF_INTEGER_32) (loc3 + loc1) - ((EIF_INTEGER_32) 1L)));
		F2142_26051(RTCW(loc7), tr1);
		RTHOOK(8);
		tp1 = F2142_26043(RTCW(loc7));
		loc5 = F1302_18537(Current, tp1);
		RTHOOK(9);
		inline_F1302_18546(loc4, (EIF_INTEGER_32) (loc1 - ((EIF_INTEGER_32) 1L)), loc5);
		RTHOOK(10);
		loc1++;
	}
	RTHOOK(11);
	inline_F1302_18546(loc4, loc2, loc6);
	RTHOOK(12);
	tr1 = RTLNS(eif_new_type(2141, 0x00).id, 2141, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F2142_26036(RTCW(tr1), arg1);
	loc7 = (EIF_REFERENCE) tr1;
	RTHOOK(13);
	tp1 = F2142_26043(RTCW(loc7));
	inline_F1302_18544(tp1, loc4, arg4, arg3);
	RTHOOK(14);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.terminate_hard */
void F1302_18534 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("terminate_hard", 1301, Current, 0, 1, 16192);
	RTGC;
	RTHOOK(1);
	ti4_1 = RTOUCB(EIF_INTEGER_32,5076,F1301_18491,(Current));
	F1302_18535(Current, ti4_1, arg1);
	RTHOOK(2);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.send_signal */
void F1302_18535 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	GTCX
	RTEX;
	
	
	RTEAA("send_signal", 1301, Current, 0, 2, 16193);
	RTHOOK(1);
	inline_F1302_18541(arg2, arg1);
	RTHOOK(2);
	RTEE;
}

/* {PROCESS_UNIX_OS}.unix_fork_process */
EIF_INTEGER_32 F1302_18536 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	
	
	RTEAA("unix_fork_process", 1301, Current, 0, 0, 16194);
	RTHOOK(1);
	inline_F1302_18543((EIF_INTEGER_32 *) &(Result));
	RTHOOK(2);
	RTEE;
	return Result;
}

/* {PROCESS_UNIX_OS}.str_dup */
EIF_POINTER F1302_18537 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	
	
	RTEAA("str_dup", 1301, Current, 0, 1, 16195);
	RTHOOK(1);
	inline_F1302_18539(arg1, (EIF_POINTER *) &(Result));
	RTHOOK(2);
	RTEE;
	return Result;
}

/* {PROCESS_UNIX_OS}.unix_allocate_arg_memory */
EIF_POINTER F1302_18538 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	
	
	RTEAA("unix_allocate_arg_memory", 1301, Current, 0, 1, 16175);
	RTHOOK(1);
	inline_F1302_18545(arg1, (EIF_POINTER *) &(Result));
	RTHOOK(2);
	RTEE;
	return Result;
}

/* {PROCESS_UNIX_OS}.c_str_dup */
void F1302_18539 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER* arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("c_str_dup", 1301, Current, 0, 2, 16176);
	inline_F1302_18539 ((EIF_POINTER) arg1, (EIF_POINTER*) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.unix_pipe */
void F1302_18540 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_pipe", 1301, Current, 0, 2, 16177);
	inline_F1302_18540 ((EIF_POINTER) arg1, (EIF_POINTER) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.unix_kill */
void F1302_18541 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_kill", 1301, Current, 0, 2, 16178);
	inline_F1302_18541 ((EIF_INTEGER_32) arg1, (EIF_INTEGER_32) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.unix_waitpid */
void F1302_18542 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_BOOLEAN arg2, EIF_BOOLEAN* arg3, EIF_INTEGER_32* arg4, EIF_BOOLEAN* arg5)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_waitpid", 1301, Current, 0, 5, 16179);
	EIF_ENTER_C;
	inline_F1302_18542 ((EIF_INTEGER_32) arg1, (EIF_BOOLEAN) arg2, (EIF_BOOLEAN*) arg3, (EIF_INTEGER_32*) arg4, (EIF_BOOLEAN*) arg5);
	EIF_EXIT_C;
	RTGC;
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.c_unix_fork_process */
void F1302_18543 (EIF_REFERENCE Current, EIF_INTEGER_32* arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("c_unix_fork_process", 1301, Current, 0, 1, 16180);
	inline_F1302_18543 ((EIF_INTEGER_32*) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.unix_exec_process */
void F1302_18544 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_exec_process", 1301, Current, 0, 4, 16181);
	inline_F1302_18544 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_BOOLEAN) arg4);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.c_unix_allocate_arg_memory */
void F1302_18545 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_POINTER* arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("c_unix_allocate_arg_memory", 1301, Current, 0, 2, 16182);
	inline_F1302_18545 ((EIF_INTEGER_32) arg1, (EIF_POINTER*) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.unix_set_arg_value */
void F1302_18546 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_INTEGER_32 arg2, EIF_POINTER arg3)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_set_arg_value", 1301, Current, 0, 3, 16183);
	inline_F1302_18546 ((EIF_POINTER) arg1, (EIF_INTEGER_32) arg2, (EIF_POINTER) arg3);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.attach_terminals */
void F1302_18547 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("attach_terminals", 1301, Current, 0, 1, 16184);
	inline_F1302_18547 ((EIF_INTEGER_32) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
}

void EIF_Minit1182 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
