note
	description: "Keygen environment variables setting and reading"
	legal: "See notice at end of class."
	status: "See notice at end of class."
	date: "$Date: 2012-12-21 01:10:02 +0000 (Fri, 21 Dec 2012) $"
	revision: "$Revision: 96472 $"

class
	KG_ENVIRONMENT_VARIABLES_IMP

inherit
	KG_ENVIRONMENT_VARIABLES

feature -- Access

	global_stored_value (name: STRING): STRING
			-- Value associated with global storage name `name'.
		local
			reg: WEL_REGISTRY
			value: detachable WEL_REGISTRY_KEY_VALUE
			l_val: STRING_32
			retried: BOOLEAN
		do
			Result := ""
			if not retried then
				create reg
				value := reg.open_key_value ("hkey_local_machine\" + Protection_key_path, name)
				if value /= Void then
					l_val := value.string_value
					if l_val.is_valid_as_string_8 then
						create Result.make (l_val.count)
						Result.append_string_general (l_val)
						last_retrieval_successful := True
					else
						last_retrieval_successful := False
					end
				else
					last_retrieval_successful := False
				end
			end
		ensure then
			non_void_if_successful: last_retrieval_successful implies not Result.is_empty
		rescue
			if not retried then
				last_retrieval_successful := False
				retried := True
			end
		end

	user_stored_value (name: STRING): STRING
			-- Value associated with user specific storage name `name'.
		local
			reg: WEL_REGISTRY
			value: detachable WEL_REGISTRY_KEY_VALUE
			retried: BOOLEAN
			l_val: STRING_32
		do
			Result := ""
			if not retried then
				create reg
				value := reg.open_key_value ("hkey_current_user\" + Protection_key_path, name)
				if value /= Void then
					l_val := value.string_value
					if l_val.is_valid_as_string_8 then
						create Result.make (l_val.count)
						Result.append_string_general (l_val)
						last_retrieval_successful := True
					else
						last_retrieval_successful := False
					end
				else
					last_retrieval_successful := False
				end
			end
		ensure then
			non_void_if_successful: last_retrieval_successful implies not Result.is_empty
		rescue
			if not retried then
				last_retrieval_successful := False
				retried := True
			end
		end

	last_retrieval_successful: BOOLEAN
			-- Was last called to `stored_value' successful?
			-- can fail is user doesn't have the right to read HKCM

	browser_command: STRING_32
			-- Retrieve internet browser command line
		local
			reg: WEL_REGISTRY
			key: POINTER
			exec: EXECUTION_ENVIRONMENT
			value: detachable WEL_REGISTRY_KEY_VALUE
		do
			Result := ""
			create reg
			key := reg.open_key ({WEL_HKEY}.hkey_classes_root, "htmlfile\shell\open\command",
				{WEL_REGISTRY_ACCESS_MODE}.key_read)
			if key /= default_pointer then
				value := reg.key_value (key, "")
				if value /= Void then
					Result := value.string_value
				end
			else
				create exec
				if attached exec.item ("SystemDrive") as l_result then
					Result := l_result + "\Program Files\Internet Explorer\iexplore.exe -nohome"
				end
			end
			if Result.is_empty then
 				Result := "C:\Program Files\Internet Explorer\iexplore.exe -nohome"
			end
		end

feature -- Element Setting

	set_global_stored_value (storage_name, value: STRING)
			-- Set `storage_name' with `value'.
		local
			reg: WEL_REGISTRY
			key: POINTER
		do
			create reg
			key := reg.create_key ({WEL_HKEY}.hkey_local_machine, Protection_key_path,
				{WEL_REGISTRY_ACCESS_MODE}.key_write)
			if key /= default_pointer then
				reg.set_key_value (key, storage_name,
					create {WEL_REGISTRY_KEY_VALUE}.make ({WEL_REGISTRY_KEY_VALUE_TYPE}.Reg_sz, value))
				reg.close_key (key)
			end
		end

	set_user_stored_value (storage_name, value: STRING)
			-- Set user specific `storage_name' with `value'.
		local
			reg: WEL_REGISTRY
			key: POINTER
		do
			create reg
			key := reg.create_key ({WEL_HKEY}.hkey_current_user, Protection_key_path,
				{WEL_REGISTRY_ACCESS_MODE}.key_write)
			if key /= default_pointer then
				reg.set_key_value (key, storage_name,
					create {WEL_REGISTRY_KEY_VALUE}.make ({WEL_REGISTRY_KEY_VALUE_TYPE}.Reg_sz, value))
				reg.close_key (key)
			end
		end

note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"




end -- class KG_ENVIRONMENT_VARIABLES_IMP
