﻿note
	description: "Objects that represent an EV_TITLED_WINDOW.%
		%The original version of this class was generated by EiffelBuild."
	legal: "See notice at end of class."
	status: "See notice at end of class."
	date: "$Date: 2017-02-26 14:33:09 +0000 (Sun, 26 Feb 2017) $"
	revision: "$Revision: 99859 $"

class
	GENERAL_SETTING_PANEL

inherit
	GENERAL_SETTING_PANEL_IMP

	DOCKING_MANAGER_HODLER
		undefine
			default_create, copy, is_equal
		end

create
	make

feature {NONE} -- Initialization

	make (a_manager: SD_DOCKING_MANAGER; a_window: like window;
		a_attribute_panel: ATTRIBUTE_SETTING_PANEL; a_transform_panel: TRANSFORM_PANEL;
		a_content_control_panel: CONTENT_CONTROL_PANEL)
			-- Set `docking_manager' with `a_manager'.
		require
			a_manager_not_void: a_manager /= Void
		do
			docking_manager := a_manager
			window := a_window
			attribute_panel := a_attribute_panel
			transform_panel := a_transform_panel
			content_control_panel := a_content_control_panel

			create_all_widgets
			create_all_actions

			back_ground_color := sd_shared.default_background_color

			default_create
		ensure
			docking_manager_not_void: docking_manager /= Void
			window_not_void: window /= Void
		end

	user_initialization
			-- Called by `initialize'.
			-- Any custom user initialization that
			-- could not be performed in `initialize',
			-- (due to regeneration of implementation class)
			-- can be added here.
		do
			show_all_indicators_check_button.select_actions.block
			if sd_shared.show_all_feedback_indicator then
				show_all_indicators_check_button.enable_select
			else
				show_all_indicators_check_button.disable_select
			end
			show_all_indicators_check_button.select_actions.resume

			show_tab_stub_text_check_button.select_actions.block
			if sd_shared.show_all_tab_stub_text then
				show_tab_stub_text_check_button.enable_select
			else
				show_tab_stub_text_check_button.disable_select
			end
			show_tab_stub_text_check_button.select_actions.resume

			key_field.change_actions.block
			key_field.set_text (key_constant.key_strings.item (sd_shared.zone_navigation_accelerator_key))
			key_field.change_actions.resume

			ctrl_check_button.select_actions.block
			if sd_shared.zone_navigation_accelerator_ctrl then
				ctrl_check_button.enable_select
			else
				ctrl_check_button.disable_select
			end
			ctrl_check_button.select_actions.resume
			alt_check_button.select_actions.block
			if sd_shared.zone_navigation_accelerator_alt then
				alt_check_button.enable_select
			else
				alt_check_button.disable_select
			end
			alt_check_button.select_actions.resume
			shift_check_button.select_actions.block
			if sd_shared.zone_navigation_accelerator_shift then
				shift_check_button.enable_select
			else
				shift_check_button.disable_select
			end
			shift_check_button.select_actions.resume

			sliding_speed_spin_button.set_value (sd_shared.auto_hide_tab_slide_timer_interval)


		end

	create_all_widgets
			-- Create all widgets
		do
			create l_ev_frame_1
			create l_ev_vertical_box_1
			create l_ev_horizontal_box_1
			create l_ev_button_1
			create l_ev_vertical_separator_1
			create l_ev_button_2
			create l_ev_frame_2
			create l_ev_horizontal_box_2
			create close_place_holder_button
			create l_ev_frame_3
			create l_ev_vertical_box_2
			create l_ev_horizontal_box_3
			create l_ev_vertical_box_3
			create show_all_indicators_check_button
			create show_tab_stub_text_check_button
			create l_ev_vertical_box_4
			create l_ev_horizontal_box_4
			create l_ev_label_1
			create sliding_speed_spin_button
			create l_ev_frame_4
			create l_ev_horizontal_box_5
			create l_ev_label_2
			create key_field
			create l_ev_cell_1
			create ctrl_check_button
			create alt_check_button
			create shift_check_button
			create l_ev_frame_5
			create l_ev_horizontal_box_6
			create lock_editors_check_button
			create lock_tools_check_button
			create lock_tool_bars_check_button
			create l_ev_frame_6
			create l_ev_horizontal_box_7
			create background_color_drawer
			create l_ev_cell_2
			create chose_color_button
			create l_ev_frame_7
			create l_ev_horizontal_box_8
			create l_ev_vertical_box_5
			create save_layout_button
			create open_layout_button
			create l_ev_vertical_box_6
			create save_tool_layout_button
			create open_tool_layout_button
			create l_ev_vertical_box_7
			create save_editor_layout_button
			create open_editor_layout_button
		end

	create_all_actions
			-- Create all actions
		do
			create string_constant_set_procedures.make (10)
			create string_constant_retrieval_functions.make (10)
			create integer_constant_set_procedures.make (10)
			create integer_constant_retrieval_functions.make (10)
			create pixmap_constant_set_procedures.make (10)
			create pixmap_constant_retrieval_functions.make (10)
			create integer_interval_constant_retrieval_functions.make (10)
			create integer_interval_constant_set_procedures.make (10)
			create font_constant_set_procedures.make (10)
			create font_constant_retrieval_functions.make (10)
			create pixmap_constant_retrieval_functions.make (10)
			create color_constant_set_procedures.make (10)
			create color_constant_retrieval_functions.make (10)
		end

feature {NONE} -- Implementation

	on_create_tool_content
			-- Called by `select_actions' of `l_ev_button_1'.
		do
			build_docking_tool_content
		end

	on_create_editor_content
			-- Called by `select_actions' of l_ev_button_2.
			-- (export status {NONE})
		do
			build_docking_editor_content
		end

	on_show_all_indicators_check_button_selected
			-- Called by `select_actions' of `show_all_indicators_check_button'.
		do
			sd_shared.set_show_all_feedback_indicator (show_all_indicators_check_button.is_selected)
		end

	on_key_field_changed
			-- Called by `change_actions' of `key_field'.
		do
			change_navigation_dialog_shortcut_key
		end

	on_sliding_speed_spin_button_changed (a_value: INTEGER)
			-- Called by `change_actions' of `sliding_speed_spin_button'.
		do
			sd_shared.set_auto_hide_tab_slide_timer_interval (a_value)
		end

	on_show_tab_stub_text_check_button_selected
			-- Called by `select_actions' of `show_tab_stub_text_check_button'.
		do
			sd_shared.set_show_tab_stub_text (show_tab_stub_text_check_button.is_selected)
		end

	on_ctrl_button_selected
			-- Called by `select_actions' of `ctrl_check_button'.
		do
			sd_shared.set_zone_navigation_accelerator_ctrl (ctrl_check_button.is_selected)
		end

	on_alt_button_selected
			-- Called by `select_actions' of `alt_check_button'.
		do
			sd_shared.set_zone_navigation_accelerator_alt (alt_check_button.is_selected)
		end

	on_shift_button_selected
			-- Called by `select_actions' of `shift_check_button'.
		do
			sd_shared.set_zone_navigation_accelerator_shift (shift_check_button.is_selected)
		end

	on_choose_color_button_selected
			-- Called by `select_actions' of `chose_color_button'.
		local
			l_dialog: EV_COLOR_DIALOG
		do
			create l_dialog
			l_dialog.set_color (sd_shared.default_background_color)
			l_dialog.ok_actions.extend (agent background_color_selected (l_dialog))
			l_dialog.show_modal_to_window (window)
		end

	on_background_color_drawer_exposed (a_x, a_y, a_width, a_height: INTEGER)
			-- Called by `expose_actions' of `background_color_drawer'.
		local
			l_color: EV_COLOR
		do
			l_color := sd_shared.default_background_color
			background_color_drawer.set_background_color (back_ground_color)
			background_color_drawer.clear
		end

	on_lock_editors_button_selected
			-- Called by `select_actions' of `lock_editors_check_button'.
		do
			if lock_editors_check_button.is_selected then
				docking_manager.lock_editor
			else
				docking_manager.unlock_editor
			end
		end

	on_lock_tools_button_selected
			-- Called by `select_actions' of `lock_tools_check_button'.
		do
			if lock_tools_check_button.is_selected then
				docking_manager.lock
			else
				docking_manager.unlock
			end
		end

	on_lock_tool_bars_button_selected
			-- Called by `select_actions' of `lock_tool_bars_check_button'.
		do
			if lock_tool_bars_check_button.is_selected then
				docking_manager.tool_bar_manager.lock
			else
				docking_manager.tool_bar_manager.unlock
			end
		end

	on_open_layout_button_selected
			-- Called by `select_actions' of `open_layout_button'.
		local
			l_dialog: like open_file_dialog
		do
			create l_dialog
			open_file_dialog := l_dialog
			l_dialog.open_actions.extend (agent on_open_layout (l_dialog, standard_layout))
			l_dialog.show_modal_to_window (window)
		end

	on_open_editor_layout_button_selected
			-- Called by `select_actions' of `open_editor_layout_button'.
		local
			l_dialog: like open_file_dialog
		do
			create l_dialog
			open_file_dialog := l_dialog
			l_dialog.open_actions.extend (agent on_open_layout (l_dialog, editor_layout))
			l_dialog.show_modal_to_window (window)
		end

	on_open_tool_layout_button_selected
			-- Called by `select_actions' of `open_tool_layout_button'.
		local
			l_dialog: like open_file_dialog
		do
			create l_dialog
			open_file_dialog := l_dialog
			l_dialog.open_actions.extend (agent on_open_layout (l_dialog, tool_layout))
			l_dialog.show_modal_to_window (window)
		end

	on_save_layout_button_selected
			-- Called by `select_actions' of `save_layout_button'.
		local
			l_dialog: like save_file_dialog
		do
			create l_dialog
			save_file_dialog := l_dialog
			l_dialog.save_actions.extend (agent on_layout_save (l_dialog, standard_layout))
			l_dialog.show_modal_to_window (window)
		end

	on_save_editor_layout_button_selected
			-- Called by `select_actions' of `save_editor_layout_button'.
		local
			l_dialog: like save_file_dialog
		do
			create l_dialog
			save_file_dialog := l_dialog
			l_dialog.save_actions.extend (agent on_layout_save (l_dialog, editor_layout))
			l_dialog.show_modal_to_window (window)
		end

	on_save_tool_layout_button_selected
			-- Called by `select_actions' of `save_tool_layout_button'.
		local
			l_dialog: like save_file_dialog
		do
			create l_dialog
			save_file_dialog := l_dialog
			l_dialog.save_actions.extend (agent on_layout_save (l_dialog, tool_layout))
			l_dialog.show_modal_to_window (window)
		end

	on_close_place_holder_button_selected
			-- Called by `select_actions' of `close_place_holder_button'.
		do
			docking_manager.close_editor_place_holder
		end

feature -- Creating

	build_docking_editor_content
			-- Build editor contents.
		local
			l_content: SD_CONTENT
		do
			l_content := new_content (True)
			l_content.set_top ({SD_ENUMERATION}.top)
		end

	build_docking_tool_content
			-- Build tool contents.
		local
			l_content: SD_CONTENT
		do
			l_content := new_content (False)
			l_content.set_top ({SD_ENUMERATION}.bottom)
		end

feature {NONE} -- Layout save

	standard_layout: INTEGER = 1
	editor_layout: INTEGER = 2
	tool_layout: INTEGER = 3

	save_file_dialog: detachable EV_FILE_SAVE_DIALOG
	open_file_dialog: detachable EV_FILE_OPEN_DIALOG

	on_layout_save (a_dialog: attached like save_file_dialog; a_type: INTEGER)
		require
			a_dialog_not_void: a_dialog /= Void
		local
			l_file_path: PATH
		do
			l_file_path := a_dialog.full_file_path
			if a_type = standard_layout then
				docking_manager.save_data_with_path (l_file_path).do_nothing
			elseif a_type = editor_layout then
				docking_manager.save_editors_data_with_path (l_file_path).do_nothing
			elseif a_type = tool_layout then
				docking_manager.save_tools_data_with_path (l_file_path).do_nothing
			end
		end

	on_open_layout (a_dialog: attached like open_file_dialog; a_type: INTEGER)
		require
			a_dialog_not_void: a_dialog /= Void
		local
			l_file_path: PATH
			l_result: BOOLEAN
		do
			l_file_path := a_dialog.full_file_path
			if a_type = standard_layout then
				l_result := docking_manager.open_config_with_path (l_file_path)
			elseif a_type = editor_layout then
				docking_manager.open_editors_config_with_path (l_file_path)
			elseif a_type = tool_layout then
				l_result := docking_manager.open_tools_config_with_path (l_file_path)
			end
		end

feature {NONE} -- Implementation

	change_navigation_dialog_shortcut_key
			-- Change navigation dialog shortcut.
		local
			l_key: STRING_GENERAL
			l_code: INTEGER
		do
			l_key := key_field.text
			l_code := key_constant.key_code_from_key_string (l_key)
			if l_code /= 0 then
				sd_shared.set_zone_navigation_accelerator_key (l_code)
			end
		end

	background_color_selected (a_dialog: EV_COLOR_DIALOG)
			-- Background color selected.
		require
			a_dialog_not_void: a_dialog /= Void
		do
			docking_manager.set_main_area_background_color (a_dialog.color)
			back_ground_color := a_dialog.color
			on_background_color_drawer_exposed (0, 0, 0, 0)
		end

feature {NONE} -- Implementation

	new_widget (a_number: like new_widget_number): EV_DRAWING_AREA
			-- New widget.
		do
			create Result
			Result.expose_actions.extend (agent (a_x, a_y, a_width, a_lenth, a_widget_number: INTEGER; a_drawing: EV_DRAWING_AREA)
				do
					a_drawing.set_background_color ((create {EV_STOCK_COLORS}).white)
					a_drawing.clear
					a_drawing.draw_text_top_left (1, 1, "DRAWING AREA #" + a_widget_number.out)
				end (?, ?, ?, ?, a_number, Result)
			)
		ensure
			Result_not_void: Result /= Void
		end

	new_content (a_editor: BOOLEAN): SD_CONTENT
			-- New content.
		require
			docking_manager_not_void: docking_manager /= Void
		local
			l_content: SD_CONTENT
			l_widget: EV_WIDGET
			l_number: like new_widget_number
			l_title: STRING_GENERAL
		do
			l_number := new_widget_number
			l_widget := new_widget (l_number)
			if a_editor then
				l_title := "Editor: #" + l_number.out
			else
				l_title := "Tool: #" + l_number.out
			end
			create l_content.make_with_widget (l_widget, l_title, docking_manager)
			l_content.set_short_title (l_title)
			l_content.set_long_title (l_title)
			l_content.set_description (l_title)
			l_content.set_detail (l_title)
			l_content.set_tab_tooltip (l_title)
			l_content.close_request_actions.extend (agent attribute_panel.close_content (l_content, is_content_hiden))
			l_content.focus_in_actions.extend (agent content_focused (l_content))
			docking_manager.contents.extend (l_content)
			if a_editor then
				l_content.set_type ({SD_ENUMERATION}.editor)
			else
				l_content.set_type ({SD_ENUMERATION}.tool)
			end
			Result := l_content
		ensure
			Result_not_void: Result /= Void
			docking_manager_has_Result: docking_manager.contents.has (Result)
		end

	is_content_hiden: BOOLEAN = True

	sd_shared: SD_SHARED
		once
			create Result
		end

	key_constant: EV_KEY_CONSTANTS
		once
			create Result
		end

	back_ground_color: EV_COLOR

feature -- Widget counting.

	new_widget_number: INTEGER
			-- New widget number
		do
			Result := widget_number + 1
			widget_number := Result
		end

	widget_number: INTEGER

feature {NONE} -- Access

	content_control_panel: CONTENT_CONTROL_PANEL
			-- Associated control panel.

	attribute_panel: ATTRIBUTE_SETTING_PANEL
			-- Associated attribute panel.

	transform_panel: TRANSFORM_PANEL
			-- Associated transform panel.

feature {NONE} -- Focusing

	content_focused (a_content: SD_CONTENT)
			-- Content focused
		require
			a_content_not_void: a_content /= Void
		do
			attribute_panel.content_focused (a_content)
			transform_panel.content_focused (a_content)
		end

note
	copyright:	"Copyright (c) 1984-2016, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			Eiffel Software
			5949 Hollister Ave., Goleta, CA 93117 USA
			Telephone 805-685-1006, Fax 805-685-6869
			Website http://www.eiffel.com
			Customer support http://support.eiffel.com
	]"

end
