note

	description:

		"Cursors for bilinked list traversals"

	library: "Gobo Eiffel Structures Library"
	copyright: "Copyright (c) 1999-2013, Eric Bezault and others"
	license: "MIT License"
	date: "$Date: 2016-05-06 19:15:38 +0000 (Fri, 06 May 2016) $"
	revision: "$Revision: 98678 $"

class DS_BILINKED_LIST_CURSOR [G]

inherit

	DS_LINKED_LIST_CURSOR [G]
		redefine
			container,
			current_cell,
			next_cursor
		end

create

	make

feature -- Access

	container: DS_BILINKED_LIST [G]
			-- List traversed

feature {DS_LINKED_LIST, DS_LINKED_LIST_CURSOR} -- Implementation

	current_cell: detachable DS_BILINKABLE [G]
			-- Cell at cursor position

feature {DS_BILINKED_LIST} -- Implementation

	next_cursor: detachable DS_BILINKED_LIST_CURSOR [G]
			-- Next cursor
			-- (Used by `container' to keep track of traversing
			-- cursors (i.e. cursors associated with `container'
			-- and which are not currently `off').)

end
