note

	description: "General message dialog implementation"
	legal: "See notice at end of class.";
	status: "See notice at end of class.";
	date: "$Date: 2008-12-29 20:27:11 +0000 (Mon, 29 Dec 2008) $";
	revision: "$Revision: 76420 $"

deferred class
		MESSAGE_D_I 

inherit

	TERMINAL_I

feature -- Status setting

	set_left_alignment
			-- Set message alignment to beginning.
		deferred
		end;

	set_center_alignment
			-- Set message alignment to center.
		deferred
		end;

	set_right_alignment
			-- Set message alignment to right.
		deferred
		end;

	show_cancel_button
			-- Make cancel button visible.
		deferred
		end;

	show_help_button
			-- Make help button visible.
		deferred
		end;

	show_ok_button
			-- Make ok button visible.
		deferred
		end

	hide_cancel_button
			-- Make cancel button invisible.
		deferred
		end;

	hide_help_button
			-- Make help button invisible.
		deferred
		end;
		
	hide_ok_button
			-- Make ok button invisible.
		deferred
		end;

feature -- Element change

	set_help_label (a_label: STRING)
			-- Set `a_label' as label for help button,
			-- by default this label is `help'.
		require
			not_label_void: a_label /= Void
		deferred
		end;

	set_message (a_message: STRING)
			-- Set `a_message' as message.
		require
			not_message_void: a_message /= Void
		deferred
		end;

	set_ok_label (a_label: STRING)
			-- Set `a_label' as label for ok button,
			-- by default this label is `ok'.
		require
			not_label_void: a_label /= Void
		deferred
		end;

	set_cancel_label (a_label: STRING)
			-- Set `a_label' as label for cancel button,
			-- by default this label is `cancel'.
		require
			not_label_void: a_label /= Void
		deferred
		end;

	add_cancel_action (a_command: COMMAND; argument: ANY)
			-- Add `a_command' to the list of action to execute when
			-- cancel button is activated.
		require
			not_a_command_void: a_command /= Void
		deferred
		end;

	add_help_action (a_command: COMMAND; argument: ANY)
			-- Add `a_command' to the list of action to execute when
			-- help button is activated.
		require
			not_a_command_void: a_command /= Void
		deferred
		end;

	add_ok_action (a_command: COMMAND; argument: ANY)
			-- Add `a_command' to the list of action to execute when
			-- ok button is activated.
		require
			not_a_command_void: a_command /= Void
		deferred
		end;

feature -- Removal

	remove_cancel_action (a_command: COMMAND; argument: ANY)
			-- Remove `a_command' from the list of action to execute when
			-- cancel button is activated.
		require
			not_a_command_void: a_command /= Void
		deferred
		end;
	
	remove_help_action (a_command: COMMAND; argument: ANY)
			-- Remove `a_command' from the list of action to execute when
			-- help button is activated.
		require
			not_a_command_void: a_command /= Void
		deferred
		end;

	remove_ok_action (a_command: COMMAND; argument: ANY)
			-- Remove `a_command' from the list of action to execute when
			-- ok button is activated.
		require
			not_a_command_void: a_command /= Void
		deferred
		end;

feature -- Display update

    update_display
			-- Updates the display of all the windows in the application	
			-- Windows implementation does not do anything
        deferred
        end

note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"




end -- class MESSAGE_D_I

